/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.script;

import java.io.Serializable;
import java.net.URL;
import java.sql.Connection;
import java.sql.Statement;
import javax.sql.DataSource;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.time.Stopwatch;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.jdbc.script.Parser;
import org.beangle.data.jdbc.script.Runner$;
import org.beangle.data.jdbc.script.Script;
import org.slf4j.Logger;
import scala.Function1;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BooleanRef;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class Runner
implements Logging {
    private Logger logger;
    private final Parser parser;
    private final List<Script> list;

    public static List<Script> read(Parser parser, Seq<URL> seq) {
        return Runner$.MODULE$.read(parser, seq);
    }

    public Runner(Parser parser, Seq<URL> urls) {
        this.parser = parser;
        Logging.$init$((Logging)this);
        this.list = Runner$.MODULE$.read(parser, urls);
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public void execute(DataSource dataSource, boolean ignoreError) {
        Stopwatch watch = new Stopwatch(true);
        this.list.foreach((Function1)(JProcedure1 & Serializable)script -> {
            Stopwatch sw = new Stopwatch(true);
            Connection conn = dataSource.getConnection();
            conn.setAutoCommit(true);
            Statement stm = conn.createStatement();
            BooleanRef terminated = BooleanRef.create((boolean)false);
            Iterator iter = script.statements().iterator();
            Set<String> commands = this.parser.commands();
            while (!terminated.elem && iter.hasNext()) {
                String statement = (String)iter.next();
                String cmd = Strings$.MODULE$.lowerCase(Strings$.MODULE$.substringBefore(statement, " "));
                if (commands.contains((Object)cmd)) {
                    String string = cmd;
                    String string2 = "prompt";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        Logger$.MODULE$.info$extension(this.logger(), () -> Runner.execute$$anonfun$3$$anonfun$1(statement, cmd));
                        continue;
                    }
                    Logger$.MODULE$.info$extension(this.logger(), () -> Runner.execute$$anonfun$4$$anonfun$2(statement));
                    continue;
                }
                this.liftedTree1$3(ignoreError, stm, terminated, statement);
            }
            stm.close();
            conn.commit();
            conn.close();
            Logger$.MODULE$.info$extension(this.logger(), () -> Runner.execute$$anonfun$5$$anonfun$3(script, sw));
        });
        Logger$.MODULE$.info$extension(this.logger(), () -> Runner.execute$$anonfun$2(watch));
    }

    private static final String execute$$anonfun$3$$anonfun$1(String statement$1, String cmd$1) {
        return Strings$.MODULE$.trim(Strings$.MODULE$.substringAfter(statement$1, cmd$1));
    }

    private static final String execute$$anonfun$4$$anonfun$2(String statement$2) {
        return statement$2;
    }

    private static final String liftedTree1$1$$anonfun$1(String statement$4) {
        return "Failure when exceute sql " + statement$4;
    }

    private static final Exception liftedTree1$2$$anonfun$2(Exception e$1) {
        return e$1;
    }

    private final void liftedTree1$3(boolean ignoreError$2, Statement stm$1, BooleanRef terminated$1, String statement$3) {
        block2: {
            try {
                stm$1.execute(statement$3);
            }
            catch (Exception e) {
                boolean bl;
                Logger$.MODULE$.error$extension(this.logger(), () -> Runner.liftedTree1$1$$anonfun$1(statement$3), () -> Runner.liftedTree1$2$$anonfun$2(e));
                if (ignoreError$2) break block2;
                terminated$1.elem = bl = true;
            }
        }
    }

    private static final String execute$$anonfun$5$$anonfun$3(Script script$1, Stopwatch sw$1) {
        return "exec " + script$1.source() + " using " + sw$1;
    }

    private static final String execute$$anonfun$2(Stopwatch watch$1) {
        return "exec sql using " + watch$1;
    }
}

