/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.engine;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.jdbc.engine.AlterTableDialect;
import org.beangle.data.jdbc.engine.DefaultAlterTableDialect;
import org.beangle.data.jdbc.engine.Dialect;
import org.beangle.data.jdbc.engine.Engine;
import org.beangle.data.jdbc.engine.Options;
import org.beangle.data.jdbc.meta.Column;
import org.beangle.data.jdbc.meta.Index;
import org.beangle.data.jdbc.meta.Sequence;
import org.beangle.data.jdbc.meta.Table;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public interface AbstractDialect
extends Dialect {
    public static void $init$(AbstractDialect $this) {
        $this.options_$eq(new Options());
    }

    public Options options();

    public void options_$eq(Options var1);

    public static String createSchema$(AbstractDialect $this, String name) {
        return $this.createSchema(name);
    }

    @Override
    default public String createSchema(String name) {
        return "create schema " + name;
    }

    public static String createTable$(AbstractDialect $this, Table table) {
        return $this.createTable(table);
    }

    @Override
    default public String createTable(Table table) {
        StringBuilder buf = new StringBuilder("create table").append(' ').append(table.qualifiedName()).append(" (");
        Iterator iter = table.columns().iterator();
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            buf.append(col.name().toLiteral((Engine)((Object)this))).append(' ');
            buf.append(col.sqlType().name());
            col.defaultValue().foreach((Function1 & Serializable)dv -> buf.append(" default ").append(dv));
            if (!col.nullable()) {
                buf.append(" not null");
            }
            if (col.hasCheck() && this.options().table().create().supportsColumnCheck()) {
                buf.append(" check (").append((String)col.check().get()).append(")");
            }
            if (!this.options().comment().supportsCommentOn()) {
                col.comment().foreach((Function1 & Serializable)c -> buf.append(" comment '" + c + "'"));
            }
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(')');
        if (!this.options().comment().supportsCommentOn()) {
            table.comment().foreach((Function1 & Serializable)c -> buf.append(" comment '" + c + "'"));
        }
        return buf.toString();
    }

    public static String truncate$(AbstractDialect $this, Table table) {
        return $this.truncate(table);
    }

    @Override
    default public String truncate(Table table) {
        return Strings$.MODULE$.replace(this.options().table().truncate().sql(), "{name}", table.qualifiedName());
    }

    public static AlterTableDialect alterTable$(AbstractDialect $this, Table table) {
        return $this.alterTable(table);
    }

    @Override
    default public AlterTableDialect alterTable(Table table) {
        return new DefaultAlterTableDialect(table, this.options());
    }

    public static String dropTable$(AbstractDialect $this, String table) {
        return $this.dropTable(table);
    }

    @Override
    default public String dropTable(String table) {
        return Strings$.MODULE$.replace(this.options().table().drop().sql(), "{name}", table);
    }

    public static Option commentOnColumn$(AbstractDialect $this, Table table, Column column, Option comment) {
        return $this.commentOnColumn(table, column, (Option<String>)comment);
    }

    @Override
    default public Option<String> commentOnColumn(Table table, Column column, Option<String> comment) {
        if (this.options().comment().supportsCommentOn()) {
            return Some$.MODULE$.apply((Object)("comment on column " + table.qualifiedName() + '.' + column.name().toLiteral(table.engine()) + " is '" + comment.getOrElse(AbstractDialect::commentOnColumn$$anonfun$1) + "'"));
        }
        return None$.MODULE$;
    }

    public static Option commentOnTable$(AbstractDialect $this, String table, Option comment) {
        return $this.commentOnTable(table, (Option<String>)comment);
    }

    @Override
    default public Option<String> commentOnTable(String table, Option<String> comment) {
        if (this.options().comment().supportsCommentOn()) {
            return Some$.MODULE$.apply((Object)("comment on table " + table + " is '" + comment.getOrElse(AbstractDialect::commentOnTable$$anonfun$1) + "'"));
        }
        return None$.MODULE$;
    }

    public static List commentsOnTable$(AbstractDialect $this, Table table, boolean includeMissing) {
        return $this.commentsOnTable(table, includeMissing);
    }

    @Override
    default public List<String> commentsOnTable(Table table, boolean includeMissing) {
        if (this.options().comment().supportsCommentOn()) {
            Buffer comments = Collections$.MODULE$.newBuffer();
            String tableName = table.qualifiedName();
            ObjectRef tableComment = ObjectRef.create((Object)((String)table.commentAndModule().getOrElse(() -> AbstractDialect.$anonfun$1(tableName))));
            if (includeMissing) {
                comments.$plus$eq((Object)("comment on table " + tableName + " is '" + (String)tableComment.elem + "'"));
                table.columns().foreach((Function1 & Serializable)c -> (Buffer)comments.$plus$eq((Object)("comment on column " + tableName + '.' + c.name() + " is '" + c.comment().getOrElse(() -> AbstractDialect.commentsOnTable$$anonfun$1$$anonfun$1(c)) + "'")));
            } else {
                table.comment().foreach((Function1 & Serializable)c -> (Buffer)comments.$plus$eq((Object)("comment on table " + tableName + " is '" + (String)tableComment$1.elem + "'")));
                table.columns().foreach((Function1)(JProcedure1 & Serializable)c -> c.comment().foreach((Function1 & Serializable)cc -> (Buffer)comments.$plus$eq((Object)("comment on column " + tableName + '.' + c.name() + " is '" + cc + "'"))));
            }
            return comments.toList();
        }
        return package$.MODULE$.List().empty();
    }

    public static Tuple2 limit$(AbstractDialect $this, String query, int offset, int size) {
        return $this.limit(query, offset, size);
    }

    @Override
    default public Tuple2<String, List<Object>> limit(String query, int offset, int size) {
        int limitOrMax;
        boolean hasOffset = offset > 0;
        int n = limitOrMax = this.options().limit().offsetPattern() == null ? offset + size : size;
        if (hasOffset) {
            List params = this.options().limit().bindInReverseOrder() ? (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{limitOrMax, offset})) : (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{offset, limitOrMax}));
            return Tuple2$.MODULE$.apply((Object)Strings$.MODULE$.replace(this.options().limit().offsetPattern(), "{}", query), (Object)params);
        }
        return Tuple2$.MODULE$.apply((Object)Strings$.MODULE$.replace(this.options().limit().pattern(), "{}", query), package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{limitOrMax})));
    }

    public static String createSequence$(AbstractDialect $this, Sequence seq) {
        return $this.createSequence(seq);
    }

    @Override
    default public String createSequence(Sequence seq) {
        if (!this.options().sequence().supports()) {
            return null;
        }
        String sql = this.options().sequence().createSql();
        sql = sql.replace("{name}", seq.qualifiedName());
        sql = sql.replace("{start}", String.valueOf(seq.current() + 1L));
        sql = sql.replace("{increment}", String.valueOf(seq.increment()));
        sql = sql.replace("{cache}", String.valueOf(seq.cache()));
        sql = sql.replace("{cycle}", seq.cycle() ? "cycle" : "");
        return sql;
    }

    public static String dropSequence$(AbstractDialect $this, Sequence seq) {
        return $this.dropSequence(seq);
    }

    @Override
    default public String dropSequence(Sequence seq) {
        if (!this.options().sequence().supports()) {
            return null;
        }
        return this.options().sequence().dropSql().replace("{name}", seq.qualifiedName());
    }

    public static String createIndex$(AbstractDialect $this, Index i) {
        return $this.createIndex(i);
    }

    @Override
    default public String createIndex(Index i) {
        StringBuilder buf = new StringBuilder("create").append(i.unique() ? " unique" : "").append(" index ").append(i.literalName()).append(" on ").append(i.table().qualifiedName()).append(" (");
        Iterator iter = i.columns().iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }

    public static String dropIndex$(AbstractDialect $this, Index i) {
        return $this.dropIndex(i);
    }

    @Override
    default public String dropIndex(Index i) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(i.table().schema().name().value()))) {
            return "drop index " + i.table().schema().name().toString() + "." + i.literalName();
        }
        return "drop index " + i.literalName();
    }

    public static String insert$(AbstractDialect $this, Table table) {
        return $this.insert(table);
    }

    @Override
    default public String insert(Table table) {
        StringBuilder sb = new StringBuilder("insert into ");
        sb.$plus$plus$eq(table.qualifiedName());
        sb.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'('));
        sb.$plus$plus$eq(table.quotedColumnNames().mkString(","));
        sb.$plus$plus$eq(") values(");
        sb.$plus$plus$eq(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("?,"), table.columns().size()));
        sb.setCharAt(sb.length() - 1, ')');
        return sb.mkString();
    }

    public static String query$(AbstractDialect $this, Table table) {
        return $this.query(table);
    }

    @Override
    default public String query(Table table) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        table.quotedColumnNames().foreach((Function1 & Serializable)columnName -> sb.append(columnName).append(','));
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" from ").append(table.qualifiedName());
        return sb.toString();
    }

    public static boolean supportSequence$(AbstractDialect $this) {
        return $this.supportSequence();
    }

    @Override
    default public boolean supportSequence() {
        return this.options().sequence() != null;
    }

    private static String commentOnColumn$$anonfun$1() {
        return "";
    }

    private static String commentOnTable$$anonfun$1() {
        return "";
    }

    private static String $anonfun$1(String tableName$1) {
        return tableName$1 + "?";
    }

    private static String commentsOnTable$$anonfun$1$$anonfun$1(Column c$1) {
        return c$1.name() + "?";
    }
}

