/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.meta;

import java.io.Serializable;
import org.beangle.data.jdbc.engine.Engine;
import org.beangle.data.jdbc.meta.Constraint$;
import org.beangle.data.jdbc.meta.ForeignKey;
import org.beangle.data.jdbc.meta.Identifier;
import org.beangle.data.jdbc.meta.Index;
import org.beangle.data.jdbc.meta.Table;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordered;

public class Constraint
implements Ordered<Constraint>,
Cloneable {
    private Table table;
    private Identifier name;
    private ListBuffer columns;
    private boolean enabled;

    public static String autoname(Constraint constraint) {
        return Constraint$.MODULE$.autoname(constraint);
    }

    public static String autoname(ForeignKey foreignKey) {
        return Constraint$.MODULE$.autoname(foreignKey);
    }

    public static String autoname(Index index) {
        return Constraint$.MODULE$.autoname(index);
    }

    public static String hashedName(String string) {
        return Constraint$.MODULE$.hashedName(string);
    }

    public Constraint(Table table, Identifier name) {
        this.table = table;
        this.name = name;
        Ordered.$init$((Ordered)this);
        this.columns = new ListBuffer();
        this.enabled = true;
    }

    public Table table() {
        return this.table;
    }

    public void table_$eq(Table x$1) {
        this.table = x$1;
    }

    public Identifier name() {
        return this.name;
    }

    public void name_$eq(Identifier x$1) {
        this.name = x$1;
    }

    public ListBuffer<Identifier> columns() {
        return this.columns;
    }

    public void columns_$eq(ListBuffer<Identifier> x$1) {
        this.columns = x$1;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void enabled_$eq(boolean x$1) {
        this.enabled = x$1;
    }

    public String literalName() {
        return this.name().toLiteral(this.table().schema().database().engine());
    }

    public void attach(Engine engine) {
        this.name_$eq(this.name().attach(engine));
        ListBuffer changed = (ListBuffer)this.columns().map((Function1 & Serializable)col -> col.attach(engine));
        this.columns().clear();
        this.columns().$plus$plus$eq((IterableOnce)changed);
    }

    public void toCase(boolean lower) {
        if (this.name() != null) {
            this.name_$eq(this.name().toCase(lower));
        }
        ListBuffer lowers = (ListBuffer)this.columns().map((Function1 & Serializable)col -> col.toCase(lower));
        this.columns().clear();
        this.columns().$plus$plus$eq((IterableOnce)lowers);
    }

    public List<String> columnNames() {
        return ((ListBuffer)this.columns().map((Function1 & Serializable)x -> x.toLiteral(this.table().schema().database().engine()))).toList();
    }

    public void addColumn(Identifier column) {
        if (column != null) {
            this.columns().$plus$eq((Object)column);
            return;
        }
    }

    public int compare(Constraint o) {
        if (this.name() == null) {
            return 0;
        }
        return this.name().compare(o.name());
    }

    public boolean sameNameColumns(Iterable<Identifier> columns1, Iterable<Identifier> columns2) {
        Set set = columns1.toSet();
        Set set2 = columns2.toSet();
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public Constraint clone() {
        Constraint cloned = (Constraint)super.clone();
        ListBuffer newColumns = new ListBuffer();
        newColumns.$plus$plus$eq(this.columns());
        cloned.columns_$eq((ListBuffer<Identifier>)newColumns);
        return cloned;
    }
}

