/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.meta;

import java.io.Serializable;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.jdbc.engine.Engine;
import org.beangle.data.jdbc.meta.Identifier;
import org.beangle.data.jdbc.meta.Identifier$;
import org.beangle.data.jdbc.meta.Schema;
import org.beangle.data.jdbc.meta.Table;
import org.beangle.data.jdbc.meta.TableRef;
import org.beangle.data.jdbc.meta.TableRef$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.HashMap;

public class Database {
    private final Engine engine;
    private String version;
    private HashMap schemas;

    public Database(Engine engine) {
        this.engine = engine;
        this.version = "UNDEFINED";
        this.schemas = new HashMap();
    }

    public Engine engine() {
        return this.engine;
    }

    public String version() {
        return this.version;
    }

    public void version_$eq(String x$1) {
        this.version = x$1;
    }

    public HashMap<Identifier, Schema> schemas() {
        return this.schemas;
    }

    public void schemas_$eq(HashMap<Identifier, Schema> x$1) {
        this.schemas = x$1;
    }

    public Schema getOrCreateSchema(Identifier schema) {
        return (Schema)this.schemas().getOrElseUpdate((Object)schema, () -> this.getOrCreateSchema$$anonfun$1(schema));
    }

    public Option<Schema> getSchema(String name) {
        if (Strings$.MODULE$.isEmpty((CharSequence)name)) {
            return this.schemas().get((Object)Identifier$.MODULE$.empty());
        }
        return this.schemas().get((Object)this.engine().toIdentifier(name));
    }

    public Option<Table> getTable(TableRef tableRef) {
        return this.getTable(tableRef.schema().name().toLiteral(this.engine()), tableRef.name().toLiteral(this.engine()));
    }

    public Option<Table> getTable(String schema, String name) {
        Option<Schema> option = this.getSchema(schema);
        if (option instanceof Some) {
            Schema s = (Schema)((Some)option).value();
            return s.getTable(name);
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    public Table addTable(String schemaName, String tableName) {
        Schema schema = this.getOrCreateSchema(schemaName);
        Table table = new Table(schema, this.engine().toIdentifier(tableName));
        schema.addTable(table);
        return table;
    }

    public Table addTable(String schema, Table table) {
        this.getOrCreateSchema(schema).addTable(table);
        return table;
    }

    public boolean hasQuotedIdentifier() {
        return this.schemas().exists((Function1 & Serializable)_$1 -> ((Schema)_$1._2()).hasQuotedIdentifier());
    }

    public TableRef refTable(String tableQualifier) {
        String referSchemaName = "";
        String referTableName = tableQualifier;
        if (tableQualifier.contains(".")) {
            referSchemaName = Strings$.MODULE$.substringBefore(tableQualifier, ".");
            referTableName = Strings$.MODULE$.substringAfter(tableQualifier, ".");
        }
        Schema referSchema = this.getOrCreateSchema(referSchemaName);
        return TableRef$.MODULE$.apply(referSchema, this.engine().toIdentifier(referTableName));
    }

    public Schema getOrCreateSchema(String schema) {
        if (Strings$.MODULE$.isEmpty((CharSequence)schema)) {
            return this.getOrCreateSchema(Identifier$.MODULE$.empty());
        }
        return this.getOrCreateSchema(this.engine().toIdentifier(schema));
    }

    private final Schema getOrCreateSchema$$anonfun$1(Identifier schema$1) {
        return new Schema(this, schema$1);
    }
}

