/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.query;

import java.io.Closeable;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.io.IOs$;
import org.beangle.data.jdbc.engine.Engine;
import org.beangle.data.jdbc.query.JdbcExecutor$;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public class ResultSetIterator
implements Iterator<Object[]>,
Closeable {
    private final ResultSet rs;
    private final Engine engine;
    private Object[] nextRecord;
    private final int[] types;

    public ResultSetIterator(ResultSet rs, Engine engine) {
        this.rs = rs;
        this.engine = engine;
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        Iterator.$init$((Iterator)this);
        this.types = this.getTypes(rs);
        this.readNext();
    }

    public Object[] nextRecord() {
        return this.nextRecord;
    }

    public void nextRecord_$eq(Object[] x$1) {
        this.nextRecord = x$1;
    }

    private void readNext() {
        if (this.rs.next()) {
            this.nextRecord_$eq(JdbcExecutor$.MODULE$.convert(this.rs, this.types));
            return;
        }
        this.nextRecord_$eq(null);
        this.close();
    }

    public boolean hasNext() {
        return this.nextRecord() != null;
    }

    public Object[] next() {
        Object[] previous = this.nextRecord();
        this.readNext();
        return previous;
    }

    private int[] getTypes(ResultSet rs) {
        ResultSetMetaData meta = rs.getMetaData();
        String string = meta.getColumnName(meta.getColumnCount());
        String string2 = "_rownum_";
        int cols = !(string != null ? !string.equals(string2) : string2 != null) ? meta.getColumnCount() - 1 : meta.getColumnCount();
        int[] typ = new int[cols];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), cols).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            typ$1[i] = this.engine.resolveCode(meta.getColumnType(i + 1), meta.getColumnTypeName(i + 1));
        });
        return typ;
    }

    @Override
    public void close() throws Exception {
        Statement smt = this.rs.getStatement();
        if (smt == null) {
            IOs$.MODULE$.close((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{this.rs}));
        } else {
            IOs$.MODULE$.close((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{this.rs, smt, smt.getConnection()}));
        }
    }

    public Seq<Object[]> listAll() {
        Buffer buffer;
        Buffer buf = Collections$.MODULE$.newBuffer();
        try {
            while (this.hasNext()) {
                buf.$plus$eq((Object)this.next());
            }
            buffer = buf;
        }
        finally {
            this.close();
        }
        return buffer;
    }
}

