/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.ds;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import javax.sql.DataSource;
import org.beangle.commons.bean.Disposable;
import org.beangle.commons.bean.Factory;
import org.beangle.commons.bean.Initializing;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.net.http.HttpUtils$;
import org.beangle.commons.net.http.Response;
import org.beangle.data.jdbc.ds.DataSourceFactory$;
import org.beangle.data.jdbc.ds.DataSourceUtils$;
import org.beangle.data.jdbc.ds.DatasourceConfig;
import org.beangle.data.jdbc.ds.DatasourceEncryptor$;
import scala.Function1;
import scala.collection.Map;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.NodeSeq;
import scala.xml.XML$;

public class DataSourceFactory
implements Factory<DataSource>,
Initializing,
Disposable {
    private String url;
    private String user;
    private String password;
    private String driver;
    private String name;
    private scala.collection.mutable.Map props = Collections$.MODULE$.newMap();
    private DataSource _result;

    public static DataSource build(String string, String string2, String string3, Map<String, String> map) {
        return DataSourceFactory$.MODULE$.build(string, string2, string3, map);
    }

    public String url() {
        return this.url;
    }

    public void url_$eq(String x$1) {
        this.url = x$1;
    }

    public String user() {
        return this.user;
    }

    public void user_$eq(String x$1) {
        this.user = x$1;
    }

    public String password() {
        return this.password;
    }

    public void password_$eq(String x$1) {
        this.password = x$1;
    }

    public String driver() {
        return this.driver;
    }

    public void driver_$eq(String x$1) {
        this.driver = x$1;
    }

    public String name() {
        return this.name;
    }

    public void name_$eq(String x$1) {
        this.name = x$1;
    }

    public scala.collection.mutable.Map<String, String> props() {
        return this.props;
    }

    public void props_$eq(scala.collection.mutable.Map<String, String> x$1) {
        this.props = x$1;
    }

    public DataSource result() {
        return this._result;
    }

    public void destroy() {
        DataSourceUtils$.MODULE$.close(this.result());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() {
        try {
            if (this.url() != null) {
                if (this.url().startsWith("jdbc:")) {
                    if (this.driver() == null) {
                        this.driver_$eq(Strings$.MODULE$.substringBetween(this.url(), "jdbc:", ":"));
                        this.props().put((Object)"url", (Object)this.url());
                    }
                } else if (this.url().startsWith("http")) {
                    Response res = HttpUtils$.MODULE$.getText(this.url());
                    if (!res.isOk()) throw new RuntimeException("access error :" + this.url());
                    this.merge(this.readConf(new ByteArrayInputStream(res.getText().getBytes())));
                } else {
                    File f = new File(this.url());
                    URL urlAddr = f.exists() ? f.toURI().toURL() : URI.create(this.url()).toURL();
                    this.merge(this.readConf(urlAddr.openStream()));
                }
            }
            this.postInit();
            this._result = DataSourceUtils$.MODULE$.build(this.driver(), this.user(), this.password(), (Map<String, String>)this.props());
            return;
        }
        catch (Throwable e) {
            throw new RuntimeException("cannot find datasource named " + this.name() + " in " + this.url(), e);
        }
    }

    public void postInit() {
        if (this.password() != null && this.password().startsWith("?")) {
            this.password_$eq(this.props().contains((Object)"url") ? DatasourceEncryptor$.MODULE$.decrypt(this.user(), (String)this.props().apply((Object)"url"), this.password().substring(1)) : DatasourceEncryptor$.MODULE$.decrypt(this.user(), (String)this.props().apply((Object)"serverName"), this.password().substring(1)));
            return;
        }
    }

    private DatasourceConfig readConf(InputStream is) {
        Elem root = (Elem)XML$.MODULE$.load(is);
        NodeSeq datasources = root.$bslash$bslash("datasource");
        NodeSeq dbs = root.$bslash$bslash("db");
        if (dbs.isEmpty() && datasources.isEmpty()) {
            is.close();
            return DataSourceUtils$.MODULE$.parseXml((Node)root);
        }
        ObjectRef conf = ObjectRef.create(null);
        NodeSeq nodes = datasources.isEmpty() ? dbs : datasources;
        nodes.foreach((Function1)(JProcedure1 & Serializable)elem -> {
            DatasourceConfig one = DataSourceUtils$.MODULE$.parseXml((Node)elem);
            if (this.name() != null) {
                String string = this.name();
                String string2 = one.name();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    DatasourceConfig datasourceConfig = one;
                    conf$1.elem = datasourceConfig;
                    datasourceConfig = null;
                    return;
                }
                return;
            }
            DatasourceConfig datasourceConfig = one;
            conf$1.elem = datasourceConfig;
            datasourceConfig = null;
        });
        is.close();
        return (DatasourceConfig)conf.elem;
    }

    private void merge(DatasourceConfig conf) {
        if (this.user() == null) {
            this.user_$eq(conf.user());
        }
        if (this.password() == null) {
            this.password_$eq(conf.password());
        }
        if (this.driver() == null) {
            this.driver_$eq(conf.driver());
        }
        if (this.name() == null) {
            this.name_$eq(conf.name());
        }
        conf.props().foreach((Function1)(JProcedure1 & Serializable)e -> {
            if (!this.props().contains(e._1())) {
                this.props().put(e._1(), e._2());
                return;
            }
        });
    }
}

