/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.engine;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.jdbc.engine.AlterTableDialect;
import org.beangle.data.jdbc.engine.Engine;
import org.beangle.data.jdbc.engine.Options;
import org.beangle.data.jdbc.meta.Column;
import org.beangle.data.jdbc.meta.ForeignKey;
import org.beangle.data.jdbc.meta.Identifier;
import org.beangle.data.jdbc.meta.PrimaryKey;
import org.beangle.data.jdbc.meta.SqlType;
import org.beangle.data.jdbc.meta.Table;
import org.beangle.data.jdbc.meta.UniqueKey;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public class DefaultAlterTableDialect
implements AlterTableDialect {
    private final Table table$field;
    private final Table table;
    private final Options options;

    public DefaultAlterTableDialect(Table table, Options options) {
        this.table = table;
        this.options = options;
        this.table$field = table;
    }

    @Override
    public Table table() {
        return this.table$field;
    }

    @Override
    public List<String> addColumn(Column col) {
        Buffer buf = Collections$.MODULE$.newBuffer();
        ObjectRef sql = ObjectRef.create((Object)("alter table " + this.table.qualifiedName() + " add column " + col.name() + " " + col.sqlType().name()));
        col.defaultValue().foreach((Function1)(JProcedure1 & Serializable)v -> {
            Object object;
            if (col.sqlType().isStringType()) {
                Object object2;
                sql$1.elem = object2 = (String)sql$1.elem + (" default '" + v + "''");
                object2 = null;
                return;
            }
            sql$1.elem = object = (String)sql$1.elem + (" default " + v);
            object = null;
        });
        if (this.options.table().create().supportsColumnCheck()) {
            col.check().foreach((Function1)(JProcedure1 & Serializable)c -> {
                Object object;
                sql$2.elem = object = (String)sql$2.elem + (" check " + c);
                object = null;
            });
        }
        buf.$plus$eq((Object)((String)sql.elem));
        if (!col.nullable()) {
            buf.$plus$eq((Object)this.modifyColumnSetNotNull(col));
        }
        return buf.toList();
    }

    @Override
    public String renameColumn(Column col, String newName) {
        String renameClause = this.options.table().alter().renameColumn();
        renameClause = Strings$.MODULE$.replace(renameClause, "{oldcolumn}", col.name().toLiteral(this.table.engine()));
        renameClause = Strings$.MODULE$.replace(renameClause, "{newcolumn}", newName);
        renameClause = Strings$.MODULE$.replace(renameClause, "{type}", col.sqlType().name());
        renameClause = Strings$.MODULE$.replace(renameClause, "{table}", this.table.qualifiedName());
        return "alter table " + this.table.qualifiedName() + " " + renameClause;
    }

    @Override
    public String dropColumn(Column col) {
        String alterClause = this.options.table().alter().dropColumn();
        alterClause = Strings$.MODULE$.replace(alterClause, "{column}", col.name().toLiteral(this.table.engine()));
        return "alter table " + this.table.qualifiedName() + " " + alterClause;
    }

    @Override
    public String modifyColumnSetNotNull(Column col) {
        String alterClause = this.options.table().alter().setNotNull();
        alterClause = Strings$.MODULE$.replace(alterClause, "{column}", col.name().toLiteral(this.table.engine()));
        alterClause = Strings$.MODULE$.replace(alterClause, "{type}", col.sqlType().name());
        return "alter table " + this.table.qualifiedName() + " " + alterClause;
    }

    @Override
    public String modifyColumnDropNotNull(Column col) {
        String alterClause = this.options.table().alter().dropNotNull();
        alterClause = Strings$.MODULE$.replace(alterClause, "{column}", col.name().toLiteral(this.table.engine()));
        alterClause = Strings$.MODULE$.replace(alterClause, "{type}", col.sqlType().name());
        return "alter table " + this.table.qualifiedName() + " " + alterClause;
    }

    @Override
    public String modifyColumnDefault(Column col, Option<String> v) {
        String string;
        Option<String> option = v;
        if (option instanceof Some) {
            string = this.options.table().alter().setDefault();
        } else if (None$.MODULE$.equals(option)) {
            string = this.options.table().alter().dropDefault();
        } else {
            throw new MatchError(option);
        }
        String alterClause = string;
        alterClause = Strings$.MODULE$.replace(alterClause, "{column}", col.name().toLiteral(this.table.engine()));
        Object value2 = (String)v.getOrElse(DefaultAlterTableDialect::$anonfun$2);
        if (col.sqlType().isStringType() && !((String)value2).startsWith("'")) {
            value2 = "'" + (String)value2 + "'";
        }
        alterClause = Strings$.MODULE$.replace(alterClause, "{value}", (String)value2);
        return "alter table " + this.table.qualifiedName() + " " + alterClause;
    }

    @Override
    public String modifyColumnType(Column col, SqlType sqlType) {
        String alterClause = this.options.table().alter().changeType();
        alterClause = Strings$.MODULE$.replace(alterClause, "{column}", col.name().toLiteral(this.table.engine()));
        alterClause = Strings$.MODULE$.replace(alterClause, "{type}", sqlType.name());
        return "alter table " + this.table.qualifiedName() + " " + alterClause;
    }

    @Override
    public String addForeignKey(ForeignKey fk) {
        Predef$.MODULE$.require(fk.name() != null && fk.table() != null && fk.referencedTable() != null);
        Predef$.MODULE$.require(fk.referencedColumns().nonEmpty(), DefaultAlterTableDialect::addForeignKey$$anonfun$1);
        Predef$.MODULE$.require(fk.columns().nonEmpty(), () -> DefaultAlterTableDialect.addForeignKey$$anonfun$2(fk));
        Engine engine = fk.table().engine();
        List referencedColumnNames = ((ListBuffer)fk.referencedColumns().map((Function1 & Serializable)x -> x.toLiteral(engine))).toList();
        String result = "alter table " + fk.table().qualifiedName() + this.foreignKeySql(fk.literalName(), (Iterable<String>)fk.columnNames(), fk.referencedTable().qualifiedName(), (Iterable<String>)referencedColumnNames);
        if (fk.cascadeDelete() && this.options.constraint().supportsCascadeDelete()) {
            return result + " on delete cascade";
        }
        return result;
    }

    @Override
    public String addPrimaryKey(PrimaryKey pk) {
        String alterClause = this.options.table().alter().addPrimaryKey();
        alterClause = Strings$.MODULE$.replace(alterClause, "{name}", pk.name().toLiteral(this.table.engine()));
        alterClause = Strings$.MODULE$.replace(alterClause, "{column-list}", this.nameList((Iterable<Identifier>)pk.columns(), this.table.engine()));
        return "alter table " + this.table.qualifiedName() + " " + alterClause;
    }

    @Override
    public String dropPrimaryKey(PrimaryKey pk) {
        String dk = this.options.table().alter().dropPrimaryKey();
        if (Strings$.MODULE$.isEmpty((CharSequence)dk)) {
            return this.dropConstraint(pk.name().toLiteral(this.table.engine()));
        }
        return "alter table " + this.table.qualifiedName() + " " + dk;
    }

    @Override
    public String dropConstraint(String name) {
        String alterClause = this.options.table().alter().dropConstraint();
        alterClause = Strings$.MODULE$.replace(alterClause, "{name}", name);
        return "alter table " + this.table.qualifiedName() + " " + alterClause;
    }

    @Override
    public String addUnique(UniqueKey fk) {
        Predef$.MODULE$.require(fk.name() != null && fk.table() != null);
        Predef$.MODULE$.require(fk.columns().nonEmpty(), () -> DefaultAlterTableDialect.addUnique$$anonfun$1(fk));
        return "alter table " + fk.table().qualifiedName() + " add constraint " + fk.literalName() + " unique (" + this.nameList((Iterable<Identifier>)fk.columns(), this.table.engine()) + ")";
    }

    public String foreignKeySql(String constraintName, Iterable<String> foreignKey, String referencedTable, Iterable<String> primaryKey) {
        StringBuffer res = new StringBuffer(30);
        res.append(" add constraint ").append(constraintName).append(" foreign key (").append(Strings$.MODULE$.join(foreignKey, ", ")).append(") references ").append(referencedTable);
        if (primaryKey.nonEmpty()) {
            res.append(" (").append(Strings$.MODULE$.join(primaryKey, ", ")).append(')');
        }
        return res.toString();
    }

    private String nameList(Iterable<Identifier> seq, Engine engine) {
        return ((IterableOnceOps)seq.map((Function1 & Serializable)_$1 -> _$1.toLiteral(engine))).mkString(",");
    }

    private static final String $anonfun$2() {
        return "null";
    }

    private static final Object addForeignKey$$anonfun$1() {
        return " reference columns is empty.";
    }

    private static final Object addForeignKey$$anonfun$2(ForeignKey fk$1) {
        return fk$1.name() + " column's size should greate than 0";
    }

    private static final Object addUnique$$anonfun$1(UniqueKey fk$2) {
        return fk$2.name() + " column's size should great than 0";
    }
}

