/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.engine;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import javax.sql.DataSource;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.jdbc.engine.DB2V8;
import org.beangle.data.jdbc.engine.Derby10;
import org.beangle.data.jdbc.engine.Engine;
import org.beangle.data.jdbc.engine.H2;
import org.beangle.data.jdbc.engine.MySQL5;
import org.beangle.data.jdbc.engine.Oracle10g;
import org.beangle.data.jdbc.engine.Oracle12c;
import org.beangle.data.jdbc.engine.PostgreSQL10;
import org.beangle.data.jdbc.engine.SQLServer2005;
import org.beangle.data.jdbc.engine.SQLServer2008;
import org.beangle.data.jdbc.engine.SQLServer2012;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Engines$
implements Serializable {
    private static final HashMap<String, List<Engine>> name2Engines;
    public static final Engines$ MODULE$;

    private Engines$() {
    }

    static {
        MODULE$ = new Engines$();
        name2Engines = new HashMap();
        MODULE$.register((Seq<Engine>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Engine[]{new PostgreSQL10(), new MySQL5(), new H2(), new Oracle10g(), new Oracle12c(), new DB2V8(), new SQLServer2005(), new SQLServer2008(), new SQLServer2012(), new Derby10()}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Engines$.class);
    }

    private void register(Seq<Engine> engines) {
        engines.foreach((Function1 & Serializable)engine -> {
            List list;
            Option option = name2Engines.get((Object)engine.name());
            if (option instanceof Some) {
                List el = (List)((Some)option).value();
                list = (List)el.appended(engine);
            } else if (None$.MODULE$.equals(option)) {
                list = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Engine[]{engine}));
            } else {
                throw new MatchError((Object)option);
            }
            List engList = list;
            return name2Engines.put((Object)engine.name(), (Object)engList);
        });
    }

    public Engine forDataSource(DataSource ds) {
        Connection connection = ds.getConnection();
        DatabaseMetaData meta = connection.getMetaData();
        String name = meta.getDatabaseProductName();
        String version = meta.getDatabaseMajorVersion() + "." + meta.getDatabaseMinorVersion();
        connection.close();
        return this.forName(name, version);
    }

    public Engine forName(String dbname, String version) {
        List list;
        String name = Strings$.MODULE$.capitalize(dbname);
        Option option = name2Engines.get((Object)(name = name.replace("sql", "SQL")));
        if (option instanceof Some) {
            List el;
            list = el = (List)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            list = dbname.toUpperCase().startsWith("DB2") ? (List)name2Engines.apply((Object)"DB2") : (dbname.toUpperCase().startsWith("SQLSERVER") || dbname.startsWith("Microsoft SQL Server") ? (List)name2Engines.apply((Object)"Microsoft SQL Server") : package$.MODULE$.List().empty());
        } else {
            throw new MatchError((Object)option);
        }
        List engineList = list;
        String string = version;
        String string2 = "last";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return (Engine)engineList.last();
        }
        Option engine = engineList.find((Function1 & Serializable)e -> e.version().contains(version));
        if (engine.isEmpty()) {
            throw new RuntimeException("Cannot find engine for database " + dbname);
        }
        return (Engine)Option$.MODULE$.option2Iterable(engine).head();
    }

    public String forName$default$2() {
        return "last";
    }
}

