/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.meta;

import java.io.File;
import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.io.Files$;
import org.beangle.data.jdbc.engine.AlterTableDialect;
import org.beangle.data.jdbc.engine.Engine;
import org.beangle.data.jdbc.meta.Column;
import org.beangle.data.jdbc.meta.Database;
import org.beangle.data.jdbc.meta.DatabaseDiff;
import org.beangle.data.jdbc.meta.ForeignKey;
import org.beangle.data.jdbc.meta.Index;
import org.beangle.data.jdbc.meta.NameDiff;
import org.beangle.data.jdbc.meta.NameDiff$;
import org.beangle.data.jdbc.meta.PrimaryKey;
import org.beangle.data.jdbc.meta.Schema;
import org.beangle.data.jdbc.meta.SchemaDiff;
import org.beangle.data.jdbc.meta.Serializer$;
import org.beangle.data.jdbc.meta.Table;
import org.beangle.data.jdbc.meta.TableDiff;
import org.beangle.data.jdbc.meta.UniqueKey;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashSet;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class Diff$
implements Serializable {
    public static final Diff$ MODULE$ = new Diff$();

    private Diff$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Diff$.class);
    }

    public void main(String[] args) {
        if (args.length < 3) {
            Predef$.MODULE$.println((Object)"Usage:Diff database1.xml database2.xml /path/to/diff.sql");
            return;
        }
        File dbFile1 = new File(args[0]);
        File dbFile2 = new File(args[1]);
        if (!dbFile1.exists()) {
            Predef$.MODULE$.println((Object)("Cannot load " + dbFile1.getAbsolutePath()));
            return;
        }
        if (!dbFile2.exists()) {
            Predef$.MODULE$.println((Object)("Cannot load " + dbFile2.getAbsolutePath()));
            return;
        }
        Database db1 = Serializer$.MODULE$.fromXml(Files$.MODULE$.readString(dbFile1, Files$.MODULE$.readString$default$2()));
        Database db2 = Serializer$.MODULE$.fromXml(Files$.MODULE$.readString(dbFile2, Files$.MODULE$.readString$default$2()));
        DatabaseDiff diff = this.diff(db1, db2);
        Iterable<String> sqls = this.sql(diff);
        Files$.MODULE$.writeString(new File(args[2]), sqls.toBuffer().append((Object)"").mkString(";\n"), Files$.MODULE$.writeString$default$3());
    }

    public DatabaseDiff diff(Database older, Database newer) {
        Engine engine = newer.engine();
        Engine engine2 = older.engine();
        if (engine == null ? engine2 != null : !engine.equals(engine2)) {
            throw new RuntimeException("Cannot diff different engines(" + newer.engine().name() + " and " + older.engine().name() + ").");
        }
        scala.collection.immutable.Set newSchemaSet = ((IterableOnceOps)newer.schemas().keySet().map((Function1 & Serializable)_$1 -> _$1.value())).toSet();
        scala.collection.immutable.Set oldSchemaSet = ((IterableOnceOps)older.schemas().keySet().map((Function1 & Serializable)_$2 -> _$2.value())).toSet();
        scala.collection.immutable.Set newSchemas = (scala.collection.immutable.Set)newSchemaSet.diff((Set)oldSchemaSet);
        scala.collection.immutable.Set removedSchemas = (scala.collection.immutable.Set)oldSchemaSet.diff((Set)newSchemaSet);
        scala.collection.immutable.Set updateSchemas = (scala.collection.immutable.Set)newSchemaSet.intersect((Set)oldSchemaSet);
        scala.collection.mutable.Map schemaDiffs = Collections$.MODULE$.newMap();
        updateSchemas.foreach((Function1)(JProcedure1 & Serializable)s -> {
            Schema oldSchema = older.getOrCreateSchema((String)s);
            Schema newSchema = newer.getOrCreateSchema((String)s);
            scala.collection.immutable.Set oldTableSet = ((IterableOnceOps)oldSchema.tables().keySet().map((Function1 & Serializable)_$3 -> _$3.value())).toSet();
            scala.collection.immutable.Set newTableSet = ((IterableOnceOps)newSchema.tables().keySet().map((Function1 & Serializable)_$4 -> _$4.value())).toSet();
            scala.collection.immutable.Set newTables = (scala.collection.immutable.Set)newTableSet.diff((Set)oldTableSet);
            scala.collection.immutable.Set removedTables = (scala.collection.immutable.Set)oldTableSet.diff((Set)newTableSet);
            scala.collection.immutable.Set updateTables = (scala.collection.immutable.Set)newTableSet.intersect((Set)oldTableSet);
            scala.collection.mutable.Map tableDiffs = Collections$.MODULE$.newMap();
            updateTables.foreach((Function1)(JProcedure1 & Serializable)t -> {
                Table oldT = (Table)oldSchema.getTable((String)t).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                Table newT = (Table)newSchema.getTable((String)t).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                this.diff(oldT, newT, newer.engine()).foreach((Function1 & Serializable)td -> tableDiffs.put(t, td));
            });
            if (!(newTables.isEmpty() && removedTables.isEmpty() && tableDiffs.isEmpty())) {
                SchemaDiff schemaDiff = new SchemaDiff(oldSchema, newSchema);
                schemaDiff.tableDiffs_$eq((scala.collection.immutable.Map<String, TableDiff>)tableDiffs.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                schemaDiff.tables_$eq(NameDiff$.MODULE$.apply((scala.collection.immutable.Set<String>)newTables, (scala.collection.immutable.Set<String>)removedTables, (scala.collection.immutable.Set<Tuple2<String, String>>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<String>)tableDiffs.keySet().toSet()));
                schemaDiffs.put(s, (Object)schemaDiff);
                return;
            }
        });
        DatabaseDiff dbDiff = new DatabaseDiff(older, newer);
        if (!(newSchemas.isEmpty() && removedSchemas.isEmpty() && schemaDiffs.isEmpty())) {
            dbDiff.schemas_$eq(NameDiff$.MODULE$.apply((scala.collection.immutable.Set<String>)newSchemas, (scala.collection.immutable.Set<String>)removedSchemas, (scala.collection.immutable.Set<Tuple2<String, String>>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<String>)schemaDiffs.keySet().toSet()));
            dbDiff.schemaDiffs_$eq((scala.collection.immutable.Map<String, SchemaDiff>)schemaDiffs.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }
        return dbDiff;
    }

    public Option<TableDiff> diff(Table older, Table newer, Engine engine) {
        TableDiff table = new TableDiff(older, newer);
        Option<PrimaryKey> option = newer.primaryKey();
        Option<PrimaryKey> option2 = older.primaryKey();
        if (option == null ? option2 != null : !option.equals(option2)) {
            table.hasPrimaryKey_$eq(true);
        }
        Option option3 = newer.comment();
        Option option4 = older.comment();
        if (option3 == null ? option4 != null : !option3.equals(option4)) {
            table.hasComment_$eq(true);
        }
        scala.collection.immutable.Map oldColMap = ((IterableOnceOps)older.columns().map((Function1 & Serializable)c -> Tuple2$.MODULE$.apply((Object)c.name().toLiteral(engine), c))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map newColMap = ((IterableOnceOps)newer.columns().map((Function1 & Serializable)c -> Tuple2$.MODULE$.apply((Object)c.name().toLiteral(engine), c))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        NameDiff columnDiff = this.nameDiff((scala.collection.immutable.Set<String>)oldColMap.keySet(), (scala.collection.immutable.Set<String>)newColMap.keySet(), (Map<String, Object>)oldColMap, (Map<String, Object>)newColMap);
        HashSet renameColumnPairs = new HashSet();
        columnDiff.newer().foreach((Function1)(JProcedure1 & Serializable)nc -> {
            Column newColumn = newer.column((String)nc);
            older.columns().find((Function1 & Serializable)x -> {
                Option option = x.comment();
                Option option2 = newColumn.comment();
                return !(option != null ? !option.equals(option2) : option2 != null);
            }).foreach((Function1)(JProcedure1 & Serializable)oldColumn -> {
                if (columnDiff.removed().contains((Object)oldColumn.name().toLiteral(engine))) {
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)oldColumn.name().toLiteral(engine));
                    renameColumnPairs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)newColumn.name().toLiteral(engine)));
                    return;
                }
            });
        });
        if (renameColumnPairs.nonEmpty()) {
            table.columns_$eq(NameDiff$.MODULE$.apply((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)columnDiff.newer().$minus$minus((IterableOnce)renameColumnPairs.map((Function1 & Serializable)_$5 -> (String)_$5._2()))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)columnDiff.removed().$minus$minus((IterableOnce)renameColumnPairs.map((Function1 & Serializable)_$6 -> (String)_$6._1()))), (scala.collection.immutable.Set<Tuple2<String, String>>)renameColumnPairs.toSet(), columnDiff.updated()));
        } else {
            table.columns_$eq(columnDiff);
        }
        scala.collection.immutable.Map oldUkMap = ((IterableOnceOps)older.uniqueKeys().map((Function1 & Serializable)c -> Tuple2$.MODULE$.apply((Object)c.name().toLiteral(engine), c))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map newUkMap = ((IterableOnceOps)newer.uniqueKeys().map((Function1 & Serializable)c -> Tuple2$.MODULE$.apply((Object)c.name().toLiteral(engine), c))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        table.uniqueKeys_$eq(this.nameDiff((scala.collection.immutable.Set<String>)oldUkMap.keySet(), (scala.collection.immutable.Set<String>)newUkMap.keySet(), (Map<String, Object>)oldUkMap, (Map<String, Object>)newUkMap));
        scala.collection.immutable.Map oldFkMap = ((IterableOnceOps)older.foreignKeys().map((Function1 & Serializable)c -> Tuple2$.MODULE$.apply((Object)c.name().toLiteral(engine), c))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map newFkMap = ((IterableOnceOps)newer.foreignKeys().map((Function1 & Serializable)c -> Tuple2$.MODULE$.apply((Object)c.name().toLiteral(engine), c))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        table.foreignKeys_$eq(this.nameDiff((scala.collection.immutable.Set<String>)oldFkMap.keySet(), (scala.collection.immutable.Set<String>)newFkMap.keySet(), (Map<String, Object>)oldFkMap, (Map<String, Object>)newFkMap));
        scala.collection.immutable.Map oldIdxMap = ((IterableOnceOps)older.indexes().map((Function1 & Serializable)c -> Tuple2$.MODULE$.apply((Object)c.name().toLiteral(engine), c))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map newIdxMap = ((IterableOnceOps)newer.indexes().map((Function1 & Serializable)c -> Tuple2$.MODULE$.apply((Object)c.name().toLiteral(engine), c))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        table.indexes_$eq(this.nameDiff((scala.collection.immutable.Set<String>)oldIdxMap.keySet(), (scala.collection.immutable.Set<String>)newIdxMap.keySet(), (Map<String, Object>)oldIdxMap, (Map<String, Object>)newIdxMap));
        if (table.isEmpty()) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)table);
    }

    private NameDiff nameDiff(scala.collection.immutable.Set<String> oldNames, scala.collection.immutable.Set<String> newNames, Map<String, Object> oldDatas, Map<String, Object> newDatas) {
        scala.collection.immutable.Set updated = (scala.collection.immutable.Set)oldNames.intersect(newNames).filter((Function1 & Serializable)n -> !BoxesRunTime.equals((Object)newDatas.apply(n), (Object)oldDatas.apply(n)));
        return NameDiff$.MODULE$.apply((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)newNames.diff(oldNames)), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)oldNames.diff(newNames)), (scala.collection.immutable.Set<Tuple2<String, String>>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<String>)updated);
    }

    public Iterable<String> sql(DatabaseDiff diff) {
        if (diff.isEmpty()) {
            return package$.MODULE$.List().empty();
        }
        Buffer schemaDdl = Collections$.MODULE$.newBuffer();
        Buffer dropTableDdl = Collections$.MODULE$.newBuffer();
        Buffer newTableDdl = Collections$.MODULE$.newBuffer();
        Buffer columnDdl = Collections$.MODULE$.newBuffer();
        Buffer primaryKeyDdl = Collections$.MODULE$.newBuffer();
        Buffer foreignKeyDdl = Collections$.MODULE$.newBuffer();
        Buffer uniqueKeyDdl = Collections$.MODULE$.newBuffer();
        Buffer indexDdl = Collections$.MODULE$.newBuffer();
        Buffer commentDdl = Collections$.MODULE$.newBuffer();
        Engine engine = diff.newer().engine();
        diff.schemas().newerList().foreach((Function1 & Serializable)n -> (Buffer)schemaDdl.$plus$eq((Object)("create schema " + n)));
        diff.schemas().removedList().foreach((Function1 & Serializable)n -> (Buffer)schemaDdl.$plus$eq((Object)("DROP schema " + n + " cascade")));
        ((List)diff.schemaDiffs().keys().toList().sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1)(JProcedure1 & Serializable)schema -> {
            SchemaDiff sdf = (SchemaDiff)diff.schemaDiffs().apply(schema);
            sdf.tables().removedList().foreach((Function1 & Serializable)t -> (Buffer)dropTableDdl.$plus$eq((Object)engine.dropTable(((Table)diff.older().getTable((String)schema, (String)t).get()).qualifiedName())));
            sdf.tables().newerList().foreach((Function1)(JProcedure1 & Serializable)t -> {
                Table tb = (Table)diff.newer().getTable((String)schema, (String)t).get();
                newTableDdl.$plus$eq((Object)engine.createTable(tb));
                commentDdl.$plus$plus$eq(engine.commentsOnTable(tb, false));
                AlterTableDialect alter = engine.alterTable(tb);
                tb.primaryKey().foreach((Function1 & Serializable)pk -> (Buffer)primaryKeyDdl.$plus$eq((Object)alter.addPrimaryKey((PrimaryKey)pk)));
                tb.uniqueKeys().foreach((Function1 & Serializable)uk -> (Buffer)uniqueKeyDdl.$plus$eq((Object)alter.addUnique((UniqueKey)uk)));
                tb.indexes().foreach((Function1 & Serializable)idx -> (Buffer)indexDdl.$plus$eq((Object)engine.createIndex((Index)idx)));
                tb.foreignKeys().foreach((Function1 & Serializable)fk -> (Buffer)foreignKeyDdl.$plus$eq((Object)alter.addForeignKey((ForeignKey)fk)));
            });
            ((List)sdf.tableDiffs().keys().toList().sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1)(JProcedure1 & Serializable)t -> {
                TableDiff tdf = (TableDiff)sdf.tableDiffs().apply(t);
                AlterTableDialect alter = engine.alterTable(tdf.newer());
                if (tdf.hasComment()) {
                    commentDdl.$plus$plus$eq(engine.commentOnTable(tdf.older().qualifiedName(), (Option<String>)tdf.newer().comment()));
                }
                tdf.columns().removedList().foreach((Function1 & Serializable)c -> (Buffer)columnDdl.$plus$eq((Object)alter.dropColumn(tdf.older().column((String)c))));
                tdf.columns().newerList().foreach((Function1)(JProcedure1 & Serializable)c2 -> {
                    Column column = tdf.newer().column((String)c2);
                    columnDdl.$plus$plus$eq(alter.addColumn(column));
                    column.comment().foreach((Function1 & Serializable)c -> (Buffer)commentDdl.$plus$plus$eq(engine.commentOnColumn(tdf.newer(), column, (Option<String>)Some$.MODULE$.apply(c))));
                });
                tdf.columns().renamed().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String o = (String)tuple2._1();
                        String n = (String)tuple2._2();
                        Column oCol = tdf.older().column(o);
                        Column nCol = tdf.newer().column(n);
                        columnDdl.$plus$eq((Object)alter.renameColumn(oCol, nCol.name().toLiteral(engine)));
                        this.alterColumn(engine, alter, tdf.newer(), oCol, nCol, (Buffer<String>)columnDdl, (Buffer<String>)commentDdl);
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                });
                tdf.columns().updatedList().foreach((Function1)(JProcedure1 & Serializable)c -> {
                    Column oCol = tdf.older().column((String)c);
                    Column nCol = tdf.newer().column((String)c);
                    this.alterColumn(engine, alter, tdf.newer(), oCol, nCol, (Buffer<String>)columnDdl, (Buffer<String>)commentDdl);
                });
                if (tdf.hasPrimaryKey()) {
                    if (tdf.older().primaryKey().nonEmpty()) {
                        primaryKeyDdl.$plus$eq((Object)alter.dropPrimaryKey((PrimaryKey)tdf.older().primaryKey().get()));
                    }
                    if (tdf.newer().primaryKey().nonEmpty()) {
                        primaryKeyDdl.$plus$eq((Object)alter.addPrimaryKey((PrimaryKey)tdf.newer().primaryKey().get()));
                    }
                }
                tdf.foreignKeys().removedList().foreach((Function1 & Serializable)fk -> (Buffer)foreignKeyDdl.$plus$eq((Object)alter.dropConstraint((String)fk)));
                tdf.foreignKeys().updatedList().foreach((Function1 & Serializable)fk -> {
                    foreignKeyDdl.$plus$eq((Object)alter.dropConstraint((String)fk));
                    return (Buffer)foreignKeyDdl.$plus$eq((Object)alter.addForeignKey((ForeignKey)tdf.newer().getForeignKey((String)fk).get()));
                });
                tdf.foreignKeys().newerList().foreach((Function1 & Serializable)fk -> (Buffer)foreignKeyDdl.$plus$eq((Object)alter.addForeignKey((ForeignKey)tdf.newer().getForeignKey((String)fk).get())));
                tdf.uniqueKeys().removedList().foreach((Function1 & Serializable)uk -> (Buffer)uniqueKeyDdl.$plus$eq((Object)alter.dropConstraint((String)uk)));
                tdf.uniqueKeys().updatedList().foreach((Function1 & Serializable)uk -> {
                    uniqueKeyDdl.$plus$eq((Object)alter.dropConstraint((String)uk));
                    return (Buffer)uniqueKeyDdl.$plus$eq((Object)alter.addUnique((UniqueKey)tdf.newer().getUniqueKey((String)uk).get()));
                });
                tdf.uniqueKeys().newerList().foreach((Function1 & Serializable)uk -> (Buffer)uniqueKeyDdl.$plus$eq((Object)alter.addUnique((UniqueKey)tdf.newer().getUniqueKey((String)uk).get())));
                tdf.indexes().removedList().foreach((Function1 & Serializable)idx -> (Buffer)indexDdl.$plus$eq((Object)engine.dropIndex((Index)tdf.older().getIndex((String)idx).get())));
                tdf.indexes().updatedList().foreach((Function1 & Serializable)idx -> {
                    indexDdl.$plus$eq((Object)engine.dropIndex((Index)tdf.older().getIndex((String)idx).get()));
                    return (Buffer)indexDdl.$plus$eq((Object)engine.createIndex((Index)tdf.newer().getIndex((String)idx).get()));
                });
                tdf.indexes().newerList().foreach((Function1 & Serializable)idx -> (Buffer)indexDdl.$plus$eq((Object)engine.createIndex((Index)tdf.newer().getIndex((String)idx).get())));
            });
        });
        Buffer result = Collections$.MODULE$.newBuffer();
        result.$plus$plus$eq((IterableOnce)schemaDdl);
        result.$plus$plus$eq((IterableOnce)dropTableDdl);
        result.$plus$plus$eq((IterableOnce)newTableDdl);
        result.$plus$plus$eq((IterableOnce)columnDdl);
        result.$plus$plus$eq((IterableOnce)primaryKeyDdl);
        result.$plus$plus$eq((IterableOnce)foreignKeyDdl);
        result.$plus$plus$eq((IterableOnce)uniqueKeyDdl);
        result.$plus$plus$eq((IterableOnce)indexDdl);
        result.$plus$plus$eq((IterableOnce)commentDdl);
        return result;
    }

    private void alterColumn(Engine engine, AlterTableDialect alter, Table table, Column oCol, Column nCol, Buffer<String> columnDdl, Buffer<String> commentDdl) {
        String string = nCol.sqlType().name();
        String string2 = oCol.sqlType().name();
        if (string == null ? string2 != null : !string.equals(string2)) {
            columnDdl.$plus$eq((Object)alter.modifyColumnType(oCol, nCol.sqlType()));
        }
        if (!((String)nCol.defaultValue().getOrElse(this::alterColumn$$anonfun$1)).equalsIgnoreCase((String)oCol.defaultValue().getOrElse(this::alterColumn$$anonfun$2))) {
            columnDdl.$plus$eq((Object)alter.modifyColumnDefault(oCol, nCol.defaultValue()));
        }
        if (nCol.nullable() != oCol.nullable()) {
            if (nCol.nullable()) {
                columnDdl.$plus$eq((Object)alter.modifyColumnDropNotNull(nCol));
            } else {
                columnDdl.$plus$eq((Object)alter.modifyColumnSetNotNull(nCol));
            }
        }
        Option option = nCol.comment();
        Option option2 = oCol.comment();
        if (option == null ? option2 != null : !option.equals(option2)) {
            commentDdl.$plus$plus$eq(engine.commentOnColumn(table, nCol, (Option<String>)nCol.comment()));
            return;
        }
    }

    private final String alterColumn$$anonfun$1() {
        return "";
    }

    private final String alterColumn$$anonfun$2() {
        return "";
    }
}

