/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.meta;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.ThreadTasks$;
import org.beangle.commons.lang.time.Stopwatch;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.jdbc.engine.Engine;
import org.beangle.data.jdbc.meta.Column;
import org.beangle.data.jdbc.meta.Constraint;
import org.beangle.data.jdbc.meta.Database;
import org.beangle.data.jdbc.meta.ForeignKey;
import org.beangle.data.jdbc.meta.Identifier;
import org.beangle.data.jdbc.meta.Identifier$;
import org.beangle.data.jdbc.meta.Index;
import org.beangle.data.jdbc.meta.MetadataColumns$;
import org.beangle.data.jdbc.meta.MetadataLoadSql;
import org.beangle.data.jdbc.meta.PrimaryKey;
import org.beangle.data.jdbc.meta.Schema;
import org.beangle.data.jdbc.meta.Schema$NameFilter$;
import org.beangle.data.jdbc.meta.Sequence;
import org.beangle.data.jdbc.meta.SqlType;
import org.beangle.data.jdbc.meta.Table;
import org.beangle.data.jdbc.meta.Table$;
import org.beangle.data.jdbc.meta.TableRef$;
import org.slf4j.Logger;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map;
import scala.jdk.javaapi.CollectionConverters$;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class MetadataLoader
implements Logging {
    private Logger logger;
    public final DatabaseMetaData org$beangle$data$jdbc$meta$MetadataLoader$$meta;
    public final Engine org$beangle$data$jdbc$meta$MetadataLoader$$engine;

    public MetadataLoader(DatabaseMetaData meta, Engine engine) {
        this.org$beangle$data$jdbc$meta$MetadataLoader$$meta = meta;
        this.org$beangle$data$jdbc$meta$MetadataLoader$$engine = engine;
        Logging.$init$((Logging)this);
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public Set<String> schemas() {
        Buffer names = Collections$.MODULE$.newBuffer();
        if (this.org$beangle$data$jdbc$meta$MetadataLoader$$engine.catalogAsSchema()) {
            ResultSet rs = this.org$beangle$data$jdbc$meta$MetadataLoader$$meta.getCatalogs();
            while (rs.next()) {
                names.addOne((Object)rs.getString("TABLE_CAT"));
            }
            rs.close();
        } else {
            ResultSet rs = this.org$beangle$data$jdbc$meta$MetadataLoader$$meta.getSchemas();
            while (rs.next()) {
                names.addOne((Object)rs.getString("TABLE_SCHEM"));
            }
            rs.close();
        }
        return names.toSet();
    }

    public void loadTables(Schema schema, boolean extras) {
        Schema.NameFilter filter = new Schema.NameFilter(Schema$NameFilter$.MODULE$.$lessinit$greater$default$1());
        filter.include("*");
        this.loadTables(schema, filter, extras);
    }

    public void loadTables(Schema schema, Schema.NameFilter filter, boolean extras) {
        String[] TYPES = new String[]{"TABLE"};
        String catalogName = schema.catalog() == null || schema.catalog().isEmpty() ? null : ((Identifier)schema.catalog().get()).value();
        String schemaPattern = schema.name().value();
        if (Strings$.MODULE$.isBlank((CharSequence)catalogName)) {
            catalogName = null;
        }
        if (Strings$.MODULE$.isBlank((CharSequence)schemaPattern)) {
            schemaPattern = null;
        }
        if (catalogName == null && schemaPattern != null && this.org$beangle$data$jdbc$meta$MetadataLoader$$engine.catalogAsSchema()) {
            String t = catalogName;
            catalogName = schemaPattern;
            schemaPattern = t;
        }
        Stopwatch sw = new Stopwatch(true);
        ObjectRef rs = ObjectRef.create((Object)this.org$beangle$data$jdbc$meta$MetadataLoader$$meta.getTables(catalogName, schemaPattern, null, TYPES));
        HashMap tables = new HashMap();
        while (((ResultSet)rs.elem).next()) {
            String tableName = ((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.TableName());
            if (tableName.contains("$") || !filter.isMatched(tableName)) continue;
            Table table2 = schema.database().addTable(this.getTableSchema((ResultSet)rs.elem), ((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.TableName()));
            table2.updateCommentAndModule(((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.Remarks()));
            tables.put((Object)Table$.MODULE$.qualify(table2.schema(), table2.name()), (Object)table2);
        }
        ((ResultSet)rs.elem).close();
        Logger$.MODULE$.info$extension(this.logger(), () -> MetadataLoader.loadTables$$anonfun$1(sw, tables));
        sw.reset().start();
        ResultSet resultSet = this.org$beangle$data$jdbc$meta$MetadataLoader$$meta.getColumns(catalogName, schemaPattern, "%", "%");
        rs.elem = resultSet;
        resultSet = null;
        IntRef cols = IntRef.create((int)0);
        Map types = Collections$.MODULE$.newMap();
        while (((ResultSet)rs.elem).next()) {
            String defaultValue = ((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.ColumnDef());
            String colName = ((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.ColumnName());
            if (colName == null) continue;
            this.getTable(schema.database(), this.getTableSchema((ResultSet)rs.elem), ((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.TableName())).foreach((Function1)(JProcedure1 & Serializable)table -> {
                int n;
                String typename = new StringTokenizer(((ResultSet)rs$1.elem).getString(MetadataColumns$.MODULE$.TypeName()), "() ").nextToken();
                int typecode = this.org$beangle$data$jdbc$meta$MetadataLoader$$engine.resolveCode(((ResultSet)rs$1.elem).getInt(MetadataColumns$.MODULE$.DataType()), typename);
                int length = ((ResultSet)rs$1.elem).getInt(MetadataColumns$.MODULE$.ColumnSize());
                int scale = ((ResultSet)rs$1.elem).getInt(MetadataColumns$.MODULE$.DecimalDigits());
                String key = typecode + "-" + typename + "-" + length + "-" + scale;
                SqlType sqlType = (SqlType)types.getOrElseUpdate((Object)key, () -> this.$anonfun$1(typecode, length, scale));
                boolean nullable = "yes".equalsIgnoreCase(((ResultSet)rs$1.elem).getString(MetadataColumns$.MODULE$.IsNullable()));
                Column col = new Column(Identifier$.MODULE$.apply(((ResultSet)rs$1.elem).getString(MetadataColumns$.MODULE$.ColumnName()), Identifier$.MODULE$.$lessinit$greater$default$2()), sqlType, nullable);
                col.comment_$eq(Option$.MODULE$.apply((Object)((ResultSet)rs$1.elem).getString(MetadataColumns$.MODULE$.Remarks())));
                if (defaultValue != null) {
                    String dv = Strings$.MODULE$.trim(defaultValue);
                    if (Strings$.MODULE$.isNotEmpty((CharSequence)dv) && dv.contains("::")) {
                        dv = Strings$.MODULE$.substringBefore(dv, "::");
                    }
                    if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(dv))) {
                        String string = dv;
                        String string2 = "null";
                        if (string == null ? string2 != null : !string.equals(string2)) {
                            col.defaultValue_$eq((Option<String>)Option$.MODULE$.apply((Object)dv));
                        }
                    }
                }
                table.add(col);
                cols$1.elem = n = cols$1.elem + 1;
            });
        }
        ((ResultSet)rs.elem).close();
        int origTabCount = tables.size();
        schema.cleanEmptyTables();
        tables.filterInPlace((Function2 & Serializable)(_$1, table) -> table.columns().nonEmpty());
        if (tables.size() == origTabCount) {
            Logger$.MODULE$.info$extension(this.logger(), () -> MetadataLoader.loadTables$$anonfun$4(sw, cols));
        } else {
            Logger$.MODULE$.info$extension(this.logger(), () -> MetadataLoader.loadTables$$anonfun$5(sw, tables, cols, origTabCount));
        }
        if (extras) {
            if (this.org$beangle$data$jdbc$meta$MetadataLoader$$engine.metadataLoadSql().supportsTableExtra()) {
                this.batchLoadExtra(schema, this.org$beangle$data$jdbc$meta$MetadataLoader$$engine.metadataLoadSql());
                return;
            }
            Logger$.MODULE$.debug$extension(this.logger(), MetadataLoader::loadTables$$anonfun$6);
            ConcurrentLinkedQueue<String> tableNames = new ConcurrentLinkedQueue<String>();
            tableNames.addAll(CollectionConverters$.MODULE$.asJava((Seq)tables.keySet().toList().sortWith((Function2 & Serializable)(_$2, _$3) -> StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(_$2), _$3))));
            ThreadTasks$.MODULE$.start((Runnable)new MetaLoadTask(this, tableNames, (HashMap<String, Table>)tables), 5, "meta-loader");
            return;
        }
    }

    private String getTableSchema(ResultSet rs) {
        return rs.getString(this.org$beangle$data$jdbc$meta$MetadataLoader$$engine.catalogAsSchema() ? MetadataColumns$.MODULE$.TableCat() : MetadataColumns$.MODULE$.TableSchema());
    }

    private void batchLoadExtra(Schema schema, MetadataLoadSql sql) {
        Stopwatch sw = new Stopwatch(true);
        ObjectRef rs = ObjectRef.create(null);
        String schemaName = schema.name().toLiteral(this.org$beangle$data$jdbc$meta$MetadataLoader$$engine);
        ResultSet resultSet = this.org$beangle$data$jdbc$meta$MetadataLoader$$meta.getConnection().createStatement().executeQuery(sql.primaryKeySql().replace(":schema", schemaName));
        rs.elem = resultSet;
        resultSet = null;
        while (((ResultSet)rs.elem).next()) {
            this.getTable(schema.database(), ((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.TableSchema()), ((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.TableName())).foreach((Function1)(JProcedure1 & Serializable)table -> {
                String colname = ((ResultSet)rs$2.elem).getString(MetadataColumns$.MODULE$.ColumnName());
                Identifier pkName = this.org$beangle$data$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs$2.elem, MetadataColumns$.MODULE$.PKName());
                Option<PrimaryKey> option = table.primaryKey();
                if (None$.MODULE$.equals(option)) {
                    table.primaryKey_$eq((Option<PrimaryKey>)Some$.MODULE$.apply((Object)new PrimaryKey((Table)table, pkName, table.column(colname).name())));
                    return;
                }
                if (option instanceof Some) {
                    PrimaryKey pk = (PrimaryKey)((Some)option).value();
                    pk.addColumn(table.column(colname));
                    return;
                }
                throw new MatchError(option);
            });
        }
        ((ResultSet)rs.elem).close();
        ResultSet resultSet2 = this.org$beangle$data$jdbc$meta$MetadataLoader$$meta.getConnection().createStatement().executeQuery(sql.importedKeySql().replace(":schema", schemaName));
        rs.elem = resultSet2;
        resultSet2 = null;
        while (((ResultSet)rs.elem).next()) {
            this.getTable(schema.database(), ((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.FKTabkeSchem()), ((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.FKTableName())).foreach((Function1)(JProcedure1 & Serializable)table -> {
                ForeignKey foreignKey;
                Identifier fkName = this.org$beangle$data$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs$3.elem, MetadataColumns$.MODULE$.FKName());
                Column column = table.column(((ResultSet)rs$3.elem).getString(MetadataColumns$.MODULE$.FKColumnName()));
                Option<ForeignKey> option = table.getForeignKey(fkName.value());
                if (None$.MODULE$.equals(option)) {
                    foreignKey = table.add(new ForeignKey((Table)table, this.org$beangle$data$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs$3.elem, MetadataColumns$.MODULE$.FKName()), column.name()));
                } else if (option instanceof Some) {
                    ForeignKey oldk;
                    foreignKey = oldk = (ForeignKey)((Some)option).value();
                } else {
                    throw new MatchError(option);
                }
                ForeignKey fk = foreignKey;
                Schema pkSchema = schema.database().getOrCreateSchema(this.org$beangle$data$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs$3.elem, MetadataColumns$.MODULE$.PKTableSchem()));
                fk.refer(TableRef$.MODULE$.apply(pkSchema, this.org$beangle$data$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs$3.elem, MetadataColumns$.MODULE$.PKTableName())), (scala.collection.immutable.Seq<Identifier>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Identifier[]{this.org$beangle$data$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs$3.elem, MetadataColumns$.MODULE$.PKColumnName())}));
                fk.cascadeDelete_$eq(((ResultSet)rs$3.elem).getInt(MetadataColumns$.MODULE$.DeleteRule()) != 3);
            });
        }
        ((ResultSet)rs.elem).close();
        ResultSet resultSet3 = this.org$beangle$data$jdbc$meta$MetadataLoader$$meta.getConnection().createStatement().executeQuery(sql.indexInfoSql().replace(":schema", schemaName));
        rs.elem = resultSet3;
        resultSet3 = null;
        while (((ResultSet)rs.elem).next()) {
            this.getTable(schema.database(), ((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.TableSchema()), ((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.TableName())).foreach((Function1)(JProcedure1 & Serializable)table -> {
                String indexName = ((ResultSet)rs$4.elem).getString(MetadataColumns$.MODULE$.IndexName());
                if (!table.primaryKey().exists((Function1 & Serializable)_$4 -> {
                    String string = _$4.name().value();
                    String string2 = indexName;
                    return !(string != null ? !string.equals(string2) : string2 != null);
                })) {
                    Index index;
                    Option<Index> option = table.getIndex(indexName);
                    if (None$.MODULE$.equals(option)) {
                        index = table.add(new Index((Table)table, Identifier$.MODULE$.apply(indexName, Identifier$.MODULE$.$lessinit$greater$default$2())));
                    } else if (option instanceof Some) {
                        Index oldIdx;
                        index = oldIdx = (Index)((Some)option).value();
                    } else {
                        throw new MatchError(option);
                    }
                    Index idx = index;
                    idx.unique_$eq(!((ResultSet)rs$4.elem).getBoolean("NON_UNIQUE"));
                    String columnName = ((ResultSet)rs$4.elem).getString(MetadataColumns$.MODULE$.ColumnName());
                    Option<Column> option2 = table.getColumn(columnName);
                    if (option2 instanceof Some) {
                        Column column = (Column)((Some)option2).value();
                        idx.addColumn(column.name());
                        return;
                    }
                    if (None$.MODULE$.equals(option2)) {
                        idx.addColumn(Identifier$.MODULE$.apply(columnName, Identifier$.MODULE$.$lessinit$greater$default$2()));
                        return;
                    }
                    throw new MatchError(option2);
                }
            });
        }
        ((ResultSet)rs.elem).close();
        schema.tables().values().foreach((Function1)(JProcedure1 & Serializable)t -> t.convertIndexToUniqueKeys());
        Logger$.MODULE$.info$extension(this.logger(), () -> MetadataLoader.batchLoadExtra$$anonfun$5(sw));
    }

    /*
     * Unable to fully structure code
     */
    public void loadSequences(Schema schema) {
        block14: {
            sequences = new HashSet();
            if (Strings$.MODULE$.isBlank((CharSequence)this.org$beangle$data$jdbc$meta$MetadataLoader$$engine.metadataLoadSql().sequenceSql())) {
                return;
            }
            sql = this.org$beangle$data$jdbc$meta$MetadataLoader$$engine.metadataLoadSql().sequenceSql();
            if ((sql = Strings$.MODULE$.replace(sql, ":schema", schema.name().toLiteral(this.org$beangle$data$jdbc$meta$MetadataLoader$$engine))) == null) break block14;
            statement = null;
            rs = ObjectRef.create(null);
            try {
                statement = this.org$beangle$data$jdbc$meta$MetadataLoader$$meta.getConnection().createStatement();
                var6_6 = statement.executeQuery(sql);
                rs.elem = var6_6;
                var6_6 = null;
                columnNames = new HashSet();
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), ((ResultSet)rs.elem).getMetaData().getColumnCount()).foreach((Function1)(JFunction1.mcZI.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (I)Z, loadSequences$$anonfun$1(scala.runtime.ObjectRef scala.collection.mutable.HashSet int ), (I)Z)((ObjectRef)rs, (HashSet)columnNames));
                while (((ResultSet)rs.elem).next()) {
                    block15: {
                        sequence = new Sequence(schema, this.org$beangle$data$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs.elem, "sequence_name"));
                        if (columnNames.contains((Object)"current_value")) {
                            sequence.current_$eq(Long.valueOf(((ResultSet)rs.elem).getString("current_value")));
                        } else if (columnNames.contains((Object)"next_value")) {
                            sequence.current_$eq(Long.valueOf(((ResultSet)rs.elem).getString("next_value")) - 1L);
                        }
                        if (columnNames.contains((Object)"increment_by")) {
                            sequence.increment_$eq(Integer.valueOf(((ResultSet)rs.elem).getString("increment_by")));
                        }
                        if (columnNames.contains((Object)"cache_size")) {
                            sequence.cache_$eq(Integer.valueOf(((ResultSet)rs.elem).getString("cache_size")));
                        }
                        if (!columnNames.contains((Object)"cycle_flag")) break block15;
                        v0 = flag = ((ResultSet)rs.elem).getString("cycle_flag").toLowerCase();
                        var10_10 = "y";
                        if (!(v0 == null ? var10_10 != null : v0.equals(var10_10) == false)) ** GOTO lbl-1000
                        v1 = flag;
                        var11_11 = "yes";
                        if (!(v1 == null ? var11_11 != null : v1.equals(var11_11) == false)) ** GOTO lbl-1000
                        v2 = flag;
                        var12_12 = "on";
                        if (!(v2 != null ? v2.equals(var12_12) == false : var12_12 != null)) lbl-1000:
                        // 3 sources

                        {
                            v3 = true;
                        } else {
                            v3 = false;
                        }
                        sequence.cycle_$eq(v3);
                    }
                    sequences.$plus$eq((Object)sequence);
                }
            }
            finally {
                if ((ResultSet)rs.elem != null) {
                    ((ResultSet)rs.elem).close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
        }
        schema.sequences().$plus$plus$eq((IterableOnce)sequences);
    }

    public Identifier org$beangle$data$jdbc$meta$MetadataLoader$$getIdentifier(ResultSet rs, String columnName) {
        return Identifier$.MODULE$.apply(rs.getString(columnName), Identifier$.MODULE$.$lessinit$greater$default$2());
    }

    private Option<Table> getTable(Database database, String schemaName, String name) {
        return database.getTable(schemaName, name);
    }

    private static final String loadTables$$anonfun$1(Stopwatch sw$1, HashMap tables$1) {
        return "Load " + tables$1.size() + " tables in " + sw$1.toString();
    }

    private final SqlType $anonfun$1(int typecode$1, int length$1, int scale$1) {
        return this.org$beangle$data$jdbc$meta$MetadataLoader$$engine.toType(typecode$1, length$1, scale$1);
    }

    private static final String loadTables$$anonfun$4(Stopwatch sw$2, IntRef cols$2) {
        return "Load " + cols$2.elem + " columns in " + sw$2;
    }

    private static final String loadTables$$anonfun$5(Stopwatch sw$3, HashMap tables$2, IntRef cols$3, int origTabCount$1) {
        return "Load " + cols$3.elem + " columns and evict empty " + (origTabCount$1 - tables$2.size()) + " tables in " + sw$3 + ".";
    }

    private static final String loadTables$$anonfun$6() {
        return "Loading primary key,foreign key and index.";
    }

    private static final String batchLoadExtra$$anonfun$5(Stopwatch sw$4) {
        return "Load constraint and index in " + sw$4 + ".";
    }

    public static final String org$beangle$data$jdbc$meta$MetadataLoader$MetaLoadTask$$_$run$$anonfun$1(Table table$1) {
        return "Loading " + table$1.qualifiedName() + "...";
    }

    public static final String org$beangle$data$jdbc$meta$MetadataLoader$MetaLoadTask$$_$run$$anonfun$2() {
        return "Error in loading metadata ";
    }

    public static final Throwable org$beangle$data$jdbc$meta$MetadataLoader$MetaLoadTask$$_$run$$anonfun$3(Exception e$1) {
        return e$1;
    }

    public static final String org$beangle$data$jdbc$meta$MetadataLoader$MetaLoadTask$$_$run$$anonfun$4(IntRef completed$1) {
        return Thread.currentThread().getName() + " loaded " + completed$1.elem + " tables";
    }

    private static final /* synthetic */ boolean loadSequences$$anonfun$1(ObjectRef rs$6, HashSet columnNames$1, int i) {
        return columnNames$1.add((Object)((ResultSet)rs$6.elem).getMetaData().getColumnLabel(i).toLowerCase());
    }

    public class MetaLoadTask
    implements Runnable {
        private final ConcurrentLinkedQueue buffer;
        private final HashMap tables;
        private final /* synthetic */ MetadataLoader $outer;

        public MetaLoadTask(MetadataLoader $outer, ConcurrentLinkedQueue<String> buffer, HashMap<String, Table> tables) {
            this.buffer = buffer;
            this.tables = tables;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public ConcurrentLinkedQueue<String> buffer() {
            return this.buffer;
        }

        public HashMap<String, Table> tables() {
            return this.tables;
        }

        @Override
        public void run() {
            IntRef completed = IntRef.create((int)0);
            String nextTableName = this.buffer().poll();
            while (nextTableName != null) {
                try {
                    int n;
                    Table table = (Table)this.tables().apply((Object)nextTableName);
                    Schema schema = table.schema();
                    String catalogName = this.$outer.org$beangle$data$jdbc$meta$MetadataLoader$$engine.catalogAsSchema() ? table.schema().name().value() : null;
                    String schemaName = this.$outer.org$beangle$data$jdbc$meta$MetadataLoader$$engine.catalogAsSchema() ? null : table.schema().name().value();
                    Logger$.MODULE$.debug$extension(this.$outer.logger(), () -> MetadataLoader.org$beangle$data$jdbc$meta$MetadataLoader$MetaLoadTask$$_$run$$anonfun$1(table));
                    ObjectRef rs = ObjectRef.create(null);
                    ResultSet resultSet = this.$outer.org$beangle$data$jdbc$meta$MetadataLoader$$meta.getPrimaryKeys(catalogName, schemaName, table.name().value());
                    rs.elem = resultSet;
                    resultSet = null;
                    Constraint pk = null;
                    while (((ResultSet)rs.elem).next()) {
                        Identifier colName = Identifier$.MODULE$.apply(((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.ColumnName()), Identifier$.MODULE$.$lessinit$greater$default$2());
                        if (pk == null) {
                            pk = new PrimaryKey(table, Identifier$.MODULE$.apply(((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.PKName()), Identifier$.MODULE$.$lessinit$greater$default$2()), colName);
                            continue;
                        }
                        pk.addColumn(colName);
                    }
                    if (pk != null) {
                        table.primaryKey_$eq((Option<PrimaryKey>)Some$.MODULE$.apply(pk));
                    }
                    ((ResultSet)rs.elem).close();
                    ResultSet resultSet2 = this.$outer.org$beangle$data$jdbc$meta$MetadataLoader$$meta.getImportedKeys(catalogName, schemaName, table.name().value());
                    rs.elem = resultSet2;
                    resultSet2 = null;
                    while (((ResultSet)rs.elem).next()) {
                        ForeignKey foreignKey;
                        String fkName = ((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.FKName());
                        Identifier columnName = Identifier$.MODULE$.apply(((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.FKColumnName()), Identifier$.MODULE$.$lessinit$greater$default$2());
                        Option<ForeignKey> option = table.getForeignKey(fkName);
                        if (None$.MODULE$.equals(option)) {
                            foreignKey = table.add(new ForeignKey(table, Identifier$.MODULE$.apply(((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.FKName()), Identifier$.MODULE$.$lessinit$greater$default$2()), columnName));
                        } else if (option instanceof Some) {
                            ForeignKey oldk;
                            foreignKey = oldk = (ForeignKey)((Some)option).value();
                        } else {
                            throw new MatchError(option);
                        }
                        ForeignKey fk = foreignKey;
                        Schema pkSchema = schema.database().getOrCreateSchema(this.$outer.org$beangle$data$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs.elem, this.$outer.org$beangle$data$jdbc$meta$MetadataLoader$$engine.catalogAsSchema() ? MetadataColumns$.MODULE$.PKTableCat() : MetadataColumns$.MODULE$.PKTableSchem()));
                        fk.refer(TableRef$.MODULE$.apply(pkSchema, this.$outer.org$beangle$data$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs.elem, MetadataColumns$.MODULE$.PKTableName())), (scala.collection.immutable.Seq<Identifier>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Identifier[]{this.$outer.org$beangle$data$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs.elem, MetadataColumns$.MODULE$.PKColumnName())}));
                        fk.cascadeDelete_$eq(((ResultSet)rs.elem).getInt(MetadataColumns$.MODULE$.DeleteRule()) != 3);
                    }
                    ((ResultSet)rs.elem).close();
                    ResultSet resultSet3 = this.$outer.org$beangle$data$jdbc$meta$MetadataLoader$$meta.getIndexInfo(catalogName, schemaName, table.name().value(), false, true);
                    rs.elem = resultSet3;
                    resultSet3 = null;
                    while (((ResultSet)rs.elem).next()) {
                        String index = ((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.IndexName());
                        if (index == null || table.isPrimaryKeyIndex(index)) continue;
                        Index info = (Index)table.getIndex(index).getOrElse(() -> this.$anonfun$2(table, rs));
                        info.unique_$eq(!((ResultSet)rs.elem).getBoolean("NON_UNIQUE"));
                        info.addColumn(this.$outer.org$beangle$data$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs.elem, MetadataColumns$.MODULE$.ColumnName()));
                    }
                    ((ResultSet)rs.elem).close();
                    completed.elem = n = completed.elem + 1;
                    table.convertIndexToUniqueKeys();
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (Exception e) {
                    Logger$.MODULE$.error$extension(this.$outer.logger(), MetadataLoader::org$beangle$data$jdbc$meta$MetadataLoader$MetaLoadTask$$_$run$$anonfun$2, () -> MetadataLoader.org$beangle$data$jdbc$meta$MetadataLoader$MetaLoadTask$$_$run$$anonfun$3(e));
                }
                nextTableName = this.buffer().poll();
            }
            Logger$.MODULE$.debug$extension(this.$outer.logger(), () -> MetadataLoader.org$beangle$data$jdbc$meta$MetadataLoader$MetaLoadTask$$_$run$$anonfun$4(completed));
        }

        public final /* synthetic */ MetadataLoader org$beangle$data$jdbc$meta$MetadataLoader$MetaLoadTask$$$outer() {
            return this.$outer;
        }

        private final Index $anonfun$2(Table table$2, ObjectRef rs$5) {
            return table$2.add(new Index(table$2, this.$outer.org$beangle$data$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs$5.elem, MetadataColumns$.MODULE$.IndexName())));
        }
    }
}

