/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.meta;

import java.io.Serializable;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.regex.AntPathPattern;
import org.beangle.data.jdbc.engine.Engine;
import org.beangle.data.jdbc.meta.Database;
import org.beangle.data.jdbc.meta.Identifier;
import org.beangle.data.jdbc.meta.Schema$NameFilter$;
import org.beangle.data.jdbc.meta.Sequence;
import org.beangle.data.jdbc.meta.Table;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;

public class Schema {
    private Database database;
    private Identifier name;
    private Option catalog;
    private final HashMap tables;
    private final HashSet sequences;

    public Schema(Database database, Identifier name) {
        this.database = database;
        this.name = name;
        this.catalog = None$.MODULE$;
        if (this.name() == null) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this.tables = new HashMap();
        this.sequences = new HashSet();
    }

    public Database database() {
        return this.database;
    }

    public void database_$eq(Database x$1) {
        this.database = x$1;
    }

    public Identifier name() {
        return this.name;
    }

    public void name_$eq(Identifier x$1) {
        this.name = x$1;
    }

    public Option<Identifier> catalog() {
        return this.catalog;
    }

    public void catalog_$eq(Option<Identifier> x$1) {
        this.catalog = x$1;
    }

    public HashMap<Identifier, Table> tables() {
        return this.tables;
    }

    public HashSet<Sequence> sequences() {
        return this.sequences;
    }

    public boolean hasQuotedIdentifier() {
        return this.tables().exists((Function1 & Serializable)_$3 -> ((Table)_$3._2()).hasQuotedIdentifier());
    }

    public void cleanEmptyTables() {
        this.tables().filterInPlace((Function2 & Serializable)(_$4, table) -> table.columns().nonEmpty());
    }

    public Schema addTable(Table table) {
        this.tables().put((Object)table.name(), (Object)table);
        return this;
    }

    public Table getOrCreateTable(String tbname) {
        Identifier tableId = this.database().engine().toIdentifier(tbname);
        Option option = this.tables().get((Object)tableId);
        if (option instanceof Some) {
            Table table = (Table)((Some)option).value();
            return table;
        }
        if (None$.MODULE$.equals(option)) {
            Table ntable = new Table(this, tableId);
            this.tables().put((Object)tableId, (Object)ntable);
            return ntable;
        }
        throw new MatchError((Object)option);
    }

    public Table createTable(String tbname) {
        Identifier tableId = this.database().engine().toIdentifier(tbname);
        Option option = this.tables().get((Object)tableId);
        if (option instanceof Some) {
            Table table = (Table)((Some)option).value();
            if (table.phantom()) {
                return table;
            }
            throw new RuntimeException("Table " + table.qualifiedName() + " is existed,creation aborted.");
        }
        if (None$.MODULE$.equals(option)) {
            Table ntable = new Table(this, tableId);
            this.tables().put((Object)tableId, (Object)ntable);
            return ntable;
        }
        throw new MatchError((Object)option);
    }

    public Option<Table> getTable(String tbname) {
        Engine engine = this.database().engine();
        if (tbname.contains(".")) {
            Identifier identifier = this.name();
            Identifier identifier2 = engine.toIdentifier(Strings$.MODULE$.substringBefore(tbname, "."));
            if (identifier == null ? identifier2 != null : !((Object)identifier).equals(identifier2)) {
                return None$.MODULE$;
            }
            return this.tables().get((Object)engine.toIdentifier(Strings$.MODULE$.substringAfter(tbname, ".")));
        }
        return this.tables().get((Object)engine.toIdentifier(tbname));
    }

    public Seq<Table> filterTables(Seq<String> includes, Seq<String> excludes) {
        NameFilter filter = new NameFilter(Schema$NameFilter$.MODULE$.$lessinit$greater$default$1());
        includes.foreach((Function1)(JProcedure1 & Serializable)include -> filter.include((String)include));
        excludes.foreach((Function1)(JProcedure1 & Serializable)exclude -> filter.exclude((String)exclude));
        return filter.filter((Iterable<Identifier>)this.tables().keySet()).map((Function1 & Serializable)t -> (Table)this.tables().apply(t));
    }

    public Seq<Sequence> filterSequences(Seq<String> includes, Seq<String> excludes) {
        Engine engine = this.database().engine();
        NameFilter filter = new NameFilter(Schema$NameFilter$.MODULE$.$lessinit$greater$default$1());
        includes.foreach((Function1)(JProcedure1 & Serializable)include -> filter.include((String)include));
        excludes.foreach((Function1)(JProcedure1 & Serializable)exclude -> filter.exclude((String)exclude));
        Map seqMap = ((IterableOnceOps)this.sequences().map((Function1 & Serializable)f -> Tuple2$.MODULE$.apply((Object)f.name(), f))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return filter.filter((Iterable<Identifier>)seqMap.keys()).map((Function1 & Serializable)s -> (Sequence)seqMap.apply(s));
    }

    public String toString() {
        return "Schema " + this.name();
    }

    public static class NameFilter {
        private final boolean lowercase;
        private final ListBuffer excludes;
        private final ListBuffer includes;

        public static boolean $lessinit$greater$default$1() {
            return Schema$NameFilter$.MODULE$.$lessinit$greater$default$1();
        }

        public NameFilter(boolean lowercase) {
            this.lowercase = lowercase;
            this.excludes = new ListBuffer();
            this.includes = new ListBuffer();
        }

        public ListBuffer<AntPathPattern> excludes() {
            return this.excludes;
        }

        public ListBuffer<AntPathPattern> includes() {
            return this.includes;
        }

        public List<Identifier> filter(Iterable<Identifier> tables) {
            ListBuffer results = new ListBuffer();
            tables.foreach((Function1)(JProcedure1 & Serializable)tabId -> {
                String tableName;
                String tabame = this.lowercase ? tabId.value().toLowerCase() : tabId.value();
                String string = tableName = tabame.contains(".") ? Strings$.MODULE$.substringAfter(tabame, ".") : tabame;
                if (this.isMatched(tableName)) {
                    results.$plus$eq(tabId);
                    return;
                }
            });
            return results.toList();
        }

        public boolean isMatched(String name) {
            return this.includes().exists((Function1 & Serializable)_$1 -> _$1.matches(name)) && !this.excludes().exists((Function1 & Serializable)_$2 -> _$2.matches(name));
        }

        public void exclude(String table) {
            this.excludes().$plus$eq((Object)new AntPathPattern(this.lowercase ? table.toLowerCase() : table));
        }

        public void include(String table) {
            this.includes().$plus$eq((Object)new AntPathPattern(this.lowercase ? table.toLowerCase() : table));
        }
    }
}

