/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.meta;

import java.io.Serializable;
import java.sql.Types;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.jdbc.meta.SqlType;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.deriving.Mirror;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class SqlType$
implements Mirror.Product,
Serializable {
    private static final Set<Object> numberTypeCodes;
    private static final Set<String> numberTypeNames;
    private static final Set<Object> stringTypeCodes;
    private static final Set<Object> timeTypeCodes;
    private static final Set<Object> temporalTypeCodes;
    public static final SqlType$ MODULE$;

    private SqlType$() {
    }

    static {
        MODULE$ = new SqlType$();
        numberTypeCodes = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-6, 5, 4, -5, 6, 7, 8, 2, 3}));
        numberTypeNames = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tinyint", "smallint", "int2", "integer", "int4", "int8", "bigint", "float4", "float", "double", "double precision", "numeric", "decimal", "number", "real", "identity"}));
        stringTypeCodes = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 12, -16}));
        timeTypeCodes = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{92, 2013, 93, 2014}));
        temporalTypeCodes = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{91, 92, 2013, 93, 2014}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SqlType$.class);
    }

    public SqlType apply(int code, String name, Option<Object> precision, Option<Object> scale) {
        return new SqlType(code, name, precision, scale);
    }

    public SqlType unapply(SqlType x$1) {
        return x$1;
    }

    public Set<Object> all() {
        Object[] fields = Types.class.getDeclaredFields();
        Object object = Predef$.MODULE$.refArrayOps(fields);
        return Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> _$1.getInt(null), ClassTag$.MODULE$.apply(Integer.TYPE))).toSet();
    }

    public boolean isNumberType(int code) {
        return numberTypeCodes.contains((Object)BoxesRunTime.boxToInteger((int)code));
    }

    public boolean isStringType(int code) {
        return stringTypeCodes.contains((Object)BoxesRunTime.boxToInteger((int)code));
    }

    public boolean isNumberType(String name) {
        String typeClass = name.contains("(") ? Strings$.MODULE$.substringBefore(name, "(") : name;
        return numberTypeNames.contains((Object)typeClass.toLowerCase());
    }

    public boolean isTimeType(int code) {
        return timeTypeCodes.contains((Object)BoxesRunTime.boxToInteger((int)code));
    }

    public boolean isTemporalType(int code) {
        return temporalTypeCodes.contains((Object)BoxesRunTime.boxToInteger((int)code));
    }

    public SqlType apply(int code, String name) {
        return this.apply(code, name, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    public SqlType apply(int code, String name, int precision) {
        return this.apply(code, name, precision, 0);
    }

    public SqlType apply(int code, String name, int precision, int scale) {
        None$ s;
        None$ p = precision > 0 ? Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)precision)) : None$.MODULE$;
        Object object = s = scale > 0 ? Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)scale)) : None$.MODULE$;
        if (this.isNumberType(code)) {
            return this.apply(code, name, (Option<Object>)p, (Option<Object>)s);
        }
        if (this.isStringType(code)) {
            return this.apply(code, name, (Option<Object>)p, (Option<Object>)None$.MODULE$);
        }
        if (this.isTimeType(code)) {
            if (code == 93 && s.contains((Object)BoxesRunTime.boxToInteger((int)6))) {
                s = None$.MODULE$;
            }
            return this.apply(code, name, (Option<Object>)None$.MODULE$, (Option<Object>)s);
        }
        return this.apply(code, name, (Option<Object>)p, (Option<Object>)s);
    }

    public SqlType fromProduct(Product x$0) {
        return new SqlType(BoxesRunTime.unboxToInt((Object)x$0.productElement(0)), (String)x$0.productElement(1), (Option<Object>)((Option)x$0.productElement(2)), (Option<Object>)((Option)x$0.productElement(3)));
    }
}

