/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.meta;

import java.io.Serializable;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.jdbc.engine.Engine;
import org.beangle.data.jdbc.meta.Column;
import org.beangle.data.jdbc.meta.Column$;
import org.beangle.data.jdbc.meta.Comment;
import org.beangle.data.jdbc.meta.Constraint$;
import org.beangle.data.jdbc.meta.ForeignKey;
import org.beangle.data.jdbc.meta.Identifier;
import org.beangle.data.jdbc.meta.Identifier$;
import org.beangle.data.jdbc.meta.Index;
import org.beangle.data.jdbc.meta.PrimaryKey;
import org.beangle.data.jdbc.meta.Schema;
import org.beangle.data.jdbc.meta.SqlType;
import org.beangle.data.jdbc.meta.Table$;
import org.beangle.data.jdbc.meta.TableRef;
import org.beangle.data.jdbc.meta.UniqueKey;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordered;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class Table
implements Ordered<Table>,
Cloneable,
Comment {
    private Option comment;
    private Schema schema;
    private Identifier name;
    private boolean phantom;
    private Option primaryKey;
    private final ListBuffer columns;
    private final ListBuffer uniqueKeys;
    private final ListBuffer foreignKeys;
    private final ListBuffer indexes;
    private Option module;

    public static Table apply(Schema schema, String string) {
        return Table$.MODULE$.apply(schema, string);
    }

    public static String qualify(Schema schema, Identifier identifier) {
        return Table$.MODULE$.qualify(schema, identifier);
    }

    public static String qualify(String string, String string2) {
        return Table$.MODULE$.qualify(string, string2);
    }

    public Table(Schema schema, Identifier name) {
        this.schema = schema;
        this.name = name;
        Ordered.$init$((Ordered)this);
        Comment.$init$(this);
        this.primaryKey = None$.MODULE$;
        this.columns = new ListBuffer();
        this.uniqueKeys = new ListBuffer();
        this.foreignKeys = new ListBuffer();
        this.indexes = new ListBuffer();
        this.module = None$.MODULE$;
    }

    public Option comment() {
        return this.comment;
    }

    public void comment_$eq(Option x$1) {
        this.comment = x$1;
    }

    public Schema schema() {
        return this.schema;
    }

    public void schema_$eq(Schema x$1) {
        this.schema = x$1;
    }

    public Identifier name() {
        return this.name;
    }

    public void name_$eq(Identifier x$1) {
        this.name = x$1;
    }

    public boolean phantom() {
        return this.phantom;
    }

    public void phantom_$eq(boolean x$1) {
        this.phantom = x$1;
    }

    public Option<PrimaryKey> primaryKey() {
        return this.primaryKey;
    }

    public void primaryKey_$eq(Option<PrimaryKey> x$1) {
        this.primaryKey = x$1;
    }

    public ListBuffer<Column> columns() {
        return this.columns;
    }

    public ListBuffer<UniqueKey> uniqueKeys() {
        return this.uniqueKeys;
    }

    public ListBuffer<ForeignKey> foreignKeys() {
        return this.foreignKeys;
    }

    public ListBuffer<Index> indexes() {
        return this.indexes;
    }

    public Option<String> module() {
        return this.module;
    }

    public void module_$eq(Option<String> x$1) {
        this.module = x$1;
    }

    public Engine engine() {
        return this.schema().database().engine();
    }

    public boolean hasQuotedIdentifier() {
        return this.name().quoted() || this.columns().exists((Function1 & Serializable)_$2 -> _$2.name().quoted()) || this.indexes().exists((Function1 & Serializable)_$3 -> _$3.name().quoted()) || this.uniqueKeys().exists((Function1 & Serializable)_$4 -> _$4.name().quoted()) || this.foreignKeys().exists((Function1 & Serializable)_$5 -> _$5.name().quoted());
    }

    public List<String> quotedColumnNames() {
        Engine e = this.engine();
        return this.columns().result().map((Function1 & Serializable)_$6 -> _$6.name().toLiteral(e));
    }

    public String qualifiedName() {
        return Table$.MODULE$.qualify(this.schema(), this.name());
    }

    public Table attach(Engine engine) {
        this.columns().foreach((Function1)(JProcedure1 & Serializable)col -> {
            SqlType st = col.sqlType();
            col.sqlType_$eq(engine.toType(st.code(), BoxesRunTime.unboxToInt((Object)st.precision().getOrElse(Table::attach$$anonfun$1$$anonfun$1)), BoxesRunTime.unboxToInt((Object)st.scale().getOrElse(Table::attach$$anonfun$1$$anonfun$2))));
            col.defaultValue().foreach((Function1)(JProcedure1 & Serializable)v -> col.defaultValue_$eq(engine.convert(col.sqlType(), (String)v)));
            col.name_$eq(col.name().attach(engine));
        });
        this.name_$eq(this.name().attach(engine));
        this.primaryKey().foreach((Function1)(JProcedure1 & Serializable)pk -> pk.attach(engine));
        this.foreignKeys().foreach((Function1)(JProcedure1 & Serializable)fk -> fk.attach(engine));
        this.uniqueKeys().foreach((Function1)(JProcedure1 & Serializable)uk -> uk.attach(engine));
        this.indexes().foreach((Function1)(JProcedure1 & Serializable)idx -> idx.attach(engine));
        return this;
    }

    public Table clone(Schema newschema) {
        Table t = this.clone();
        Schema oldSchema = t.schema();
        t.foreignKeys().foreach((Function1)(JProcedure1 & Serializable)fk -> {
            Schema schema = fk.referencedTable().schema();
            Schema schema2 = oldSchema;
            if (!(schema != null ? !schema.equals(schema2) : schema2 != null)) {
                fk.referencedTable().schema_$eq(newschema);
                return;
            }
        });
        t.schema_$eq(newschema);
        t.attach(t.engine());
        return t;
    }

    public Table clone() {
        Table tb = new Table(this.schema(), this.name());
        tb.comment_$eq(this.comment());
        tb.module_$eq(this.module());
        this.columns().foreach((Function1 & Serializable)col -> tb.add(col.clone()));
        this.primaryKey().foreach((Function1)(JProcedure1 & Serializable)pk -> {
            PrimaryKey npk = pk.clone();
            npk.table_$eq(tb);
            tb.primaryKey_$eq((Option<PrimaryKey>)Some$.MODULE$.apply((Object)npk));
        });
        this.foreignKeys().foreach((Function1 & Serializable)fk -> tb.add(fk.clone()));
        this.uniqueKeys().foreach((Function1 & Serializable)uk -> tb.add(uk.clone()));
        this.indexes().foreach((Function1 & Serializable)idx -> tb.add(idx.clone()));
        return tb;
    }

    public boolean isPrimaryKeyIndex(String indexName) {
        return this.primaryKey().exists((Function1 & Serializable)_$7 -> {
            String string = _$7.name().value();
            String string2 = indexName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }) || indexName.toLowerCase().contains("primary_key");
    }

    public boolean isSameStruct(Table o) {
        String string = this.qualifiedName();
        String string2 = o.qualifiedName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        if (this.columns().size() != o.columns().size()) {
            return false;
        }
        return this.columns().forall((Function1 & Serializable)c -> {
            Option option = o.columns().find((Function1 & Serializable)_$8 -> {
                Identifier identifier = _$8.name();
                Identifier identifier2 = c.name();
                return !(identifier != null ? !((Object)identifier).equals(identifier2) : identifier2 != null);
            });
            if (None$.MODULE$.equals(option)) {
                return false;
            }
            if (option instanceof Some) {
                Column c2 = (Column)((Some)option).value();
                return c.isSame(c2);
            }
            throw new MatchError((Object)option);
        });
    }

    public void toCase(boolean lower) {
        this.name_$eq(this.name().toCase(lower));
        this.columns().foreach((Function1)(JProcedure1 & Serializable)col -> col.toCase(lower));
        this.primaryKey().foreach((Function1)(JProcedure1 & Serializable)pk -> pk.toCase(lower));
        this.foreignKeys().foreach((Function1)(JProcedure1 & Serializable)fk -> fk.toCase(lower));
        this.uniqueKeys().foreach((Function1)(JProcedure1 & Serializable)uk -> uk.toCase(lower));
        this.indexes().foreach((Function1)(JProcedure1 & Serializable)idx -> idx.toCase(lower));
    }

    public int compare(Table o) {
        return this.qualifiedName().compareTo(o.qualifiedName());
    }

    private boolean hasPrimaryKey() {
        return this.primaryKey().isDefined();
    }

    public String toString() {
        return Table$.MODULE$.qualify(this.schema(), this.name());
    }

    public Column column(String columnName) {
        return (Column)this.columns().find((Function1 & Serializable)f -> {
            String string = f.name().toLiteral(this.engine());
            String string2 = columnName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).get();
    }

    public Option<Column> getColumn(String columnName) {
        return this.columns().find((Function1 & Serializable)f -> {
            String string = f.name().toLiteral(this.engine());
            String string2 = columnName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public boolean columnExits(Identifier columnName) {
        return this.columns().exists((Function1 & Serializable)f -> {
            Identifier identifier = f.name();
            Identifier identifier2 = columnName;
            return !(identifier != null ? !((Object)identifier).equals(identifier2) : identifier2 != null);
        });
    }

    public Option<ForeignKey> getForeignKey(String keyName) {
        return this.foreignKeys().find((Function1 & Serializable)f -> {
            String string = f.name().toLiteral(this.engine());
            String string2 = keyName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public Option<UniqueKey> getUniqueKey(String keyName) {
        return this.uniqueKeys().find((Function1 & Serializable)f -> {
            String string = f.name().toLiteral(this.engine());
            String string2 = keyName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public UniqueKey createUniqueKey(String keyName, Seq<String> columnNames) {
        Engine eng = this.engine();
        UniqueKey uk = new UniqueKey(this, Identifier$.MODULE$.apply("uk_temp", Identifier$.MODULE$.$lessinit$greater$default$2()));
        columnNames.foreach((Function1)(JProcedure1 & Serializable)colName -> uk.addColumn(eng.toIdentifier((String)colName)));
        if (Strings$.MODULE$.isBlank((CharSequence)keyName)) {
            uk.name_$eq(eng.toIdentifier(Constraint$.MODULE$.autoname(uk)));
        } else {
            uk.name_$eq(eng.toIdentifier(keyName));
        }
        this.add(uk);
        return uk;
    }

    public Index createIndex(String indexName, boolean unique, Seq<String> columnNames) {
        Index index = new Index(this, Identifier$.MODULE$.apply("indx_temp", Identifier$.MODULE$.$lessinit$greater$default$2()));
        Engine eng = this.engine();
        columnNames.foreach((Function1)(JProcedure1 & Serializable)colName -> index.addColumn(eng.toIdentifier((String)colName)));
        index.unique_$eq(unique);
        if (Strings$.MODULE$.isBlank((CharSequence)indexName)) {
            index.name_$eq(eng.toIdentifier(Constraint$.MODULE$.autoname(index)));
        } else {
            index.name_$eq(eng.toIdentifier(indexName));
        }
        this.indexes().$plus$eq((Object)index);
        return index;
    }

    public PrimaryKey createPrimaryKey(String keyName, Seq<String> columnNames) {
        PrimaryKey primaryKey;
        Engine egn = this.engine();
        if (columnNames.size() == 1) {
            primaryKey = new PrimaryKey(this, Identifier$.MODULE$.empty(), egn.toIdentifier((String)columnNames.head()));
        } else {
            PrimaryKey pk2 = new PrimaryKey(this, Identifier$.MODULE$.empty(), null);
            columnNames.foreach((Function1)(JProcedure1 & Serializable)cn -> {
                Identifier cnName = egn.toIdentifier((String)cn);
                this.columns().foreach((Function1)(JProcedure1 & Serializable)c -> {
                    Identifier identifier = c.name();
                    Identifier identifier2 = cnName;
                    if (!(identifier != null ? !((Object)identifier).equals(identifier2) : identifier2 != null)) {
                        pk2.addColumn((Column)c);
                        return;
                    }
                });
            });
            primaryKey = pk2;
        }
        PrimaryKey pk = primaryKey;
        pk.name_$eq(this.engine().toIdentifier(Strings$.MODULE$.isBlank((CharSequence)keyName) ? Constraint$.MODULE$.autoname(pk) : keyName));
        this.primaryKey_$eq((Option<PrimaryKey>)Some$.MODULE$.apply((Object)pk));
        pk.columns().foreach((Function1)(JProcedure1 & Serializable)c -> this.column(c.toLiteral(this.engine())).nullable_$eq(false));
        return pk;
    }

    public ForeignKey createForeignKey(String keyName, String columnName, TableRef refTable, String refencedColumn) {
        Engine eng = this.engine();
        ForeignKey fk = new ForeignKey(this, Identifier$.MODULE$.apply("fk_temp", Identifier$.MODULE$.$lessinit$greater$default$2()), eng.toIdentifier(columnName));
        fk.refer(refTable, (Seq<Identifier>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Identifier[]{eng.toIdentifier(refencedColumn)}));
        fk.name_$eq(Strings$.MODULE$.isNotBlank((CharSequence)keyName) ? this.engine().toIdentifier(keyName) : this.engine().toIdentifier(Constraint$.MODULE$.autoname(fk)));
        return this.add(fk);
    }

    public ForeignKey createForeignKey(String keyName, String columnName, Table refTable) {
        Engine eng = this.engine();
        Option<PrimaryKey> option = refTable.primaryKey();
        if (option instanceof Some) {
            PrimaryKey pk = (PrimaryKey)((Some)option).value();
            ForeignKey fk = new ForeignKey(this, Identifier$.MODULE$.apply("fk_temp", Identifier$.MODULE$.$lessinit$greater$default$2()), eng.toIdentifier(columnName));
            fk.refer(refTable, (Seq<Identifier>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Identifier[]{(Identifier)pk.columns().head()}));
            if (Strings$.MODULE$.isBlank((CharSequence)keyName)) {
                fk.name_$eq(eng.toIdentifier(Constraint$.MODULE$.autoname(fk)));
            } else {
                fk.name_$eq(eng.toIdentifier(keyName));
            }
            return this.add(fk);
        }
        if (None$.MODULE$.equals(option)) {
            throw new RuntimeException("Cannot refer on a table without primary key");
        }
        throw new MatchError(option);
    }

    public ForeignKey add(ForeignKey key) {
        key.table_$eq(this);
        this.foreignKeys().dropWhileInPlace((Function1 & Serializable)_$9 -> {
            Identifier identifier = _$9.name();
            Identifier identifier2 = key.name();
            return !(identifier != null ? !((Object)identifier).equals(identifier2) : identifier2 != null);
        });
        this.foreignKeys().$plus$eq((Object)key);
        return key;
    }

    public UniqueKey add(UniqueKey key) {
        key.table_$eq(this);
        this.uniqueKeys().dropWhileInPlace((Function1 & Serializable)_$10 -> {
            Identifier identifier = _$10.name();
            Identifier identifier2 = key.name();
            return !(identifier != null ? !((Object)identifier).equals(identifier2) : identifier2 != null);
        });
        this.uniqueKeys().$plus$eq((Object)key);
        return key;
    }

    public void remove(Column column) {
        this.columns().find((Function1 & Serializable)_$11 -> {
            Identifier identifier = _$11.name();
            Identifier identifier2 = column.name();
            return !(identifier != null ? !((Object)identifier).equals(identifier2) : identifier2 != null);
        }).foreach((Function1 & Serializable)c -> {
            this.columns().$minus$eq(c);
            return (ListBuffer)this.uniqueKeys().$minus$minus$eq((IterableOnce)this.uniqueKeys().filter((Function1 & Serializable)uk -> uk.columns().size() == 1 && uk.columns().contains((Object)c.name())));
        });
    }

    public void rename(Column column, Identifier newName) {
        this.remove(column);
        column.name_$eq(newName);
        this.add(column);
    }

    public Column add(Column column) {
        Option ukName = this.uniqueKeys().find((Function1 & Serializable)uk -> uk.columns().size() == 1 && uk.columns().contains((Object)column.name())).map((Function1 & Serializable)_$12 -> _$12.name().value());
        this.remove(column);
        this.columns().$plus$eq((Object)column);
        if (column.unique()) {
            this.createUniqueKey((String)ukName.getOrElse(() -> this.add$$anonfun$3(column)), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{column.name().value()}));
        }
        return column;
    }

    public void add(Seq<Column> cols) {
        cols.foreach((Function1 & Serializable)col -> this.add((Column)col));
    }

    public Index add(Index index) {
        index.table_$eq(this);
        this.indexes().dropWhileInPlace((Function1 & Serializable)_$13 -> {
            Identifier identifier = _$13.name();
            Identifier identifier2 = index.name();
            return !(identifier != null ? !((Object)identifier).equals(identifier2) : identifier2 != null);
        });
        this.indexes().$plus$eq((Object)index);
        return index;
    }

    public Column createColumn(String name, SqlType sqlType) {
        Engine egn = this.engine();
        Column col = new Column(egn.toIdentifier(name), sqlType, Column$.MODULE$.$lessinit$greater$default$3());
        this.add(col);
        return col;
    }

    public Column createColumn(String name, String typeName) {
        Engine egn = this.engine();
        Column col = new Column(egn.toIdentifier(name), egn.toType(typeName), Column$.MODULE$.$lessinit$greater$default$3());
        this.add(col);
        return col;
    }

    public Option<Index> getIndex(String indexName) {
        return this.indexes().find((Function1 & Serializable)f -> {
            String string = f.name().value();
            String string2 = indexName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public void updateSchema(Schema newSchema) {
        Schema oldSchema = this.schema();
        this.schema_$eq(newSchema);
        this.foreignKeys().foreach((Function1)(JProcedure1 & Serializable)fk -> {
            if (fk.referencedTable() != null) {
                Schema schema = fk.referencedTable().schema();
                Schema schema2 = oldSchema;
                if (!(schema != null ? !schema.equals(schema2) : schema2 != null)) {
                    fk.referencedTable().schema_$eq(newSchema);
                    return;
                }
                return;
            }
        });
    }

    public void updateCommentAndModule(String newComment) {
        if (Strings$.MODULE$.isBlank((CharSequence)newComment)) {
            this.comment_$eq((Option)None$.MODULE$);
            this.module_$eq((Option<String>)None$.MODULE$);
            return;
        }
        if (newComment.contains("@")) {
            this.comment_$eq((Option)Some$.MODULE$.apply((Object)Strings$.MODULE$.substringBefore(newComment, "@")));
            this.module_$eq((Option<String>)Some$.MODULE$.apply((Object)Strings$.MODULE$.substringAfter(newComment, "@")));
            return;
        }
        this.comment_$eq((Option)Some$.MODULE$.apply((Object)newComment));
        this.module_$eq((Option<String>)None$.MODULE$);
    }

    public Option<String> commentAndModule() {
        Option option = this.comment();
        if (option instanceof Some) {
            String c = (String)((Some)option).value();
            Option<String> option2 = this.module();
            if (option2 instanceof Some) {
                String m = (String)((Some)option2).value();
                return Some$.MODULE$.apply((Object)(c + "@" + m));
            }
            if (None$.MODULE$.equals(option2)) {
                return this.comment();
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            return this.comment();
        }
        throw new MatchError((Object)option);
    }

    public void convertIndexToUniqueKeys() {
        ListBuffer ui = (ListBuffer)this.indexes().filter((Function1 & Serializable)i -> i.unique());
        this.indexes().$minus$minus$eq((IterableOnce)ui);
        ui.foreach((Function1 & Serializable)i -> this.createUniqueKey(i.name().value(), (Seq<String>)((IterableOnceOps)i.columns().map((Function1 & Serializable)_$14 -> _$14.value())).toSeq()));
    }

    private static final int attach$$anonfun$1$$anonfun$1() {
        return 0;
    }

    private static final int attach$$anonfun$1$$anonfun$2() {
        return 0;
    }

    private final String add$$anonfun$3(Column column$3) {
        return this.name().value() + "_" + column$3.name().value() + "_key";
    }
}

