/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.orm.tool;

import java.io.FileWriter;
import java.net.URL;
import java.util.Locale;
import org.beangle.commons.io.ResourcePatternResolver$;
import org.beangle.commons.lang.Locales$;
import org.beangle.commons.lang.SystemInfo$;
import org.beangle.data.jdbc.meta.DBScripts;
import org.beangle.data.jdbc.meta.Database;
import org.beangle.data.jdbc.meta.Engine;
import org.beangle.data.jdbc.meta.Engines$;
import org.beangle.data.orm.Mappings;
import org.beangle.data.orm.SchemaExporter;
import scala.collection.immutable.List;

public final class DdlGenerator$ {
    public static DdlGenerator$ MODULE$;

    static {
        new DdlGenerator$();
    }

    public void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: DdlGenerator PostgreSQL /tmp zh_CN com.my.package");
            return;
        }
        String dir = SystemInfo$.MODULE$.tmpDir();
        if (args.length > 1) {
            dir = args[1];
        }
        Locale locale = Locale.getDefault();
        if (args.length > 2) {
            locale = Locales$.MODULE$.toLocale(args[2]);
        }
        String pattern = null;
        if (args.length > 3) {
            pattern = args[3];
        }
        String dialect = args[0];
        Engine engine = Engines$.MODULE$.forDatabase(dialect);
        List ormLocations = ResourcePatternResolver$.MODULE$.getResources("classpath*://META-INF/beangle/orm.xml");
        Mappings mappings = new Mappings(new Database(engine), (List<URL>)ormLocations);
        mappings.autobind();
        DBScripts scripts = new SchemaExporter(mappings).generateSql();
        this.writeTo(dir, "0-schemas.sql", scripts.schemas());
        this.writeTo(dir, "1-tables.sql", scripts.tables());
        this.writeTo(dir, "2-constraints.sql", scripts.constraints());
        this.writeTo(dir, "3-indices.sql", scripts.indices());
        this.writeTo(dir, "4-sequences.sql", scripts.sequences());
        this.writeTo(dir, "5-comments.sql", scripts.comments());
    }

    private void writeTo(String dir, String file, String content) {
        FileWriter writer = new FileWriter(dir + "/" + file, false);
        writer.write(content);
        writer.flush();
        writer.close();
    }

    private DdlGenerator$() {
        MODULE$ = this;
    }
}

