/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.orm.tool;

import java.io.FileWriter;
import java.net.URL;
import java.util.Locale;
import org.beangle.commons.io.ResourcePatternResolver$;
import org.beangle.commons.lang.Locales$;
import org.beangle.commons.lang.SystemInfo$;
import org.beangle.data.jdbc.dialect.Dialect;
import org.beangle.data.jdbc.dialect.Dialects$;
import org.beangle.data.jdbc.meta.DBScripts;
import org.beangle.data.jdbc.meta.Database;
import org.beangle.data.orm.Mappings;
import org.beangle.data.orm.tool.SchemaExporter;
import scala.Function1;
import scala.Serializable;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;

public final class DdlGenerator$ {
    public static DdlGenerator$ MODULE$;

    static {
        new DdlGenerator$();
    }

    public void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: DdlGenerator PostgreSQL /tmp zh_CN");
            return;
        }
        String dir = SystemInfo$.MODULE$.tmpDir();
        if (args.length > 1) {
            dir = args[1];
        }
        Locale locale = Locale.getDefault();
        if (args.length > 2) {
            locale = Locales$.MODULE$.toLocale(args[2]);
        }
        String dialectName = args[0];
        Dialect dialect = Dialects$.MODULE$.forName(dialectName);
        List ormLocations = ResourcePatternResolver$.MODULE$.getResources("classpath*:META-INF/beangle/orm.xml");
        Mappings mappings = new Mappings(new Database(dialect.engine()), (List<URL>)ormLocations);
        mappings.locale_$eq(locale);
        mappings.autobind();
        DBScripts scripts = new SchemaExporter(mappings, dialect).generate();
        this.writeTo(dir, "0-schemas.sql", (List<String>)scripts.schemas());
        this.writeTo(dir, "1-tables.sql", (List<String>)scripts.tables());
        this.writeTo(dir, "2-constraints.sql", (List<String>)scripts.constraints());
        this.writeTo(dir, "3-indices.sql", (List<String>)scripts.indices());
        this.writeTo(dir, "4-sequences.sql", (List<String>)scripts.sequences());
        this.writeTo(dir, "5-comments.sql", (List<String>)scripts.comments());
    }

    private void writeTo(String dir, String file, List<String> contents) {
        block0: {
            if (contents == null || contents.isEmpty()) break block0;
            FileWriter writer = new FileWriter(dir + "/" + file, false);
            contents.foreach((Function1 & java.io.Serializable & Serializable)c -> {
                DdlGenerator$.$anonfun$writeTo$1(writer, c);
                return BoxedUnit.UNIT;
            });
            writer.flush();
            writer.close();
        }
    }

    public static final /* synthetic */ void $anonfun$writeTo$1(FileWriter writer$1, String c) {
        writer$1.write(c);
        writer$1.write(";\n");
    }

    private DdlGenerator$() {
        MODULE$ = this;
    }
}

