/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.orm;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Locale;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.config.Resources;
import org.beangle.commons.lang.ClassLoaders$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.annotation.value;
import org.beangle.commons.lang.reflect.BeanInfo;
import org.beangle.commons.lang.reflect.BeanInfos$;
import org.beangle.commons.lang.reflect.TypeInfo;
import org.beangle.commons.logging.Logging;
import org.beangle.commons.text.i18n.Messages;
import org.beangle.commons.text.i18n.Messages$;
import org.beangle.data.jdbc.DefaultSqlTypeMapping;
import org.beangle.data.jdbc.SqlTypeMapping;
import org.beangle.data.jdbc.meta.Column;
import org.beangle.data.jdbc.meta.Database;
import org.beangle.data.jdbc.meta.Identifier;
import org.beangle.data.jdbc.meta.Schema;
import org.beangle.data.jdbc.meta.Table;
import org.beangle.data.model.IntIdEntity;
import org.beangle.data.model.LongIdEntity;
import org.beangle.data.model.ShortIdEntity;
import org.beangle.data.model.StringIdEntity;
import org.beangle.data.model.meta.EntityType;
import org.beangle.data.model.meta.Type;
import org.beangle.data.orm.Collection;
import org.beangle.data.orm.Jpas$;
import org.beangle.data.orm.Name;
import org.beangle.data.orm.OrmBasicType;
import org.beangle.data.orm.OrmCollectionProperty;
import org.beangle.data.orm.OrmEmbeddableType;
import org.beangle.data.orm.OrmEntityType;
import org.beangle.data.orm.OrmMapProperty;
import org.beangle.data.orm.OrmPluralProperty;
import org.beangle.data.orm.OrmProperty;
import org.beangle.data.orm.OrmSingularProperty;
import org.beangle.data.orm.OrmStructType;
import org.beangle.data.orm.OrmType;
import org.beangle.data.orm.TypeDef;
import org.beangle.data.orm.cfg.Profiles;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.reflect.Enum;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public final class Mappings
implements Logging {
    private Logger logger;
    private final Database database;
    private final Profiles profiles;
    private Locale locale;
    private SqlTypeMapping sqlTypeMapping;
    private final HashMap classTypes;
    private final HashMap typeDefs;
    private final HashSet valueTypes;
    private final HashSet enumTypes;
    private final HashMap collectMap;
    private final scala.collection.mutable.Map entityTypes;
    private Messages messages;

    public Mappings(Database database, Profiles profiles) {
        this.database = database;
        this.profiles = profiles;
        Logging.$init$((Logging)this);
        this.locale = Locale.getDefault();
        this.sqlTypeMapping = new DefaultSqlTypeMapping(database.engine());
        this.classTypes = new HashMap();
        this.typeDefs = new HashMap();
        this.valueTypes = new HashSet();
        this.enumTypes = new HashSet();
        this.collectMap = new HashMap();
        this.entityTypes = Collections$.MODULE$.newMap();
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public Database database() {
        return this.database;
    }

    public Profiles profiles() {
        return this.profiles;
    }

    public Mappings(Database database, List<URL> ormLocations) {
        this(database, new Profiles(new Resources((Option)None$.MODULE$, ormLocations, (Option)None$.MODULE$)));
    }

    public Locale locale() {
        return this.locale;
    }

    public void locale_$eq(Locale x$1) {
        this.locale = x$1;
    }

    public SqlTypeMapping sqlTypeMapping() {
        return this.sqlTypeMapping;
    }

    public void sqlTypeMapping_$eq(SqlTypeMapping x$1) {
        this.sqlTypeMapping = x$1;
    }

    public HashMap<Class<?>, OrmEntityType> classTypes() {
        return this.classTypes;
    }

    public HashMap<String, TypeDef> typeDefs() {
        return this.typeDefs;
    }

    public HashSet<Class<?>> valueTypes() {
        return this.valueTypes;
    }

    public HashSet<String> enumTypes() {
        return this.enumTypes;
    }

    public HashMap<String, Collection> collectMap() {
        return this.collectMap;
    }

    public scala.collection.mutable.Map<String, OrmEntityType> entityTypes() {
        return this.entityTypes;
    }

    public Iterable<Collection> collections() {
        return this.collectMap().values();
    }

    public OrmEntityType getEntity(Class<?> clazz) {
        return (OrmEntityType)this.classTypes().apply(clazz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Mappings addEntity(OrmEntityType mapping) {
        BoxedUnit boxedUnit;
        Class<?> cls = mapping.clazz();
        this.classTypes().put(cls, (Object)mapping);
        if (!cls.isInterface() && !Modifier.isAbstract(cls.getModifiers())) {
            Option option = this.entityTypes().get((Object)mapping.entityName());
            if (option instanceof Some) {
                OrmEntityType o = (OrmEntityType)((Some)option).value();
                if (o.clazz().isAssignableFrom(mapping.clazz())) {
                    this.entityTypes().put((Object)mapping.entityName(), (Object)mapping);
                    boxedUnit = BoxedUnit.UNIT;
                    return this;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return this;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                boxedUnit = this.entityTypes().put((Object)mapping.entityName(), (Object)mapping);
            }
            return this;
        } else {
            mapping.table().phantom_$eq(true);
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public Mappings addCollection(Collection definition) {
        this.collectMap().put((Object)(definition.clazz().getName() + definition.property()), (Object)definition);
        return this;
    }

    public Mappings cache(OrmEntityType em, String region, String usage) {
        em.cacheRegion_$eq(region);
        em.cacheUsage_$eq(usage);
        return this;
    }

    public Mappings cacheAll(OrmEntityType em, String region, String usage) {
        em.cacheAll_$eq(true);
        em.cacheRegion_$eq(region);
        em.cacheUsage_$eq(usage);
        return this;
    }

    public void addType(String name, String clazz, scala.collection.immutable.Map<String, String> params) {
        this.typeDefs().put((Object)name, (Object)new TypeDef(clazz, params));
    }

    public void autobind() {
        this.messages = Messages$.MODULE$.apply(this.locale());
        this.profiles().modules().foreach((Function1)(JProcedure1 & Serializable)m -> m.configure(this));
        this.classTypes().subtractAll((IterableOnce)((MapOps)this.classTypes().filter((Function1 & Serializable)x -> ((OrmStructType)x._2()).properties().isEmpty())).keys());
        ((List)this.classTypes().keys().toList().sortWith((Function2 & Serializable)(a, b) -> a.isAssignableFrom((Class<?>)b))).foreach((Function1)(JProcedure1 & Serializable)cls -> this.merge((OrmEntityType)this.classTypes().apply(cls)));
        scala.collection.mutable.Map notEntities = (scala.collection.mutable.Map)this.entityTypes().filter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
            } else {
                throw new MatchError((Object)tuple2);
            }
            OrmEntityType c = (OrmEntityType)tuple2._2();
            return c.clazz().isInterface() || Modifier.isAbstract(c.clazz().getModifiers());
        });
        this.entityTypes().$minus$minus$eq((IterableOnce)notEntities.keys());
        this.database().schemas().values().foreach((Function1 & Serializable)s -> {
            HashMap phantomTables = (HashMap)s.tables().filter((Function1 & Serializable)_$2 -> ((Table)_$2._2()).phantom());
            return s.tables().subtractAll((IterableOnce)phantomTables.keys());
        });
        this.entityTypes().values().foreach((Function1)(JProcedure1 & Serializable)em -> this.firstPass((OrmEntityType)em));
        this.entityTypes().values().foreach((Function1)(JProcedure1 & Serializable)em -> this.secondPass((OrmEntityType)em));
    }

    public OrmEntityType autobind(Class<?> cls, String entityName, BeanInfo manifest) {
        if (cls.isAnnotationPresent(Jpas$.MODULE$.JpaEntityAnn())) {
            return null;
        }
        String fixedEntityName = entityName == null ? Jpas$.MODULE$.findEntityName(cls) : entityName;
        OrmEntityType entity = this.refEntity(cls, fixedEntityName);
        manifest.readables().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                BeanInfo.PropertyInfo prop = (BeanInfo.PropertyInfo)tuple2._2();
                if (!prop.isTransient() && prop.readable() && prop.writable() && !entity.properties().contains((Object)name)) {
                    TypeInfo typeinfo = prop.typeinfo();
                    Class propType = typeinfo.isOptional() ? ((TypeInfo)typeinfo.args().apply(0)).clazz() : typeinfo.clazz();
                    String string = name;
                    String string2 = "id";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        this.bindId(entity, name, typeinfo);
                    } else if (Jpas$.MODULE$.isEntity(propType)) {
                        this.bindManyToOne(entity, entity, name, typeinfo);
                    } else if (Jpas$.MODULE$.isSeq(propType) || Jpas$.MODULE$.isSet(propType)) {
                        this.bindCollection(entity, entity, name, typeinfo);
                    } else if (Jpas$.MODULE$.isMap(propType)) {
                        this.bindMap(entity, entity, name, typeinfo);
                    } else if (Jpas$.MODULE$.isComponent(propType)) {
                        this.bindComponent(entity, entity, name, typeinfo);
                    } else {
                        this.bindScalar(entity, entity, name, typeinfo);
                    }
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
        });
        return entity;
    }

    public OrmEntityType refEntity(Class<?> clazz, String entityName) {
        OrmEntityType ormEntityType;
        Option option = this.entityTypes().get((Object)entityName);
        if (option instanceof Some) {
            OrmEntityType entity = (OrmEntityType)((Some)option).value();
            Class<?> clazz2 = entity.clazz();
            Class<?> clazz3 = clazz;
            if ((clazz2 == null ? clazz3 != null : !clazz2.equals(clazz3)) && entity.clazz().isAssignableFrom(clazz)) {
                entity.clazz_$eq(clazz);
            }
            ormEntityType = entity;
        } else if (None$.MODULE$.equals(option)) {
            Name naming = this.profiles().getNamingPolicy(clazz).classToTableName(clazz, entityName);
            Schema schema = this.database().getOrCreateSchema((String)naming.schema().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            Table table = schema.createTable(naming.text());
            OrmEntityType e = new OrmEntityType(entityName, clazz, table);
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                e.isAbstract_$eq(true);
                table.phantom_$eq(true);
            }
            this.addEntity(e);
            ormEntityType = e;
        } else {
            throw new MatchError((Object)option);
        }
        return ormEntityType;
    }

    public String columnName(Class<?> clazz, String propertyName, boolean key) {
        int lastDot = propertyName.lastIndexOf(".");
        String colName = lastDot == -1 ? propertyName : propertyName.substring(lastDot + 1);
        colName = key ? colName + "Id" : colName;
        colName = this.profiles().getNamingPolicy(clazz).propertyToColumnName(clazz, colName);
        return colName;
    }

    public boolean columnName$default$3() {
        return false;
    }

    private void firstPass(OrmEntityType etm) {
        Class<?> clazz = etm.clazz();
        if (etm.idGenerator() == null) {
            throw new RuntimeException("Cannot find id generator for entity " + etm.entityName());
        }
        if (etm.id() == null) {
            throw new RuntimeException("Cannot find id for entity " + etm.entityName());
        }
        OrmProperty pm = etm.id();
        String idName = pm.name();
        Column column = (Column)((OrmSingularProperty)pm).columns().head();
        column.comment_$eq((Option)Some$.MODULE$.apply((Object)(this.getComment(clazz, idName) + (":" + etm.idGenerator().name()))));
        etm.table().createPrimaryKey("", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{column.name().toLiteral(etm.table().engine())}));
        etm.table().comment_$eq((Option)Some$.MODULE$.apply((Object)this.getComment(clazz, clazz.getSimpleName())));
        etm.table().module_$eq(etm.module());
    }

    private void secondPass(OrmEntityType etm) {
        this.processProperties(etm, etm, etm.table());
        this.processCache(etm, etm);
    }

    private void processCache(OrmStructType stm, OrmEntityType em) {
        if (em.cacheAll()) {
            stm.properties().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                String p = (String)tuple2._1();
                OrmProperty pm = (OrmProperty)tuple2._2();
                OrmProperty ormProperty = pm;
                if (ormProperty instanceof OrmSingularProperty) {
                    OrmSingularProperty spm = (OrmSingularProperty)ormProperty;
                    OrmType ormType = spm.propertyType();
                    if (!(ormType instanceof OrmEmbeddableType)) return;
                    OrmEmbeddableType etm = (OrmEmbeddableType)ormType;
                    this.processCache(etm, em);
                    return;
                } else {
                    boolean canCache;
                    boolean bl;
                    if (!(ormProperty instanceof OrmPluralProperty)) throw new MatchError((Object)ormProperty);
                    OrmPluralProperty ppm = (OrmPluralProperty)ormProperty;
                    OrmType ormType = ppm.element();
                    if (ormType instanceof EntityType) {
                        EntityType et = (EntityType)ormType;
                        bl = ((OrmEntityType)this.entityTypes().apply((Object)et.entityName())).cacheable();
                    } else {
                        bl = canCache = true;
                    }
                    if (!canCache) return;
                    this.addCollection(new Collection(em.clazz(), p, em.cacheRegion(), em.cacheUsage()));
                }
            });
        }
    }

    private void processProperties(OrmEntityType oet, OrmStructType ost, Table table) {
        ost.properties().foreach((Function1)(JProcedure1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String p = (String)tuple2._1();
            OrmProperty property = (OrmProperty)tuple2._2();
            OrmProperty ormProperty = property;
            if (ormProperty instanceof OrmSingularProperty) {
                OrmSingularProperty spm = (OrmSingularProperty)ormProperty;
                OrmType ormType = spm.propertyType();
                if (ormType instanceof OrmBasicType) {
                    OrmBasicType btm = (OrmBasicType)ormType;
                    this.addBasicTypeMapping(ost.clazz(), property.name(), btm, btm.column(), table);
                    return;
                } else if (ormType instanceof OrmEntityType) {
                    OrmEntityType btm = (OrmEntityType)ormType;
                    this.addBasicTypeMapping(ost.clazz(), property.name(), btm, (Column)spm.joinColumn().get(), table);
                    return;
                } else {
                    if (!(ormType instanceof OrmEmbeddableType)) throw new MatchError((Object)ormType);
                    OrmEmbeddableType etm = (OrmEmbeddableType)ormType;
                    this.processProperties(oet, etm, table);
                }
                return;
            } else {
                if (!(ormProperty instanceof OrmPluralProperty)) throw new MatchError((Object)ormProperty);
                OrmPluralProperty ppm = (OrmPluralProperty)ormProperty;
                if (ppm.one2many()) {
                    OrmType ormType = ppm.element();
                    if (!(ormType instanceof EntityType)) return;
                    EntityType et = (EntityType)ormType;
                    OrmEntityType etm = this.refEntity(et.clazz(), et.entityName());
                    ppm.mappedBy().foreach((Function1)(JProcedure1 & Serializable)mappedBy -> {
                        if (!etm.properties().contains(mappedBy)) {
                            throw new RuntimeException("Cannot find mappedBy property " + mappedBy + " in " + etm.entityName());
                        }
                    });
                    boolean defined = etm.table().indexes().exists((Function1 & Serializable)_$3 -> {
                        Object object = _$3.columns().head();
                        Identifier identifier = ppm.ownerColumn().name();
                        return !(object != null ? !object.equals(identifier) : identifier != null);
                    });
                    if (defined) return;
                    etm.table().createIndex("", false, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ppm.ownerColumn().name().value()}));
                    return;
                } else {
                    if (!ppm.many2many()) return;
                    Option<String> option = ppm.mappedBy();
                    if (option instanceof Some) {
                        String mappedBy2 = (String)((Some)option).value();
                        OrmType ormType = ppm.element();
                        if (!(ormType instanceof OrmEntityType)) return;
                        OrmEntityType oet = (OrmEntityType)ormType;
                        Table refTable = this.refEntity(oet.clazz(), oet.entityName()).table();
                        String table = refTable.name().toString() + "_" + Strings$.MODULE$.unCamel(mappedBy2, '_');
                        ppm.table_$eq((Option<String>)Some$.MODULE$.apply((Object)table));
                        if (BeanInfos$.MODULE$.get(oet.clazz()).getPropertyType(mappedBy2).isEmpty()) {
                            throw new RuntimeException("Cannot find " + mappedBy2 + " in " + oet.clazz().getName());
                        }
                        Table collectTable = refTable.schema().getOrCreateTable(table);
                        collectTable.module_$eq(oet.module());
                        collectTable.createIndex(null, false, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ppm.ownerColumn().name().value()}));
                        return;
                    } else {
                        BoxedUnit boxedUnit;
                        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                        if (ppm.table().isEmpty()) {
                            ppm.table_$eq((Option<String>)Some$.MODULE$.apply((Object)(table.name().toString() + "_" + Strings$.MODULE$.unCamel(p, '_'))));
                        }
                        Table collectTable = table.schema().getOrCreateTable((String)ppm.table().get());
                        collectTable.module_$eq(oet.module());
                        collectTable.comment_$eq((Option)Some$.MODULE$.apply((Object)this.getComment(ost.clazz(), property.name())));
                        ppm.ownerColumn().comment_$eq((Option)Some$.MODULE$.apply((Object)(this.getComment(oet.clazz(), oet.clazz().getSimpleName()) + "ID")));
                        collectTable.add(ppm.ownerColumn());
                        ppm.inverseColumn().foreach((Function1 & Serializable)c -> collectTable.add(c));
                        ppm.index().foreach((Function1 & Serializable)idxColumn -> collectTable.add(idxColumn));
                        collectTable.createIndex(null, false, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ppm.ownerColumn().name().value()}));
                        this.createForeignKey(collectTable, (Iterable<Column>)((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{ppm.ownerColumn()}))), table);
                        OrmType ormType = ppm.element();
                        if (ormType instanceof OrmBasicType) {
                            OrmBasicType btm = (OrmBasicType)ormType;
                            this.addBasicTypeMapping(ost.clazz(), property.name(), ppm.element(), btm.column(), collectTable);
                        } else if (ormType instanceof OrmEntityType) {
                            OrmEntityType oet = (OrmEntityType)ormType;
                            this.addBasicTypeMapping(ost.clazz(), property.name(), ppm.element(), (Column)ppm.inverseColumn().get(), collectTable);
                        } else {
                            if (!(ormType instanceof OrmEmbeddableType)) throw new MatchError((Object)ormType);
                            OrmEmbeddableType etm = (OrmEmbeddableType)ormType;
                            etm.properties().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                                Tuple2 tuple2 = x$1;
                                if (tuple2 == null) throw new MatchError((Object)tuple2);
                                String p = (String)tuple2._1();
                                OrmProperty pm = (OrmProperty)tuple2._2();
                                OrmProperty ormProperty = pm;
                                if (!(ormProperty instanceof OrmSingularProperty)) throw new RuntimeException("Cannot support " + pm.getClass().getName() + " in collection");
                                OrmSingularProperty spm = (OrmSingularProperty)ormProperty;
                                OrmType ormType = spm.propertyType();
                                if (ormType instanceof OrmBasicType) {
                                    OrmBasicType btm = (OrmBasicType)ormType;
                                    this.addBasicTypeMapping(etm.clazz(), p, btm, btm.column(), collectTable);
                                    return;
                                } else if (ormType instanceof OrmEntityType) {
                                    OrmEntityType oet = (OrmEntityType)ormType;
                                    Class<?> idType = this.idTypeOf(oet.clazz());
                                    Column column = this.newColumn(this.columnName(spm.clazz(), spm.name(), true), idType, spm.optional());
                                    this.addBasicTypeMapping(etm.clazz(), property.name(), oet, column, collectTable);
                                    return;
                                } else {
                                    if (!(ormType instanceof OrmStructType)) throw new MatchError((Object)ormType);
                                    OrmStructType ost = (OrmStructType)ormType;
                                    this.processProperties(oet, ost, collectTable);
                                }
                            });
                        }
                        OrmPluralProperty ormPluralProperty = ppm;
                        if (ormPluralProperty instanceof OrmMapProperty) {
                            OrmMapProperty mm = (OrmMapProperty)ormPluralProperty;
                            OrmType ormType2 = mm.key();
                            if (ormType2 instanceof OrmBasicType) {
                                OrmBasicType obt = (OrmBasicType)ormType2;
                                boxedUnit = collectTable.add(obt.column());
                            } else if (ormType2 instanceof OrmEntityType) {
                                OrmEntityType oet = (OrmEntityType)ormType2;
                                boxedUnit = collectTable.add(mm.keyColumn());
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        collectTable.createPrimaryKey(null, (Seq)((ListBuffer)collectTable.columns().map((Function1 & Serializable)_$4 -> _$4.name().toLiteral(table.engine()))).toList());
                    }
                }
            }
        });
    }

    private void addRefComment(Column column, Class<?> clazz, String entityName) {
        column.comment_$eq((Option)Some$.MODULE$.apply((Object)(this.getComment(clazz, clazz.getSimpleName()) + "ID")));
    }

    private void addBasicTypeMapping(Class<?> clazz, String propertyName, Type typ, Column elec, Table table) {
        this.detectValueType(typ.clazz());
        Type type = typ;
        if (type instanceof EntityType) {
            EntityType et = (EntityType)type;
            this.createForeignKey(table, (Iterable<Column>)((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{elec}))), ((OrmEntityType)this.entityTypes().apply((Object)et.entityName())).table());
            if (elec.comment().isEmpty()) {
                String fkcomment;
                String string = fkcomment = this.getComment(clazz, propertyName);
                String string2 = propertyName + "?";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    this.addRefComment(elec, et.clazz(), et.clazz().getSimpleName());
                } else {
                    elec.comment_$eq((Option)Some$.MODULE$.apply((Object)(fkcomment + "ID")));
                }
            }
        } else if (elec.comment().isEmpty()) {
            elec.comment_$eq((Option)Some$.MODULE$.apply((Object)this.getComment(clazz, propertyName)));
        }
        if (!table.columnExits(elec.name())) {
            table.add(elec);
        }
    }

    private void createForeignKey(Table table, Iterable<Column> columns, Table refTable) {
        table.createForeignKey(null, ((Column)columns.head()).name().toLiteral(table.engine()), refTable);
    }

    /*
     * WARNING - void declaration
     */
    private String getComment(Class<?> clazz, String key) {
        void var3_3;
        String comment = this.messages.get(clazz, key);
        String string = key;
        String string2 = comment;
        return !(string != null ? !string.equals(string2) : string2 != null) ? key + "?" : var3_3;
    }

    private void merge(OrmEntityType entity) {
        Class<?> cls = entity.clazz();
        ListBuffer supers = new ListBuffer();
        Object object = Predef$.MODULE$.refArrayOps((Object[])cls.getInterfaces());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)i -> {
            if (this.classTypes().contains(i)) {
                supers.$plus$eq(this.classTypes().apply(i));
            }
        });
        for (Class<?> supclz = cls.getSuperclass(); supclz != null; supclz = supclz.getSuperclass()) {
            Class<?> clazz = supclz;
            Class<Object> clazz2 = Object.class;
            if (!(clazz == null ? clazz2 != null : !clazz.equals(clazz2))) break;
            if (this.classTypes().contains(supclz)) {
                supers.$plus$eq(this.classTypes().apply(supclz));
            }
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])supclz.getInterfaces());
            ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)i -> {
                if (this.classTypes().contains(i)) {
                    supers.$plus$eq(this.classTypes().apply(i));
                }
            });
        }
        scala.collection.mutable.Map inheris = Collections$.MODULE$.newMap();
        ((IterableOnceOps)supers.reverse()).foreach((Function1)(JProcedure1 & Serializable)e -> {
            inheris.$plus$plus$eq((IterableOnce)e.properties().filter((Function1 & Serializable)_$5 -> !((OrmProperty)_$5._2()).mergeable()));
            if (entity.idGenerator() == null) {
                entity.idGenerator_$eq(e.idGenerator());
            }
            if (entity.cacheRegion() == null && entity.cacheUsage() == null) {
                entity.cache(e.cacheRegion(), e.cacheUsage());
            }
        });
        scala.collection.mutable.Map inherited = Collections$.MODULE$.newMap();
        inheris.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                OrmProperty p = (OrmProperty)tuple2._2();
                if (((OrmProperty)entity.properties().apply((Object)name)).mergeable()) {
                    inherited.put((Object)name, (Object)p.copy());
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
        });
        entity.addProperties((Map<String, OrmProperty>)inherited);
    }

    private void bindComponent(OrmEntityType entity, OrmStructType c, String name, TypeInfo typeInfo) {
        Class propertyType = typeInfo.clazz();
        boolean optional = typeInfo.isOptional();
        OrmEmbeddableType oet = new OrmEmbeddableType(propertyType);
        OrmSingularProperty cpm = new OrmSingularProperty(name, propertyType, optional, oet);
        c.addProperty(cpm);
        BeanInfo manifest = BeanInfos$.MODULE$.get(propertyType);
        manifest.readables().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                BeanInfo.PropertyInfo prop = (BeanInfo.PropertyInfo)tuple2._2();
                if (!prop.isTransient() && prop.readable() && prop.writable()) {
                    Class propType;
                    TypeInfo typeinfo = prop.typeinfo();
                    Class clazz = propType = typeinfo.isOptional() ? ((TypeInfo)typeinfo.args().apply(0)).clazz() : typeinfo.clazz();
                    if (Jpas$.MODULE$.isEntity(propType)) {
                        Class clazz2 = propType;
                        Class<?> clazz3 = entity.clazz();
                        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                            oet.parentName_$eq((Option<String>)Some$.MODULE$.apply((Object)name));
                        } else {
                            this.bindManyToOne(entity, oet, name, typeinfo);
                        }
                    } else if (Jpas$.MODULE$.isSeq(propType) || Jpas$.MODULE$.isSet(propType)) {
                        this.bindCollection(entity, oet, name, typeinfo);
                    } else if (Jpas$.MODULE$.isMap(propType)) {
                        this.bindMap(entity, oet, name, typeinfo);
                    } else if (Jpas$.MODULE$.isComponent(propType)) {
                        this.bindComponent(entity, oet, name, typeinfo);
                    } else {
                        this.bindScalar(entity, oet, name, typeinfo);
                    }
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
        });
    }

    private void detectValueType(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        Class<Object> clazz3 = Object.class;
        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
            throw new RuntimeException("Cannot find scalar type for object");
        }
        if (clazz.isAnnotationPresent(value.class)) {
            this.valueTypes().$plus$eq(clazz);
        } else if (Enum.class.isAssignableFrom(clazz)) {
            this.enumTypes().$plus$eq((Object)clazz.getName());
        }
    }

    private Class<?> idTypeOf(Class<?> clazz) {
        return LongIdEntity.class.isAssignableFrom(clazz) ? Long.TYPE : (IntIdEntity.class.isAssignableFrom(clazz) ? Integer.TYPE : (ShortIdEntity.class.isAssignableFrom(clazz) ? Short.TYPE : (StringIdEntity.class.isAssignableFrom(clazz) ? String.class : (Class)BeanInfos$.MODULE$.get(clazz).getPropertyType("id").get())));
    }

    private void bindMap(OrmEntityType entity, OrmStructType c, String name, TypeInfo typeInfo) {
        block2: {
            TypeInfo.IterableType it = (TypeInfo.IterableType)typeInfo;
            ArraySeq kvtype = it.elementType().args();
            Class mapKeyClazz = ((TypeInfo)kvtype.apply(0)).clazz();
            Class mapEleClazz = ((TypeInfo)kvtype.apply(1)).clazz();
            OrmType keyMeta = null;
            Column keyColumn = null;
            if (Jpas$.MODULE$.isEntity(mapKeyClazz)) {
                keyMeta = this.refEntity(mapKeyClazz, mapKeyClazz.getName());
                keyColumn = this.newRefColumn(mapKeyClazz, mapKeyClazz.getName());
            } else {
                keyColumn = this.newColumn("name", mapKeyClazz, false);
                keyColumn.comment_$eq((Option)Some$.MODULE$.apply((Object)"name"));
                keyMeta = new OrmBasicType(mapKeyClazz, keyColumn);
            }
            OrmType eleMeta = this.buildElement(mapEleClazz, mapEleClazz.getName());
            OrmMapProperty property = new OrmMapProperty(name, typeInfo.clazz(), keyMeta, eleMeta);
            c.addProperty(property);
            property.keyColumn_$eq(keyColumn);
            property.ownerColumn_$eq(this.newRefColumn(entity.clazz(), entity.entityName()));
            OrmType ormType = eleMeta;
            if (!(ormType instanceof OrmEntityType)) break block2;
            OrmEntityType oet = (OrmEntityType)ormType;
            property.inverseColumn_$eq((Option<Column>)Some$.MODULE$.apply((Object)this.newRefColumn(oet.clazz(), oet.entityName())));
        }
    }

    private void bindCollection(OrmEntityType entity, OrmStructType c, String name, TypeInfo typeInfo) {
        block0: {
            String entityName = ((TypeInfo.IterableType)typeInfo).elementType().clazz().getName();
            Class entityClazz = ClassLoaders$.MODULE$.load(entityName, ClassLoaders$.MODULE$.load$default$2());
            OrmType typ = this.buildElement(entityClazz, entityName);
            OrmCollectionProperty property = new OrmCollectionProperty(name, typeInfo.clazz(), typ);
            c.addProperty(property);
            property.ownerColumn_$eq(this.newRefColumn(entity.clazz(), entity.entityName()));
            OrmType ormType = typ;
            if (!(ormType instanceof OrmEntityType)) break block0;
            property.inverseColumn_$eq((Option<Column>)Some$.MODULE$.apply((Object)this.newRefColumn(entityClazz, entityName)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private OrmType buildElement(Class<?> clazz, String entityName) {
        OrmType ormType;
        if (Jpas$.MODULE$.isEntity(clazz)) {
            ormType = this.refEntity(clazz, entityName);
        } else if (Jpas$.MODULE$.isComponent(clazz)) {
            void var3_3;
            OrmEmbeddableType e = new OrmEmbeddableType(clazz);
            BeanInfo manifest = BeanInfos$.MODULE$.get(clazz);
            manifest.readables().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    BeanInfo.PropertyInfo prop = (BeanInfo.PropertyInfo)tuple2._2();
                    if (!prop.isTransient() && prop.readable() && prop.writable()) {
                        boolean optional = prop.typeinfo().isOptional();
                        Class propType = prop.typeinfo().clazz();
                        OrmSingularProperty property = null;
                        if (Jpas$.MODULE$.isEntity(propType)) {
                            OrmEntityType ormType = this.refEntity(propType, propType.getName());
                            Class<?> idType = this.idTypeOf(propType);
                            Column column = this.newColumn(this.columnName(propType, name, true), idType, optional);
                            this.addRefComment(column, ormType.clazz(), ormType.entityName());
                            OrmSingularProperty sp = new OrmSingularProperty(name, propType, optional, ormType);
                            sp.joinColumn_$eq((Option<Column>)Some$.MODULE$.apply((Object)column));
                            property = sp;
                        } else if (Jpas$.MODULE$.isComponent(propType)) {
                            property = new OrmSingularProperty(name, propType, optional, this.buildElement(propType, null));
                        } else {
                            Column column = this.newColumn(this.columnName(propType, name, this.columnName$default$3()), propType, optional);
                            OrmBasicType ormType = new OrmBasicType(propType, column);
                            property = new OrmSingularProperty(name, propType, optional, ormType);
                        }
                        e.addProperty(property);
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
            });
            ormType = var3_3;
        } else {
            ormType = new OrmBasicType(clazz, this.newColumn("value_", clazz, false));
        }
        return ormType;
    }

    private void bindId(OrmEntityType entity, String name, TypeInfo typeinfo) {
        Class clazz = typeinfo.clazz();
        Column column = this.newColumn(this.columnName(entity.clazz(), name, this.columnName$default$3()), clazz, false);
        column.nullable_$eq(false);
        OrmSingularProperty property = new OrmSingularProperty(name, clazz, false, new OrmBasicType(clazz, column));
        entity.addProperty(property);
        entity.table().add(column);
    }

    private void bindScalar(OrmEntityType entity, OrmStructType c, String name, TypeInfo typeInfo) {
        Class clazz;
        Class clazz2 = clazz = typeInfo.isOptional() ? ((TypeInfo)typeInfo.args().apply(0)).clazz() : typeInfo.clazz();
        Class<Object> clazz3 = Object.class;
        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
            Predef$.MODULE$.println((Object)"xxxx");
        }
        this.detectValueType(clazz);
        Column column = this.newColumn(this.columnName(c.clazz(), name, this.columnName$default$3()), clazz, typeInfo.isOptional());
        OrmSingularProperty property = new OrmSingularProperty(name, clazz, typeInfo.isOptional(), new OrmBasicType(clazz, column));
        entity.table().add(column);
        c.addProperty(property);
    }

    private void bindManyToOne(OrmEntityType entity, OrmStructType c, String name, TypeInfo typeInfo) {
        Class clazz = typeInfo.isOptional() ? ((TypeInfo)typeInfo.args().apply(0)).clazz() : typeInfo.clazz();
        OrmEntityType typ = this.refEntity(clazz, clazz.getName());
        Class<?> idType = this.idTypeOf(clazz);
        Column column = this.newColumn(this.columnName(c.clazz(), name, true), idType, typeInfo.isOptional());
        OrmSingularProperty property = new OrmSingularProperty(name, clazz, typeInfo.isOptional(), typ);
        property.joinColumn_$eq((Option<Column>)Some$.MODULE$.apply((Object)column));
        c.addProperty(property);
        entity.table().add(column);
    }

    private Column newColumn(String name, Class<?> clazz, boolean optional) {
        return new Column(this.database().engine().toIdentifier(name), this.sqlTypeMapping().sqlType(clazz), optional);
    }

    public Column newRefColumn(Class<?> clazz, String entityName) {
        Class<?> idType = this.idTypeOf(clazz);
        Column column = new Column(this.database().engine().toIdentifier(this.columnName(clazz, entityName, true)), this.sqlTypeMapping().sqlType(idType), false);
        this.addRefComment(column, clazz, entityName);
        return column;
    }
}

