/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.orm.cfg;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import org.beangle.commons.config.Resources;
import org.beangle.commons.lang.ClassLoaders$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.reflect.Reflections$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.orm.MappingModule;
import org.beangle.data.orm.NamingPolicy;
import org.beangle.data.orm.cfg.AnnotationModule;
import org.beangle.data.orm.cfg.MappingProfile;
import org.beangle.data.orm.cfg.RailsNamingPolicy;
import org.slf4j.Logger;
import scala.Console$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.XML$;

public class Profiles
implements Logging {
    private Logger logger;
    private final Resources resources;
    private final MappingProfile defaultProfile;
    private final HashMap<String, MappingProfile> profiles;
    private final HashMap<String, NamingPolicy> namings;
    private List modules;

    public Profiles(Resources resources) {
        this.resources = resources;
        Logging.$init$((Logging)this);
        this.defaultProfile = new MappingProfile();
        this.profiles = new HashMap();
        this.namings = new HashMap();
        this.init();
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public List<MappingModule> modules() {
        return this.modules;
    }

    public void modules_$eq(List<MappingModule> x$1) {
        this.modules = x$1;
    }

    private Option<String> globalSchema() {
        String s = System.getProperty("beangle.data.orm.global_schema");
        return Strings$.MODULE$.isBlank((CharSequence)s) ? None$.MODULE$ : Some$.MODULE$.apply((Object)s.trim());
    }

    private void init() {
        this.namings.put((Object)"rails", (Object)new RailsNamingPolicy(this));
        this.defaultProfile.naming_$eq(new RailsNamingPolicy(this));
        this.globalSchema().foreach((Function1)(JProcedure1 & Serializable)s -> this.defaultProfile._schema_$eq((Option<String>)Some$.MODULE$.apply(s)));
        ArrayBuffer ms = new ArrayBuffer();
        this.resources.paths().foreach((Function1)(JProcedure1 & Serializable)url -> this.addConfig((URL)url, (ArrayBuffer<MappingModule>)ms));
        if (Logger$.MODULE$.isDebugEnabled$extension(this.logger()) && this.profiles.nonEmpty()) {
            Logger$.MODULE$.debug$extension(this.logger(), this::init$$anonfun$3);
        }
        this.modules_$eq((List<MappingModule>)((IterableOnceOps)ms.sortBy((Function1 & Serializable)_$2 -> _$2.getClass().getName(), (Ordering)Ordering.String$.MODULE$)).toList());
    }

    private void addConfig(URL url, ArrayBuffer<MappingModule> ms) {
        try {
            Logger$.MODULE$.debug$extension(this.logger(), () -> Profiles.addConfig$$anonfun$1(url));
            InputStream is = url.openStream();
            if (is != null) {
                Elem xml = (Elem)XML$.MODULE$.load(is);
                xml.$bslash("naming").$bslash("profile").foreach((Function1)(JProcedure1 & Serializable)ele -> this.parseProfile((Node)ele, null));
                xml.$bslash("mapping").foreach((Function1 & Serializable)ele -> {
                    String name = ele.$bslash("@name").text();
                    MappingModule module = (MappingModule)Reflections$.MODULE$.getInstance(ele.$bslash("@class").text());
                    if (Strings$.MODULE$.isNotBlank((CharSequence)name)) {
                        module.name_$eq((Option<String>)Some$.MODULE$.apply((Object)name.trim()));
                    }
                    return (ArrayBuffer)ms.$plus$eq((Object)module);
                });
                is.close();
            }
            this.autoWire();
        }
        catch (Exception e) {
            Logger$.MODULE$.error$extension(this.logger(), () -> Profiles.addConfig$$anonfun$4(url), () -> Profiles.addConfig$$anonfun$5(e));
        }
    }

    public Option<String> getSchema(Class<?> clazz) {
        MappingProfile profile = this.getProfile(clazz);
        ObjectRef schema = ObjectRef.create(profile.schema());
        Option anno = profile.annotations().find((Function1 & Serializable)ann -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])clazz.getAnnotations());
            return ArrayOps$.MODULE$.exists$extension(object, (Function1 & Serializable)annon -> ann.clazz().isAssignableFrom(annon.getClass()) ? (Strings$.MODULE$.isNotEmpty((CharSequence)ann.value()) ? Profiles.liftedTree1$1(ann, annon) : true) : false);
        });
        anno.foreach((Function1)(JProcedure1 & Serializable)an -> {
            if (Strings$.MODULE$.isNotEmpty((CharSequence)an.schema())) {
                Some some = Some$.MODULE$.apply((Object)an.schema());
                schema$1.elem = some;
            }
        });
        return (Option)schema.elem;
    }

    public String getPrefix(Class<?> clazz) {
        MappingProfile profile = this.getProfile(clazz);
        ObjectRef prefix = ObjectRef.create((Object)profile.prefix());
        Option anno = profile.annotations().find((Function1 & Serializable)ann -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])clazz.getAnnotations());
            return ArrayOps$.MODULE$.exists$extension(object, (Function1 & Serializable)annon -> ann.clazz().isAssignableFrom(annon.getClass()) ? (Strings$.MODULE$.isNotEmpty((CharSequence)ann.value()) ? Profiles.liftedTree2$1(ann, annon) : true) : false);
        });
        anno.foreach((Function1)(JProcedure1 & Serializable)an -> {
            if (Strings$.MODULE$.isNotEmpty((CharSequence)an.prefix())) {
                String string = an.prefix();
                prefix$1.elem = string;
            }
        });
        return Strings$.MODULE$.isEmpty((CharSequence)((String)prefix.elem)) ? "" : (String)prefix.elem;
    }

    public NamingPolicy getNamingPolicy(Class<?> clazz) {
        return this.getProfile(clazz).naming();
    }

    public MappingProfile getProfile(Class<?> clazz) {
        String name = clazz.getName();
        None$ matched = None$.MODULE$;
        while (Strings$.MODULE$.isNotEmpty((CharSequence)name) && matched.isEmpty()) {
            if (this.profiles.contains((Object)name)) {
                matched = Some$.MODULE$.apply(this.profiles.apply((Object)name));
            }
            int len = name.length();
            if ((name = Strings$.MODULE$.substringBeforeLast(name, ".")).length() != len) continue;
            name = "";
        }
        return (MappingProfile)matched.getOrElse(this::getProfile$$anonfun$1);
    }

    private void autoWire() {
        if (this.profiles.size() > 1) {
            this.profiles.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    MappingProfile profile = (MappingProfile)tuple2._2();
                    ObjectRef parentName = ObjectRef.create((Object)Strings$.MODULE$.substringBeforeLast(key, "."));
                    while (Strings$.MODULE$.isNotEmpty((CharSequence)((String)parentName.elem)) && profile.parent() == null) {
                        if (this.profiles.contains((Object)((String)parentName.elem))) {
                            String string = profile.packageName();
                            String string2 = (String)parentName.elem;
                            if (string == null ? string2 != null : !string.equals(string2)) {
                                Logger$.MODULE$.debug$extension(this.logger(), () -> Profiles.autoWire$$anonfun$2$$anonfun$1(profile, parentName));
                                profile.parent_$eq((Option<MappingProfile>)this.profiles.get((Object)((String)parentName.elem)));
                            }
                        }
                        int len = ((String)parentName.elem).length();
                        String string = Strings$.MODULE$.substringBeforeLast((String)parentName.elem, ".");
                        parentName.elem = string;
                        if (((String)parentName.elem).length() != len) continue;
                        String string3 = "";
                        parentName.elem = string3;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
            });
        }
    }

    private void parseProfile(Node melem, MappingProfile parent) {
        String naming;
        MappingProfile profile = new MappingProfile();
        if (melem.$bslash("@package").nonEmpty()) {
            profile.packageName_$eq(melem.$bslash("@package").text());
            if (parent != null) {
                profile.packageName_$eq(parent.packageName() + "." + profile.packageName());
            }
        }
        melem.$bslash("class").foreach((Function1)(JProcedure1 & Serializable)anElem -> {
            Class clazz = ClassLoaders$.MODULE$.load(anElem.$bslash("@annotation").text(), ClassLoaders$.MODULE$.load$default$2());
            String value2 = anElem.$bslash("@value").text();
            AnnotationModule annModule = new AnnotationModule(clazz, value2);
            profile._annotations().$plus$eq((Object)annModule);
            if (anElem.$bslash("@schema").nonEmpty()) {
                annModule.schema_$eq(this.parseSchema(anElem.$bslash("@schema").text()));
            }
            if (anElem.$bslash("@prefix").nonEmpty()) {
                annModule.prefix_$eq(anElem.$bslash("@prefix").text());
            }
        });
        if (melem.$bslash("@schema").nonEmpty()) {
            profile._schema_$eq((Option<String>)Some$.MODULE$.apply((Object)this.parseSchema(melem.$bslash("@schema").text())));
        }
        if (melem.$bslash("@prefix").nonEmpty()) {
            profile._prefix_$eq((Option<String>)Some$.MODULE$.apply((Object)melem.$bslash("@prefix").text()));
        }
        String string = naming = melem.$bslash("@naming").nonEmpty() ? melem.$bslash("@naming").text() : "rails";
        if (!this.namings.contains((Object)naming)) {
            throw new RuntimeException("Cannot find naming policy :" + naming);
        }
        profile.naming_$eq((NamingPolicy)this.namings.apply((Object)naming));
        this.profiles.put((Object)profile.packageName(), (Object)profile);
        profile.parent_$eq((Option<MappingProfile>)Option$.MODULE$.apply((Object)parent));
        melem.$bslash("profile").foreach((Function1)(JProcedure1 & Serializable)child -> this.parseProfile((Node)child, profile));
    }

    private String parseSchema(String name) {
        String string;
        Option<String> option = this.globalSchema();
        if (None$.MODULE$.equals(option)) {
            if (Strings$.MODULE$.isEmpty((CharSequence)name) || -1 == name.indexOf(123)) {
                return name;
            }
            String newName = Strings$.MODULE$.replace(name, "$", "");
            String propertyName = Strings$.MODULE$.substringBetween(newName, "{", "}");
            String pv = System.getProperty(propertyName);
            string = Strings$.MODULE$.replace(newName, "{" + propertyName + "}", pv == null ? "" : pv);
        } else if (option instanceof Some) {
            String n;
            string = n = (String)((Some)option).value();
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public String toString() {
        if (this.profiles.isEmpty()) {
            return "";
        }
        int maxlength = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.profiles.keys().map((Function1 & Serializable)_$3 -> _$3.length())).max((Ordering)Ordering.Int$.MODULE$));
        StringBuilder sb = new StringBuilder();
        ((List)this.profiles.keySet().toList().sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable)packageName -> {
            MappingProfile profile = (MappingProfile)this.profiles.apply(packageName);
            sb.append(Strings$.MODULE$.rightPad(packageName, maxlength, ' ')).append(" : [").append((String)profile.schema().getOrElse(Profiles::toString$$anonfun$2$$anonfun$1)).append(",");
            sb.append(Strings$.MODULE$.isEmpty((CharSequence)profile.prefix()) ? "_" : profile.prefix());
            return sb.append(']').append("\n");
        });
        if (sb.nonEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private final String init$$anonfun$3() {
        return "Table name pattern: -> \n" + this.toString();
    }

    private static final String addConfig$$anonfun$1(URL url$1) {
        return "loading " + url$1;
    }

    private static final String addConfig$$anonfun$4(URL url$2) {
        return "property load error in url:" + url$2;
    }

    private static final Exception addConfig$$anonfun$5(Exception e$1) {
        return e$1;
    }

    private static final boolean liftedTree1$1(AnnotationModule ann$2, Annotation annon$1) {
        boolean bl;
        block3: {
            try {
                Method method = annon$1.getClass().getMethod("value", new Class[0]);
                String string = String.valueOf(method.invoke((Object)annon$1, new Object[0]));
                String string2 = ann$2.value();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            catch (Throwable throwable) {
                Console$.MODULE$.err().print(Tuple3$.MODULE$.apply((Object)"Annotation value needed:", (Object)ann$2.value(), annon$1.getClass()));
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean liftedTree2$1(AnnotationModule ann$4, Annotation annon$2) {
        boolean bl;
        block3: {
            try {
                Method method = annon$2.getClass().getMethod("value", new Class[0]);
                String string = String.valueOf(method.invoke((Object)annon$2, new Object[0]));
                String string2 = ann$4.value();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            catch (Exception exception) {
                Console$.MODULE$.err().print(Tuple3$.MODULE$.apply((Object)"Annotation value needed:", (Object)ann$4.value(), annon$2.getClass()));
                bl = false;
            }
        }
        return bl;
    }

    private final MappingProfile getProfile$$anonfun$1() {
        return this.defaultProfile;
    }

    private static final String autoWire$$anonfun$2$$anonfun$1(MappingProfile profile$1, ObjectRef parentName$1) {
        return "set " + profile$1.packageName() + "'s parent is " + (String)parentName$1.elem;
    }

    private static final String toString$$anonfun$2$$anonfun$1() {
        return "_";
    }
}

