/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.orm.tool;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.io.ResourcePatternResolver$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.jdbc.engine.Engine;
import org.beangle.data.jdbc.meta.DBScripts;
import org.beangle.data.jdbc.meta.Database;
import org.beangle.data.jdbc.meta.Identifier;
import org.beangle.data.jdbc.meta.Table;
import org.beangle.data.orm.Mappings;
import org.slf4j.Logger;
import scala.Function1;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class SchemaExporter
implements Logging {
    private Logger logger;
    private final Mappings mappings;
    private final Engine engine;
    private final ListBuffer<String> schemas;
    private final ListBuffer<String> tables;
    private final ListBuffer<String> sequences;
    private final ListBuffer<String> keys;
    private final ListBuffer<String> comments;
    private final ListBuffer<String> constraints;
    private final ListBuffer<String> indexes;
    private final ListBuffer<String> warnings;
    private final HashSet<Table> processed;

    public SchemaExporter(Mappings mappings, Engine engine) {
        this.mappings = mappings;
        this.engine = engine;
        Logging.$init$((Logging)this);
        this.schemas = new ListBuffer();
        this.tables = new ListBuffer();
        this.sequences = new ListBuffer();
        this.keys = new ListBuffer();
        this.comments = new ListBuffer();
        this.constraints = new ListBuffer();
        this.indexes = new ListBuffer();
        this.warnings = new ListBuffer();
        this.processed = new HashSet();
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    /*
     * WARNING - void declaration
     */
    public DBScripts generate() {
        void var2_2;
        Database database = this.mappings.database();
        database.schemas().values().foreach((Function1)(JProcedure1 & Serializable)schema -> schema.tables().values().foreach((Function1)(JProcedure1 & Serializable)table -> this.generateTableSql((Table)table)));
        DBScripts scripts = new DBScripts();
        int uncommentLines = this.comments.count((Function1 & Serializable)_$1 -> _$1.contains("?"));
        if (uncommentLines > 0) {
            this.warnings.$plus$eq((Object)("" + this.engine.name() + ":find " + uncommentLines + " uncomment lines"));
        }
        if (database.hasQuotedIdentifier()) {
            this.warnings.$plus$eq((Object)("" + this.engine.name() + ":find quoted identifiers"));
        }
        this.schemas.$plus$plus$eq((IterableOnce)((IterableOps)database.schemas().keys().filter((Function1 & Serializable)i -> i.value().length() > 0)).map((Function1 & Serializable)s -> "create schema " + s));
        scripts.schemas_$eq(((ListBuffer)this.schemas.sorted((Ordering)Ordering.String$.MODULE$)).toList());
        scripts.comments_$eq((List)this.comments.toSet().toList().sorted((Ordering)Ordering.String$.MODULE$));
        scripts.tables_$eq(((ListBuffer)this.tables.sorted((Ordering)Ordering.String$.MODULE$)).toList());
        scripts.keys_$eq(((ListBuffer)this.keys.sorted((Ordering)Ordering.String$.MODULE$)).toList());
        scripts.indices_$eq(((ListBuffer)((StrictOptimizedIterableOps)this.indexes.sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x -> Strings$.MODULE$.substringAfter(x, "--"))).toList());
        scripts.sequences_$eq(((ListBuffer)this.sequences.sorted((Ordering)Ordering.String$.MODULE$)).toList());
        scripts.constraints_$eq(((ListBuffer)this.constraints.sorted((Ordering)Ordering.String$.MODULE$)).toList());
        Buffer auxiliaries = Collections$.MODULE$.newBuffer();
        String dialectShortName = this.engine.getClass().getSimpleName().toLowerCase();
        ResourcePatternResolver$.MODULE$.getResources("classpath*:META-INF/beangle/ddl/" + dialectShortName + "/*.sql").foreach((Function1 & Serializable)r -> (Buffer)auxiliaries.$plus$eq((Object)IOs$.MODULE$.readString(r.openStream(), IOs$.MODULE$.readString$default$2())));
        scripts.auxiliaries_$eq(auxiliaries.toList());
        scripts.warnings_$eq(this.warnings.toList());
        return var2_2;
    }

    private void generateTableSql(Table table) {
        if (this.processed.contains((Object)table)) {
            return;
        }
        this.processed.add((Object)table);
        this.checkNameLength(table.schema().name().value(), table.name());
        this.comments.$plus$plus$eq((IterableOnce)this.engine.commentsOnTable(table, true));
        this.tables.$plus$eq((Object)this.engine.createTable(table));
        table.primaryKey().foreach((Function1 & Serializable)pk -> {
            this.checkNameLength(table.qualifiedName(), pk.name());
            return (ListBuffer)this.keys.$plus$eq((Object)this.engine.alterTableAddPrimaryKey(table, pk));
        });
        table.uniqueKeys().foreach((Function1 & Serializable)uk -> {
            this.checkNameLength(table.qualifiedName(), uk.name());
            return (ListBuffer)this.keys.$plus$eq((Object)this.engine.alterTableAddUnique(uk));
        });
        table.indexes().foreach((Function1 & Serializable)idx -> {
            this.checkNameLength(idx.literalName(), idx.name());
            return (ListBuffer)this.indexes.$plus$eq((Object)(table.qualifiedName() + "--" + this.engine.createIndex(idx)));
        });
        table.foreignKeys().foreach((Function1 & Serializable)fk -> (ListBuffer)this.constraints.$plus$eq((Object)this.engine.alterTableAddForeignKey(fk)));
    }

    public void checkNameLength(String owner, Identifier i) {
        if (i.value().length() > this.engine.maxIdentifierLength()) {
            this.warnings.$plus$eq((Object)("" + this.engine.name() + ":" + owner + "." + i.value() + "'s length is " + i.value().length() + ",greate than " + this.engine.maxIdentifierLength()));
        }
    }
}

