/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.dao;

import java.io.Serializable;
import org.beangle.data.dao.Dao;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.model.Entity;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;

public abstract class AbstractDao<T extends Entity<ID>, ID extends Serializable>
implements Dao<T, ID> {
    private final Class entityClass;
    private final EntityDao entityDao;

    public <T extends Entity<ID>, ID extends Serializable> AbstractDao(Class<T> entityClass, EntityDao entityDao) {
        this.entityClass = entityClass;
        this.entityDao = entityDao;
    }

    @Override
    public Class<T> entityClass() {
        return this.entityClass;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    @Override
    public T get(ID id) {
        return this.entityDao().get(this.entityClass(), id);
    }

    @Override
    public Option<T> find(ID id) {
        return this.entityDao().find(this.entityClass(), id);
    }

    @Override
    public Seq<T> find(ID[] ids) {
        return this.entityDao().find(this.entityClass(), Predef$.MODULE$.genericWrapArray(ids));
    }

    @Override
    public void saveOrUpdate(T first, Seq<T> entities) {
        this.entityDao().saveOrUpdate(first, entities);
    }

    @Override
    public void saveOrUpdate(Seq<T> entities) {
        this.entityDao().saveOrUpdate(entities);
    }

    @Override
    public void remove(Iterable<T> entities) {
        this.entityDao().remove(entities);
    }

    @Override
    public void remove(T first, Seq<T> entities) {
        this.entityDao().remove(first, entities);
    }

    @Override
    public void remove(ID id, Seq<ID> ids) {
        this.entityDao().remove(this.entityClass(), id, ids);
    }
}

