/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.orm;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.reflect.BeanInfo;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.jdbc.engine.Engine;
import org.beangle.data.jdbc.meta.Column;
import org.beangle.data.jdbc.meta.Constraint;
import org.beangle.data.jdbc.meta.Constraint$;
import org.beangle.data.jdbc.meta.Identifier$;
import org.beangle.data.jdbc.meta.Index;
import org.beangle.data.jdbc.meta.UniqueKey;
import org.beangle.data.model.Entity;
import org.beangle.data.orm.Collection;
import org.beangle.data.orm.ColumnHolder;
import org.beangle.data.orm.IdGenerator;
import org.beangle.data.orm.IdGenerator$;
import org.beangle.data.orm.MappingMacro$;
import org.beangle.data.orm.MappingModule$;
import org.beangle.data.orm.MappingModule$CacheConfig$;
import org.beangle.data.orm.MappingModule$Expression$;
import org.beangle.data.orm.MappingModule$One2Many$;
import org.beangle.data.orm.Mappings;
import org.beangle.data.orm.OrmBasicType;
import org.beangle.data.orm.OrmCollectionProperty;
import org.beangle.data.orm.OrmEntityType;
import org.beangle.data.orm.OrmMapProperty;
import org.beangle.data.orm.OrmPluralProperty;
import org.beangle.data.orm.OrmProperty;
import org.beangle.data.orm.OrmSingularProperty;
import org.beangle.data.orm.OrmType;
import org.beangle.data.orm.Proxy;
import org.beangle.data.orm.Proxy$;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public abstract class MappingModule
implements Logging {
    private Logger logger;
    private Option name;
    private EntityHolder<?> currentHolder;
    private final Map<Class<?>, String> defaultIdGenerators;
    private final CacheConfig cacheConfig;
    private final Map<String, OrmEntityType> entityMappings;
    private Mappings mappings;

    public static String OrderColumnName() {
        return MappingModule$.MODULE$.OrderColumnName();
    }

    public MappingModule(Option<String> name) {
        this.name = name;
        Logging.$init$((Logging)this);
        this.defaultIdGenerators = Collections$.MODULE$.newMap();
        this.cacheConfig = new CacheConfig(MappingModule$CacheConfig$.MODULE$.$lessinit$greater$default$1(), MappingModule$CacheConfig$.MODULE$.$lessinit$greater$default$2());
        this.entityMappings = Collections$.MODULE$.newMap();
        this.init();
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public Option<String> name() {
        return this.name;
    }

    public void name_$eq(Option<String> x$1) {
        this.name = x$1;
    }

    public CacheConfig org$beangle$data$orm$MappingModule$$cacheConfig() {
        return this.cacheConfig;
    }

    public Expression any2Expression(Object i) {
        return new Expression(this.currentHolder);
    }

    public MappingModule() {
        this((Option<String>)None$.MODULE$);
    }

    public abstract void binding();

    public void init() {
        this.defaultIdGenerator(Integer.TYPE, IdGenerator$.MODULE$.AutoIncrement());
        this.defaultIdGenerator(Long.TYPE, IdGenerator$.MODULE$.DateTime());
        this.defaultIdGenerator(String.class, IdGenerator$.MODULE$.Uuid());
    }

    public void autoIncrement() {
        this.defaultIdGenerator(Integer.TYPE, IdGenerator$.MODULE$.AutoIncrement());
        this.defaultIdGenerator(Long.TYPE, IdGenerator$.MODULE$.AutoIncrement());
    }

    public NotNull notnull() {
        return new NotNull();
    }

    public Unique unique() {
        return new Unique();
    }

    public ReadOnly readOnly() {
        return new ReadOnly();
    }

    public Immutable immutable() {
        return new Immutable();
    }

    public Lob lob() {
        return new Lob();
    }

    public Length length(int len) {
        return new Length(len);
    }

    public Cache cacheable() {
        return new Cache(new CacheHolder(this.mappings, this.org$beangle$data$orm$MappingModule$$cacheConfig().region(), this.org$beangle$data$orm$MappingModule$$cacheConfig().usage()));
    }

    public Cache cacheable(String region, String usage) {
        return new Cache(new CacheHolder(this.mappings, region, usage));
    }

    public One2Many depends(Class<?> clazz, String mappedBy) {
        return new One2Many((Option<Class<?>>)Some$.MODULE$.apply(clazz), mappedBy, MappingModule$One2Many$.MODULE$.$lessinit$greater$default$3()).cascaded();
    }

    public One2Many depends(String mappedBy) {
        return new One2Many((Option<Class<?>>)None$.MODULE$, mappedBy, MappingModule$One2Many$.MODULE$.$lessinit$greater$default$3()).cascaded();
    }

    public One2Many one2many(String mappedBy) {
        return new One2Many((Option<Class<?>>)None$.MODULE$, mappedBy, MappingModule$One2Many$.MODULE$.$lessinit$greater$default$3());
    }

    public One2Many one2many(Class<?> clazz, String mappedBy) {
        return new One2Many((Option<Class<?>>)Some$.MODULE$.apply(clazz), mappedBy, MappingModule$One2Many$.MODULE$.$lessinit$greater$default$3());
    }

    public Many2Many many2many(String mappedBy) {
        return new Many2Many(mappedBy);
    }

    public OrderBy orderby(String orderby) {
        return new OrderBy(orderby);
    }

    public Table table(String t) {
        return new Table(t);
    }

    public OrderColumn ordered() {
        return new OrderColumn(null);
    }

    public OrderColumn ordered(String column) {
        return new OrderColumn(column);
    }

    public ColumnName column(String name) {
        return new ColumnName(name);
    }

    public KeyColumn keyColumn(String name) {
        return new KeyColumn(name);
    }

    public KeyLength keyLength(int len) {
        return new KeyLength(len);
    }

    public ElementColumn eleColumn(String name) {
        return new ElementColumn(name);
    }

    public ElementLength eleLength(int len) {
        return new ElementLength(len);
    }

    public JoinColumn joinColumn(String name) {
        return new JoinColumn(name);
    }

    public <T> EntityHolder<T> bindImpl(Class<T> cls, String entityName, BeanInfo bi) {
        OrmEntityType mapping = this.mappings.autobind(cls, entityName, bi);
        for (Class<Object> superCls = cls.getSuperclass(); superCls != null; superCls = superCls.getSuperclass()) {
            Class<T> clazz = superCls;
            Class<Object> clazz2 = Object.class;
            if (!(clazz == null ? clazz2 != null : !clazz.equals(clazz2))) break;
            if (!this.entityMappings.contains((Object)superCls.getName())) continue;
            mapping.idGenerator_$eq(((OrmEntityType)this.entityMappings.apply((Object)superCls.getName())).idGenerator());
            if (mapping.idGenerator() == null) continue;
            superCls = Object.class;
        }
        if (mapping.idGenerator() == null) {
            bi.getPropertyType("id").foreach((Function1)(JProcedure1 & Serializable)idtype -> {
                IdGenerator idGenerator;
                String unsaved = idtype.isPrimitive() ? "0" : "null";
                Option option = this.defaultIdGenerators.get(idtype);
                if (option instanceof Some) {
                    String ig = (String)((Some)option).value();
                    idGenerator = new IdGenerator(ig).unsaved(unsaved);
                } else if (None$.MODULE$.equals(option)) {
                    idGenerator = new IdGenerator(IdGenerator$.MODULE$.Assigned()).unsaved(unsaved);
                } else {
                    throw new MatchError((Object)option);
                }
                mapping.idGenerator_$eq(idGenerator);
            });
        }
        EntityHolder<T> holder = new EntityHolder<T>(mapping, this.mappings, cls, this);
        mapping.module_$eq(this.name());
        this.currentHolder = holder;
        this.entityMappings.put((Object)mapping.entityName(), (Object)mapping);
        return holder;
    }

    public final void defaultIdGenerator(Class<?> clazz, String strategy) {
        this.defaultIdGenerators.put(clazz, (Object)strategy);
    }

    public final CacheHolder cache(String region, String usage) {
        return new CacheHolder(this.mappings, region, usage);
    }

    public final CacheHolder cache() {
        return new CacheHolder(this.mappings, this.org$beangle$data$orm$MappingModule$$cacheConfig().region(), this.org$beangle$data$orm$MappingModule$$cacheConfig().usage());
    }

    public final Entities all() {
        Map newEntities = Collections$.MODULE$.newMap();
        return new Entities(this.mappings, (Map<String, OrmEntityType>)((Map)newEntities.$plus$plus(this.entityMappings)), this.org$beangle$data$orm$MappingModule$$cacheConfig());
    }

    public final void defaultCache(String region, String usage) {
        this.org$beangle$data$orm$MappingModule$$cacheConfig().region_$eq(region);
        this.org$beangle$data$orm$MappingModule$$cacheConfig().usage_$eq(usage);
    }

    public final void configure(Mappings mappings) {
        if (Logger$.MODULE$.isDebugEnabled$extension(this.logger())) {
            Logger$.MODULE$.debug$extension(this.logger(), this::configure$$anonfun$1);
        }
        this.mappings = mappings;
        this.binding();
        this.entityMappings.clear();
    }

    public void index(String name, boolean unique, Seq<Object> properties) {
        LinkedHashSet<String> lasts = this.currentHolder.proxy().lastAccessed();
        if (lasts.isEmpty()) {
            throw new RuntimeException("Cannot find access properties for " + this.currentHolder.mapping().entityName() + " with index declarations");
        }
        OrmEntityType mapping = this.currentHolder.mapping();
        Buffer pms = Collections$.MODULE$.newBuffer();
        Iterator i = lasts.iterator();
        while (i.hasNext()) {
            pms.$plus$eq((Object)mapping.property((String)i.next()));
        }
        new IndexDeclaration(name, unique).apply(this.currentHolder, (Iterable<OrmProperty>)pms);
        lasts.clear();
    }

    public void typedef(String name, String clazz, scala.collection.immutable.Map<String, String> params) {
        this.mappings.addType(name, clazz, params);
    }

    public scala.collection.immutable.Map<String, String> typedef$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public void typedef(Class<?> forClass, String clazz) {
        this.mappings.addType(forClass.getName(), clazz, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public void typedef(Class<?> forClass, String clazz, scala.collection.immutable.Map<String, String> params) {
        this.mappings.addType(forClass.getName(), clazz, params);
    }

    private final String configure$$anonfun$1() {
        return "Process " + this.getClass().getName();
    }

    public static class Cache
    implements PropertyDeclaration {
        private final CacheHolder cacheholder;

        public Cache(CacheHolder cacheholder) {
            this.cacheholder = cacheholder;
        }

        public CacheHolder cacheholder() {
            return this.cacheholder;
        }

        @Override
        public void apply(EntityHolder<?> holder, OrmProperty pm) {
            this.cacheholder().add((List<Collection>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Collection[]{new Collection(holder.clazz(), pm.name())}))), (Seq<List<Collection>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[0]));
        }
    }

    public static final class CacheConfig {
        private String region;
        private String usage;

        public static String $lessinit$greater$default$1() {
            return MappingModule$CacheConfig$.MODULE$.$lessinit$greater$default$1();
        }

        public static String $lessinit$greater$default$2() {
            return MappingModule$CacheConfig$.MODULE$.$lessinit$greater$default$2();
        }

        public CacheConfig(String region, String usage) {
            this.region = region;
            this.usage = usage;
        }

        public String region() {
            return this.region;
        }

        public void region_$eq(String x$1) {
            this.region = x$1;
        }

        public String usage() {
            return this.usage;
        }

        public void usage_$eq(String x$1) {
            this.usage = x$1;
        }
    }

    public static final class CacheHolder {
        private final Mappings mappings;
        private final String cacheRegion;
        private final String cacheUsage;

        public CacheHolder(Mappings mappings, String cacheRegion, String cacheUsage) {
            this.mappings = mappings;
            this.cacheRegion = cacheRegion;
            this.cacheUsage = cacheUsage;
        }

        public Mappings mappings() {
            return this.mappings;
        }

        public String cacheRegion() {
            return this.cacheRegion;
        }

        public String cacheUsage() {
            return this.cacheUsage;
        }

        public CacheHolder add(List<Collection> first, Seq<List<Collection>> definitionLists) {
            first.foreach((Function1 & Serializable)d -> this.mappings().addCollection(d.cache(this.cacheRegion(), this.cacheUsage())));
            definitionLists.foreach((Function1)(JProcedure1 & Serializable)definitions -> definitions.foreach((Function1 & Serializable)d -> this.mappings().addCollection(d.cache(this.cacheRegion(), this.cacheUsage()))));
            return this;
        }

        public CacheHolder add(Class<? extends Entity<?>> first, Seq<Class<? extends Entity<?>>> classes) {
            this.mappings().getEntity(first).cache(this.cacheRegion(), this.cacheUsage());
            classes.foreach((Function1 & Serializable)clazz -> this.mappings().getEntity((Class<?>)clazz).cache(this.cacheRegion(), this.cacheUsage()));
            return this;
        }
    }

    public static class ColumnName
    implements PropertyDeclaration {
        private final String name;

        public ColumnName(String name) {
            this.name = name;
        }

        @Override
        public void apply(EntityHolder<?> holder, OrmProperty pm) {
            ColumnHolder ch;
            if (!ColumnHolder.class.isAssignableFrom(pm.getClass())) {
                MappingMacro$.MODULE$.mismatch("Column holder needed", holder.mapping(), pm);
            }
            if ((ch = (ColumnHolder)((Object)pm)).columns().size() == 1) {
                ((Column)ch.columns().head()).name_$eq(Identifier$.MODULE$.apply(this.name, Identifier$.MODULE$.$lessinit$greater$default$2()));
                return;
            }
        }
    }

    public static class ElementColumn
    implements PropertyDeclaration {
        private final String name;

        public ElementColumn(String name) {
            this.name = name;
        }

        @Override
        public void apply(EntityHolder<?> holder, OrmProperty pm) {
            OrmPluralProperty mp;
            OrmType ormType;
            if (!OrmPluralProperty.class.isAssignableFrom(pm.getClass())) {
                MappingMacro$.MODULE$.mismatch("element column should used on PluralProperty", holder.mapping(), pm);
            }
            if ((ormType = (mp = (OrmPluralProperty)pm).element()) instanceof OrmBasicType) {
                OrmBasicType ch = (OrmBasicType)ormType;
                ch.columns().foreach((Function1)(JProcedure1 & Serializable)x -> x.name_$eq(Identifier$.MODULE$.apply(this.name, Identifier$.MODULE$.$lessinit$greater$default$2())));
                return;
            }
            if (ormType instanceof OrmEntityType) {
                mp.inverseColumn().foreach((Function1)(JProcedure1 & Serializable)x -> x.name_$eq(Identifier$.MODULE$.apply(this.name, Identifier$.MODULE$.$lessinit$greater$default$2())));
                return;
            }
        }
    }

    public static class ElementLength
    implements PropertyDeclaration {
        private final int len;

        public ElementLength(int len) {
            this.len = len;
        }

        @Override
        public void apply(EntityHolder<?> holder, OrmProperty pm) {
            OrmPluralProperty mp;
            OrmType ormType;
            if (!OrmPluralProperty.class.isAssignableFrom(pm.getClass())) {
                MappingMacro$.MODULE$.mismatch("element length should used on PluralProperty", holder.mapping(), pm);
            }
            if ((ormType = (mp = (OrmPluralProperty)pm).element()) instanceof OrmBasicType) {
                OrmBasicType ch = (OrmBasicType)ormType;
                ch.columns().foreach((Function1)(JProcedure1 & Serializable)x -> x.sqlType_$eq(holder.mappings().database().engine().toType(x.sqlType().code(), this.len)));
                return;
            }
            if (ormType instanceof OrmEntityType) {
                mp.inverseColumn().foreach((Function1)(JProcedure1 & Serializable)x -> x.sqlType_$eq(holder.mappings().database().engine().toType(x.sqlType().code(), this.len)));
                return;
            }
        }
    }

    public static final class Entities {
        private final Mappings mappings;
        private final Map entityMappings;
        private final CacheConfig cacheConfig;

        public Entities(Mappings mappings, Map<String, OrmEntityType> entityMappings, CacheConfig cacheConfig) {
            this.mappings = mappings;
            this.entityMappings = entityMappings;
            this.cacheConfig = cacheConfig;
        }

        public Mappings mappings() {
            return this.mappings;
        }

        public Map<String, OrmEntityType> entityMappings() {
            return this.entityMappings;
        }

        public Entities except(Seq<Class<?>> clazzes) {
            clazzes.foreach((Function1 & Serializable)c -> (Map)this.entityMappings().$minus$eq((Object)c.getName()));
            return this;
        }

        public void cacheable() {
            this.cache(this.cacheConfig.region(), this.cacheConfig.usage());
        }

        public Entities cache(String region, String usage) {
            this.entityMappings().foreach((Function1 & Serializable)e -> this.mappings().cache((OrmEntityType)e._2(), this.cacheConfig.region(), this.cacheConfig.usage()));
            return this;
        }

        public Entities cacheAll(String region, String usage) {
            this.entityMappings().foreach((Function1 & Serializable)e -> this.mappings().cacheAll((OrmEntityType)e._2(), this.cacheConfig.region(), this.cacheConfig.usage()));
            return this;
        }

        public String cacheAll$default$1() {
            return this.cacheConfig.region();
        }

        public String cacheAll$default$2() {
            return this.cacheConfig.usage();
        }
    }

    public static final class EntityHolder<T> {
        private final OrmEntityType mapping;
        private final Mappings mappings;
        private final Class clazz;
        private final MappingModule module;
        private Proxy.EntityProxy proxy;

        public EntityHolder(OrmEntityType mapping, Mappings mappings, Class<T> clazz, MappingModule module) {
            this.mapping = mapping;
            this.mappings = mappings;
            this.clazz = clazz;
            this.module = module;
        }

        public OrmEntityType mapping() {
            return this.mapping;
        }

        public Mappings mappings() {
            return this.mappings;
        }

        public Class<T> clazz() {
            return this.clazz;
        }

        public Proxy.EntityProxy proxy() {
            return this.proxy;
        }

        public void proxy_$eq(Proxy.EntityProxy x$1) {
            this.proxy = x$1;
        }

        public EntityHolder cacheable() {
            this.mappings().cache(this.mapping(), this.module.org$beangle$data$orm$MappingModule$$cacheConfig().region(), this.module.org$beangle$data$orm$MappingModule$$cacheConfig().usage());
            return this;
        }

        public EntityHolder cacheAll(String region, String usage) {
            this.mappings().cacheAll(this.mapping(), region, usage);
            return this;
        }

        public String cacheAll$default$1() {
            return this.module.org$beangle$data$orm$MappingModule$$cacheConfig().region();
        }

        public String cacheAll$default$2() {
            return this.module.org$beangle$data$orm$MappingModule$$cacheConfig().usage();
        }

        public EntityHolder cache(String region, String usage) {
            this.mappings().cache(this.mapping(), region, usage);
            return this;
        }

        public EntityHolder declare(Function1<T, Object> declarations) {
            if (this.proxy() == null) {
                this.proxy_$eq(Proxy$.MODULE$.generate(this.clazz()));
            }
            declarations.apply((Object)this.proxy());
            return this;
        }

        public EntityHolder generator(String strategy) {
            this.mapping().idGenerator_$eq(new IdGenerator(strategy));
            return this;
        }

        public EntityHolder table(String table) {
            org.beangle.data.jdbc.meta.Table t = this.mapping().table();
            t.name_$eq(Identifier$.MODULE$.apply(table, Identifier$.MODULE$.$lessinit$greater$default$2()));
            return this;
        }
    }

    public static class Expression {
        private final EntityHolder holder;

        public Expression(EntityHolder<?> holder) {
            this.holder = holder;
        }

        public EntityHolder<?> holder() {
            return this.holder;
        }

        public void is(Seq<PropertyDeclaration> declarations) {
            MappingModule$Expression$.MODULE$.is(this.holder(), declarations);
        }

        public Expressions $amp(Expression next) {
            return new Expressions(this.holder());
        }
    }

    public static class Expressions {
        private final EntityHolder holder;

        public Expressions(EntityHolder<?> holder) {
            this.holder = holder;
        }

        public EntityHolder<?> holder() {
            return this.holder;
        }

        public Expressions $amp(Expression next) {
            return this;
        }

        public void are(Seq<PropertyDeclaration> declarations) {
            MappingModule$Expression$.MODULE$.is(this.holder(), declarations);
        }
    }

    public static class Immutable
    implements PropertyDeclaration {
        @Override
        public void apply(EntityHolder<?> holder, OrmProperty pm) {
            pm.updatable_$eq(false);
            pm.insertable_$eq(true);
        }
    }

    public static class IndexDeclaration {
        private final String name;
        private final boolean unique;

        public IndexDeclaration(String name, boolean unique) {
            this.name = name;
            this.unique = unique;
        }

        public void apply(EntityHolder<?> holder, Iterable<OrmProperty> pms) {
            if (this.unique) {
                UniqueKey uk = new UniqueKey(holder.mapping().table(), Identifier$.MODULE$.apply(this.name, Identifier$.MODULE$.$lessinit$greater$default$2()));
                pms.foreach((Function1)(JProcedure1 & Serializable)pm -> {
                    if (!ColumnHolder.class.isAssignableFrom(pm.getClass())) {
                        MappingMacro$.MODULE$.mismatch("Column holder needed", holder.mapping(), (OrmProperty)pm);
                    }
                    ColumnHolder ch = (ColumnHolder)((Object)pm);
                    ch.columns().find((Function1 & Serializable)_$5 -> _$5.nullable()).foreach((Function1 & Serializable)nullCol -> {
                        throw new RuntimeException("Cannot create unique index " + this.name + " on " + holder.mapping().table().name() + ",nullable column " + nullCol.name() + " finded!");
                    });
                    ch.columns().foreach((Function1)(JProcedure1 & Serializable)e -> uk.addColumn(e.name()));
                });
                if (Strings$.MODULE$.isBlank((CharSequence)this.name)) {
                    uk.name_$eq(Identifier$.MODULE$.apply(Constraint$.MODULE$.autoname((Constraint)uk), Identifier$.MODULE$.$lessinit$greater$default$2()));
                }
                holder.mapping().table().add(uk);
                return;
            }
            Index idx = new Index(holder.mapping().table(), Identifier$.MODULE$.apply(this.name, Identifier$.MODULE$.$lessinit$greater$default$2()));
            idx.unique_$eq(false);
            pms.foreach((Function1)(JProcedure1 & Serializable)pm -> {
                if (!ColumnHolder.class.isAssignableFrom(pm.getClass())) {
                    MappingMacro$.MODULE$.mismatch("Column holder needed", holder.mapping(), (OrmProperty)pm);
                }
                ColumnHolder ch = (ColumnHolder)((Object)pm);
                ch.columns().foreach((Function1)(JProcedure1 & Serializable)e -> idx.addColumn(e.name()));
            });
            if (Strings$.MODULE$.isBlank((CharSequence)this.name)) {
                idx.name_$eq(Identifier$.MODULE$.apply(Constraint$.MODULE$.autoname(idx), Identifier$.MODULE$.$lessinit$greater$default$2()));
            }
            holder.mapping().table().add(idx);
        }
    }

    public static class JoinColumn
    implements PropertyDeclaration {
        private final String name;

        public JoinColumn(String name) {
            this.name = name;
        }

        @Override
        public void apply(EntityHolder<?> holder, OrmProperty pm) {
            OrmPluralProperty mp;
            if (!OrmPluralProperty.class.isAssignableFrom(pm.getClass())) {
                MappingMacro$.MODULE$.mismatch("element column should used on PluralProperty", holder.mapping(), pm);
            }
            if ((mp = (OrmPluralProperty)pm).ownerColumn() != null) {
                mp.ownerColumn().name_$eq(Identifier$.MODULE$.apply(this.name, Identifier$.MODULE$.$lessinit$greater$default$2()));
                return;
            }
        }
    }

    public static class KeyColumn
    implements PropertyDeclaration {
        private final String name;

        public KeyColumn(String name) {
            this.name = name;
        }

        @Override
        public void apply(EntityHolder<?> holder, OrmProperty pm) {
            if (!OrmMapProperty.class.isAssignableFrom(pm.getClass())) {
                MappingMacro$.MODULE$.mismatch("key column should used on MapProperty", holder.mapping(), pm);
            }
            OrmMapProperty mp = (OrmMapProperty)pm;
            mp.keyColumn().name_$eq(Identifier$.MODULE$.apply(this.name, Identifier$.MODULE$.$lessinit$greater$default$2()));
        }
    }

    public static class KeyLength
    implements PropertyDeclaration {
        private final int len;

        public KeyLength(int len) {
            this.len = len;
        }

        @Override
        public void apply(EntityHolder<?> holder, OrmProperty pm) {
            if (!OrmMapProperty.class.isAssignableFrom(pm.getClass())) {
                MappingMacro$.MODULE$.mismatch("key length should used on MapProperty", holder.mapping(), pm);
            }
            OrmMapProperty mp = (OrmMapProperty)pm;
            Column x = mp.keyColumn();
            mp.keyColumn().sqlType_$eq(holder.mappings().database().engine().toType(x.sqlType().code(), this.len));
        }
    }

    public static class Length
    implements PropertyDeclaration {
        private final int len;

        public Length(int len) {
            this.len = len;
        }

        @Override
        public void apply(EntityHolder<?> holder, OrmProperty pm) {
            if (!ColumnHolder.class.isAssignableFrom(pm.getClass())) {
                MappingMacro$.MODULE$.mismatch("Column holder needed", holder.mapping(), pm);
            }
            ColumnHolder ch = (ColumnHolder)((Object)pm);
            Engine engine = holder.mappings().database().engine();
            ch.columns().foreach((Function1)(JProcedure1 & Serializable)c -> c.sqlType_$eq(engine.toType(c.sqlType().code(), this.len, BoxesRunTime.unboxToInt((Object)c.sqlType().scale().getOrElse(this::apply$$anonfun$13$$anonfun$1)))));
        }

        private final int apply$$anonfun$13$$anonfun$1() {
            return 0;
        }
    }

    public static class Lob
    implements PropertyDeclaration {
        /*
         * Unable to fully structure code
         */
        @Override
        public void apply(EntityHolder<?> holder, OrmProperty pm) {
            block11: {
                block8: {
                    block12: {
                        block10: {
                            block9: {
                                if (!ColumnHolder.class.isAssignableFrom(pm.getClass())) {
                                    MappingMacro$.MODULE$.mismatch("Column holder needed", holder.mapping(), pm);
                                }
                                ch = (ColumnHolder)pm;
                                c = pm.clazz();
                                isBlob = false;
                                isClob = false;
                                if (!c.isArray()) break block8;
                                if (c.getName().equals("[B")) break block9;
                                v0 = c.getComponentType();
                                var7_7 = Byte.class;
                                if (v0 != null ? v0.equals(var7_7) == false : var7_7 != null) break block10;
                            }
                            isBlob = true;
                            break block11;
                        }
                        if (c.getName().equals("[C")) break block12;
                        v1 = c.getComponentType();
                        var8_8 = Character.class;
                        if (v1 != null ? v1.equals(var8_8) == false : var8_8 != null) break block11;
                    }
                    isClob = true;
                    break block11;
                }
                v2 = c;
                var9_9 = Clob.class;
                if (!(v2 == null ? var9_9 != null : v2.equals(var9_9) == false)) ** GOTO lbl-1000
                v3 = c;
                var10_10 = String.class;
                if (!(v3 != null ? v3.equals(var10_10) == false : var10_10 != null)) lbl-1000:
                // 2 sources

                {
                    isClob = true;
                } else {
                    v4 = c;
                    var11_11 = Blob.class;
                    if (!(v4 == null ? var11_11 != null : v4.equals(var11_11) == false) || Serializable.class.isAssignableFrom(c)) {
                        isBlob = true;
                    }
                }
            }
            if (!isClob && !isBlob) {
                throw new RuntimeException("Cannot mapping " + holder.clazz().getName() + "." + pm.name() + "(" + c.getName() + ") to lob!");
            }
            engine = holder.mappings().database().engine();
            if (isBlob) {
                ch.columns().foreach((Function1)(JProcedure1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)V, apply$$anonfun$4(org.beangle.data.jdbc.engine.Engine org.beangle.data.jdbc.meta.Column ), (Lorg/beangle/data/jdbc/meta/Column;)V)((Lob)this, (Engine)engine));
                return;
            }
            ch.columns().foreach((Function1)(JProcedure1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)V, apply$$anonfun$5(org.beangle.data.jdbc.engine.Engine org.beangle.data.jdbc.meta.Column ), (Lorg/beangle/data/jdbc/meta/Column;)V)((Lob)this, (Engine)engine));
        }

        private final /* synthetic */ void apply$$anonfun$4(Engine engine$1, Column c) {
            c.sqlType_$eq(engine$1.toType(2004));
        }

        private final /* synthetic */ void apply$$anonfun$5(Engine engine$2, Column c) {
            c.sqlType_$eq(engine$2.toType(2005));
        }
    }

    public static class Many2Many
    implements PropertyDeclaration {
        private final String mappedBy;

        public Many2Many(String mappedBy) {
            this.mappedBy = mappedBy;
        }

        @Override
        public void apply(EntityHolder<?> holder, OrmProperty pm) {
            if (!OrmCollectionProperty.class.isAssignableFrom(pm.getClass())) {
                MappingMacro$.MODULE$.mismatch("many2many should used on seq", holder.mapping(), pm);
            }
            OrmCollectionProperty colpm = (OrmCollectionProperty)pm;
            colpm.mappedBy_$eq((Option<String>)Some$.MODULE$.apply((Object)this.mappedBy));
            if (!(colpm.element() instanceof OrmEntityType)) {
                MappingMacro$.MODULE$.mismatch("many2many with mappedBy should be applied on entity", holder.mapping(), pm);
            }
            colpm.table_$eq((Option<String>)None$.MODULE$);
        }
    }

    public static class NotNull
    implements PropertyDeclaration {
        @Override
        public void apply(EntityHolder<?> holder, OrmProperty pm) {
            if (!ColumnHolder.class.isAssignableFrom(pm.getClass())) {
                MappingMacro$.MODULE$.mismatch("Column holder needed", holder.mapping(), pm);
            }
            ColumnHolder ch = (ColumnHolder)((Object)pm);
            ch.columns().foreach((Function1)(JProcedure1 & Serializable)c -> c.nullable_$eq(false));
        }
    }

    public static class One2Many
    implements PropertyDeclaration {
        private final Option<Class<?>> targetEntity;
        private final String mappedBy;
        private Option cascade;

        public static Option<String> $lessinit$greater$default$3() {
            return MappingModule$One2Many$.MODULE$.$lessinit$greater$default$3();
        }

        public One2Many(Option<Class<?>> targetEntity, String mappedBy, Option<String> cascade) {
            this.targetEntity = targetEntity;
            this.mappedBy = mappedBy;
            this.cascade = cascade;
        }

        private Option<String> cascade() {
            return this.cascade;
        }

        private void cascade_$eq(Option<String> x$0) {
            this.cascade = x$0;
        }

        @Override
        public void apply(EntityHolder<?> holder, OrmProperty pm) {
            if (!OrmCollectionProperty.class.isAssignableFrom(pm.getClass())) {
                MappingMacro$.MODULE$.mismatch("one2many should used on seq", holder.mapping(), pm);
            }
            OrmCollectionProperty colpm = (OrmCollectionProperty)pm;
            colpm.ownerColumn_$eq(MappingModule$.MODULE$.org$beangle$data$orm$MappingModule$$$genOwnerColumn(holder, (Option<String>)Some$.MODULE$.apply((Object)this.mappedBy)));
            colpm.mappedBy_$eq((Option<String>)Some$.MODULE$.apply((Object)this.mappedBy));
            this.targetEntity.foreach((Function1)(JProcedure1 & Serializable)clazz -> {
                colpm.element_$eq(holder.mappings().refEntity((Class<?>)clazz, clazz.getName()));
                colpm.inverseColumn_$eq((Option<Column>)Some$.MODULE$.apply((Object)holder.mappings().newRefColumn((Class<?>)clazz, clazz.getName())));
            });
            colpm.one2many_$eq(true);
            this.cascade().foreach((Function1)(JProcedure1 & Serializable)c -> colpm.cascade_$eq((Option<String>)Some$.MODULE$.apply(c)));
        }

        public One2Many cascade(String c, boolean orphanRemoval) {
            this.cascade_$eq((Option<String>)Some$.MODULE$.apply(orphanRemoval && !c.contains("delete-orphan") ? c + ",delete-orphan" : c));
            return this;
        }

        public boolean cascade$default$2() {
            return true;
        }

        public One2Many cascaded() {
            this.cascade_$eq((Option<String>)Some$.MODULE$.apply((Object)"all,delete-orphan"));
            return this;
        }
    }

    public static class OrderBy
    implements PropertyDeclaration {
        private final String orderBy;

        public OrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        @Override
        public void apply(EntityHolder<?> holder, OrmProperty pm) {
            if (!OrmCollectionProperty.class.isAssignableFrom(pm.getClass())) {
                MappingMacro$.MODULE$.mismatch("order by should used on seq", holder.mapping(), pm);
            }
            OrmCollectionProperty cm = (OrmCollectionProperty)pm;
            cm.orderBy_$eq((Option<String>)Some$.MODULE$.apply((Object)this.orderBy));
        }
    }

    public static class OrderColumn
    implements PropertyDeclaration {
        private final String orderColumn;

        public OrderColumn(String orderColumn) {
            this.orderColumn = orderColumn;
        }

        @Override
        public void apply(EntityHolder<?> holder, OrmProperty pm) {
            if (!OrmCollectionProperty.class.isAssignableFrom(pm.getClass())) {
                MappingMacro$.MODULE$.mismatch("order column should used on many2many seq", holder.mapping(), pm);
            }
            OrmCollectionProperty collp = (OrmCollectionProperty)pm;
            Column idxCol = new Column(Identifier$.MODULE$.apply(this.orderColumn == null ? MappingModule$.MODULE$.OrderColumnName() : this.orderColumn, Identifier$.MODULE$.$lessinit$greater$default$2()), holder.mappings().sqlTypeMapping().sqlType(Integer.TYPE), false);
            idxCol.comment_$eq((Option)Some$.MODULE$.apply((Object)"index no"));
            collp.index_$eq((Option<Column>)Some$.MODULE$.apply((Object)idxCol));
        }
    }

    public static interface PropertyDeclaration {
        public void apply(EntityHolder<?> var1, OrmProperty var2);
    }

    public static class ReadOnly
    implements PropertyDeclaration {
        @Override
        public void apply(EntityHolder<?> holder, OrmProperty pm) {
            pm.updatable_$eq(false);
            pm.insertable_$eq(false);
        }
    }

    public static class Table
    implements PropertyDeclaration {
        private final String table;

        public Table(String table) {
            this.table = table;
        }

        @Override
        public void apply(EntityHolder<?> holder, OrmProperty pm) {
            if (!OrmPluralProperty.class.isAssignableFrom(pm.getClass())) {
                MappingMacro$.MODULE$.mismatch("table should used on seq", holder.mapping(), pm);
            }
            ((OrmPluralProperty)pm).table_$eq((Option<String>)Some$.MODULE$.apply((Object)this.table));
        }
    }

    public static class Target
    implements PropertyDeclaration {
        private final Class<?> clazz;

        public Target(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public void apply(EntityHolder<?> holder, OrmProperty pm) {
            OrmSingularProperty sp2 = (OrmSingularProperty)pm;
            sp2.propertyType_$eq(holder.mappings().refEntity(this.clazz, this.clazz.getName()));
        }
    }

    public static class Unique
    implements PropertyDeclaration {
        @Override
        public void apply(EntityHolder<?> holder, OrmProperty pm) {
            if (!ColumnHolder.class.isAssignableFrom(pm.getClass())) {
                MappingMacro$.MODULE$.mismatch("Column holder needed", holder.mapping(), pm);
            }
            ColumnHolder ch = (ColumnHolder)((Object)pm);
            ch.columns().foreach((Function1)(JProcedure1 & Serializable)c -> c.unique_$eq(true));
        }
    }
}

