/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.orm.hibernate;

import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import javax.sql.DataSource;
import org.beangle.commons.lang.ClassLoaders$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.jdbc.engine.Engine;
import org.beangle.data.jdbc.engine.Engines$;
import org.beangle.data.jdbc.meta.Database;
import org.beangle.data.orm.Mappings;
import org.beangle.data.orm.hibernate.ConfigurationBuilder$;
import org.beangle.data.orm.hibernate.cfg.MappingService;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.slf4j.Logger;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.Statics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConfigurationBuilder
implements Logging {
    private Logger logger;
    private final DataSource dataSource;
    private final Properties properties;
    private Seq ormLocations;

    public static Configuration default() {
        return ConfigurationBuilder$.MODULE$.default();
    }

    public static Properties $lessinit$greater$default$2() {
        return ConfigurationBuilder$.MODULE$.$lessinit$greater$default$2();
    }

    public ConfigurationBuilder(DataSource dataSource, Properties properties) {
        this.dataSource = dataSource;
        this.properties = properties;
        Logging.$init$((Logging)this);
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public DataSource dataSource() {
        return this.dataSource;
    }

    public Seq<URL> ormLocations() {
        return this.ormLocations;
    }

    public void ormLocations_$eq(Seq<URL> x$1) {
        this.ormLocations = x$1;
    }

    public void importSysProperties() {
        Properties sysProps = System.getProperties();
        Enumeration<?> keys = sysProps.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith("hibernate.")) continue;
            String value2 = sysProps.getProperty(key);
            boolean overrided = this.properties.containsKey(key);
            this.properties.put(key, value2);
            if (!overrided) continue;
            Logger$.MODULE$.info$extension(this.logger(), () -> ConfigurationBuilder.importSysProperties$$anonfun$1(key, value2));
        }
    }

    public void addDefaultProperties() {
        if (this.dataSource() != null) {
            this.properties.put("hibernate.connection.datasource", this.dataSource());
        }
        this.addDefault("hibernate.connection.handling_mode", PhysicalConnectionHandlingMode.DELAYED_ACQUISITION_AND_RELEASE_AFTER_TRANSACTION.name());
        this.addDefault("hibernate.current_session_context_class", "org.beangle.data.orm.hibernate.SpringSessionContext");
        this.addDefault("hibernate.archive.autodetection", "none");
        this.addDefault("hibernate.xml_mapping_enabled", "false");
        this.addDefault("hibernate.max_fetch_depth", "1");
        this.addDefault("hibernate.jdbc.batch_size", "20");
        this.addDefault("hibernate.jdbc.fetch_size", "500");
        this.addDefault("hibernate.default_batch_fetch_size", "100");
        this.addDefault("hibernate.jdbc.use_get_generated_keys", "true");
        this.addDefault("hibernate.cache.use_second_level_cache", "true");
        this.addDefault("hibernate.cache.use_query_cache", "true");
        this.addDefault("hibernate.cache.region.factory_class", "jcache");
        if (!this.properties.contains("hibernate.javax.cache.provider")) {
            this.addDefault("hibernate.javax.cache.missing_cache_strategy", "create");
            String caffeine = "com.github.benmanes.caffeine.jcache.spi.CaffeineCachingProvider";
            if (ClassLoaders$.MODULE$.get(caffeine, ClassLoaders$.MODULE$.get$default$2()).nonEmpty()) {
                this.addDefault("hibernate.javax.cache.provider", caffeine);
            }
        }
        this.addDefault("hibernate.show_sql", "false");
        this.addDefault("hibernate.format_sql", "false");
    }

    public void enableDevMode() {
        this.addDefault("hibernate.show_sql", "true");
        this.addDefault("hibernate.session.events.log.LOG_QUERIES_SLOWER_THAN_MS", "100");
    }

    private void addDefault(String name, Object value2) {
        if (!this.properties.containsKey(name)) {
            this.properties.put(name, value2);
            return;
        }
    }

    public Configuration build() {
        this.addDefaultProperties();
        this.importSysProperties();
        StandardServiceRegistryBuilder standardRegistryBuilder = new StandardServiceRegistryBuilder();
        Mappings mappings = this.getMappings();
        standardRegistryBuilder.addService(MappingService.class, (Service)new MappingService(mappings));
        standardRegistryBuilder.applySettings(this.properties);
        StandardServiceRegistry standardRegistry = standardRegistryBuilder.build();
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)standardRegistry);
        Configuration configuration = new Configuration(metadataSources);
        configuration.addProperties(this.properties);
        return configuration;
    }

    private Mappings getMappings() {
        Engine engine = Engines$.MODULE$.forDataSource(this.dataSource());
        Mappings mappings = new Mappings(new Database(engine), (List<URL>)this.ormLocations().toList());
        mappings.autobind();
        return mappings;
    }

    private static final String importSysProperties$$anonfun$1(String key$1, String value$1) {
        return "Override hibernate property " + key$1 + "=" + value$1;
    }
}

