/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.orm.cfg;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import org.beangle.commons.config.Resources;
import org.beangle.commons.lang.ClassLoaders$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.reflect.Reflections$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.orm.MappingModule;
import org.beangle.data.orm.NamingPolicy;
import org.beangle.data.orm.cfg.AnnotationModule;
import org.beangle.data.orm.cfg.EJB3NamingPolicy;
import org.beangle.data.orm.cfg.MappingProfile;
import org.beangle.data.orm.cfg.RailsNamingPolicy;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.XML$;

public class Profiles
implements Logging {
    private Logger logger;
    private final Resources resources;
    private final MappingProfile defaultProfile;
    private final HashMap<String, MappingProfile> profiles;
    private final HashMap<String, NamingPolicy> namings;
    private List modules;

    public Profiles(Resources resources) {
        this.resources = resources;
        Logging.$init$((Logging)this);
        this.defaultProfile = new MappingProfile();
        this.profiles = new HashMap();
        this.namings = new HashMap();
        this.init();
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public List<MappingModule> modules() {
        return this.modules;
    }

    public void modules_$eq(List<MappingModule> x$1) {
        this.modules = x$1;
    }

    public Option<String> getSchema(Class<?> clazz) {
        return this.getProfile(clazz).getSchema(clazz);
    }

    public String getPrefix(Class<?> clazz) {
        return this.getProfile(clazz).getPrefix(clazz);
    }

    public MappingProfile getProfile(Class<?> clazz) {
        String name = clazz.getName();
        None$ matched = None$.MODULE$;
        while (Strings$.MODULE$.isNotEmpty((CharSequence)name) && matched.isEmpty()) {
            if (this.profiles.contains((Object)name)) {
                matched = Some$.MODULE$.apply(this.profiles.apply((Object)name));
            }
            int len = name.length();
            if ((name = Strings$.MODULE$.substringBeforeLast(name, ".")).length() != len) continue;
            name = "";
        }
        return (MappingProfile)matched.getOrElse(this::getProfile$$anonfun$1);
    }

    public NamingPolicy getNamingPolicy(Class<?> clazz) {
        return this.getProfile(clazz).naming();
    }

    public String toString() {
        if (this.profiles.isEmpty()) {
            return "";
        }
        int maxlength = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.profiles.keys().map((Function1 & Serializable)_$2 -> _$2.length())).max((Ordering)Ordering.Int$.MODULE$));
        StringBuilder sb = new StringBuilder();
        ((List)this.profiles.keySet().toList().sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable)packageName -> {
            MappingProfile profile = (MappingProfile)this.profiles.apply(packageName);
            sb.append(Strings$.MODULE$.rightPad(packageName, maxlength, ' ')).append(" : [").append((String)profile.schema().getOrElse(Profiles::toString$$anonfun$1$$anonfun$1)).append(",");
            sb.append(Strings$.MODULE$.isEmpty((CharSequence)profile.prefix()) ? "_" : profile.prefix());
            return sb.append(']').append("\n");
        });
        if (sb.nonEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private Option<String> globalSchema() {
        String s = System.getProperty("beangle.data.orm.global_schema");
        if (Strings$.MODULE$.isBlank((CharSequence)s)) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)s.trim());
    }

    private void init() {
        RailsNamingPolicy rails = new RailsNamingPolicy(this);
        this.namings.put((Object)"rails", (Object)rails);
        this.namings.put((Object)"ejb3", (Object)new EJB3NamingPolicy(this));
        this.defaultProfile.naming_$eq(rails);
        this.globalSchema().foreach((Function1)(JProcedure1 & Serializable)s -> this.defaultProfile._schema_$eq((Option<String>)Some$.MODULE$.apply(s)));
        HashMap ms = new HashMap();
        this.resources.paths().foreach((Function1)(JProcedure1 & Serializable)url -> this.addConfig((URL)url, (HashMap<String, MappingModule>)ms));
        if (Logger$.MODULE$.isDebugEnabled$extension(this.logger()) && this.profiles.nonEmpty()) {
            Logger$.MODULE$.debug$extension(this.logger(), this::init$$anonfun$3);
        }
        this.modules_$eq((List<MappingModule>)((IterableOnceOps)ms.values().toSeq().sortBy((Function1 & Serializable)_$3 -> _$3.getClass().getName(), (Ordering)Ordering.String$.MODULE$)).toList());
    }

    private void addConfig(URL url, HashMap<String, MappingModule> ms) {
        try {
            Logger$.MODULE$.debug$extension(this.logger(), () -> Profiles.addConfig$$anonfun$1(url));
            InputStream is = url.openStream();
            if (is != null) {
                Elem xml = (Elem)XML$.MODULE$.load(is);
                xml.$bslash("naming").$bslash("profile").foreach((Function1)(JProcedure1 & Serializable)ele -> this.parseProfile((Node)ele, null));
                xml.$bslash("mapping").foreach((Function1 & Serializable)ele -> {
                    String name = ele.$bslash("@name").text();
                    String clz = ele.$bslash("@class").text();
                    if (ms.contains((Object)clz)) {
                        Logger$.MODULE$.warn$extension(this.logger(), () -> Profiles.addConfig$$anonfun$3$$anonfun$1(clz));
                        return BoxedUnit.UNIT;
                    }
                    MappingModule module = (MappingModule)Reflections$.MODULE$.getInstance(clz);
                    if (Strings$.MODULE$.isNotBlank((CharSequence)name)) {
                        module.name_$eq((Option<String>)Some$.MODULE$.apply((Object)name.trim()));
                    }
                    return ms.put((Object)clz, (Object)module);
                });
                is.close();
            }
            this.autoWire();
        }
        catch (Exception e) {
            throw new RuntimeException("property load error in url:" + url, e);
        }
    }

    private void autoWire() {
        if (this.profiles.size() > 1) {
            this.profiles.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    MappingProfile profile = (MappingProfile)tuple2._2();
                    ObjectRef parentName = ObjectRef.create((Object)Strings$.MODULE$.substringBeforeLast(key, "."));
                    while (Strings$.MODULE$.isNotEmpty((CharSequence)((String)parentName.elem)) && profile.parent() == null) {
                        if (this.profiles.contains((Object)((String)parentName.elem))) {
                            String string = profile.packageName();
                            String string2 = (String)parentName.elem;
                            if (string == null ? string2 != null : !string.equals(string2)) {
                                Logger$.MODULE$.debug$extension(this.logger(), () -> Profiles.autoWire$$anonfun$1$$anonfun$1(profile, parentName));
                                profile.parent_$eq((Option<MappingProfile>)this.profiles.get((Object)((String)parentName.elem)));
                            }
                        }
                        int len = ((String)parentName.elem).length();
                        String string = Strings$.MODULE$.substringBeforeLast((String)parentName.elem, ".");
                        parentName.elem = string;
                        string = null;
                        if (((String)parentName.elem).length() != len) continue;
                        String string3 = "";
                        parentName.elem = string3;
                        string3 = null;
                    }
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            return;
        }
    }

    private void parseProfile(Node melem, MappingProfile parent) {
        String naming;
        MappingProfile profile = new MappingProfile();
        if (melem.$bslash("@package").nonEmpty()) {
            profile.packageName_$eq(melem.$bslash("@package").text());
            if (parent != null) {
                profile.packageName_$eq(parent.packageName() + "." + profile.packageName());
            }
        }
        melem.$bslash("annotation").foreach((Function1)(JProcedure1 & Serializable)anElem -> {
            Class clazz = ClassLoaders$.MODULE$.load(anElem.$bslash("@class").text(), ClassLoaders$.MODULE$.load$default$2());
            String value2 = anElem.$bslash("@value").text();
            AnnotationModule annModule = new AnnotationModule(clazz, value2);
            profile._annotations().$plus$eq((Object)annModule);
            if (anElem.$bslash("@schema").nonEmpty()) {
                annModule.schema_$eq(this.parseSchema(anElem.$bslash("@schema").text()));
            }
            if (anElem.$bslash("@prefix").nonEmpty()) {
                annModule.prefix_$eq(anElem.$bslash("@prefix").text());
                return;
            }
        });
        if (melem.$bslash("@schema").nonEmpty()) {
            profile._schema_$eq((Option<String>)Some$.MODULE$.apply((Object)this.parseSchema(melem.$bslash("@schema").text())));
        }
        if (melem.$bslash("@abbrs").nonEmpty()) {
            profile.abbrs_$eq(this.parseAbbreviations(melem.$bslash("@abbrs").text()));
        }
        if (melem.$bslash("@prefix").nonEmpty()) {
            profile._prefix_$eq((Option<String>)Some$.MODULE$.apply((Object)melem.$bslash("@prefix").text()));
        }
        String string = naming = melem.$bslash("@naming").nonEmpty() ? melem.$bslash("@naming").text() : "rails";
        if (this.namings.contains((Object)naming)) {
            profile.naming_$eq((NamingPolicy)this.namings.apply((Object)naming));
        } else {
            try {
                Class policyClzz = ClassLoaders$.MODULE$.load(naming, ClassLoaders$.MODULE$.load$default$2());
                NamingPolicy policy = (NamingPolicy)policyClzz.getConstructor(Profiles.class).newInstance(this);
                this.namings.put((Object)naming, (Object)policy);
                profile.naming_$eq(policy);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot find naming policy :" + naming + " due to " + e.getMessage());
            }
        }
        this.profiles.put((Object)profile.packageName(), (Object)profile);
        profile.parent_$eq((Option<MappingProfile>)Option$.MODULE$.apply((Object)parent));
        melem.$bslash("profile").foreach((Function1)(JProcedure1 & Serializable)child -> this.parseProfile((Node)child, profile));
    }

    private String parseSchema(String name) {
        Option<String> option = this.globalSchema();
        if (None$.MODULE$.equals(option)) {
            if (Strings$.MODULE$.isEmpty((CharSequence)name) || -1 == name.indexOf(123)) {
                return name;
            }
            String newName = Strings$.MODULE$.replace(name, "$", "");
            String propertyName = Strings$.MODULE$.substringBetween(newName, "{", "}");
            String pv = System.getProperty(propertyName);
            return Strings$.MODULE$.replace(newName, "{" + propertyName + "}", pv == null ? "" : pv);
        }
        if (option instanceof Some) {
            String n = (String)((Some)option).value();
            return n;
        }
        throw new MatchError(option);
    }

    private Map<String, String> parseAbbreviations(String text) {
        HashMap map = new HashMap();
        Object[] abbrs = Strings$.MODULE$.split(text);
        Object object = Predef$.MODULE$.refArrayOps(abbrs);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)abbr -> {
            String[] abbrPair = Strings$.MODULE$.split(abbr, "=");
            if (abbrPair.length == 1) {
                return map.put((Object)abbrPair[0].trim(), (Object)"");
            }
            return map.put((Object)abbrPair[0].trim(), (Object)abbrPair[1].trim());
        });
        return map.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private final MappingProfile getProfile$$anonfun$1() {
        return this.defaultProfile;
    }

    private static final String toString$$anonfun$1$$anonfun$1() {
        return "_";
    }

    private final String init$$anonfun$3() {
        return "Table name pattern: -> \n" + this.toString();
    }

    private static final String addConfig$$anonfun$1(URL url$1) {
        return "loading " + url$1;
    }

    private static final String addConfig$$anonfun$3$$anonfun$1(String clz$1) {
        return "duplicated moudule " + clz$1;
    }

    private static final String autoWire$$anonfun$1$$anonfun$1(MappingProfile profile$1, ObjectRef parentName$1) {
        return "set " + profile$1.packageName() + "'s parent is " + (String)parentName$1.elem;
    }
}

