/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.orm.hibernate;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.orm.hibernate.HibernateTransactionManager;
import org.beangle.data.orm.hibernate.SessionHelper;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.service.spi.Wrapped;
import org.slf4j.Logger;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.ResourceTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public final class SessionHelper$
implements Logging,
Serializable {
    private static Logger logger;
    public static final SessionHelper$ MODULE$;

    private SessionHelper$() {
    }

    static {
        MODULE$ = new SessionHelper$();
        Logging.$init$((Logging)MODULE$);
        Statics.releaseFence();
    }

    public Logger logger() {
        return logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        logger = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SessionHelper$.class);
    }

    public Object beginTransaction(EntityManager entityManager, TransactionDefinition definition) throws TransactionException, SQLException, PersistenceException {
        ResourceTransactionDefinition rtd;
        SessionImplementor session = this.getSession(entityManager);
        if (definition.getTimeout() != -1) {
            ((Transaction)session.getTransaction()).setTimeout(definition.getTimeout());
        }
        boolean isolationLevelNeeded = definition.getIsolationLevel() != -1;
        Integer previousIsolationLevel = null;
        Connection preparedCon = null;
        if (isolationLevelNeeded || definition.isReadOnly()) {
            if (ConnectionReleaseMode.ON_CLOSE.equals((Object)session.getJdbcCoordinator().getLogicalConnection().getConnectionHandlingMode().getReleaseMode())) {
                preparedCon = session.getJdbcCoordinator().getLogicalConnection().getPhysicalConnection();
                previousIsolationLevel = this.prepareConnectionForTransaction(preparedCon, definition);
            } else if (isolationLevelNeeded) {
                throw new InvalidIsolationLevelException("HibernateJpaDialect is not allowed to support custom isolation levels.");
            }
        }
        entityManager.getTransaction().begin();
        FlushMode previousFlushMode = this.prepareFlushMode((Session)session, definition.isReadOnly());
        TransactionDefinition transactionDefinition = definition;
        if (transactionDefinition instanceof ResourceTransactionDefinition && (rtd = (ResourceTransactionDefinition)transactionDefinition).isLocalResource()) {
            previousFlushMode = null;
            if (definition.isReadOnly()) {
                session.setDefaultReadOnly(true);
            }
        }
        return new SessionHelper.SessionTransactionData(session, previousFlushMode, preparedCon != null, previousIsolationLevel, definition.isReadOnly());
    }

    private FlushMode prepareFlushMode(Session session, boolean readOnly) {
        FlushMode flushMode = session.getHibernateFlushMode();
        if (readOnly) {
            FlushMode flushMode2 = flushMode;
            FlushMode flushMode3 = FlushMode.MANUAL;
            if (flushMode2 == null ? flushMode3 != null : !flushMode2.equals(flushMode3)) {
                session.setHibernateFlushMode(FlushMode.MANUAL);
                return flushMode;
            }
        } else if (flushMode.lessThan(FlushMode.COMMIT)) {
            session.setHibernateFlushMode(FlushMode.AUTO);
            return flushMode;
        }
        return null;
    }

    public void cleanupTransaction(Object transactionData) {
        Object object = transactionData;
        if (object instanceof SessionHelper.SessionTransactionData) {
            SessionHelper.SessionTransactionData std = (SessionHelper.SessionTransactionData)object;
            std.resetSessionState();
            return;
        }
    }

    public void releaseJdbcConnection(ConnectionHandle conHandle, EntityManager em) {
    }

    public ConnectionHandle getJdbcConnection(EntityManager entityManager, boolean readOnly) {
        return new SessionHelper.HibernateConnectionHandle(this.getSession(entityManager));
    }

    public SessionImplementor getSession(EntityManager entityManager) {
        return (SessionImplementor)entityManager.unwrap(SessionImplementor.class);
    }

    public void safeCloseSession(EntityManager em) {
        if (em != null) {
            try {
                if (em.isOpen()) {
                    em.close();
                }
            }
            catch (Throwable ex) {
                Logger$.MODULE$.error$extension(this.logger(), this::safeCloseSession$$anonfun$1, () -> this.safeCloseSession$$anonfun$2(ex));
            }
            return;
        }
    }

    public DataSource getDataSource(SessionFactory factory) {
        SessionFactoryImplementor factoryImpl = (SessionFactoryImplementor)factory;
        if (factoryImpl.getSessionFactoryOptions().isMultiTenancyEnabled()) {
            return (DataSource)((Wrapped)factoryImpl.getServiceRegistry().getService(MultiTenantConnectionProvider.class)).unwrap(DataSource.class);
        }
        return (DataSource)((Wrapped)factoryImpl.getServiceRegistry().getService(ConnectionProvider.class)).unwrap(DataSource.class);
    }

    private Integer prepareConnectionForTransaction(Connection con, TransactionDefinition definition) throws SQLException {
        int currentIsolation;
        if (definition != null && definition.isReadOnly()) {
            try {
                con.setReadOnly(true);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof SQLException || throwable2 instanceof RuntimeException) {
                    Exception ex;
                    for (Throwable exToCheck = ex = (Exception)throwable2; exToCheck != null; exToCheck = exToCheck.getCause()) {
                        if (!exToCheck.getClass().getSimpleName().contains("Timeout")) continue;
                        throw ex;
                    }
                }
                throw throwable;
            }
        }
        Integer previousIsolationLevel = null;
        if (definition != null && !(Predef$.MODULE$.int2Integer(definition.getIsolationLevel()) == Predef$.MODULE$.int2Integer(-1)) && (currentIsolation = con.getTransactionIsolation()) != definition.getIsolationLevel()) {
            previousIsolationLevel = Predef$.MODULE$.int2Integer(currentIsolation);
            con.setTransactionIsolation(definition.getIsolationLevel());
        }
        return previousIsolationLevel;
    }

    private Session doOpenSession(SessionFactory factory, Option<Interceptor> interceptor, Option<Consumer<Session>> initializer) {
        Session session;
        Option<Interceptor> option = interceptor;
        if (option instanceof Some) {
            Interceptor i = (Interceptor)((Some)option).value();
            SessionBuilder builder = factory.withOptions();
            builder.interceptor(i);
            session = builder.openSession();
        } else if (None$.MODULE$.equals(option)) {
            session = factory.openSession();
        } else {
            throw new MatchError(option);
        }
        Session s = session;
        initializer.foreach((Function1)(JProcedure1 & Serializable)iz -> iz.accept(s));
        return s;
    }

    public HibernateTransactionManager.SessionHolder openSession(SessionFactory factory, Option<Interceptor> interceptor, Option<Consumer<Session>> initializer) {
        HibernateTransactionManager.SessionHolder holder = (HibernateTransactionManager.SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)factory));
        Session session = null;
        if (holder == null) {
            session = this.doOpenSession(factory, interceptor, initializer);
            session.setHibernateFlushMode(FlushMode.COMMIT);
            holder = new HibernateTransactionManager.SessionHolder(session);
            TransactionSynchronizationManager.bindResource((Object)factory, (Object)((Object)holder));
        }
        return holder;
    }

    public Option<Interceptor> openSession$default$2() {
        return None$.MODULE$;
    }

    public Option<Consumer<Session>> openSession$default$3() {
        return None$.MODULE$;
    }

    public HibernateTransactionManager.SessionHolder currentSession(SessionFactory factory) {
        return (HibernateTransactionManager.SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)factory));
    }

    public void closeSession(SessionFactory factory) {
        try {
            HibernateTransactionManager.SessionHolder holder = (HibernateTransactionManager.SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)factory));
            if (holder != null) {
                TransactionSynchronizationManager.unbindResource((Object)factory);
                holder.session().close();
            }
        }
        catch (HibernateException ex) {
            Logger$.MODULE$.debug$extension(this.logger(), this::closeSession$$anonfun$1, () -> this.closeSession$$anonfun$2(ex));
        }
        catch (Throwable e) {
            Logger$.MODULE$.debug$extension(this.logger(), this::closeSession$$anonfun$3, () -> this.closeSession$$anonfun$4(e));
        }
    }

    public void closeSession(Session session) {
        try {
            HibernateTransactionManager.SessionHolder holder = (HibernateTransactionManager.SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)session.getSessionFactory()));
            if (holder != null) {
                TransactionSynchronizationManager.unbindResource((Object)session.getSessionFactory());
            }
            session.close();
        }
        catch (HibernateException ex) {
            Logger$.MODULE$.debug$extension(this.logger(), this::closeSession$$anonfun$5, () -> this.closeSession$$anonfun$6(ex));
        }
        catch (Throwable e) {
            Logger$.MODULE$.debug$extension(this.logger(), this::closeSession$$anonfun$7, () -> this.closeSession$$anonfun$8(e));
        }
    }

    public String toString(Session session) {
        return session.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(session));
    }

    private final String safeCloseSession$$anonfun$1() {
        return "Failed to release JPA EntityManager";
    }

    private final Throwable safeCloseSession$$anonfun$2(Throwable ex$1) {
        return ex$1;
    }

    private final String closeSession$$anonfun$1() {
        return "Could not close Hibernate Session";
    }

    private final Throwable closeSession$$anonfun$2(HibernateException ex$2) {
        return ex$2;
    }

    private final String closeSession$$anonfun$3() {
        return "Unexpected exception on closing Hibernate Session";
    }

    private final Throwable closeSession$$anonfun$4(Throwable e$1) {
        return e$1;
    }

    private final String closeSession$$anonfun$5() {
        return "Could not close Hibernate Session";
    }

    private final Throwable closeSession$$anonfun$6(HibernateException ex$3) {
        return ex$3;
    }

    private final String closeSession$$anonfun$7() {
        return "Unexpected exception on closing Hibernate Session";
    }

    private final Throwable closeSession$$anonfun$8(Throwable e$2) {
        return e$2;
    }
}

