/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.transfer.excel;

import java.io.InputStream;
import java.text.NumberFormat;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logger;
import org.beangle.commons.logging.Logging;
import org.beangle.data.transfer.excel.ExcelItemReader$;
import org.beangle.data.transfer.io.ItemReader;
import org.beangle.data.transfer.io.ItemReader$class;
import org.beangle.data.transfer.io.TransferFormat$;
import scala.Enumeration;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Range$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005mt!B\u0001\u0003\u0011\u0003i\u0011aD#yG\u0016d\u0017\n^3n%\u0016\fG-\u001a:\u000b\u0005\r!\u0011!B3yG\u0016d'BA\u0003\u0007\u0003!!(/\u00198tM\u0016\u0014(BA\u0004\t\u0003\u0011!\u0017\r^1\u000b\u0005%Q\u0011a\u00022fC:<G.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001A\u0011abD\u0007\u0002\u0005\u0019)\u0001C\u0001E\u0001#\tyQ\t_2fY&#X-\u001c*fC\u0012,'o\u0005\u0002\u0010%A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001aDQ!G\b\u0005\u0002i\ta\u0001P5oSRtD#A\u0007\t\u000fqy!\u0019!C\u0001;\u0005\tB)\u0012$B+2#v\fS#B\t&sE)\u0012-\u0016\u0003y\u0001\"aE\u0010\n\u0005\u0001\"\"aA%oi\"1!e\u0004Q\u0001\ny\t!\u0003R#G\u0003VcEk\u0018%F\u0003\u0012Ke\nR#YA!9Ae\u0004b\u0001\n\u0003)\u0013\u0001\u00048v[\n,'OR8s[\u0006$X#\u0001\u0014\u0011\u0005\u001dbS\"\u0001\u0015\u000b\u0005%R\u0013\u0001\u0002;fqRT\u0011aK\u0001\u0005U\u00064\u0018-\u0003\u0002.Q\taa*^7cKJ4uN]7bi\"1qf\u0004Q\u0001\n\u0019\nQB\\;nE\u0016\u0014hi\u001c:nCR\u0004c\u0001\u0002\t\u0003\u0001E\u001aB\u0001\r\n3qA\u00111GN\u0007\u0002i)\u0011Q\u0007B\u0001\u0003S>L!a\u000e\u001b\u0003\u0015%#X-\u001c*fC\u0012,'\u000f\u0005\u0002:}5\t!H\u0003\u0002<y\u00059An\\4hS:<'BA\u001f\t\u0003\u001d\u0019w.\\7p]NL!a\u0010\u001e\u0003\u000f1{wmZ5oO\"A\u0011\t\rB\u0001B\u0003%!)\u0001\u0002jgB\u00111)R\u0007\u0002\t*\u0011QGK\u0005\u0003\r\u0012\u00131\"\u00138qkR\u001cFO]3b[\")\u0011\u0004\rC\u0001\u0011R\u0011\u0011J\u0013\t\u0003\u001dABQ!Q$A\u0002\tCq\u0001\u0014\u0019C\u0002\u0013\u0005Q$\u0001\u0005tQ\u0016,GOT;n\u0011\u0019q\u0005\u0007)A\u0005=\u0005I1\u000f[3fi:+X\u000e\t\u0005\b!B\u0002\r\u0011\"\u0003\u001e\u00031Ig\u000eZ3y\u0013:\u001c\u0006.Z3u\u0011\u001d\u0011\u0006\u00071A\u0005\nM\u000b\u0001#\u001b8eKbLen\u00155fKR|F%Z9\u0015\u0005Q;\u0006CA\nV\u0013\t1FC\u0001\u0003V]&$\bb\u0002-R\u0003\u0003\u0005\rAH\u0001\u0004q\u0012\n\u0004B\u0002.1A\u0003&a$A\u0007j]\u0012,\u00070\u00138TQ\u0016,G\u000f\t\u0005\n9B\u0002\r\u00111A\u0005\nu\t\u0011\"\u0019;ue\u000e{WO\u001c;\t\u0013y\u0003\u0004\u0019!a\u0001\n\u0013y\u0016!D1uiJ\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0002UA\"9\u0001,XA\u0001\u0002\u0004q\u0002B\u000221A\u0003&a$\u0001\u0006biR\u00148i\\;oi\u0002Bq\u0001\u001a\u0019C\u0002\u0013%Q-\u0001\u0005x_J\\'m\\8l+\u00051\u0007CA4q\u001b\u0005A'BA5k\u0003%)8/\u001a:n_\u0012,GN\u0003\u0002lY\u0006!\u0001n]:g\u0015\tig.A\u0002q_&T!a\u001c\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\t\bN\u0001\u0007I'N3uk\u001c:lE>|7\u000e\u0003\u0004ta\u0001\u0006IAZ\u0001\no>\u00148NY8pW\u0002BQ!\u0007\u0019\u0005\u0002U$2!\u0013<x\u0011\u0015\tE\u000f1\u0001C\u0011\u0015AH\u000f1\u0001\u001f\u0003%AW-\u00193J]\u0012,\u0007\u0010C\u0003{a\u0011\u000530A\bsK\u0006$G)Z:de&\u0004H/[8o)\u0005a\b#B?\u0002\f\u0005Eab\u0001@\u0002\b9\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002\u0019\u00051AH]8pizJ\u0011!F\u0005\u0004\u0003\u0013!\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u001b\tyA\u0001\u0003MSN$(bAA\u0005)A!\u00111CA\r\u001d\r\u0019\u0012QC\u0005\u0004\u0003/!\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001c\u0005u!AB*ue&twMC\u0002\u0002\u0018QAa!!\t1\t\u0003Z\u0018!\u0003:fC\u0012$\u0016\u000e\u001e7f\u0011\u001d\t)\u0003\rC\t\u0003O\t\u0001B]3bI2Kg.\u001a\u000b\u0006y\u0006%\u00121\u0007\u0005\t\u0003W\t\u0019\u00031\u0001\u0002.\u0005)1\u000f[3fiB\u0019q-a\f\n\u0007\u0005E\u0002NA\u0005I'N35\u000b[3fi\"9\u0011QGA\u0012\u0001\u0004q\u0012\u0001\u0003:po&sG-\u001a=\t\u000f\u0005e\u0002\u0007\"\u0011\u0002<\u0005!!/Z1e)\t\ti\u0004E\u0002\u0014\u0003\u007fI1!!\u0011\u0015\u0005\r\te.\u001f\u0005\b\u0003\u000b\u0002D\u0011AA$\u000319W\r^\"fY24\u0016\r\\;f)\u0011\tI%!\u0016\u0011\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bR1!a\u0014+\u0003\u0011a\u0017M\\4\n\t\u0005M\u0013Q\n\u0002\u0007\u001f\nTWm\u0019;\t\u0011\u0005]\u00131\ta\u0001\u00033\nAaY3mYB\u0019q-a\u0017\n\u0007\u0005u\u0003N\u0001\u0005I'N35)\u001a7m\u0011\u001d\t\t\u0007\rC!\u0003G\naAZ8s[\u0006$XCAA3!\u0011\t9'!\u001c\u000f\u0007M\nI'C\u0002\u0002lQ\na\u0002\u0016:b]N4WM\u001d$pe6\fG/\u0003\u0003\u0002p\u0005E$!\u0002,bYV,\u0017bAA:)\tYQI\\;nKJ\fG/[8o\u0011\u001d\t9\b\rC!\u0003s\nQa\u00197pg\u0016$\u0012\u0001\u0016")
public class ExcelItemReader
implements ItemReader,
Logging {
    private final int sheetNum;
    private int indexInSheet;
    private int attrCount;
    private final HSSFWorkbook workbook;
    private final Logger logger;
    private int headIndex;
    private int dataIndex;

    public static NumberFormat numberFormat() {
        return ExcelItemReader$.MODULE$.numberFormat();
    }

    public static int DEFAULT_HEADINDEX() {
        return ExcelItemReader$.MODULE$.DEFAULT_HEADINDEX();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public int headIndex() {
        return this.headIndex;
    }

    @Override
    public void headIndex_$eq(int x$1) {
        this.headIndex = x$1;
    }

    @Override
    public int dataIndex() {
        return this.dataIndex;
    }

    @Override
    public void dataIndex_$eq(int x$1) {
        this.dataIndex = x$1;
    }

    public int sheetNum() {
        return this.sheetNum;
    }

    private int indexInSheet() {
        return this.indexInSheet;
    }

    private void indexInSheet_$eq(int x$1) {
        this.indexInSheet = x$1;
    }

    private int attrCount() {
        return this.attrCount;
    }

    private void attrCount_$eq(int x$1) {
        this.attrCount = x$1;
    }

    private HSSFWorkbook workbook() {
        return this.workbook;
    }

    @Override
    public List<String> readDescription() {
        List<String> list;
        if (this.workbook().getNumberOfSheets() < 1) {
            list = List$.MODULE$.empty();
        } else {
            HSSFSheet sheet = this.workbook().getSheetAt(0);
            list = this.readLine(sheet, 0);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> readTitle() {
        List list;
        if (this.workbook().getNumberOfSheets() < 1) {
            list = List$.MODULE$.empty();
        } else {
            void var2_2;
            HSSFSheet sheet = this.workbook().getSheetAt(0);
            List<String> attrs = this.readLine(sheet, this.headIndex());
            this.attrCount_$eq(attrs.length());
            list = var2_2;
        }
        return list;
    }

    public List<String> readLine(HSSFSheet sheet, int rowIndex) {
        HSSFRow row = sheet.getRow(rowIndex);
        ListBuffer attrList = new ListBuffer();
        BooleanRef hasEmptyCell = BooleanRef.create((boolean)false);
        Predef$ predef$ = Predef$.MODULE$;
        short s = row.getLastCellNum();
        Serializable serializable = new Serializable(this, row, attrList, hasEmptyCell){
            public static final long serialVersionUID = 0L;
            public final HSSFRow row$1;
            public final ListBuffer attrList$1;
            public final BooleanRef hasEmptyCell$1;

            public final Object apply(int i) {
                BoxedUnit boxedUnit;
                if (this.hasEmptyCell$1.elem) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    HSSFCell cell = this.row$1.getCell(i);
                    if (cell == null) {
                        this.hasEmptyCell$1.elem = true;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        String attr = cell.getRichStringCellValue().getString();
                        Strings$ strings$ = Strings$.MODULE$;
                        if (attr == null || 0 == attr.length()) {
                            this.hasEmptyCell$1.elem = true;
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = this.attrList$1.$plus$eq((Object)attr.trim());
                        }
                    }
                }
                return boxedUnit;
            }
            {
                this.row$1 = row$1;
                this.attrList$1 = attrList$1;
                this.hasEmptyCell$1 = hasEmptyCell$1;
            }
        };
        Range range = Range$.MODULE$.apply(0, (int)s);
        range.scala$collection$immutable$Range$$validateMaxLength();
        boolean bl = range.start() != Integer.MIN_VALUE || range.end() != Integer.MIN_VALUE;
        int n = range.start();
        int n2 = 0;
        int n3 = range.terminalElement();
        int n4 = range.step();
        while (!bl ? n2 < range.numRangeElements() : n != n3) {
            BoxedUnit boxedUnit;
            int n5 = n;
            if (serializable.hasEmptyCell$1.elem) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                HSSFCell cell1 = serializable.row$1.getCell(n5);
                if (cell1 == null) {
                    serializable.hasEmptyCell$1.elem = true;
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    String attr1 = cell1.getRichStringCellValue().getString();
                    Strings$ strings$ = Strings$.MODULE$;
                    if (attr1 == null || 0 == attr1.length()) {
                        serializable.hasEmptyCell$1.elem = true;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = serializable.attrList$1.$plus$eq((Object)attr1.trim());
                    }
                }
            }
            ++n2;
            n += n4;
        }
        return attrList.toList();
    }

    @Override
    public Object read() {
        HSSFSheet sheet = this.workbook().getSheetAt(this.sheetNum());
        if (this.indexInSheet() > sheet.getLastRowNum()) {
            return null;
        }
        HSSFRow row = sheet.getRow(this.indexInSheet());
        this.indexInSheet_$eq(this.indexInSheet() + 1);
        if (row == null) {
            return new Object[this.attrCount()];
        }
        Object[] values = new Object[this.attrCount() != 0 ? this.attrCount() : (int)row.getLastCellNum()];
        Predef$ predef$ = Predef$.MODULE$;
        int n = values.length;
        Range range = Range$.MODULE$.apply(0, n);
        range.scala$collection$immutable$Range$$validateMaxLength();
        boolean bl = range.start() != Integer.MIN_VALUE || range.end() != Integer.MIN_VALUE;
        int n2 = range.start();
        int n3 = 0;
        int n4 = range.terminalElement();
        int n5 = range.step();
        while (!bl ? n3 < range.numRangeElements() : n2 != n4) {
            var7_3[n2] = this.getCellValue(row.getCell(n2));
            ++n3;
            n2 += n5;
        }
        return values;
    }

    public Object getCellValue(HSSFCell cell) {
        Object object;
        if (cell == null) {
            return null;
        }
        int n = cell.getCellType();
        switch (n) {
            default: {
                object = null;
                break;
            }
            case 4: {
                if (cell.getBooleanCellValue()) {
                    object = Boolean.TRUE;
                    break;
                }
                object = Boolean.FALSE;
                break;
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    object = cell.getDateCellValue();
                    break;
                }
                object = ExcelItemReader$.MODULE$.numberFormat().format(cell.getNumericCellValue());
                break;
            }
            case 1: {
                object = Strings$.MODULE$.trim(cell.getRichStringCellValue().getString());
                break;
            }
            case 3: {
                object = null;
            }
        }
        return object;
    }

    @Override
    public Enumeration.Value format() {
        return TransferFormat$.MODULE$.Xls();
    }

    @Override
    public void close() {
        this.workbook().cloneSheet(this.sheetNum());
    }

    public ExcelItemReader(InputStream is) {
        ItemReader$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.sheetNum = 0;
        this.headIndex_$eq(ExcelItemReader$.MODULE$.DEFAULT_HEADINDEX());
        this.dataIndex_$eq(this.headIndex() + 1);
        this.indexInSheet = this.dataIndex();
        this.workbook = new HSSFWorkbook(is);
    }

    public ExcelItemReader(InputStream is, int headIndex) {
        this(is);
        this.headIndex_$eq(headIndex);
        this.dataIndex_$eq(headIndex + 1);
        this.indexInSheet_$eq(this.dataIndex());
    }
}

