/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.transfer.excel;

import java.io.InputStream;
import java.io.Serializable;
import java.text.NumberFormat;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logger;
import org.beangle.commons.logging.Logging;
import org.beangle.data.transfer.excel.ExcelItemReader$;
import org.beangle.data.transfer.io.ItemReader;
import org.beangle.data.transfer.io.TransferFormat$;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ut!B\u0001\u0003\u0011\u0003i\u0011aD#yG\u0016d\u0017\n^3n%\u0016\fG-\u001a:\u000b\u0005\r!\u0011!B3yG\u0016d'BA\u0003\u0007\u0003!!(/\u00198tM\u0016\u0014(BA\u0004\t\u0003\u0011!\u0017\r^1\u000b\u0005%Q\u0011a\u00022fC:<G.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001A\u0011abD\u0007\u0002\u0005\u0019)\u0001C\u0001E\u0001#\tyQ\t_2fY&#X-\u001c*fC\u0012,'o\u0005\u0002\u0010%A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001aDQ!G\b\u0005\u0002i\ta\u0001P5oSRtD#A\u0007\t\u000fqy!\u0019!C\u0001;\u0005\tB)\u0012$B+2#v\fS#B\t&sE)\u0012-\u0016\u0003y\u0001\"aE\u0010\n\u0005\u0001\"\"aA%oi\"1!e\u0004Q\u0001\ny\t!\u0003R#G\u0003VcEk\u0018%F\u0003\u0012Ke\nR#YA!9Ae\u0004b\u0001\n\u0003)\u0013\u0001\u00048v[\n,'OR8s[\u0006$X#\u0001\u0014\u0011\u0005\u001dbS\"\u0001\u0015\u000b\u0005%R\u0013\u0001\u0002;fqRT\u0011aK\u0001\u0005U\u00064\u0018-\u0003\u0002.Q\taa*^7cKJ4uN]7bi\"1qf\u0004Q\u0001\n\u0019\nQB\\;nE\u0016\u0014hi\u001c:nCR\u0004c\u0001\u0002\t\u0003\u0001E\u001aB\u0001\r\n3qA\u00111GN\u0007\u0002i)\u0011Q\u0007B\u0001\u0003S>L!a\u000e\u001b\u0003\u0015%#X-\u001c*fC\u0012,'\u000f\u0005\u0002:}5\t!H\u0003\u0002<y\u00059An\\4hS:<'BA\u001f\t\u0003\u001d\u0019w.\\7p]NL!a\u0010\u001e\u0003\u000f1{wmZ5oO\"A\u0011\t\rB\u0001B\u0003%!)\u0001\u0002jgB\u00111)R\u0007\u0002\t*\u0011QGK\u0005\u0003\r\u0012\u00131\"\u00138qkR\u001cFO]3b[\")\u0011\u0004\rC\u0001\u0011R\u0011\u0011J\u0013\t\u0003\u001dABQ!Q$A\u0002\tCq\u0001\u0014\u0019C\u0002\u0013\u0005Q$\u0001\u0005tQ\u0016,GOT;n\u0011\u0019q\u0005\u0007)A\u0005=\u0005I1\u000f[3fi:+X\u000e\t\u0005\b!B\u0002\r\u0011\"\u0003\u001e\u00031Ig\u000eZ3y\u0013:\u001c\u0006.Z3u\u0011\u001d\u0011\u0006\u00071A\u0005\nM\u000b\u0001#\u001b8eKbLen\u00155fKR|F%Z9\u0015\u0005Q;\u0006CA\nV\u0013\t1FC\u0001\u0003V]&$\bb\u0002-R\u0003\u0003\u0005\rAH\u0001\u0004q\u0012\n\u0004B\u0002.1A\u0003&a$A\u0007j]\u0012,\u00070\u00138TQ\u0016,G\u000f\t\u0005\n9B\u0002\r\u00111A\u0005\nu\t\u0011\"\u0019;ue\u000e{WO\u001c;\t\u0013y\u0003\u0004\u0019!a\u0001\n\u0013y\u0016!D1uiJ\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0002UA\"9\u0001,XA\u0001\u0002\u0004q\u0002B\u000221A\u0003&a$\u0001\u0006biR\u00148i\\;oi\u0002Bq\u0001\u001a\u0019C\u0002\u0013%Q-\u0001\u0005x_J\\'m\\8l+\u00051\u0007CA4q\u001b\u0005A'BA5k\u0003%)8/\u001a:n_\u0012,GN\u0003\u0002lY\u0006!\u0001n]:g\u0015\tig.A\u0002q_&T!a\u001c\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\t\bN\u0001\u0007I'N3uk\u001c:lE>|7\u000e\u0003\u0004ta\u0001\u0006IAZ\u0001\no>\u00148NY8pW\u0002BQ!\u0007\u0019\u0005\u0002U$2!\u0013<x\u0011\u0015\tE\u000f1\u0001C\u0011\u0015AH\u000f1\u0001\u001f\u0003%AW-\u00193J]\u0012,\u0007\u0010C\u0003{a\u0011\u000530A\bsK\u0006$G)Z:de&\u0004H/[8o)\u0005a\b#B?\u0002\f\u0005Eab\u0001@\u0002\b9\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002\u0019\u00051AH]8pizJ\u0011!F\u0005\u0004\u0003\u0013!\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u001b\tyA\u0001\u0003MSN$(bAA\u0005)A!\u00111CA\u000e\u001d\u0011\t)\"a\u0006\u0011\u0005}$\u0012bAA\r)\u00051\u0001K]3eK\u001aLA!!\b\u0002 \t11\u000b\u001e:j]\u001eT1!!\u0007\u0015\u0011\u0019\t\u0019\u0003\rC!w\u0006I!/Z1e)&$H.\u001a\u0005\b\u0003O\u0001D\u0011CA\u0015\u0003!\u0011X-\u00193MS:,G#\u0002?\u0002,\u0005U\u0002\u0002CA\u0017\u0003K\u0001\r!a\f\u0002\u000bMDW-\u001a;\u0011\u0007\u001d\f\t$C\u0002\u00024!\u0014\u0011\u0002S*T\rNCW-\u001a;\t\u000f\u0005]\u0012Q\u0005a\u0001=\u0005A!o\\<J]\u0012,\u0007\u0010C\u0004\u0002<A\"\t%!\u0010\u0002\tI,\u0017\r\u001a\u000b\u0003\u0003\u007f\u00012aEA!\u0013\r\t\u0019\u0005\u0006\u0002\u0004\u0003:L\bbBA$a\u0011\u0005\u0011\u0011J\u0001\rO\u0016$8)\u001a7m-\u0006dW/\u001a\u000b\u0005\u0003\u0017\n9\u0006\u0005\u0003\u0002N\u0005MSBAA(\u0015\r\t\tFK\u0001\u0005Y\u0006tw-\u0003\u0003\u0002V\u0005=#AB(cU\u0016\u001cG\u000f\u0003\u0005\u0002Z\u0005\u0015\u0003\u0019AA.\u0003\u0011\u0019W\r\u001c7\u0011\u0007\u001d\fi&C\u0002\u0002`!\u0014\u0001\u0002S*T\r\u000e+G\u000e\u001c\u0005\b\u0003G\u0002D\u0011IA3\u0003\u00191wN]7biV\u0011\u0011q\r\t\u0005\u0003S\nyGD\u00024\u0003WJ1!!\u001c5\u00039!&/\u00198tM\u0016\u0014hi\u001c:nCRLA!!\u001d\u0002t\t)a+\u00197vK&\u0019\u0011Q\u000f\u000b\u0003\u0017\u0015sW/\\3sCRLwN\u001c\u0005\b\u0003s\u0002D\u0011IA>\u0003\u0015\u0019Gn\\:f)\u0005!\u0006")
public class ExcelItemReader
implements ItemReader,
Logging {
    private final int sheetNum;
    private int indexInSheet;
    private int attrCount;
    private final HSSFWorkbook workbook;
    private final Logger logger;
    private int headIndex;
    private int dataIndex;

    public static NumberFormat numberFormat() {
        return ExcelItemReader$.MODULE$.numberFormat();
    }

    public static int DEFAULT_HEADINDEX() {
        return ExcelItemReader$.MODULE$.DEFAULT_HEADINDEX();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public int headIndex() {
        return this.headIndex;
    }

    @Override
    public void headIndex_$eq(int x$1) {
        this.headIndex = x$1;
    }

    @Override
    public int dataIndex() {
        return this.dataIndex;
    }

    @Override
    public void dataIndex_$eq(int x$1) {
        this.dataIndex = x$1;
    }

    public int sheetNum() {
        return this.sheetNum;
    }

    private int indexInSheet() {
        return this.indexInSheet;
    }

    private void indexInSheet_$eq(int x$1) {
        this.indexInSheet = x$1;
    }

    private int attrCount() {
        return this.attrCount;
    }

    private void attrCount_$eq(int x$1) {
        this.attrCount = x$1;
    }

    private HSSFWorkbook workbook() {
        return this.workbook;
    }

    @Override
    public List<String> readDescription() {
        List<String> list;
        if (this.workbook().getNumberOfSheets() < 1) {
            list = List$.MODULE$.empty();
        } else {
            HSSFSheet sheet = this.workbook().getSheetAt(0);
            list = this.readLine(sheet, 0);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> readTitle() {
        List list;
        if (this.workbook().getNumberOfSheets() < 1) {
            list = List$.MODULE$.empty();
        } else {
            void var2_2;
            HSSFSheet sheet = this.workbook().getSheetAt(0);
            List<String> attrs = this.readLine(sheet, this.headIndex());
            this.attrCount_$eq(attrs.length());
            list = var2_2;
        }
        return list;
    }

    public List<String> readLine(HSSFSheet sheet, int rowIndex) {
        HSSFRow row = sheet.getRow(rowIndex);
        ListBuffer attrList = new ListBuffer();
        BooleanRef hasEmptyCell = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)row.getLastCellNum()).foreach((Function1 & Serializable & scala.Serializable)i -> ExcelItemReader.org$beangle$data$transfer$excel$ExcelItemReader$$$anonfun$1(row, attrList, hasEmptyCell, BoxesRunTime.unboxToInt((Object)i)));
        return attrList.toList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object read() {
        void var3_3;
        HSSFSheet sheet = this.workbook().getSheetAt(this.sheetNum());
        if (this.indexInSheet() > sheet.getLastRowNum()) {
            return null;
        }
        HSSFRow row = sheet.getRow(this.indexInSheet());
        this.indexInSheet_$eq(this.indexInSheet() + 1);
        if (row == null) {
            return new Object[this.attrCount()];
        }
        Object[] values = new Object[this.attrCount() != 0 ? this.attrCount() : (int)row.getLastCellNum()];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), values.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> {
            values$1[k] = this.getCellValue(row.getCell(k));
        });
        return var3_3;
    }

    public Object getCellValue(HSSFCell cell) {
        Object object;
        if (cell == null) {
            return null;
        }
        int n = cell.getCellType();
        switch (n) {
            case 3: {
                object = null;
                break;
            }
            case 1: {
                object = Strings$.MODULE$.trim(cell.getRichStringCellValue().getString());
                break;
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    object = cell.getDateCellValue();
                    break;
                }
                object = ExcelItemReader$.MODULE$.numberFormat().format(cell.getNumericCellValue());
                break;
            }
            case 4: {
                if (cell.getBooleanCellValue()) {
                    object = Boolean.TRUE;
                    break;
                }
                object = Boolean.FALSE;
                break;
            }
            default: {
                object = null;
                break;
            }
        }
        return object;
    }

    @Override
    public Enumeration.Value format() {
        return TransferFormat$.MODULE$.Xls();
    }

    @Override
    public void close() {
        this.workbook().cloneSheet(this.sheetNum());
    }

    public static final /* synthetic */ Object org$beangle$data$transfer$excel$ExcelItemReader$$$anonfun$1(HSSFRow row$1, ListBuffer attrList$1, BooleanRef hasEmptyCell$1, int i) {
        BoxedUnit boxedUnit;
        if (!hasEmptyCell$1.elem) {
            HSSFCell cell = row$1.getCell(i);
            if (cell != null) {
                String attr = cell.getRichStringCellValue().getString();
                if (Strings$.MODULE$.isEmpty((CharSequence)attr)) {
                    hasEmptyCell$1.elem = true;
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = attrList$1.$plus$eq((Object)attr.trim());
                }
            } else {
                hasEmptyCell$1.elem = true;
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public ExcelItemReader(InputStream is) {
        super.$init$();
        this.sheetNum = 0;
        this.headIndex_$eq(ExcelItemReader$.MODULE$.DEFAULT_HEADINDEX());
        this.dataIndex_$eq(this.headIndex() + 1);
        this.indexInSheet = this.dataIndex();
        this.workbook = new HSSFWorkbook(is);
    }

    public ExcelItemReader(InputStream is, int headIndex) {
        this(is);
        this.headIndex_$eq(headIndex);
        this.dataIndex_$eq(headIndex + 1);
        this.indexInSheet_$eq(this.dataIndex());
    }
}

