/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.transfer.excel;

import java.io.InputStream;
import java.io.Serializable;
import java.text.NumberFormat;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.transfer.Format$;
import org.beangle.data.transfer.excel.ExcelItemReader$;
import org.beangle.data.transfer.io.ItemReader;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005}t!B\u0001\u0003\u0011\u0003i\u0011aD#yG\u0016d\u0017\n^3n%\u0016\fG-\u001a:\u000b\u0005\r!\u0011!B3yG\u0016d'BA\u0003\u0007\u0003!!(/\u00198tM\u0016\u0014(BA\u0004\t\u0003\u0011!\u0017\r^1\u000b\u0005%Q\u0011a\u00022fC:<G.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001A\u0011abD\u0007\u0002\u0005\u0019)\u0001C\u0001E\u0001#\tyQ\t_2fY&#X-\u001c*fC\u0012,'o\u0005\u0002\u0010%A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001aDQ!G\b\u0005\u0002i\ta\u0001P5oSRtD#A\u0007\t\u000fqy!\u0019!C\u0001;\u0005\tB)\u0012$B+2#v\fS#B\t&sE)\u0012-\u0016\u0003y\u0001\"aE\u0010\n\u0005\u0001\"\"aA%oi\"1!e\u0004Q\u0001\ny\t!\u0003R#G\u0003VcEk\u0018%F\u0003\u0012Ke\nR#YA!9Ae\u0004b\u0001\n\u0003)\u0013\u0001\u00048v[\n,'OR8s[\u0006$X#\u0001\u0014\u0011\u0005\u001dbS\"\u0001\u0015\u000b\u0005%R\u0013\u0001\u0002;fqRT\u0011aK\u0001\u0005U\u00064\u0018-\u0003\u0002.Q\taa*^7cKJ4uN]7bi\"1qf\u0004Q\u0001\n\u0019\nQB\\;nE\u0016\u0014hi\u001c:nCR\u0004c\u0001\u0002\t\u0003\u0001E\u001aB\u0001\r\n3qA\u00111GN\u0007\u0002i)\u0011Q\u0007B\u0001\u0003S>L!a\u000e\u001b\u0003\u0015%#X-\u001c*fC\u0012,'\u000f\u0005\u0002:}5\t!H\u0003\u0002<y\u00059An\\4hS:<'BA\u001f\t\u0003\u001d\u0019w.\\7p]NL!a\u0010\u001e\u0003\u000f1{wmZ5oO\"A\u0011\t\rB\u0001B\u0003%!)\u0001\u0002jgB\u00111)R\u0007\u0002\t*\u0011QGK\u0005\u0003\r\u0012\u00131\"\u00138qkR\u001cFO]3b[\")\u0011\u0004\rC\u0001\u0011R\u0011\u0011J\u0013\t\u0003\u001dABQ!Q$A\u0002\tCq\u0001\u0014\u0019C\u0002\u0013\u0005Q$\u0001\u0005tQ\u0016,GOT;n\u0011\u0019q\u0005\u0007)A\u0005=\u0005I1\u000f[3fi:+X\u000e\t\u0005\b!B\u0002\r\u0011\"\u0003\u001e\u00031Ig\u000eZ3y\u0013:\u001c\u0006.Z3u\u0011\u001d\u0011\u0006\u00071A\u0005\nM\u000b\u0001#\u001b8eKbLen\u00155fKR|F%Z9\u0015\u0005Q;\u0006CA\nV\u0013\t1FC\u0001\u0003V]&$\bb\u0002-R\u0003\u0003\u0005\rAH\u0001\u0004q\u0012\n\u0004B\u0002.1A\u0003&a$A\u0007j]\u0012,\u00070\u00138TQ\u0016,G\u000f\t\u0005\n9B\u0002\r\u00111A\u0005\nu\t\u0011\"\u0019;ue\u000e{WO\u001c;\t\u0013y\u0003\u0004\u0019!a\u0001\n\u0013y\u0016!D1uiJ\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0002UA\"9\u0001,XA\u0001\u0002\u0004q\u0002\"\u000321\u0001\u0004\u0005\t\u0015)\u0003\u001f\u0003)\tG\u000f\u001e:D_VtG\u000f\t\u0005\bIB\u0012\r\u0011\"\u0003f\u0003!9xN]6c_>\\W#\u00014\u0011\u0005\u001d\u0004X\"\u00015\u000b\u0005%T\u0017!C;tKJlw\u000eZ3m\u0015\tYG.\u0001\u0003igN4'BA7o\u0003\r\u0001x.\u001b\u0006\u0003_*\ta!\u00199bG\",\u0017BA9i\u00051A5k\u0015$X_J\\'m\\8l\u0011\u0019\u0019\b\u0007)A\u0005M\u0006Iqo\u001c:lE>|7\u000e\t\u0005\u00063A\"\t!\u001e\u000b\u0004\u0013Z<\b\"B!u\u0001\u0004\u0011\u0005\"\u0002=u\u0001\u0004q\u0012!\u00035fC\u0012Le\u000eZ3y\u0011\u0015Q\b\u0007\"\u0011|\u0003=\u0011X-\u00193EKN\u001c'/\u001b9uS>tG#\u0001?\u0011\u000bu\fY!!\u0005\u000f\u0007y\f9AD\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\rA\"\u0001\u0004=e>|GOP\u0005\u0002+%\u0019\u0011\u0011\u0002\u000b\u0002\u000fA\f7m[1hK&!\u0011QBA\b\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005%A\u0003\u0005\u0003\u0002\u0014\u0005ma\u0002BA\u000b\u0003/\u0001\"a \u000b\n\u0007\u0005eA#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003;\tyB\u0001\u0004TiJLgn\u001a\u0006\u0004\u00033!\u0002BBA\u0012a\u0011\u000530A\u0005sK\u0006$G+\u001b;mK\"9\u0011q\u0005\u0019\u0005\u0012\u0005%\u0012\u0001\u0003:fC\u0012d\u0015N\\3\u0015\u000bq\fY#!\u000e\t\u0011\u00055\u0012Q\u0005a\u0001\u0003_\tQa\u001d5fKR\u00042aZA\u0019\u0013\r\t\u0019\u0004\u001b\u0002\n\u0011N\u001bfi\u00155fKRDq!a\u000e\u0002&\u0001\u0007a$\u0001\u0005s_^Le\u000eZ3y\u0011\u001d\tY\u0004\rC!\u0003{\tAA]3bIR\u0011\u0011q\b\t\u0004'\u0005\u0005\u0013bAA\")\t\u0019\u0011I\\=\t\u000f\u0005\u001d\u0003\u0007\"\u0001\u0002J\u0005aq-\u001a;DK2dg+\u00197vKR!\u00111JA,!\u0011\ti%a\u0015\u000e\u0005\u0005=#bAA)U\u0005!A.\u00198h\u0013\u0011\t)&a\u0014\u0003\r=\u0013'.Z2u\u0011!\tI&!\u0012A\u0002\u0005m\u0013\u0001B2fY2\u00042aZA/\u0013\r\ty\u0006\u001b\u0002\t\u0011N\u001bfiQ3mY\"9\u00111\r\u0019\u0005B\u0005\u0015\u0014A\u00024pe6\fG/\u0006\u0002\u0002hA!\u0011\u0011NA9\u001d\u0011\tY'!\u001c\u000e\u0003\u0011I1!a\u001c\u0005\u0003\u00191uN]7bi&!\u00111OA;\u0005\u00151\u0016\r\\;f\u0013\r\t9\b\u0006\u0002\f\u000b:,X.\u001a:bi&|g\u000eC\u0004\u0002|A\"\t%! \u0002\u000b\rdwn]3\u0015\u0003Q\u0003")
public class ExcelItemReader
implements ItemReader,
Logging {
    private final int sheetNum;
    private int indexInSheet;
    private int attrCount;
    private final HSSFWorkbook workbook;
    private final Logger logger;
    private int headIndex;
    private int dataIndex;

    public static NumberFormat numberFormat() {
        return ExcelItemReader$.MODULE$.numberFormat();
    }

    public static int DEFAULT_HEADINDEX() {
        return ExcelItemReader$.MODULE$.DEFAULT_HEADINDEX();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public int headIndex() {
        return this.headIndex;
    }

    @Override
    public void headIndex_$eq(int x$1) {
        this.headIndex = x$1;
    }

    @Override
    public int dataIndex() {
        return this.dataIndex;
    }

    @Override
    public void dataIndex_$eq(int x$1) {
        this.dataIndex = x$1;
    }

    public int sheetNum() {
        return this.sheetNum;
    }

    private int indexInSheet() {
        return this.indexInSheet;
    }

    private void indexInSheet_$eq(int x$1) {
        this.indexInSheet = x$1;
    }

    private int attrCount() {
        return this.attrCount;
    }

    private void attrCount_$eq(int x$1) {
        this.attrCount = x$1;
    }

    private HSSFWorkbook workbook() {
        return this.workbook;
    }

    @Override
    public List<String> readDescription() {
        List<String> list;
        if (this.workbook().getNumberOfSheets() < 1) {
            list = List$.MODULE$.empty();
        } else {
            HSSFSheet sheet = this.workbook().getSheetAt(0);
            list = this.readLine(sheet, 0);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> readTitle() {
        List list;
        if (this.workbook().getNumberOfSheets() < 1) {
            list = List$.MODULE$.empty();
        } else {
            void var2_2;
            HSSFSheet sheet = this.workbook().getSheetAt(0);
            List<String> attrs = this.readLine(sheet, this.headIndex());
            this.attrCount_$eq(attrs.length());
            list = var2_2;
        }
        return list;
    }

    public List<String> readLine(HSSFSheet sheet, int rowIndex) {
        HSSFRow row = sheet.getRow(rowIndex);
        ListBuffer attrList = new ListBuffer();
        BooleanRef hasEmptyCell = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)row.getLastCellNum()).foreach((Function1 & Serializable & scala.Serializable)i -> ExcelItemReader.$anonfun$readLine$1(row, attrList, hasEmptyCell, BoxesRunTime.unboxToInt((Object)i)));
        return attrList.toList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object read() {
        void var3_3;
        HSSFSheet sheet = this.workbook().getSheetAt(this.sheetNum());
        if (this.indexInSheet() > sheet.getLastRowNum()) {
            return null;
        }
        HSSFRow row = sheet.getRow(this.indexInSheet());
        this.indexInSheet_$eq(this.indexInSheet() + 1);
        if (row == null) {
            return new Object[this.attrCount()];
        }
        Object[] values = new Object[this.attrCount() != 0 ? this.attrCount() : (int)row.getLastCellNum()];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), values.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> {
            values$1[k] = this.getCellValue(row.getCell(k));
        });
        return var3_3;
    }

    public Object getCellValue(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        CellType cellType = cell.getCellTypeEnum();
        Object object = CellType.BLANK.equals(cellType) ? null : (CellType.STRING.equals(cellType) ? Strings$.MODULE$.trim(cell.getRichStringCellValue().getString()) : (CellType.NUMERIC.equals(cellType) ? (DateUtil.isCellDateFormatted((Cell)cell) ? cell.getDateCellValue() : ExcelItemReader$.MODULE$.numberFormat().format(cell.getNumericCellValue())) : (CellType.BOOLEAN.equals(cellType) ? (cell.getBooleanCellValue() ? Boolean.TRUE : Boolean.FALSE) : null)));
        return object;
    }

    @Override
    public Enumeration.Value format() {
        return Format$.MODULE$.Xls();
    }

    @Override
    public void close() {
        this.workbook().cloneSheet(this.sheetNum());
    }

    public static final /* synthetic */ Object $anonfun$readLine$1(HSSFRow row$1, ListBuffer attrList$1, BooleanRef hasEmptyCell$1, int i) {
        BoxedUnit boxedUnit;
        if (!hasEmptyCell$1.elem) {
            HSSFCell cell = row$1.getCell(i);
            if (cell != null) {
                String attr = cell.getRichStringCellValue().getString();
                if (Strings$.MODULE$.isEmpty((CharSequence)attr)) {
                    hasEmptyCell$1.elem = true;
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = attrList$1.$plus$eq((Object)attr.trim());
                }
            } else {
                hasEmptyCell$1.elem = true;
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public ExcelItemReader(InputStream is) {
        ItemReader.$init$(this);
        Logging.$init$((Logging)this);
        this.sheetNum = 0;
        this.headIndex_$eq(ExcelItemReader$.MODULE$.DEFAULT_HEADINDEX());
        this.dataIndex_$eq(this.headIndex() + 1);
        this.indexInSheet = this.dataIndex();
        this.workbook = new HSSFWorkbook(is);
    }

    public ExcelItemReader(InputStream is, int headIndex) {
        this(is);
        this.headIndex_$eq(headIndex);
        this.dataIndex_$eq(headIndex + 1);
        this.indexInSheet_$eq(this.dataIndex());
    }
}

