/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.transfer.excel;

import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Calendar;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.beangle.commons.lang.Numbers$;
import org.beangle.data.transfer.Format$;
import org.beangle.data.transfer.exporter.Context;
import org.beangle.data.transfer.io.ItemWriter;
import org.beangle.data.transfer.io.Writer;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u0001\u0003\u00015\u0011q\"\u0012=dK2LE/Z7Xe&$XM\u001d\u0006\u0003\u0007\u0011\tQ!\u001a=dK2T!!\u0002\u0004\u0002\u0011Q\u0014\u0018M\\:gKJT!a\u0002\u0005\u0002\t\u0011\fG/\u0019\u0006\u0003\u0013)\tqAY3b]\u001edWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UAR\"\u0001\f\u000b\u0005]!\u0011AA5p\u0013\tIbC\u0001\u0006Ji\u0016lwK]5uKJD\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0001H\u0001\bG>tG/\u001a=u+\u0005i\u0002C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u0005\u0003!)\u0007\u0010]8si\u0016\u0014\u0018B\u0001\u0012 \u0005\u001d\u0019uN\u001c;fqRD\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!H\u0001\tG>tG/\u001a=uA!)a\u0005\u0001C\u0001O\u00051A(\u001b8jiz\"\"\u0001\u000b\u0016\u0011\u0005%\u0002Q\"\u0001\u0002\t\u000bm)\u0003\u0019A\u000f\t\u000f1\u0002\u0001\u0019!C\u0001[\u0005i1m\\;oiB+'o\u00155fKR,\u0012A\f\t\u0003\u001f=J!\u0001\r\t\u0003\u0007%sG\u000fC\u00043\u0001\u0001\u0007I\u0011A\u001a\u0002#\r|WO\u001c;QKJ\u001c\u0006.Z3u?\u0012*\u0017\u000f\u0006\u00025oA\u0011q\"N\u0005\u0003mA\u0011A!\u00168ji\"9\u0001(MA\u0001\u0002\u0004q\u0013a\u0001=%c!1!\b\u0001Q!\n9\nabY8v]R\u0004VM]*iK\u0016$\b\u0005C\u0004=\u0001\u0001\u0007I\u0011A\u001f\u0002\u0011]|'o\u001b2p_.,\u0012A\u0010\t\u0003\u007f!k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000b\u0011\"^:fe6|G-\u001a7\u000b\u0005\r#\u0015\u0001\u00025tg\u001aT!!\u0012$\u0002\u0007A|\u0017N\u0003\u0002H\u0015\u00051\u0011\r]1dQ\u0016L!!\u0013!\u0003\u0019!\u001b6KR,pe.\u0014wn\\6\t\u000f-\u0003\u0001\u0019!C\u0001\u0019\u0006aqo\u001c:lE>|7n\u0018\u0013fcR\u0011A'\u0014\u0005\bq)\u000b\t\u00111\u0001?\u0011\u0019y\u0005\u0001)Q\u0005}\u0005Iqo\u001c:lE>|7\u000e\t\u0005\b#\u0002\u0001\r\u0011\"\u0001.\u0003\u0015Ig\u000eZ3y\u0011\u001d\u0019\u0006\u00011A\u0005\u0002Q\u000b\u0011\"\u001b8eKb|F%Z9\u0015\u0005Q*\u0006b\u0002\u001dS\u0003\u0003\u0005\rA\f\u0005\u0007/\u0002\u0001\u000b\u0015\u0002\u0018\u0002\r%tG-\u001a=!\u0011%I\u0006\u00011AA\u0002\u0013\u0005!,A\u0003tQ\u0016,G/F\u0001\\!\tyD,\u0003\u0002^\u0001\nI\u0001jU*G'\",W\r\u001e\u0005\n?\u0002\u0001\r\u00111A\u0005\u0002\u0001\f\u0011b\u001d5fKR|F%Z9\u0015\u0005Q\n\u0007b\u0002\u001d_\u0003\u0003\u0005\ra\u0017\u0005\nG\u0002\u0001\r\u0011!Q!\nm\u000baa\u001d5fKR\u0004\u0003\"C3\u0001\u0001\u0004\u0005\r\u0011\"\u0001g\u0003%!\u0017\r^3TifdW-F\u0001h!\ty\u0004.\u0003\u0002j\u0001\ni\u0001jU*G\u0007\u0016dGn\u0015;zY\u0016D\u0011b\u001b\u0001A\u0002\u0003\u0007I\u0011\u00017\u0002\u001b\u0011\fG/Z*us2,w\fJ3r)\t!T\u000eC\u00049U\u0006\u0005\t\u0019A4\t\u0013=\u0004\u0001\u0019!A!B\u00139\u0017A\u00033bi\u0016\u001cF/\u001f7fA!I\u0011\u000f\u0001a\u0001\u0002\u0004%\tAZ\u0001\ni&lWm\u0015;zY\u0016D\u0011b\u001d\u0001A\u0002\u0003\u0007I\u0011\u0001;\u0002\u001bQLW.Z*us2,w\fJ3r)\t!T\u000fC\u00049e\u0006\u0005\t\u0019A4\t\u0013]\u0004\u0001\u0019!A!B\u00139\u0017A\u0003;j[\u0016\u001cF/\u001f7fA!I\u0011\u0010\u0001a\u0001\u0002\u0004%\tA_\u0001\u0006i&$H.Z\u000b\u0002wB\u0011q\u0002`\u0005\u0003{B\u00111!\u00118z\u0011)y\b\u00011AA\u0002\u0013\u0005\u0011\u0011A\u0001\ni&$H.Z0%KF$2\u0001NA\u0002\u0011\u001dAd0!AA\u0002mD!\"a\u0002\u0001\u0001\u0004\u0005\t\u0015)\u0003|\u0003\u0019!\u0018\u000e\u001e7fA!9\u00111\u0002\u0001\u0005\u0002\u00055\u0011\u0001B5oSR$\u0012\u0001\u000e\u0005\b\u0003#\u0001A\u0011AA\u0007\u0003\u0015\u0019Gn\\:f\u0011\u001d\t)\u0002\u0001C!\u0003/\tQa\u001e:ji\u0016$2\u0001NA\r\u0011\u001d\tY\"a\u0005A\u0002m\f1a\u001c2k\u0011\u001d\ty\u0002\u0001C!\u0003C\t!b\u001e:ji\u0016$\u0016\u000e\u001e7f)\u0015!\u00141EA\u001f\u0011!\t)#!\bA\u0002\u0005\u001d\u0012!\u0003;ji2,g*Y7f!\u0011\tI#a\u000e\u000f\t\u0005-\u00121\u0007\t\u0004\u0003[\u0001RBAA\u0018\u0015\r\t\t\u0004D\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005U\u0002#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003s\tYD\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003k\u0001\u0002BB\u0004\u0002\u001e\u0001\u00071\u0010C\u0004\u0002B\u0001!\t!a\u0011\u0002\r\u0019|'/\\1u+\t\t)\u0005\u0005\u0003\u0002H\u0005=c\u0002BA%\u0003\u0017j\u0011\u0001B\u0005\u0004\u0003\u001b\"\u0011A\u0002$pe6\fG/\u0003\u0003\u0002R\u0005M#!\u0002,bYV,\u0017bAA+!\tYQI\\;nKJ\fG/[8o\u0011\u001d\tI\u0006\u0001C\t\u00037\n\u0011b\u001e:ji\u0016LE/Z7\u0015\u0007Q\ni\u0006C\u0004\u0002`\u0005]\u0003\u0019A>\u0002\u000b\u0011\fG/Y:\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f\u0005aq-\u001a;ECR,7\u000b^=mKR\tq\rC\u0004\u0002j\u0001!I!!\u001a\u0002\u0019\u001d,G\u000fV5nKN#\u0018\u0010\\3\t\u000f\u00055\u0004\u0001\"\u0005\u0002p\u0005iq-\u001a;ECR,gi\u001c:nCR$\"!a\n\t\u000f\u0005M\u0004\u0001\"\u0005\u0002p\u0005\tr-\u001a;ECR,G+[7f\r>\u0014X.\u0019;\t\u000f\u0005]\u0004\u0001\"\u0005\u0002f\u0005y!-^5mIRKG\u000f\\3TifdW\r")
public class ExcelItemWriter
implements ItemWriter {
    private final Context context;
    private int countPerSheet;
    private HSSFWorkbook workbook;
    private int index;
    private HSSFSheet sheet;
    private HSSFCellStyle dateStyle;
    private HSSFCellStyle timeStyle;
    private Object title;
    private OutputStream outputStream;

    @Override
    public OutputStream outputStream() {
        return this.outputStream;
    }

    @Override
    public void outputStream_$eq(OutputStream x$1) {
        this.outputStream = x$1;
    }

    public Context context() {
        return this.context;
    }

    public int countPerSheet() {
        return this.countPerSheet;
    }

    public void countPerSheet_$eq(int x$1) {
        this.countPerSheet = x$1;
    }

    public HSSFWorkbook workbook() {
        return this.workbook;
    }

    public void workbook_$eq(HSSFWorkbook x$1) {
        this.workbook = x$1;
    }

    public int index() {
        return this.index;
    }

    public void index_$eq(int x$1) {
        this.index = x$1;
    }

    public HSSFSheet sheet() {
        return this.sheet;
    }

    public void sheet_$eq(HSSFSheet x$1) {
        this.sheet = x$1;
    }

    public HSSFCellStyle dateStyle() {
        return this.dateStyle;
    }

    public void dateStyle_$eq(HSSFCellStyle x$1) {
        this.dateStyle = x$1;
    }

    public HSSFCellStyle timeStyle() {
        return this.timeStyle;
    }

    public void timeStyle_$eq(HSSFCellStyle x$1) {
        this.timeStyle = x$1;
    }

    public Object title() {
        return this.title;
    }

    public void title_$eq(Object x$1) {
        this.title = x$1;
    }

    public void init() {
        block0: {
            int countParam;
            Object count;
            if (this.context() == null || (count = this.context().datas().get((Object)"countPerSheet").getOrElse((Function0 & Serializable & scala.Serializable)() -> "")) == null || !Numbers$.MODULE$.isDigits(count.toString()) || (countParam = Numbers$.MODULE$.toInt(count.toString(), Numbers$.MODULE$.toInt$default$2())) <= 0) break block0;
            this.countPerSheet_$eq(countParam);
        }
    }

    @Override
    public void close() {
        this.workbook().write(this.outputStream());
    }

    @Override
    public void write(Object obj) {
        if (this.index() + 1 >= this.countPerSheet()) {
            this.writeTitle(null, this.title());
        }
        this.writeItem(obj);
        this.index_$eq(this.index() + 1);
    }

    @Override
    public void writeTitle(String titleName, Object data) {
        if (titleName != null) {
            this.sheet_$eq(this.workbook().createSheet(titleName));
        } else {
            this.sheet_$eq(this.workbook().createSheet());
        }
        this.title_$eq(data);
        this.index_$eq(0);
        this.writeItem(data);
        ObjectRef titleRow = ObjectRef.create((Object)this.sheet().getRow(this.index()));
        ObjectRef titleStyle = ObjectRef.create((Object)this.buildTitleStyle());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)((HSSFRow)titleRow.elem).getLastCellNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> ((HSSFRow)titleRow$1.elem).getCell(i).setCellStyle((HSSFCellStyle)titleStyle$1.elem));
        this.index_$eq(this.index() + 1);
    }

    @Override
    public Enumeration.Value format() {
        return Format$.MODULE$.Xls();
    }

    public void writeItem(Object datas) {
        block4: {
            ObjectRef row = ObjectRef.create((Object)this.sheet().createRow(this.index()));
            if (datas == null) break block4;
            if (datas.getClass().isArray()) {
                Object values = datas;
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), ScalaRunTime$.MODULE$.array_length(values)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    Object object;
                    HSSFCell cell = ((HSSFRow)row$1.elem).createCell(i);
                    Object v = ScalaRunTime$.MODULE$.array_apply(values, i);
                    if (v != null && v instanceof Option) {
                        v = ((Option)v).getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
                    }
                    if ((object = v) instanceof Number) {
                        Number number = (Number)object;
                        cell.setCellType(CellType.NUMERIC);
                        cell.setCellValue(number.doubleValue());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (object instanceof Date) {
                        Date date = (Date)object;
                        cell.setCellValue((java.util.Date)date);
                        cell.setCellStyle(this.getDateStyle());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (object instanceof java.util.Date) {
                        java.util.Date date = (java.util.Date)object;
                        cell.setCellValue(date);
                        cell.setCellStyle(this.getTimeStyle());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (object instanceof LocalDate) {
                        LocalDate localDate = (LocalDate)object;
                        cell.setCellValue((java.util.Date)Date.valueOf(localDate));
                        cell.setCellStyle(this.getDateStyle());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (object instanceof Instant) {
                        Instant instant = (Instant)object;
                        cell.setCellValue(java.util.Date.from(instant));
                        cell.setCellStyle(this.getTimeStyle());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (object instanceof Calendar) {
                        Calendar calendar = (Calendar)object;
                        cell.setCellValue(calendar);
                        cell.setCellStyle(this.getTimeStyle());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        cell.setCellValue((RichTextString)new HSSFRichTextString(v == null ? "" : v.toString()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                });
            } else {
                HSSFCell cell = ((HSSFRow)row.elem).createCell(0);
                Object object = datas;
                if (object instanceof Number) {
                    cell.setCellType(CellType.NUMERIC);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                cell.setCellValue((RichTextString)new HSSFRichTextString(datas.toString()));
            }
        }
    }

    private HSSFCellStyle getDateStyle() {
        block0: {
            if (this.dateStyle() != null) break block0;
            this.dateStyle_$eq(this.workbook().createCellStyle());
            this.dateStyle().setDataFormat(this.workbook().createDataFormat().getFormat(this.getDateFormat()));
        }
        return this.dateStyle();
    }

    private HSSFCellStyle getTimeStyle() {
        block0: {
            if (this.timeStyle() != null) break block0;
            this.timeStyle_$eq(this.workbook().createCellStyle());
            this.timeStyle().setDataFormat(this.workbook().createDataFormat().getFormat(this.getDateTimeFormat()));
        }
        return this.timeStyle();
    }

    public String getDateFormat() {
        return "YYYY-MM-DD";
    }

    public String getDateTimeFormat() {
        return "YYYY-MM-DD HH:MM:SS";
    }

    /*
     * WARNING - void declaration
     */
    public HSSFCellStyle buildTitleStyle() {
        void var1_1;
        HSSFCellStyle style = this.workbook().createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        return var1_1;
    }

    public ExcelItemWriter(Context context) {
        this.context = context;
        Writer.$init$(this);
        this.countPerSheet = 50000;
        this.workbook = new HSSFWorkbook();
        this.index = 0;
        this.init();
    }
}

