/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.transfer.excel;

import java.io.InputStream;
import java.io.Serializable;
import java.text.NumberFormat;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.transfer.Format$;
import org.beangle.data.transfer.excel.ExcelItemReader$;
import org.beangle.data.transfer.io.ItemReader;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005u!B\u000e\u001d\u0011\u00039c!B\u0015\u001d\u0011\u0003Q\u0003\"B\u0019\u0002\t\u0003\u0011\u0004bB\u001a\u0002\u0005\u0004%\t\u0001\u000e\u0005\u0007{\u0005\u0001\u000b\u0011B\u001b\u0007\t%b\u0002A\u0010\u0005\t\u001b\u0016\u0011\t\u0011)A\u0005\u001d\")\u0011'\u0002C\u0001'\"9a+\u0002b\u0001\n\u00039\u0006BB.\u0006A\u0003%\u0001\fC\u0004]\u000b\u0001\u0007I\u0011B,\t\u000fu+\u0001\u0019!C\u0005=\"1A-\u0002Q!\naC\u0011\"Z\u0003A\u0002\u0003\u0007I\u0011B,\t\u0013\u0019,\u0001\u0019!a\u0001\n\u00139\u0007\"C5\u0006\u0001\u0004\u0005\t\u0015)\u0003Y\u0011\u001dQWA1A\u0005\n-Da\u0001_\u0003!\u0002\u0013a\u0007\"B\u0019\u0006\t\u0003I\b\"B?\u0006\t\u0003r\bBBA\u0014\u000b\u0011\u0005c\u0010C\u0004\u0002*\u0015!\t\"a\u000b\t\u000f\u0005mR\u0001\"\u0001\u0002>!9\u00111I\u0003\u0005B\u0005\u0015\u0003bBA'\u000b\u0011\u0005\u0011q\n\u0005\b\u0003O*A\u0011IA5\u0011\u001d\ti(\u0002C!\u0003\u007f\nq\"\u0012=dK2LE/Z7SK\u0006$WM\u001d\u0006\u0003;y\tQ!\u001a=dK2T!a\b\u0011\u0002\u0011Q\u0014\u0018M\\:gKJT!!\t\u0012\u0002\t\u0011\fG/\u0019\u0006\u0003G\u0011\nqAY3b]\u001edWMC\u0001&\u0003\ry'oZ\u0002\u0001!\tA\u0013!D\u0001\u001d\u0005=)\u0005pY3m\u0013R,WNU3bI\u0016\u00148CA\u0001,!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aJ\u0001\r]Vl'-\u001a:G_Jl\u0017\r^\u000b\u0002kA\u0011agO\u0007\u0002o)\u0011\u0001(O\u0001\u0005i\u0016DHOC\u0001;\u0003\u0011Q\u0017M^1\n\u0005q:$\u0001\u0004(v[\n,'OR8s[\u0006$\u0018!\u00048v[\n,'OR8s[\u0006$\be\u0005\u0003\u0006W}*\u0005C\u0001!D\u001b\u0005\t%B\u0001\"\u001f\u0003\tIw.\u0003\u0002E\u0003\nQ\u0011\n^3n%\u0016\fG-\u001a:\u0011\u0005\u0019[U\"A$\u000b\u0005!K\u0015a\u00027pO\u001eLgn\u001a\u0006\u0003\u0015\n\nqaY8n[>t7/\u0003\u0002M\u000f\n9Aj\\4hS:<\u0017AA5t!\ty\u0015+D\u0001Q\u0015\t\u0011\u0015(\u0003\u0002S!\nY\u0011J\u001c9viN#(/Z1n)\t!V\u000b\u0005\u0002)\u000b!)Qj\u0002a\u0001\u001d\u0006A1\u000f[3fi:+X.F\u0001Y!\ta\u0013,\u0003\u0002[[\t\u0019\u0011J\u001c;\u0002\u0013MDW-\u001a;Ok6\u0004\u0013\u0001D5oI\u0016D\u0018J\\*iK\u0016$\u0018\u0001E5oI\u0016D\u0018J\\*iK\u0016$x\fJ3r)\ty&\r\u0005\u0002-A&\u0011\u0011-\f\u0002\u0005+:LG\u000fC\u0004d\u0017\u0005\u0005\t\u0019\u0001-\u0002\u0007a$\u0013'A\u0007j]\u0012,\u00070\u00138TQ\u0016,G\u000fI\u0001\nCR$(oQ8v]R\fQ\"\u0019;ue\u000e{WO\u001c;`I\u0015\fHCA0i\u0011\u001d\u0019g\"!AA\u0002a\u000b!\"\u0019;ue\u000e{WO\u001c;!\u0003!9xN]6c_>\\W#\u00017\u0011\u000554X\"\u00018\u000b\u0005=\u0004\u0018!C;tKJlw\u000eZ3m\u0015\t\t(/\u0001\u0003igN4'BA:u\u0003\r\u0001x.\u001b\u0006\u0003k\u0012\na!\u00199bG\",\u0017BA<o\u00051A5k\u0015$X_J\\'m\\8l\u0003%9xN]6c_>\\\u0007\u0005F\u0002UunDQ!\u0014\nA\u00029CQ\u0001 \nA\u0002a\u000b\u0011\u0002[3bI&sG-\u001a=\u0002\u001fI,\u0017\r\u001a#fg\u000e\u0014\u0018\u000e\u001d;j_:$\u0012a \t\u0007\u0003\u0003\t\t\"a\u0006\u000f\t\u0005\r\u0011Q\u0002\b\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011\u0002\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0013bAA\b[\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\n\u0003+\u0011A\u0001T5ti*\u0019\u0011qB\u0017\u0011\t\u0005e\u0011\u0011\u0005\b\u0005\u00037\ti\u0002E\u0002\u0002\u00065J1!a\b.\u0003\u0019\u0001&/\u001a3fM&!\u00111EA\u0013\u0005\u0019\u0019FO]5oO*\u0019\u0011qD\u0017\u0002\u0013I,\u0017\r\u001a+ji2,\u0017\u0001\u0003:fC\u0012d\u0015N\\3\u0015\u000b}\fi#a\u000e\t\u000f\u0005=R\u00031\u0001\u00022\u0005)1\u000f[3fiB\u0019Q.a\r\n\u0007\u0005UbNA\u0005I'N35\u000b[3fi\"1\u0011\u0011H\u000bA\u0002a\u000b\u0001B]8x\u0013:$W\r_\u0001\re\u0016\fGmQ8n[\u0016tGo\u001d\u000b\u0006\u007f\u0006}\u0012\u0011\t\u0005\b\u0003_1\u0002\u0019AA\u0019\u0011\u0019\tID\u0006a\u00011\u0006!!/Z1e)\t\t9\u0005E\u0002-\u0003\u0013J1!a\u0013.\u0005\r\te._\u0001\rO\u0016$8)\u001a7m-\u0006dW/\u001a\u000b\u0005\u0003#\ni\u0006\u0005\u0003\u0002T\u0005eSBAA+\u0015\r\t9&O\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\\\u0005U#AB(cU\u0016\u001cG\u000fC\u0004\u0002`a\u0001\r!!\u0019\u0002\t\r,G\u000e\u001c\t\u0004[\u0006\r\u0014bAA3]\nA\u0001jU*G\u0007\u0016dG.\u0001\u0004g_Jl\u0017\r^\u000b\u0003\u0003W\u0002B!!\u001c\u0002v9!\u0011qNA9\u001b\u0005q\u0012bAA:=\u00051ai\u001c:nCRLA!a\u001e\u0002z\t)a+\u00197vK&\u0019\u00111P\u0017\u0003\u0017\u0015sW/\\3sCRLwN\\\u0001\u0006G2|7/\u001a\u000b\u0002?\u0002")
public class ExcelItemReader
implements ItemReader,
Logging {
    private final int sheetNum;
    private int indexInSheet;
    private int attrCount;
    private final HSSFWorkbook workbook;
    private final Logger logger;
    private int headIndex;
    private int dataIndex;

    public static NumberFormat numberFormat() {
        return ExcelItemReader$.MODULE$.numberFormat();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public int headIndex() {
        return this.headIndex;
    }

    @Override
    public void headIndex_$eq(int x$1) {
        this.headIndex = x$1;
    }

    @Override
    public int dataIndex() {
        return this.dataIndex;
    }

    @Override
    public void dataIndex_$eq(int x$1) {
        this.dataIndex = x$1;
    }

    public int sheetNum() {
        return this.sheetNum;
    }

    private int indexInSheet() {
        return this.indexInSheet;
    }

    private void indexInSheet_$eq(int x$1) {
        this.indexInSheet = x$1;
    }

    private int attrCount() {
        return this.attrCount;
    }

    private void attrCount_$eq(int x$1) {
        this.attrCount = x$1;
    }

    private HSSFWorkbook workbook() {
        return this.workbook;
    }

    @Override
    public List<String> readDescription() {
        return this.workbook().getNumberOfSheets() < 1 ? List$.MODULE$.empty() : this.readLine(this.workbook().getSheetAt(0), this.headIndex());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> readTitle() {
        List list;
        if (this.workbook().getNumberOfSheets() < 1) {
            list = List$.MODULE$.empty();
        } else {
            void var1_1;
            List<String> comments = this.readComments(this.workbook().getSheetAt(0), this.headIndex());
            this.attrCount_$eq(comments.length());
            list = var1_1;
        }
        return list;
    }

    public List<String> readLine(HSSFSheet sheet, int rowIndex) {
        HSSFRow row = sheet.getRow(rowIndex);
        ListBuffer attrList = new ListBuffer();
        BooleanRef hasEmptyCell = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)row.getLastCellNum()).withFilter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> !hasEmptyCell$1.elem).foreach((Function1 & Serializable & scala.Serializable)i -> ExcelItemReader.$anonfun$readLine$2(row, hasEmptyCell, attrList, BoxesRunTime.unboxToInt((Object)i)));
        return attrList.toList();
    }

    public List<String> readComments(HSSFSheet sheet, int rowIndex) {
        HSSFRow row = sheet.getRow(rowIndex);
        ListBuffer attrList = new ListBuffer();
        BooleanRef hasEmptyCell = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)row.getLastCellNum()).withFilter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> !hasEmptyCell$2.elem).foreach((Function1 & Serializable & scala.Serializable)i -> ExcelItemReader.$anonfun$readComments$2(row, hasEmptyCell, attrList, BoxesRunTime.unboxToInt((Object)i)));
        return attrList.toList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object read() {
        void var3_3;
        HSSFSheet sheet = this.workbook().getSheetAt(this.sheetNum());
        if (this.indexInSheet() > sheet.getLastRowNum()) {
            return null;
        }
        HSSFRow row = sheet.getRow(this.indexInSheet());
        this.indexInSheet_$eq(this.indexInSheet() + 1);
        if (row == null) {
            return new Object[this.attrCount()];
        }
        Object[] values = new Object[this.attrCount() != 0 ? this.attrCount() : (int)row.getLastCellNum()];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), values.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> {
            values$1[k] = this.getCellValue(row.getCell(k));
        });
        return var3_3;
    }

    public Object getCellValue(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        CellType cellType = cell.getCellTypeEnum();
        Object object = CellType.BLANK.equals(cellType) ? null : (CellType.STRING.equals(cellType) ? Strings$.MODULE$.trim(cell.getRichStringCellValue().getString()) : (CellType.NUMERIC.equals(cellType) ? (DateUtil.isCellDateFormatted((Cell)cell) ? cell.getDateCellValue() : ExcelItemReader$.MODULE$.numberFormat().format(cell.getNumericCellValue())) : (CellType.BOOLEAN.equals(cellType) ? (cell.getBooleanCellValue() ? Boolean.TRUE : Boolean.FALSE) : null)));
        return object;
    }

    @Override
    public Enumeration.Value format() {
        return Format$.MODULE$.Xls();
    }

    @Override
    public void close() {
        this.workbook().cloneSheet(this.sheetNum());
    }

    public static final /* synthetic */ Object $anonfun$readLine$2(HSSFRow row$1, BooleanRef hasEmptyCell$1, ListBuffer attrList$1, int i) {
        BoxedUnit boxedUnit;
        HSSFCell cell = row$1.getCell(i);
        String attr = cell.getRichStringCellValue().getString();
        if (Strings$.MODULE$.isEmpty((CharSequence)attr)) {
            hasEmptyCell$1.elem = true;
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = attrList$1.$plus$eq((Object)attr.trim());
        }
        return boxedUnit;
    }

    public static final /* synthetic */ Object $anonfun$readComments$2(HSSFRow row$2, BooleanRef hasEmptyCell$2, ListBuffer attrList$2, int i) {
        BoxedUnit boxedUnit;
        HSSFCell cell = row$2.getCell(i);
        HSSFComment comment = cell.getCellComment();
        if (comment == null || Strings$.MODULE$.isEmpty((CharSequence)comment.getString().getString())) {
            hasEmptyCell$2.elem = true;
            boxedUnit = BoxedUnit.UNIT;
        } else {
            String commentStr = comment.getString().getString();
            if (commentStr.indexOf(58) > 0) {
                commentStr = Strings$.MODULE$.substringAfterLast(commentStr, ":");
            }
            boxedUnit = attrList$2.$plus$eq((Object)commentStr.trim());
        }
        return boxedUnit;
    }

    public ExcelItemReader(InputStream is) {
        ItemReader.$init$(this);
        Logging.$init$((Logging)this);
        this.sheetNum = 0;
        this.headIndex_$eq(0);
        this.dataIndex_$eq(this.headIndex() + 1);
        this.indexInSheet = this.dataIndex();
        this.workbook = new HSSFWorkbook(is);
    }

    public ExcelItemReader(InputStream is, int headIndex) {
        this(is);
        this.headIndex_$eq(headIndex);
        this.dataIndex_$eq(this.headIndex() + 1);
        this.indexInSheet_$eq(this.dataIndex());
    }
}

