/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.transfer.excel;

import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Calendar;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.beangle.commons.lang.Numbers$;
import org.beangle.data.transfer.Format$;
import org.beangle.data.transfer.exporter.Context;
import org.beangle.data.transfer.io.ItemWriter;
import org.beangle.data.transfer.io.Writer;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001\u0002\u0013&\u0001AB\u0001\"\u0010\u0001\u0003\u0006\u0004%\tA\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\u007f!)a\t\u0001C\u0001\u000f\"91\n\u0001a\u0001\n\u0003a\u0005b\u0002)\u0001\u0001\u0004%\t!\u0015\u0005\u0007/\u0002\u0001\u000b\u0015B'\t\u000fa\u0003\u0001\u0019!C\u00013\"9a\r\u0001a\u0001\n\u00039\u0007BB5\u0001A\u0003&!\fC\u0004k\u0001\u0001\u0007I\u0011\u0001'\t\u000f-\u0004\u0001\u0019!C\u0001Y\"1a\u000e\u0001Q!\n5C\u0011b\u001c\u0001A\u0002\u0003\u0007I\u0011\u00019\t\u0013Q\u0004\u0001\u0019!a\u0001\n\u0003)\b\"C<\u0001\u0001\u0004\u0005\t\u0015)\u0003r\u0011%A\b\u00011AA\u0002\u0013\u0005\u0011\u0010C\u0005~\u0001\u0001\u0007\t\u0019!C\u0001}\"Q\u0011\u0011\u0001\u0001A\u0002\u0003\u0005\u000b\u0015\u0002>\t\u0015\u0005\r\u0001\u00011AA\u0002\u0013\u0005\u0011\u0010C\u0006\u0002\u0006\u0001\u0001\r\u00111A\u0005\u0002\u0005\u001d\u0001BCA\u0006\u0001\u0001\u0007\t\u0011)Q\u0005u\"Y\u0011Q\u0002\u0001A\u0002\u0003\u0007I\u0011AA\b\u0011-\t9\u0002\u0001a\u0001\u0002\u0004%\t!!\u0007\t\u0017\u0005u\u0001\u00011A\u0001B\u0003&\u0011\u0011\u0003\u0005\b\u0003?\u0001A\u0011AA\u0011\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003CAq!!\n\u0001\t\u0003\n9\u0003C\u0004\u0002.\u0001!\t%a\f\t\u000f\u00055\u0003\u0001\"\u0001\u0002P!9\u00111\r\u0001\u0005\u0012\u0005\u0015\u0004bBA6\u0001\u0011%\u0011Q\u000e\u0005\b\u0003_\u0002A\u0011BA7\u0011\u001d\t\t\b\u0001C\t\u0003gBq!!\u001e\u0001\t#\t\u0019\bC\u0004\u0002x\u0001!\t\"!\u001c\u0003\u001f\u0015C8-\u001a7Ji\u0016lwK]5uKJT!AJ\u0014\u0002\u000b\u0015D8-\u001a7\u000b\u0005!J\u0013\u0001\u0003;sC:\u001ch-\u001a:\u000b\u0005)Z\u0013\u0001\u00023bi\u0006T!\u0001L\u0017\u0002\u000f\t,\u0017M\\4mK*\ta&A\u0002pe\u001e\u001c\u0001aE\u0002\u0001c]\u0002\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012a!\u00118z%\u00164\u0007C\u0001\u001d<\u001b\u0005I$B\u0001\u001e(\u0003\tIw.\u0003\u0002=s\tQ\u0011\n^3n/JLG/\u001a:\u0002\u000f\r|g\u000e^3yiV\tq\b\u0005\u0002A\u00076\t\u0011I\u0003\u0002CO\u0005AQ\r\u001f9peR,'/\u0003\u0002E\u0003\n91i\u001c8uKb$\u0018\u0001C2p]R,\u0007\u0010\u001e\u0011\u0002\rqJg.\u001b;?)\tA%\n\u0005\u0002J\u00015\tQ\u0005C\u0003>\u0007\u0001\u0007q(A\u0007d_VtG\u000fU3s'\",W\r^\u000b\u0002\u001bB\u0011!GT\u0005\u0003\u001fN\u00121!\u00138u\u0003E\u0019w.\u001e8u!\u0016\u00148\u000b[3fi~#S-\u001d\u000b\u0003%V\u0003\"AM*\n\u0005Q\u001b$\u0001B+oSRDqAV\u0003\u0002\u0002\u0003\u0007Q*A\u0002yIE\nabY8v]R\u0004VM]*iK\u0016$\b%\u0001\u0005x_J\\'m\\8l+\u0005Q\u0006CA.e\u001b\u0005a&BA/_\u0003%)8/\u001a:n_\u0012,GN\u0003\u0002`A\u0006!\u0001n]:g\u0015\t\t'-A\u0002q_&T!aY\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t)GL\u0001\u0007I'N3uk\u001c:lE>|7.\u0001\u0007x_J\\'m\\8l?\u0012*\u0017\u000f\u0006\u0002SQ\"9a\u000bCA\u0001\u0002\u0004Q\u0016!C<pe.\u0014wn\\6!\u0003\u0015Ig\u000eZ3y\u0003%Ig\u000eZ3y?\u0012*\u0017\u000f\u0006\u0002S[\"9akCA\u0001\u0002\u0004i\u0015AB5oI\u0016D\b%A\u0003tQ\u0016,G/F\u0001r!\tY&/\u0003\u0002t9\nI\u0001jU*G'\",W\r^\u0001\ng\",W\r^0%KF$\"A\u0015<\t\u000fYs\u0011\u0011!a\u0001c\u000611\u000f[3fi\u0002\n\u0011\u0002Z1uKN#\u0018\u0010\\3\u0016\u0003i\u0004\"aW>\n\u0005qd&!\u0004%T'\u001a\u001bU\r\u001c7TifdW-A\u0007eCR,7\u000b^=mK~#S-\u001d\u000b\u0003%~DqAV\t\u0002\u0002\u0003\u0007!0\u0001\u0006eCR,7\u000b^=mK\u0002\n\u0011\u0002^5nKN#\u0018\u0010\\3\u0002\u001bQLW.Z*us2,w\fJ3r)\r\u0011\u0016\u0011\u0002\u0005\b-R\t\t\u00111\u0001{\u0003)!\u0018.\\3TifdW\rI\u0001\u0006i&$H.Z\u000b\u0003\u0003#\u00012AMA\n\u0013\r\t)b\r\u0002\u0004\u0003:L\u0018!\u0003;ji2,w\fJ3r)\r\u0011\u00161\u0004\u0005\t-^\t\t\u00111\u0001\u0002\u0012\u00051A/\u001b;mK\u0002\nA!\u001b8jiR\t!+A\u0003dY>\u001cX-A\u0003xe&$X\rF\u0002S\u0003SAq!a\u000b\u001c\u0001\u0004\t\t\"A\u0002pE*\f!b\u001e:ji\u0016$\u0016\u000e\u001e7f)\u0015\u0011\u0016\u0011GA&\u0011\u001d\t\u0019\u0004\ba\u0001\u0003k\t\u0011\u0002^5uY\u0016t\u0015-\\3\u0011\t\u0005]\u0012Q\t\b\u0005\u0003s\t\t\u0005E\u0002\u0002<Mj!!!\u0010\u000b\u0007\u0005}r&\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0007\u001a\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002H\u0005%#AB*ue&twMC\u0002\u0002DMBaA\u000b\u000fA\u0002\u0005E\u0011A\u00024pe6\fG/\u0006\u0002\u0002RA!\u00111KA.\u001d\u0011\t)&a\u0016\u000e\u0003\u001dJ1!!\u0017(\u0003\u00191uN]7bi&!\u0011QLA0\u0005\u00151\u0016\r\\;f\u0013\r\t\tg\r\u0002\f\u000b:,X.\u001a:bi&|g.A\u0005xe&$X-\u0013;f[R\u0019!+a\u001a\t\u000f\u0005%d\u00041\u0001\u0002\u0012\u0005)A-\u0019;bg\u0006aq-\u001a;ECR,7\u000b^=mKR\t!0\u0001\u0007hKR$\u0016.\\3TifdW-A\u0007hKR$\u0015\r^3G_Jl\u0017\r\u001e\u000b\u0003\u0003k\t\u0011cZ3u\t\u0006$X\rV5nK\u001a{'/\\1u\u0003=\u0011W/\u001b7e)&$H.Z*us2,\u0007")
public class ExcelItemWriter
implements ItemWriter {
    private final Context context;
    private int countPerSheet;
    private HSSFWorkbook workbook;
    private int index;
    private HSSFSheet sheet;
    private HSSFCellStyle dateStyle;
    private HSSFCellStyle timeStyle;
    private Object title;
    private OutputStream outputStream;

    @Override
    public OutputStream outputStream() {
        return this.outputStream;
    }

    @Override
    public void outputStream_$eq(OutputStream x$1) {
        this.outputStream = x$1;
    }

    public Context context() {
        return this.context;
    }

    public int countPerSheet() {
        return this.countPerSheet;
    }

    public void countPerSheet_$eq(int x$1) {
        this.countPerSheet = x$1;
    }

    public HSSFWorkbook workbook() {
        return this.workbook;
    }

    public void workbook_$eq(HSSFWorkbook x$1) {
        this.workbook = x$1;
    }

    public int index() {
        return this.index;
    }

    public void index_$eq(int x$1) {
        this.index = x$1;
    }

    public HSSFSheet sheet() {
        return this.sheet;
    }

    public void sheet_$eq(HSSFSheet x$1) {
        this.sheet = x$1;
    }

    public HSSFCellStyle dateStyle() {
        return this.dateStyle;
    }

    public void dateStyle_$eq(HSSFCellStyle x$1) {
        this.dateStyle = x$1;
    }

    public HSSFCellStyle timeStyle() {
        return this.timeStyle;
    }

    public void timeStyle_$eq(HSSFCellStyle x$1) {
        this.timeStyle = x$1;
    }

    public Object title() {
        return this.title;
    }

    public void title_$eq(Object x$1) {
        this.title = x$1;
    }

    public void init() {
        block0: {
            int countParam;
            Object count;
            if (this.context() == null || (count = this.context().datas().get((Object)"countPerSheet").getOrElse((Function0 & Serializable & scala.Serializable)() -> "")) == null || !Numbers$.MODULE$.isDigits(count.toString()) || (countParam = Numbers$.MODULE$.toInt(count.toString(), Numbers$.MODULE$.toInt$default$2())) <= 0) break block0;
            this.countPerSheet_$eq(countParam);
        }
    }

    @Override
    public void close() {
        this.workbook().write(this.outputStream());
    }

    @Override
    public void write(Object obj) {
        if (this.index() + 1 >= this.countPerSheet()) {
            this.writeTitle(null, this.title());
        }
        this.writeItem(obj);
        this.index_$eq(this.index() + 1);
    }

    @Override
    public void writeTitle(String titleName, Object data) {
        if (titleName != null) {
            this.sheet_$eq(this.workbook().createSheet(titleName));
        } else {
            this.sheet_$eq(this.workbook().createSheet());
        }
        this.title_$eq(data);
        this.index_$eq(0);
        this.writeItem(data);
        ObjectRef titleRow = ObjectRef.create((Object)this.sheet().getRow(this.index()));
        ObjectRef titleStyle = ObjectRef.create((Object)this.buildTitleStyle());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)((HSSFRow)titleRow.elem).getLastCellNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> ((HSSFRow)titleRow$1.elem).getCell(i).setCellStyle((HSSFCellStyle)titleStyle$1.elem));
        this.index_$eq(this.index() + 1);
    }

    @Override
    public Enumeration.Value format() {
        return Format$.MODULE$.Xls();
    }

    public void writeItem(Object datas) {
        block4: {
            ObjectRef row = ObjectRef.create((Object)this.sheet().createRow(this.index()));
            if (datas == null) break block4;
            if (datas.getClass().isArray()) {
                Object values = datas;
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), ScalaRunTime$.MODULE$.array_length(values)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    Object object;
                    HSSFCell cell = ((HSSFRow)row$1.elem).createCell(i);
                    Object v = ScalaRunTime$.MODULE$.array_apply(values, i);
                    if (v != null && v instanceof Option) {
                        v = ((Option)v).getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
                    }
                    if ((object = v) instanceof Number) {
                        Number number = (Number)object;
                        cell.setCellType(CellType.NUMERIC);
                        cell.setCellValue(number.doubleValue());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (object instanceof Date) {
                        Date date = (Date)object;
                        cell.setCellValue((java.util.Date)date);
                        cell.setCellStyle(this.getDateStyle());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (object instanceof java.util.Date) {
                        java.util.Date date = (java.util.Date)object;
                        cell.setCellValue(date);
                        cell.setCellStyle(this.getTimeStyle());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (object instanceof LocalDate) {
                        LocalDate localDate = (LocalDate)object;
                        cell.setCellValue((java.util.Date)Date.valueOf(localDate));
                        cell.setCellStyle(this.getDateStyle());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (object instanceof Instant) {
                        Instant instant = (Instant)object;
                        cell.setCellValue(java.util.Date.from(instant));
                        cell.setCellStyle(this.getTimeStyle());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (object instanceof Calendar) {
                        Calendar calendar = (Calendar)object;
                        cell.setCellValue(calendar);
                        cell.setCellStyle(this.getTimeStyle());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        cell.setCellValue((RichTextString)new HSSFRichTextString(v == null ? "" : v.toString()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                });
            } else {
                HSSFCell cell = ((HSSFRow)row.elem).createCell(0);
                Object object = datas;
                if (object instanceof Number) {
                    cell.setCellType(CellType.NUMERIC);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                cell.setCellValue((RichTextString)new HSSFRichTextString(datas.toString()));
            }
        }
    }

    private HSSFCellStyle getDateStyle() {
        block0: {
            if (this.dateStyle() != null) break block0;
            this.dateStyle_$eq(this.workbook().createCellStyle());
            this.dateStyle().setDataFormat(this.workbook().createDataFormat().getFormat(this.getDateFormat()));
        }
        return this.dateStyle();
    }

    private HSSFCellStyle getTimeStyle() {
        block0: {
            if (this.timeStyle() != null) break block0;
            this.timeStyle_$eq(this.workbook().createCellStyle());
            this.timeStyle().setDataFormat(this.workbook().createDataFormat().getFormat(this.getDateTimeFormat()));
        }
        return this.timeStyle();
    }

    public String getDateFormat() {
        return "YYYY-MM-DD";
    }

    public String getDateTimeFormat() {
        return "YYYY-MM-DD HH:MM:SS";
    }

    /*
     * WARNING - void declaration
     */
    public HSSFCellStyle buildTitleStyle() {
        void var1_1;
        HSSFCellStyle style = this.workbook().createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        return var1_1;
    }

    public ExcelItemWriter(Context context) {
        this.context = context;
        Writer.$init$(this);
        this.countPerSheet = 50000;
        this.workbook = new HSSFWorkbook();
        this.index = 0;
        this.init();
    }
}

