/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.transfer.excel;

import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Calendar;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.beangle.commons.lang.Numbers$;
import org.beangle.data.transfer.Format$;
import org.beangle.data.transfer.exporter.ExportContext;
import org.beangle.data.transfer.io.ItemWriter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001\u0002\u0014(\u0001IB\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001\u0011\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0003\"A\u0001\n\u0001BC\u0002\u0013\u0005\u0011\n\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003K\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u001dA\u0006\u00011A\u0005\u0002eCq!\u0018\u0001A\u0002\u0013\u0005a\f\u0003\u0004e\u0001\u0001\u0006KA\u0017\u0005\bK\u0002\u0001\r\u0011\"\u0001g\u0011\u001d\u0019\b\u00011A\u0005\u0002QDaA\u001e\u0001!B\u00139\u0007bB<\u0001\u0001\u0004%\t!\u0017\u0005\bq\u0002\u0001\r\u0011\"\u0001z\u0011\u0019Y\b\u0001)Q\u00055\"IA\u0010\u0001a\u0001\u0002\u0004%\t! \u0005\f\u0003\u0007\u0001\u0001\u0019!a\u0001\n\u0003\t)\u0001\u0003\u0006\u0002\n\u0001\u0001\r\u0011!Q!\nyD1\"a\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u000e!Y\u0011Q\u0003\u0001A\u0002\u0003\u0007I\u0011AA\f\u0011-\tY\u0002\u0001a\u0001\u0002\u0003\u0006K!a\u0004\t\u0017\u0005u\u0001\u00011AA\u0002\u0013\u0005\u0011Q\u0002\u0005\f\u0003?\u0001\u0001\u0019!a\u0001\n\u0003\t\t\u0003C\u0006\u0002&\u0001\u0001\r\u0011!Q!\n\u0005=\u0001bCA\u0014\u0001\u0001\u0007\t\u0019!C\u0001\u0003SA1\"!\r\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u00024!Y\u0011q\u0007\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0016\u0011\u001d\tI\u0004\u0001C\u0001\u0003wAq!!\u0010\u0001\t\u0003\tY\u0004C\u0004\u0002@\u0001!\t%!\u0011\t\u000f\u0005\u001d\u0003\u0001\"\u0011\u0002J!9\u0011q\r\u0001\u0005\u0002\u0005%\u0004bBA?\u0001\u0011E\u0011q\u0010\u0005\b\u0003\u000b\u0003A\u0011BAD\u0011\u001d\tI\t\u0001C\u0005\u0003\u000fCq!a#\u0001\t#\ti\tC\u0004\u0002\u0010\u0002!\t\"!$\t\u000f\u0005E\u0005\u0001\"\u0005\u0002\b\nyQ\t_2fY&#X-\\,sSR,'O\u0003\u0002)S\u0005)Q\r_2fY*\u0011!fK\u0001\tiJ\fgn\u001d4fe*\u0011A&L\u0001\u0005I\u0006$\u0018M\u0003\u0002/_\u00059!-Z1oO2,'\"\u0001\u0019\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0019\u0014\b\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATG\u0001\u0004B]f\u0014VM\u001a\t\u0003uuj\u0011a\u000f\u0006\u0003y%\n!![8\n\u0005yZ$AC%uK6<&/\u001b;fe\u000691m\u001c8uKb$X#A!\u0011\u0005\t+U\"A\"\u000b\u0005\u0011K\u0013\u0001C3ya>\u0014H/\u001a:\n\u0005\u0019\u001b%!D#ya>\u0014HoQ8oi\u0016DH/\u0001\u0005d_:$X\r\u001f;!\u00031yW\u000f\u001e9viN#(/Z1n+\u0005Q\u0005CA&P\u001b\u0005a%B\u0001\u001fN\u0015\u0005q\u0015\u0001\u00026bm\u0006L!\u0001\u0015'\u0003\u0019=+H\u000f];u'R\u0014X-Y7\u0002\u001b=,H\u000f];u'R\u0014X-Y7!\u0003\u0019a\u0014N\\5u}Q\u0019AKV,\u0011\u0005U\u0003Q\"A\u0014\t\u000b}*\u0001\u0019A!\t\u000b!+\u0001\u0019\u0001&\u0002\u001b\r|WO\u001c;QKJ\u001c\u0006.Z3u+\u0005Q\u0006C\u0001\u001b\\\u0013\taVGA\u0002J]R\f\u0011cY8v]R\u0004VM]*iK\u0016$x\fJ3r)\ty&\r\u0005\u00025A&\u0011\u0011-\u000e\u0002\u0005+:LG\u000fC\u0004d\u000f\u0005\u0005\t\u0019\u0001.\u0002\u0007a$\u0013'\u0001\bd_VtG\u000fU3s'\",W\r\u001e\u0011\u0002\u0011]|'o\u001b2p_.,\u0012a\u001a\t\u0003QFl\u0011!\u001b\u0006\u0003U.\f\u0011\"^:fe6|G-\u001a7\u000b\u00051l\u0017\u0001\u00025tg\u001aT!A\\8\u0002\u0007A|\u0017N\u0003\u0002q_\u00051\u0011\r]1dQ\u0016L!A]5\u0003\u0019!\u001b6KR,pe.\u0014wn\\6\u0002\u0019]|'o\u001b2p_.|F%Z9\u0015\u0005}+\bbB2\u000b\u0003\u0003\u0005\raZ\u0001\no>\u00148NY8pW\u0002\nQ!\u001b8eKb\f\u0011\"\u001b8eKb|F%Z9\u0015\u0005}S\bbB2\u000e\u0003\u0003\u0005\rAW\u0001\u0007S:$W\r\u001f\u0011\u0002\u000bMDW-\u001a;\u0016\u0003y\u0004\"\u0001[@\n\u0007\u0005\u0005\u0011NA\u0005I'N35\u000b[3fi\u0006I1\u000f[3fi~#S-\u001d\u000b\u0004?\u0006\u001d\u0001bB2\u0011\u0003\u0003\u0005\rA`\u0001\u0007g\",W\r\u001e\u0011\u0002\u0013\u0011\fG/Z*us2,WCAA\b!\rA\u0017\u0011C\u0005\u0004\u0003'I'!\u0004%T'\u001a\u001bU\r\u001c7TifdW-A\u0007eCR,7\u000b^=mK~#S-\u001d\u000b\u0004?\u0006e\u0001\u0002C2\u0014\u0003\u0003\u0005\r!a\u0004\u0002\u0015\u0011\fG/Z*us2,\u0007%A\u0005uS6,7\u000b^=mK\u0006iA/[7f'RLH.Z0%KF$2aXA\u0012\u0011!\u0019g#!AA\u0002\u0005=\u0011A\u0003;j[\u0016\u001cF/\u001f7fA\u0005)A/\u001b;mKV\u0011\u00111\u0006\t\u0004i\u00055\u0012bAA\u0018k\t\u0019\u0011I\\=\u0002\u0013QLG\u000f\\3`I\u0015\fHcA0\u00026!A1-GA\u0001\u0002\u0004\tY#\u0001\u0004uSRdW\rI\u0001\u0005S:LG\u000fF\u0001`\u0003\u0015\u0019Gn\\:f\u0003\u00159(/\u001b;f)\ry\u00161\t\u0005\b\u0003\u000bj\u0002\u0019AA\u0016\u0003\ry'M[\u0001\u000boJLG/\u001a+ji2,G#B0\u0002L\u0005\u0015\u0004bBA'=\u0001\u0007\u0011qJ\u0001\ni&$H.\u001a(b[\u0016\u0004B!!\u0015\u0002`9!\u00111KA.!\r\t)&N\u0007\u0003\u0003/R1!!\u00172\u0003\u0019a$o\\8u}%\u0019\u0011QL\u001b\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t'a\u0019\u0003\rM#(/\u001b8h\u0015\r\ti&\u000e\u0005\u0007Yy\u0001\r!a\u000b\u0002\r\u0019|'/\\1u+\t\tY\u0007\u0005\u0003\u0002n\u0005Ud\u0002BA8\u0003cj\u0011!K\u0005\u0004\u0003gJ\u0013A\u0002$pe6\fG/\u0003\u0003\u0002x\u0005e$!\u0002,bYV,\u0017bAA>k\tYQI\\;nKJ\fG/[8o\u0003%9(/\u001b;f\u0013R,W\u000eF\u0002`\u0003\u0003Cq!a!!\u0001\u0004\tY#A\u0003eCR\f7/\u0001\u0007hKR$\u0015\r^3TifdW\r\u0006\u0002\u0002\u0010\u0005aq-\u001a;US6,7\u000b^=mK\u0006iq-\u001a;ECR,gi\u001c:nCR$\"!a\u0014\u0002#\u001d,G\u000fR1uKRKW.\u001a$pe6\fG/A\bck&dG\rV5uY\u0016\u001cF/\u001f7f\u0001")
public class ExcelItemWriter
implements ItemWriter {
    private final ExportContext context;
    private final OutputStream outputStream;
    private int countPerSheet;
    private HSSFWorkbook workbook;
    private int index;
    private HSSFSheet sheet;
    private HSSFCellStyle dateStyle;
    private HSSFCellStyle timeStyle;
    private Object title;

    public ExportContext context() {
        return this.context;
    }

    public OutputStream outputStream() {
        return this.outputStream;
    }

    public int countPerSheet() {
        return this.countPerSheet;
    }

    public void countPerSheet_$eq(int x$1) {
        this.countPerSheet = x$1;
    }

    public HSSFWorkbook workbook() {
        return this.workbook;
    }

    public void workbook_$eq(HSSFWorkbook x$1) {
        this.workbook = x$1;
    }

    public int index() {
        return this.index;
    }

    public void index_$eq(int x$1) {
        this.index = x$1;
    }

    public HSSFSheet sheet() {
        return this.sheet;
    }

    public void sheet_$eq(HSSFSheet x$1) {
        this.sheet = x$1;
    }

    public HSSFCellStyle dateStyle() {
        return this.dateStyle;
    }

    public void dateStyle_$eq(HSSFCellStyle x$1) {
        this.dateStyle = x$1;
    }

    public HSSFCellStyle timeStyle() {
        return this.timeStyle;
    }

    public void timeStyle_$eq(HSSFCellStyle x$1) {
        this.timeStyle = x$1;
    }

    public Object title() {
        return this.title;
    }

    public void title_$eq(Object x$1) {
        this.title = x$1;
    }

    public void init() {
        block0: {
            int countParam;
            Object count;
            if (this.context() == null || (count = this.context().datas().get((Object)"countPerSheet").getOrElse((Function0 & Serializable & scala.Serializable)() -> "")) == null || !Numbers$.MODULE$.isDigits(count.toString()) || (countParam = Numbers$.MODULE$.toInt(count.toString(), Numbers$.MODULE$.toInt$default$2())) <= 0) break block0;
            this.countPerSheet_$eq(countParam);
        }
    }

    @Override
    public void close() {
        this.workbook().write(this.outputStream());
    }

    @Override
    public void write(Object obj) {
        if (this.index() + 1 >= this.countPerSheet()) {
            this.writeTitle(null, this.title());
        }
        this.writeItem(obj);
        this.index_$eq(this.index() + 1);
    }

    @Override
    public void writeTitle(String titleName, Object data) {
        if (titleName != null) {
            this.sheet_$eq(this.workbook().createSheet(titleName));
        } else {
            this.sheet_$eq(this.workbook().createSheet());
        }
        this.title_$eq(data);
        this.index_$eq(0);
        this.writeItem(data);
        ObjectRef titleRow = ObjectRef.create((Object)this.sheet().getRow(this.index()));
        ObjectRef titleStyle = ObjectRef.create((Object)this.buildTitleStyle());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)((HSSFRow)titleRow.elem).getLastCellNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> ((HSSFRow)titleRow$1.elem).getCell(i).setCellStyle((HSSFCellStyle)titleStyle$1.elem));
        this.index_$eq(this.index() + 1);
    }

    @Override
    public Enumeration.Value format() {
        return Format$.MODULE$.Xls();
    }

    public void writeItem(Object datas) {
        block4: {
            ObjectRef row = ObjectRef.create((Object)this.sheet().createRow(this.index()));
            if (datas == null) break block4;
            if (datas.getClass().isArray()) {
                Object values = datas;
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), ScalaRunTime$.MODULE$.array_length(values)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    Object object;
                    HSSFCell cell = ((HSSFRow)row$1.elem).createCell(i);
                    Object v = ScalaRunTime$.MODULE$.array_apply(values, i);
                    if (v != null && v instanceof Option) {
                        v = ((Option)v).getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
                    }
                    if ((object = v) instanceof Number) {
                        Number number = (Number)object;
                        cell.setCellType(CellType.NUMERIC);
                        cell.setCellValue(number.doubleValue());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (object instanceof Date) {
                        Date date = (Date)object;
                        cell.setCellValue((java.util.Date)date);
                        cell.setCellStyle(this.getDateStyle());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (object instanceof java.util.Date) {
                        java.util.Date date = (java.util.Date)object;
                        cell.setCellValue(date);
                        cell.setCellStyle(this.getTimeStyle());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (object instanceof LocalDate) {
                        LocalDate localDate = (LocalDate)object;
                        cell.setCellValue((java.util.Date)Date.valueOf(localDate));
                        cell.setCellStyle(this.getDateStyle());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (object instanceof Instant) {
                        Instant instant = (Instant)object;
                        cell.setCellValue(java.util.Date.from(instant));
                        cell.setCellStyle(this.getTimeStyle());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (object instanceof Calendar) {
                        Calendar calendar = (Calendar)object;
                        cell.setCellValue(calendar);
                        cell.setCellStyle(this.getTimeStyle());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        cell.setCellValue((RichTextString)new HSSFRichTextString(v == null ? "" : v.toString()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                });
            } else {
                HSSFCell cell = ((HSSFRow)row.elem).createCell(0);
                Object object = datas;
                if (object instanceof Number) {
                    cell.setCellType(CellType.NUMERIC);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                cell.setCellValue((RichTextString)new HSSFRichTextString(datas.toString()));
            }
        }
    }

    private HSSFCellStyle getDateStyle() {
        block0: {
            if (this.dateStyle() != null) break block0;
            this.dateStyle_$eq(this.workbook().createCellStyle());
            this.dateStyle().setDataFormat(this.workbook().createDataFormat().getFormat(this.getDateFormat()));
        }
        return this.dateStyle();
    }

    private HSSFCellStyle getTimeStyle() {
        block0: {
            if (this.timeStyle() != null) break block0;
            this.timeStyle_$eq(this.workbook().createCellStyle());
            this.timeStyle().setDataFormat(this.workbook().createDataFormat().getFormat(this.getDateTimeFormat()));
        }
        return this.timeStyle();
    }

    public String getDateFormat() {
        return "YYYY-MM-DD";
    }

    public String getDateTimeFormat() {
        return "YYYY-MM-DD HH:MM:SS";
    }

    /*
     * WARNING - void declaration
     */
    public HSSFCellStyle buildTitleStyle() {
        void var1_1;
        HSSFCellStyle style = this.workbook().createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        return var1_1;
    }

    public ExcelItemWriter(ExportContext context, OutputStream outputStream) {
        this.context = context;
        this.outputStream = outputStream;
        this.countPerSheet = 50000;
        this.workbook = new HSSFWorkbook();
        this.index = 0;
        this.init();
    }
}

