/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.transfer.excel;

import java.io.InputStream;
import java.io.Serializable;
import java.sql.Date;
import java.text.NumberFormat;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.transfer.Format$;
import org.beangle.data.transfer.excel.ExcelItemReader$;
import org.beangle.data.transfer.io.Attribute;
import org.beangle.data.transfer.io.ItemReader;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005-u!B\u000e\u001d\u0011\u00039c!B\u0015\u001d\u0011\u0003Q\u0003\"B\u0019\u0002\t\u0003\u0011\u0004bB\u001a\u0002\u0005\u0004%\t\u0001\u000e\u0005\u0007{\u0005\u0001\u000b\u0011B\u001b\t\u000fy\n\u0011\u0013!C\u0001\u007f!9Q*AI\u0001\n\u0003qe\u0001B\u0015\u001d\u0001eC\u0001\u0002[\u0004\u0003\u0002\u0003\u0006I!\u001b\u0005\t]\u001e\u0011\t\u0011)A\u0005\u0003\"Aqn\u0002BC\u0002\u0013\u0005\u0001\u000f\u0003\u0005r\u000f\t\u0005\t\u0015!\u0003Q\u0011\u0015\tt\u0001\"\u0001s\u0011\u001d9xA1A\u0005\naDq!a\u0003\bA\u0003%\u0011\u0010C\u0005\u0002\u000e\u001d\u0001\r\u0011\"\u0003\u0002\u0010!I\u0011\u0011C\u0004A\u0002\u0013%\u00111\u0003\u0005\b\u0003?9\u0001\u0015)\u0003B\u0011-\t\tc\u0002a\u0001\u0002\u0004%I!a\t\t\u0017\u0005\rs\u00011AA\u0002\u0013%\u0011Q\t\u0005\f\u0003\u0013:\u0001\u0019!A!B\u0013\t)\u0003C\u0004\u0002L\u001d!I!!\u0014\t\u000f\u0005Ms\u0001\"\u0011\u0002V!9\u00111K\u0004\u0005\u0012\u0005]\u0003bBA0\u000f\u0011\u0005\u0013\u0011\r\u0005\b\u0003s:A\u0011AA>\u0011\u001d\t9i\u0002C!\u0003\u0013\u000bq\"\u0012=dK2LE/Z7SK\u0006$WM\u001d\u0006\u0003;y\tQ!\u001a=dK2T!a\b\u0011\u0002\u0011Q\u0014\u0018M\\:gKJT!!\t\u0012\u0002\t\u0011\fG/\u0019\u0006\u0003G\u0011\nqAY3b]\u001edWMC\u0001&\u0003\ry'oZ\u0002\u0001!\tA\u0013!D\u0001\u001d\u0005=)\u0005pY3m\u0013R,WNU3bI\u0016\u00148CA\u0001,!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aJ\u0001\r]Vl'-\u001a:G_Jl\u0017\r^\u000b\u0002kA\u0011agO\u0007\u0002o)\u0011\u0001(O\u0001\u0005i\u0016DHOC\u0001;\u0003\u0011Q\u0017M^1\n\u0005q:$\u0001\u0004(v[\n,'OR8s[\u0006$\u0018!\u00048v[\n,'OR8s[\u0006$\b%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0002\u0001*\u0012\u0011\t\u0012\t\u0003Y\tK!aQ\u0017\u0003\u0007%sGoK\u0001F!\t15*D\u0001H\u0015\tA\u0015*A\u0005v]\u000eDWmY6fI*\u0011!*L\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001'H\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003=S#\u0001\u0015#\u0011\u0005E+fB\u0001*T\u001b\u0005q\u0012B\u0001+\u001f\u0003\u00191uN]7bi&\u0011ak\u0016\u0002\u0006-\u0006dW/Z\u0005\u000316\u00121\"\u00128v[\u0016\u0014\u0018\r^5p]N!qa\u000b.a!\tYf,D\u0001]\u0015\tif$\u0001\u0002j_&\u0011q\f\u0018\u0002\u000b\u0013R,WNU3bI\u0016\u0014\bCA1g\u001b\u0005\u0011'BA2e\u0003\u001dawnZ4j]\u001eT!!\u001a\u0012\u0002\u000f\r|W.\\8og&\u0011qM\u0019\u0002\b\u0019><w-\u001b8h\u0003\tI7\u000f\u0005\u0002kY6\t1N\u0003\u0002^s%\u0011Qn\u001b\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW.\u0001\u0005tQ\u0016,GOT;n\u0003\u00191wN]7biV\t\u0001+A\u0004g_Jl\u0017\r\u001e\u0011\u0015\tM$XO\u001e\t\u0003Q\u001dAQ\u0001\u001b\u0007A\u0002%DqA\u001c\u0007\u0011\u0002\u0003\u0007\u0011\tC\u0004p\u0019A\u0005\t\u0019\u0001)\u0002\u000bMDW-\u001a;\u0016\u0003e\u00042A_A\u0004\u001b\u0005Y(B\u0001?~\u0003%)8/\u001a:n_\u0012,GN\u0003\u0002\u007f\u007f\u0006\u00111o\u001d\u0006\u0005\u0003\u0003\t\u0019!A\u0002q_&T1!!\u0002%\u0003\u0019\t\u0007/Y2iK&\u0019\u0011\u0011B>\u0003\u000bMCW-\u001a;\u0002\rMDW-\u001a;!\u00031Ig\u000eZ3y\u0013:\u001c\u0006.Z3u+\u0005\t\u0015\u0001E5oI\u0016D\u0018J\\*iK\u0016$x\fJ3r)\u0011\t)\"a\u0007\u0011\u00071\n9\"C\u0002\u0002\u001a5\u0012A!\u00168ji\"A\u0011Q\u0004\t\u0002\u0002\u0003\u0007\u0011)A\u0002yIE\nQ\"\u001b8eKbLen\u00155fKR\u0004\u0013!B1uiJ\u001cXCAA\u0013!\u0019\t9#a\u000e\u0002>9!\u0011\u0011FA\u001a\u001d\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018M\u00051AH]8pizJ\u0011AL\u0005\u0004\u0003ki\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003s\tYD\u0001\u0003MSN$(bAA\u001b[A\u00191,a\u0010\n\u0007\u0005\u0005CLA\u0005BiR\u0014\u0018NY;uK\u0006I\u0011\r\u001e;sg~#S-\u001d\u000b\u0005\u0003+\t9\u0005C\u0005\u0002\u001eM\t\t\u00111\u0001\u0002&\u00051\u0011\r\u001e;sg\u0002\n!BY;jY\u0012\u001c\u0006.Z3u)\u0015I\u0018qJA)\u0011\u0015AW\u00031\u0001j\u0011\u0015qW\u00031\u0001B\u00039\u0011X-\u00193BiR\u0014\u0018NY;uKN$\"!!\n\u0015\r\u0005\u0015\u0012\u0011LA.\u0011\u00159x\u00031\u0001z\u0011\u0019\tif\u0006a\u0001\u0003\u0006A!o\\<J]\u0012,\u00070\u0001\u0003sK\u0006$GCAA2!\u0015a\u0013QMA5\u0013\r\t9'\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003W\n\u0019H\u0004\u0003\u0002n\u0005=\u0004cAA\u0016[%\u0019\u0011\u0011O\u0017\u0002\rA\u0013X\rZ3g\u0013\u0011\t)(a\u001e\u0003\rM#(/\u001b8h\u0015\r\t\t(L\u0001\rO\u0016$8)\u001a7m-\u0006dW/\u001a\u000b\u0005\u0003S\ni\bC\u0004\u0002\u0000e\u0001\r!!!\u0002\t\r,G\u000e\u001c\t\u0004u\u0006\r\u0015bAACw\n!1)\u001a7m\u0003\u0015\u0019Gn\\:f)\t\t)\u0002")
public class ExcelItemReader
implements ItemReader,
Logging {
    private final Enumeration.Value format;
    private final Sheet sheet;
    private int indexInSheet;
    private List<Attribute> attrs;
    private Logger logger;

    public static Enumeration.Value $lessinit$greater$default$3() {
        return ExcelItemReader$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return ExcelItemReader$.MODULE$.$lessinit$greater$default$2();
    }

    public static NumberFormat numberFormat() {
        return ExcelItemReader$.MODULE$.numberFormat();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Enumeration.Value format() {
        return this.format;
    }

    private Sheet sheet() {
        return this.sheet;
    }

    private int indexInSheet() {
        return this.indexInSheet;
    }

    private void indexInSheet_$eq(int x$1) {
        this.indexInSheet = x$1;
    }

    private List<Attribute> attrs() {
        return this.attrs;
    }

    private void attrs_$eq(List<Attribute> x$1) {
        this.attrs = x$1;
    }

    private Sheet buildSheet(InputStream is, int sheetNum) {
        HSSFSheet hSSFSheet;
        Enumeration.Value value = this.format();
        Enumeration.Value value2 = Format$.MODULE$.Xls();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            hSSFSheet = new HSSFWorkbook(is).getSheetAt(sheetNum);
        } else {
            Enumeration.Value value4 = Format$.MODULE$.Xlsx();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                hSSFSheet = new XSSFWorkbook(is).getSheetAt(sheetNum);
            } else {
                throw new RuntimeException(new StringBuilder(28).append("Cannot support excel format ").append(this.format()).toString());
            }
        }
        return hSSFSheet;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Attribute> readAttributes() {
        void var2_2;
        int i;
        List<Attribute> attrs = List$.MODULE$.empty();
        for (i = 0; i < 10 && attrs.isEmpty(); ++i) {
            attrs = this.readAttributes(this.sheet(), i);
        }
        this.indexInSheet_$eq(i);
        this.attrs_$eq(attrs);
        return var2_2;
    }

    public List<Attribute> readAttributes(Sheet sheet, int rowIndex) {
        Row row = sheet.getRow(rowIndex);
        ListBuffer attrList = new ListBuffer();
        BooleanRef hasEmptyCell = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), (int)row.getLastCellNum()).withFilter((Function1)(JFunction1.mcZI.sp & Serializable)i -> !hasEmptyCell$1.elem).foreach((Function1 & Serializable)i -> ExcelItemReader.$anonfun$readAttributes$2(row, hasEmptyCell, attrList, BoxesRunTime.unboxToInt((Object)i)));
        return attrList.toList();
    }

    /*
     * WARNING - void declaration
     */
    public String[] read() {
        String[] stringArray;
        if (this.indexInSheet() > this.sheet().getLastRowNum()) {
            return null;
        }
        Row row = this.sheet().getRow(this.indexInSheet());
        this.indexInSheet_$eq(this.indexInSheet() + 1);
        int attrCount = this.attrs().size();
        if (row == null) {
            stringArray = new String[attrCount];
        } else {
            void var3_3;
            String[] values = new String[attrCount != 0 ? attrCount : (int)row.getLastCellNum()];
            ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps((Object[])values)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)k -> {
                values$1[k] = this.getCellValue(row.getCell(k));
            });
            stringArray = var3_3;
        }
        return stringArray;
    }

    public String getCellValue(Cell cell) {
        String string;
        if (cell == null) {
            return null;
        }
        CellType cellType = cell.getCellType();
        if (CellType.BLANK.equals(cellType)) {
            string = null;
        } else if (CellType.STRING.equals(cellType)) {
            string = Strings$.MODULE$.trim(cell.getRichStringCellValue().getString());
        } else if (CellType.NUMERIC.equals(cellType)) {
            String string2;
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                java.util.Date date = cell.getDateCellValue();
                String string3 = date == null ? null : new Date(date.getTime()).toLocalDate().toString();
                string2 = string3;
            } else {
                string2 = ExcelItemReader$.MODULE$.numberFormat().format(cell.getNumericCellValue());
            }
            string = string2;
        } else if (CellType.BOOLEAN.equals(cellType)) {
            string = cell.getBooleanCellValue() ? "true" : "false";
        } else if (CellType.FORMULA.equals(cellType)) {
            CellType cellType2 = cell.getCachedFormulaResultType();
            String string4 = CellType.STRING.equals(cellType2) ? Strings$.MODULE$.trim(cell.getRichStringCellValue().getString()) : (CellType.NUMERIC.equals(cellType2) ? ExcelItemReader$.MODULE$.numberFormat().format(cell.getNumericCellValue()) : null);
            string = string4;
        } else {
            string = null;
        }
        return string;
    }

    @Override
    public void close() {
        this.sheet().getWorkbook().close();
    }

    public static final /* synthetic */ Object $anonfun$readAttributes$2(Row row$1, BooleanRef hasEmptyCell$1, ListBuffer attrList$1, int i) {
        BoxedUnit boxedUnit;
        Cell cell = row$1.getCell(i);
        Comment comment = cell.getCellComment();
        if (comment == null || Strings$.MODULE$.isEmpty((CharSequence)comment.getString().getString())) {
            hasEmptyCell$1.elem = true;
            boxedUnit = BoxedUnit.UNIT;
        } else {
            String commentStr = comment.getString().getString();
            if (commentStr.indexOf(58) > 0) {
                commentStr = Strings$.MODULE$.substringAfterLast(commentStr, ":");
            }
            boxedUnit = attrList$1.$plus$eq((Object)new Attribute(i + 1, commentStr.trim(), cell.getRichStringCellValue().getString()));
        }
        return boxedUnit;
    }

    public ExcelItemReader(InputStream is, int sheetNum, Enumeration.Value format) {
        this.format = format;
        Logging.$init$((Logging)this);
        this.sheet = this.buildSheet(is, sheetNum);
        this.indexInSheet = 1;
        Statics.releaseFence();
    }
}

