/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.transfer.excel;

import java.io.OutputStream;
import java.io.Serializable;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.transfer.excel.Constraints$;
import org.beangle.data.transfer.excel.ExcelColumn;
import org.beangle.data.transfer.excel.ExcelScheet;
import org.beangle.data.transfer.excel.ExcelSchema;
import scala.Function0;
import scala.Function1;
import scala.collection.Seq;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;

public final class ExcelSchemaWriter$ {
    public static final ExcelSchemaWriter$ MODULE$ = new ExcelSchemaWriter$();

    public void generate(ExcelSchema schema, OutputStream os) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        schema.sheets().foreach((Function1 & Serializable)esheet -> {
            ExcelSchemaWriter$.$anonfun$generate$1(workbook, schema, esheet);
            return BoxedUnit.UNIT;
        });
        workbook.write(os);
        os.close();
    }

    private boolean addRefValidation(ExcelSchema schema, Sheet sheet, XSSFDataValidationHelper helper, ExcelColumn col, int startRowIdx, int columnIdx) {
        BooleanRef finded = BooleanRef.create((boolean)false);
        schema.sheets().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ExcelSchemaWriter$.$anonfun$addRefValidation$1(sheet, x$2))).foreach((Function1 & Serializable)codeSheet -> {
            ExcelSchemaWriter$.$anonfun$addRefValidation$2(finded, col, helper, startRowIdx, columnIdx, sheet, codeSheet);
            return BoxedUnit.UNIT;
        });
        return finded.elem;
    }

    private Cell writeColumnRemark(Sheet sheet, String content, Row row, int columnIdx) {
        Cell cell = row.createCell(columnIdx);
        int newLines = Strings$.MODULE$.count(content, "\n");
        if (newLines > 1) {
            row.setHeightInPoints((float)(newLines + 1) * sheet.getDefaultRowHeightInPoints());
        }
        cell.setCellValue(content);
        return cell;
    }

    private Cell writeColumn(Sheet sheet, String content, Row row, int columnIdx, boolean required) {
        Cell cell = row.createCell(columnIdx);
        if (required) {
            cell.setCellValue(new StringBuilder(1).append("*").append(content).toString());
        } else {
            cell.setCellValue(content);
        }
        return cell;
    }

    private Cell writeRow(Sheet sheet, String content, int rowIdx, int colSpan) {
        CellRangeAddress mergedRegion = new CellRangeAddress(rowIdx, rowIdx, 0, colSpan - 1);
        sheet.addMergedRegion(mergedRegion);
        Row row = sheet.createRow(rowIdx);
        Cell cell = row.createCell(0);
        int newLines = Strings$.MODULE$.count(content, "\n");
        if (newLines > 1) {
            row.setHeightInPoints((float)(newLines + 1) * sheet.getDefaultRowHeightInPoints());
            CellStyle cs = sheet.getWorkbook().createCellStyle();
            cs.setWrapText(true);
            cell.setCellStyle(cs);
        }
        cell.setCellValue(content);
        return cell;
    }

    /*
     * WARNING - void declaration
     */
    private CellStyle getRemarkStyle(Workbook wb) {
        void var2_2;
        CellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(true);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private CellStyle getTitleStyle(Workbook wb) {
        void var2_2;
        CellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        Font font = wb.createFont();
        font.setFontHeightInPoints((short)20);
        font.setFontName("\u5b8b\u4f53");
        font.setItalic(false);
        font.setBold(true);
        style.setFont(font);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private CellStyle getColumnStyle(Workbook wb, boolean required) {
        void var3_3;
        XSSFCellStyle style = (XSSFCellStyle)wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        byte[] rgb = new byte[]{(byte)221, (byte)217, (byte)196};
        style.setFillForegroundColor(new XSSFColor(rgb, (IndexedColorMap)new DefaultIndexedColorMap()));
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        XSSFFont font = (XSSFFont)wb.createFont();
        font.setBold(true);
        if (required) {
            font.setColor(IndexedColors.RED.index);
        }
        style.setFont((Font)font);
        return var3_3;
    }

    public static final /* synthetic */ void $anonfun$generate$2(XSSFSheet sheet$1, IntRef rowIdx$1, ExcelScheet esheet$1, XSSFWorkbook workbook$1, String title) {
        Cell cell = MODULE$.writeRow((Sheet)sheet$1, title, rowIdx$1.elem, esheet$1.columns().size());
        cell.setCellStyle(MODULE$.getTitleStyle((Workbook)workbook$1));
        ++rowIdx$1.elem;
    }

    public static final /* synthetic */ void $anonfun$generate$3(XSSFSheet sheet$1, IntRef rowIdx$1, ExcelScheet esheet$1, String remark) {
        MODULE$.writeRow((Sheet)sheet$1, remark, rowIdx$1.elem, esheet$1.columns().size());
        ++rowIdx$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$generate$4(ExcelColumn x$1) {
        return x$1.remark().nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$generate$8(XSSFDrawing drawing$1, int curColumnIdx$1, IntRef rowIdx$1, Cell cell$1, String c) {
        XSSFComment comment = drawing$1.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, curColumnIdx$1, rowIdx$1.elem, curColumnIdx$1, rowIdx$1.elem));
        comment.setString((RichTextString)new XSSFRichTextString(c));
        cell$1.setCellComment((Comment)comment);
    }

    public static final /* synthetic */ void $anonfun$generate$9(XSSFSheet sheet$1, IntRef dIdx$1, IntRef rowIdx$1, int curColumnIdx$1, String data) {
        XSSFRow dataRow = sheet$1.getRow(dIdx$1.elem + rowIdx$1.elem);
        if (dataRow == null) {
            dataRow = sheet$1.createRow(dIdx$1.elem + rowIdx$1.elem);
        }
        ++dIdx$1.elem;
        dataRow.createCell(curColumnIdx$1).setCellValue(data);
    }

    public static final /* synthetic */ Object $anonfun$generate$7(ExcelScheet esheet$1, XSSFSheet sheet$1, XSSFRow columnRow$1, XSSFDrawing drawing$1, IntRef rowIdx$1, CellStyle requiredStyle$1, CellStyle optionalStyle$1, XSSFDataValidationHelper dvHelper$1, ExcelSchema schema$1, int curColumnIdx) {
        Object object;
        ExcelColumn col = (ExcelColumn)esheet$1.columns().apply(curColumnIdx);
        Cell cell = MODULE$.writeColumn((Sheet)sheet$1, col.name(), (Row)columnRow$1, curColumnIdx, col.required());
        col.comment().foreach((Function1 & Serializable)c -> {
            ExcelSchemaWriter$.$anonfun$generate$8(drawing$1, curColumnIdx, rowIdx$1, cell, c);
            return BoxedUnit.UNIT;
        });
        if (col.required()) {
            cell.setCellStyle(requiredStyle$1);
        } else {
            cell.setCellStyle(optionalStyle$1);
        }
        if (col.datas() == null) {
            if (col.isInt()) {
                sheet$1.addValidationData(Constraints$.MODULE$.asNumeric(dvHelper$1, col, 1, rowIdx$1.elem + 1, curColumnIdx));
                object = BoxedUnit.UNIT;
            } else if (col.isDecimal()) {
                sheet$1.addValidationData(Constraints$.MODULE$.asNumeric(dvHelper$1, col, 2, rowIdx$1.elem + 1, curColumnIdx));
                object = BoxedUnit.UNIT;
            } else if (col.date().nonEmpty()) {
                sheet$1.addValidationData(Constraints$.MODULE$.asDate(dvHelper$1, col, rowIdx$1.elem + 1, curColumnIdx));
                object = BoxedUnit.UNIT;
            } else if (col.length().nonEmpty()) {
                String string = col.formular1();
                String string2 = "0";
                if (!(string != null ? !string.equals(string2) : string2 != null) && col.required()) {
                    col.formular1_$eq("1");
                }
                if (col.unique()) {
                    sheet$1.addValidationData(Constraints$.MODULE$.asUnique(dvHelper$1, col, rowIdx$1.elem + 1, curColumnIdx));
                    object = BoxedUnit.UNIT;
                } else {
                    sheet$1.addValidationData(Constraints$.MODULE$.asNumeric(dvHelper$1, col, 6, rowIdx$1.elem + 1, curColumnIdx));
                    object = BoxedUnit.UNIT;
                }
            } else if (col.isBool()) {
                sheet$1.addValidationData(Constraints$.MODULE$.asBoolean(dvHelper$1, col, rowIdx$1.elem + 1, curColumnIdx));
                object = BoxedUnit.UNIT;
            } else {
                object = col.refs() != null && col.refs().nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)MODULE$.addRefValidation(schema$1, (Sheet)sheet$1, dvHelper$1, col, rowIdx$1.elem + 1, curColumnIdx)) : BoxedUnit.UNIT;
            }
        } else {
            IntRef dIdx = IntRef.create((int)1);
            col.datas().foreach((Function1 & Serializable)data -> {
                ExcelSchemaWriter$.$anonfun$generate$9(sheet$1, dIdx, rowIdx$1, curColumnIdx, data);
                return BoxedUnit.UNIT;
            });
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public static final /* synthetic */ void $anonfun$generate$1(XSSFWorkbook workbook$1, ExcelSchema schema$1, ExcelScheet esheet) {
        XSSFSheet sheet = workbook$1.createSheet(esheet.name());
        sheet.setDefaultColumnWidth(15);
        IntRef rowIdx = IntRef.create((int)0);
        esheet.title().foreach((Function1 & Serializable)title -> {
            ExcelSchemaWriter$.$anonfun$generate$2(sheet, rowIdx, esheet, workbook$1, title);
            return BoxedUnit.UNIT;
        });
        esheet.remark().foreach((Function1 & Serializable)remark -> {
            ExcelSchemaWriter$.$anonfun$generate$3(sheet, rowIdx, esheet, remark);
            return BoxedUnit.UNIT;
        });
        boolean existsColumnRemark = esheet.columns().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ExcelSchemaWriter$.$anonfun$generate$4(x$1)));
        if (existsColumnRemark) {
            XSSFRow remarkRow = sheet.createRow(rowIdx.elem);
            CellStyle remarkStyle = MODULE$.getRemarkStyle((Workbook)workbook$1);
            ++rowIdx.elem;
            esheet.columns().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                ExcelColumn col = (ExcelColumn)esheet.columns().apply(i);
                Cell cell = MODULE$.writeColumnRemark((Sheet)sheet, (String)col.remark().getOrElse((Function0 & Serializable)() -> ""), (Row)remarkRow, i);
                cell.setCellStyle(remarkStyle);
            });
        }
        XSSFRow columnRow = sheet.createRow(rowIdx.elem);
        CellStyle optionalStyle = MODULE$.getColumnStyle((Workbook)workbook$1, false);
        CellStyle requiredStyle = MODULE$.getColumnStyle((Workbook)workbook$1, true);
        XSSFDrawing drawing = sheet.createDrawingPatriarch();
        XSSFDataValidationHelper dvHelper = new XSSFDataValidationHelper(sheet);
        esheet.columns().indices().foreach((Function1 & Serializable)curColumnIdx -> ExcelSchemaWriter$.$anonfun$generate$7(esheet, sheet, columnRow, drawing, rowIdx, requiredStyle, optionalStyle, dvHelper, schema$1, BoxesRunTime.unboxToInt((Object)curColumnIdx)));
    }

    public static final /* synthetic */ boolean $anonfun$addRefValidation$1(Sheet sheet$2, ExcelScheet x$2) {
        String string = x$2.name();
        String string2 = sheet$2.getSheetName();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$addRefValidation$3(BooleanRef finded$1, ExcelColumn c) {
        return !finded$1.elem;
    }

    public static final /* synthetic */ void $anonfun$addRefValidation$4(ExcelColumn col$1, BooleanRef finded$1, IntRef codeColIdx$1, ExcelColumn c) {
        Seq<String> seq = c.datas();
        Seq<String> seq2 = col$1.refs();
        if (!(seq != null ? !seq.equals(seq2) : seq2 != null)) {
            finded$1.elem = true;
        }
        ++codeColIdx$1.elem;
    }

    public static final /* synthetic */ void $anonfun$addRefValidation$2(BooleanRef finded$1, ExcelColumn col$1, XSSFDataValidationHelper helper$1, int startRowIdx$1, int columnIdx$1, Sheet sheet$2, ExcelScheet codeSheet) {
        block0: {
            IntRef codeColIdx = IntRef.create((int)65);
            codeSheet.columns().withFilter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)ExcelSchemaWriter$.$anonfun$addRefValidation$3(finded$1, c))).foreach((Function1 & Serializable)c -> {
                ExcelSchemaWriter$.$anonfun$addRefValidation$4(col$1, finded$1, codeColIdx, c);
                return BoxedUnit.UNIT;
            });
            if (!finded$1.elem) break block0;
            char refColumn = (char)(codeColIdx.elem - 1);
            String formular = new StringBuilder(7).append(codeSheet.name()).append("!$").append(refColumn).append("$2:$").append(refColumn).append("$").append(col$1.refs().size() + 1).toString();
            DataValidation validation = Constraints$.MODULE$.asFormular(helper$1, formular, col$1, startRowIdx$1, columnIdx$1, new StringBuilder(6).append("\u8bf7\u9009\u62e9\u5408\u9002\u7684").append(col$1.name()).toString());
            sheet$2.addValidationData(validation);
        }
    }

    private ExcelSchemaWriter$() {
    }
}

