/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.transfer.excel;

import java.io.InputStream;
import java.io.Serializable;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.transfer.Format$;
import org.beangle.data.transfer.excel.CellOps$;
import org.beangle.data.transfer.excel.ExcelItemReader$;
import org.beangle.data.transfer.io.Attribute;
import org.beangle.data.transfer.io.DataType$;
import org.beangle.data.transfer.io.ItemReader;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005=d\u0001B\r\u001b\u0001\u0015B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"Aa\t\u0001BC\u0002\u0013\u0005q\t\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003I\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u001dI\u0006A1A\u0005\niCaa\u001a\u0001!\u0002\u0013Y\u0006b\u00025\u0001\u0001\u0004%I!\u001b\u0005\bU\u0002\u0001\r\u0011\"\u0003l\u0011\u0019\t\b\u0001)Q\u0005\u0007\"I!\u000f\u0001a\u0001\u0002\u0004%Ia\u001d\u0005\f\u0003\u000f\u0001\u0001\u0019!a\u0001\n\u0013\tI\u0001\u0003\u0006\u0002\u000e\u0001\u0001\r\u0011!Q!\nQDq!a\u0004\u0001\t\u0013\t\t\u0002C\u0004\u0002\u0018\u0001!\t%!\u0007\t\u000f\u0005]\u0001\u0001\"\u0005\u0002\u001c!9\u00111\u0005\u0001\u0005B\u0005\u0015\u0002bBA\u001a\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003\u000b\u0002A\u0011IA$\u000f%\tIEGA\u0001\u0012\u0003\tYE\u0002\u0005\u001a5\u0005\u0005\t\u0012AA'\u0011\u0019\u0011V\u0003\"\u0001\u0002P!I\u0011\u0011K\u000b\u0012\u0002\u0013\u0005\u00111\u000b\u0005\n\u0003S*\u0012\u0013!C\u0001\u0003W\u0012q\"\u0012=dK2LE/Z7SK\u0006$WM\u001d\u0006\u00037q\tQ!\u001a=dK2T!!\b\u0010\u0002\u0011Q\u0014\u0018M\\:gKJT!a\b\u0011\u0002\t\u0011\fG/\u0019\u0006\u0003C\t\nqAY3b]\u001edWMC\u0001$\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0005\f\u001a\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r\u0005s\u0017PU3g!\ti\u0003'D\u0001/\u0015\tyC$\u0001\u0002j_&\u0011\u0011G\f\u0002\u000b\u0013R,WNU3bI\u0016\u0014\bCA\u001a9\u001b\u0005!$BA\u001b7\u0003\u001dawnZ4j]\u001eT!a\u000e\u0011\u0002\u000f\r|W.\\8og&\u0011\u0011\b\u000e\u0002\b\u0019><w-\u001b8h\u0003\tI7\u000f\u0005\u0002=\u00016\tQH\u0003\u00020})\tq(\u0001\u0003kCZ\f\u0017BA!>\u0005-Ie\u000e];u'R\u0014X-Y7\u0002\u0011MDW-\u001a;Ok6\u0004\"a\n#\n\u0005\u0015C#aA%oi\u00061am\u001c:nCR,\u0012\u0001\u0013\t\u0003\u00136s!AS&\u000e\u0003qI!\u0001\u0014\u000f\u0002\r\u0019{'/\\1u\u0013\tquJA\u0003WC2,X-\u0003\u0002QQ\tYQI\\;nKJ\fG/[8o\u0003\u001d1wN]7bi\u0002\na\u0001P5oSRtD\u0003\u0002+W/b\u0003\"!\u0016\u0001\u000e\u0003iAQAO\u0003A\u0002mBqAQ\u0003\u0011\u0002\u0003\u00071\tC\u0004G\u000bA\u0005\t\u0019\u0001%\u0002\u000bMDW-\u001a;\u0016\u0003m\u0003\"\u0001X3\u000e\u0003uS!AX0\u0002\u0013U\u001cXM]7pI\u0016d'B\u00011b\u0003\t\u00198O\u0003\u0002cG\u0006\u0019\u0001o\\5\u000b\u0005\u0011\u0014\u0013AB1qC\u000eDW-\u0003\u0002g;\n)1\u000b[3fi\u000611\u000f[3fi\u0002\nA\"\u001b8eKbLen\u00155fKR,\u0012aQ\u0001\u0011S:$W\r_%o'\",W\r^0%KF$\"\u0001\\8\u0011\u0005\u001dj\u0017B\u00018)\u0005\u0011)f.\u001b;\t\u000fAL\u0011\u0011!a\u0001\u0007\u0006\u0019\u0001\u0010J\u0019\u0002\u001b%tG-\u001a=J]NCW-\u001a;!\u0003\u0015\tG\u000f\u001e:t+\u0005!\b\u0003B;~\u0003\u0003q!A^>\u000f\u0005]TX\"\u0001=\u000b\u0005e$\u0013A\u0002\u001fs_>$h(C\u0001*\u0013\ta\b&A\u0004qC\u000e\\\u0017mZ3\n\u0005y|(\u0001\u0002'jgRT!\u0001 \u0015\u0011\u00075\n\u0019!C\u0002\u0002\u00069\u0012\u0011\"\u0011;ue&\u0014W\u000f^3\u0002\u0013\u0005$HO]:`I\u0015\fHc\u00017\u0002\f!9\u0001\u000fDA\u0001\u0002\u0004!\u0018AB1uiJ\u001c\b%\u0001\u0006ck&dGm\u00155fKR$RaWA\n\u0003+AQA\u000f\bA\u0002mBQA\u0011\bA\u0002\r\u000baB]3bI\u0006#HO]5ckR,7\u000fF\u0001u)\u0015!\u0018QDA\u0010\u0011\u0015I\u0006\u00031\u0001\\\u0011\u0019\t\t\u0003\u0005a\u0001\u0007\u0006A!o\\<J]\u0012,\u00070\u0001\u0003sK\u0006$GCAA\u0014!\u00159\u0013\u0011FA\u0017\u0013\r\tY\u0003\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004O\u0005=\u0012bAA\u0019Q\t\u0019\u0011I\\=\u0002\u0019\u001d,GoQ3mYZ\u000bG.^3\u0015\r\u00055\u0012qGA!\u0011\u001d\tID\u0005a\u0001\u0003w\tAaY3mYB\u0019A,!\u0010\n\u0007\u0005}RL\u0001\u0003DK2d\u0007bBA\"%\u0001\u0007\u0011\u0011A\u0001\nCR$(/\u001b2vi\u0016\fQa\u00197pg\u0016$\u0012\u0001\\\u0001\u0010\u000bb\u001cW\r\\%uK6\u0014V-\u00193feB\u0011Q+F\n\u0003+\u0019\"\"!a\u0013\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t)FK\u0002D\u0003/Z#!!\u0017\u0011\t\u0005m\u0013QM\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003GB\u0013AC1o]>$\u0018\r^5p]&!\u0011qMA/\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u00055$f\u0001%\u0002X\u0001")
public class ExcelItemReader
implements ItemReader,
Logging {
    private final Enumeration.Value format;
    private final Sheet sheet;
    private int indexInSheet;
    private List<Attribute> attrs;
    private Logger logger;

    public static Enumeration.Value $lessinit$greater$default$3() {
        return ExcelItemReader$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return ExcelItemReader$.MODULE$.$lessinit$greater$default$2();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Enumeration.Value format() {
        return this.format;
    }

    private Sheet sheet() {
        return this.sheet;
    }

    private int indexInSheet() {
        return this.indexInSheet;
    }

    private void indexInSheet_$eq(int x$1) {
        this.indexInSheet = x$1;
    }

    private List<Attribute> attrs() {
        return this.attrs;
    }

    private void attrs_$eq(List<Attribute> x$1) {
        this.attrs = x$1;
    }

    private Sheet buildSheet(InputStream is, int sheetNum) {
        HSSFSheet hSSFSheet;
        Enumeration.Value value = this.format();
        Enumeration.Value value2 = Format$.MODULE$.Xls();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            hSSFSheet = new HSSFWorkbook(is).getSheetAt(sheetNum);
        } else {
            Enumeration.Value value4 = Format$.MODULE$.Xlsx();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                hSSFSheet = new XSSFWorkbook(is).getSheetAt(sheetNum);
            } else {
                throw new RuntimeException(new StringBuilder(28).append("Cannot support excel format ").append(this.format()).toString());
            }
        }
        return hSSFSheet;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Attribute> readAttributes() {
        void var2_2;
        int i;
        List<Attribute> attrs = List$.MODULE$.empty();
        for (i = 0; i < 10 && attrs.isEmpty(); ++i) {
            attrs = this.readAttributes(this.sheet(), i);
        }
        this.indexInSheet_$eq(i);
        this.attrs_$eq(attrs);
        return var2_2;
    }

    public List<Attribute> readAttributes(Sheet sheet, int rowIndex) {
        Row row = sheet.getRow(rowIndex);
        ListBuffer attrList = new ListBuffer();
        BooleanRef hasEmptyCell = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), (int)row.getLastCellNum()).withFilter((Function1)(JFunction1.mcZI.sp & Serializable)i -> !hasEmptyCell$1.elem).foreach((Function1 & Serializable)i -> ExcelItemReader.$anonfun$readAttributes$2(row, hasEmptyCell, attrList, BoxesRunTime.unboxToInt((Object)i)));
        return attrList.toList();
    }

    /*
     * WARNING - void declaration
     */
    public Object[] read() {
        Object[] objectArray;
        if (this.indexInSheet() > this.sheet().getLastRowNum()) {
            return null;
        }
        Row row = this.sheet().getRow(this.indexInSheet());
        this.indexInSheet_$eq(this.indexInSheet() + 1);
        int attrCount = this.attrs().size();
        if (row == null) {
            objectArray = new Object[attrCount];
        } else {
            void var3_3;
            Object[] values = new Object[attrCount];
            ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.genericArrayOps((Object)values)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)k -> {
                values$1[k] = this.getCellValue(row.getCell(k), (Attribute)this.attrs().apply(k));
            });
            objectArray = var3_3;
        }
        return objectArray;
    }

    public Object getCellValue(Cell cell, Attribute attribute) {
        if (cell == null) {
            return null;
        }
        return CellOps$.MODULE$.getValue$extension(CellOps$.MODULE$.toCell(cell), attribute.dataType());
    }

    @Override
    public void close() {
        this.sheet().getWorkbook().close();
    }

    public static final /* synthetic */ Object $anonfun$readAttributes$2(Row row$1, BooleanRef hasEmptyCell$1, ListBuffer attrList$1, int i) {
        BoxedUnit boxedUnit;
        Cell cell = row$1.getCell(i);
        Comment comment = cell.getCellComment();
        if (comment == null || Strings$.MODULE$.isEmpty((CharSequence)comment.getString().getString())) {
            hasEmptyCell$1.elem = true;
            boxedUnit = BoxedUnit.UNIT;
        } else {
            String commentStr = comment.getString().getString().trim();
            Enumeration.Value dataType = DataType$.MODULE$.String();
            if (commentStr.indexOf(58) > 0) {
                dataType = DataType$.MODULE$.withName(Strings$.MODULE$.substringAfterLast(commentStr, ":"));
                commentStr = Strings$.MODULE$.substringBefore(commentStr, ":");
            }
            boxedUnit = attrList$1.$plus$eq((Object)new Attribute(i + 1, commentStr.trim(), dataType, cell.getRichStringCellValue().getString()));
        }
        return boxedUnit;
    }

    public ExcelItemReader(InputStream is, int sheetNum, Enumeration.Value format) {
        this.format = format;
        Logging.$init$((Logging)this);
        this.sheet = this.buildSheet(is, sheetNum);
        this.indexInSheet = 1;
        Statics.releaseFence();
    }
}

