/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.transfer.excel;

import java.io.OutputStream;
import java.io.Serializable;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.transfer.excel.Constraints$;
import org.beangle.data.transfer.excel.ExcelColumn;
import org.beangle.data.transfer.excel.ExcelScheet;
import org.beangle.data.transfer.excel.ExcelSchema;
import scala.Function0;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;

public final class ExcelSchemaWriter$ {
    public static final ExcelSchemaWriter$ MODULE$ = new ExcelSchemaWriter$();

    public void generate(ExcelSchema schema, OutputStream os) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        schema.sheets().foreach((Function1 & Serializable)esheet -> {
            ExcelSchemaWriter$.$anonfun$generate$1(workbook, schema, esheet);
            return BoxedUnit.UNIT;
        });
        workbook.write(os);
        os.close();
    }

    private void setDefaultStyle(Sheet sheet, Map<String, CellStyle> defaults, int columnIdx, String format) {
        CellStyle style = (CellStyle)defaults.getOrElseUpdate((Object)format, (Function0 & Serializable)() -> {
            void var2_2;
            CellStyle s = sheet.getWorkbook().createCellStyle();
            DataFormat df = sheet.getWorkbook().createDataFormat();
            s.setDataFormat(df.getFormat(format));
            return var2_2;
        });
        sheet.setDefaultColumnStyle(columnIdx, style);
    }

    private boolean addRefValidation(ExcelSchema schema, Sheet sheet, XSSFDataValidationHelper helper, ExcelColumn col, int startRowIdx, int columnIdx) {
        BooleanRef finded = BooleanRef.create((boolean)false);
        schema.sheets().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ExcelSchemaWriter$.$anonfun$addRefValidation$1(sheet, x$2))).foreach((Function1 & Serializable)codeSheet -> {
            ExcelSchemaWriter$.$anonfun$addRefValidation$2(finded, col, helper, startRowIdx, columnIdx, sheet, codeSheet);
            return BoxedUnit.UNIT;
        });
        return finded.elem;
    }

    private Cell writeColumnRemark(Sheet sheet, String content, Row row, int columnIdx) {
        float newHeight;
        Cell cell = row.createCell(columnIdx);
        int newLines = Strings$.MODULE$.count(content.trim(), "\n");
        if (newLines > 0 && (newHeight = (float)(newLines + 1) * sheet.getDefaultRowHeightInPoints()) > row.getHeightInPoints()) {
            row.setHeightInPoints(newHeight);
        }
        cell.setCellValue(content);
        return cell;
    }

    private Cell writeColumn(Sheet sheet, String content, Row row, int columnIdx, boolean required) {
        Cell cell = row.createCell(columnIdx);
        if (required) {
            cell.setCellValue(new StringBuilder(1).append("*").append(content).toString());
        } else {
            cell.setCellValue(content);
        }
        return cell;
    }

    private Cell writeRow(Sheet sheet, String content, int rowIdx, int colSpan) {
        CellRangeAddress mergedRegion = new CellRangeAddress(rowIdx, rowIdx, 0, colSpan - 1);
        sheet.addMergedRegion(mergedRegion);
        Row row = sheet.createRow(rowIdx);
        Cell cell = row.createCell(0);
        int newLines = Strings$.MODULE$.count(content.trim(), "\n");
        if (newLines > 0) {
            row.setHeightInPoints((float)(newLines + 1) * sheet.getDefaultRowHeightInPoints());
        }
        cell.setCellValue(content);
        return cell;
    }

    /*
     * WARNING - void declaration
     */
    private CellStyle getRemarkStyle(Workbook wb) {
        void var2_2;
        CellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(true);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private CellStyle getTitleStyle(Workbook wb) {
        void var2_2;
        CellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(true);
        Font font = wb.createFont();
        font.setFontHeightInPoints((short)15);
        font.setFontName("\u5b8b\u4f53");
        font.setItalic(false);
        font.setBold(true);
        style.setFont(font);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private CellStyle getColumnRemarkStyle(Workbook wb) {
        void var2_2;
        XSSFCellStyle style = (XSSFCellStyle)wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(true);
        style.setFillForegroundColor(IndexedColors.AUTOMATIC.index);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private CellStyle getColumnTitleStyle(Workbook wb, boolean required) {
        void var3_3;
        XSSFCellStyle style = (XSSFCellStyle)wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        byte[] rgb = new byte[]{(byte)221, (byte)217, (byte)196};
        style.setFillForegroundColor(new XSSFColor(rgb, (IndexedColorMap)new DefaultIndexedColorMap()));
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        XSSFFont font = (XSSFFont)wb.createFont();
        font.setBold(true);
        if (required) {
            font.setColor(IndexedColors.RED.index);
        }
        style.setFont((Font)font);
        return var3_3;
    }

    public static final /* synthetic */ void $anonfun$generate$2(XSSFSheet sheet$1, IntRef rowIdx$1, ExcelScheet esheet$1, XSSFWorkbook workbook$1, String title) {
        Cell cell = MODULE$.writeRow((Sheet)sheet$1, title, rowIdx$1.elem, esheet$1.columns().size());
        cell.getRow().setHeightInPoints(15.0f);
        cell.setCellStyle(MODULE$.getTitleStyle((Workbook)workbook$1));
        ++rowIdx$1.elem;
    }

    public static final /* synthetic */ void $anonfun$generate$3(XSSFSheet sheet$1, IntRef rowIdx$1, ExcelScheet esheet$1, XSSFWorkbook workbook$1, String remark) {
        Cell cell = MODULE$.writeRow((Sheet)sheet$1, remark, rowIdx$1.elem, esheet$1.columns().size());
        cell.setCellStyle(MODULE$.getRemarkStyle((Workbook)workbook$1));
        ++rowIdx$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$generate$4(ExcelColumn x$1) {
        return x$1.remark().nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$generate$8(XSSFDrawing drawing$1, int curColumnIdx$1, IntRef rowIdx$1, ExcelColumn col$1, Cell cell$1, String c) {
        XSSFComment comment = drawing$1.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, curColumnIdx$1, rowIdx$1.elem, curColumnIdx$1, rowIdx$1.elem));
        comment.setString((RichTextString)new XSSFRichTextString(new StringBuilder(1).append(c).append(":").append(col$1.dataType()).toString()));
        cell$1.setCellComment((Comment)comment);
        comment.setVisible(false);
    }

    public static final /* synthetic */ void $anonfun$generate$11(XSSFSheet sheet$1, IntRef dIdx$1, IntRef rowIdx$1, int curColumnIdx$1, String data) {
        XSSFRow dataRow = sheet$1.getRow(dIdx$1.elem + rowIdx$1.elem);
        if (dataRow == null) {
            dataRow = sheet$1.createRow(dIdx$1.elem + rowIdx$1.elem);
        }
        ++dIdx$1.elem;
        dataRow.createCell(curColumnIdx$1).setCellValue(data);
    }

    public static final /* synthetic */ void $anonfun$generate$1(XSSFWorkbook workbook$1, ExcelSchema schema$1, ExcelScheet esheet) {
        XSSFSheet sheet = workbook$1.createSheet(esheet.name());
        sheet.setDefaultColumnWidth(15);
        IntRef rowIdx = IntRef.create((int)0);
        esheet.title().foreach((Function1 & Serializable)title -> {
            ExcelSchemaWriter$.$anonfun$generate$2(sheet, rowIdx, esheet, workbook$1, title);
            return BoxedUnit.UNIT;
        });
        esheet.remark().foreach((Function1 & Serializable)remark -> {
            ExcelSchemaWriter$.$anonfun$generate$3(sheet, rowIdx, esheet, workbook$1, remark);
            return BoxedUnit.UNIT;
        });
        boolean existsColumnRemark = esheet.columns().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ExcelSchemaWriter$.$anonfun$generate$4(x$1)));
        if (existsColumnRemark) {
            XSSFRow remarkRow = sheet.createRow(rowIdx.elem);
            CellStyle remarkStyle = MODULE$.getColumnRemarkStyle((Workbook)workbook$1);
            ++rowIdx.elem;
            esheet.columns().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                ExcelColumn col = (ExcelColumn)esheet.columns().apply(i);
                Cell cell = MODULE$.writeColumnRemark((Sheet)sheet, (String)col.remark().getOrElse((Function0 & Serializable)() -> ""), (Row)remarkRow, i);
                cell.setCellStyle(remarkStyle);
            });
        }
        Map defaultStyles = Collections$.MODULE$.newMap();
        XSSFRow columnRow = sheet.createRow(rowIdx.elem);
        CellStyle optionalStyle = MODULE$.getColumnTitleStyle((Workbook)workbook$1, false);
        CellStyle requiredStyle = MODULE$.getColumnTitleStyle((Workbook)workbook$1, true);
        XSSFDrawing drawing = sheet.createDrawingPatriarch();
        XSSFDataValidationHelper dvHelper = new XSSFDataValidationHelper(sheet);
        esheet.columns().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)curColumnIdx -> {
            ExcelColumn col = (ExcelColumn)esheet.columns().apply(curColumnIdx);
            Cell cell = MODULE$.writeColumn((Sheet)sheet, col.name(), (Row)columnRow, curColumnIdx, col.required());
            col.comment().foreach((Function1 & Serializable)c -> {
                ExcelSchemaWriter$.$anonfun$generate$8(drawing, curColumnIdx, rowIdx, col, cell, c);
                return BoxedUnit.UNIT;
            });
            if (col.required()) {
                cell.setCellStyle(requiredStyle);
            } else {
                cell.setCellStyle(optionalStyle);
            }
            if (col.datas() == null) {
                if (col.isInt()) {
                    sheet.addValidationData(Constraints$.MODULE$.asNumeric(dvHelper, col, 1, rowIdx$1.elem + 1, curColumnIdx));
                    MODULE$.setDefaultStyle((Sheet)sheet, (Map<String, CellStyle>)defaultStyles, curColumnIdx, (String)col.format().getOrElse((Function0 & Serializable)() -> "0"));
                } else if (col.isDecimal()) {
                    sheet.addValidationData(Constraints$.MODULE$.asNumeric(dvHelper, col, 2, rowIdx$1.elem + 1, curColumnIdx));
                    MODULE$.setDefaultStyle((Sheet)sheet, (Map<String, CellStyle>)defaultStyles, curColumnIdx, (String)col.format().getOrElse((Function0 & Serializable)() -> "General"));
                } else if (col.isDate()) {
                    sheet.addValidationData(Constraints$.MODULE$.asDate(dvHelper, col, rowIdx$1.elem + 1, curColumnIdx));
                    MODULE$.setDefaultStyle((Sheet)sheet, (Map<String, CellStyle>)defaultStyles, curColumnIdx, (String)col.format().get());
                } else if (col.length().nonEmpty()) {
                    String string = col.formular1();
                    String string2 = "0";
                    if (!(string != null ? !string.equals(string2) : string2 != null) && col.required()) {
                        col.formular1_$eq("1");
                    }
                    if (col.unique()) {
                        sheet.addValidationData(Constraints$.MODULE$.asUnique(dvHelper, col, rowIdx$1.elem + 1, curColumnIdx));
                    } else {
                        sheet.addValidationData(Constraints$.MODULE$.asNumeric(dvHelper, col, 6, rowIdx$1.elem + 1, curColumnIdx));
                    }
                    MODULE$.setDefaultStyle((Sheet)sheet, (Map<String, CellStyle>)defaultStyles, curColumnIdx, "@");
                } else if (col.isBool()) {
                    sheet.addValidationData(Constraints$.MODULE$.asBoolean(dvHelper, col, rowIdx$1.elem + 1, curColumnIdx));
                } else if (col.refs() != null && col.refs().nonEmpty()) {
                    MODULE$.addRefValidation(schema$1, (Sheet)sheet, dvHelper, col, rowIdx$1.elem + 1, curColumnIdx);
                    MODULE$.setDefaultStyle((Sheet)sheet, (Map<String, CellStyle>)defaultStyles, curColumnIdx, "@");
                }
            } else {
                IntRef dIdx = IntRef.create((int)1);
                col.datas().foreach((Function1 & Serializable)data -> {
                    ExcelSchemaWriter$.$anonfun$generate$11(sheet, dIdx, rowIdx, curColumnIdx, data);
                    return BoxedUnit.UNIT;
                });
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$addRefValidation$1(Sheet sheet$3, ExcelScheet x$2) {
        String string = x$2.name();
        String string2 = sheet$3.getSheetName();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$addRefValidation$3(BooleanRef finded$1, ExcelColumn c) {
        return !finded$1.elem;
    }

    public static final /* synthetic */ void $anonfun$addRefValidation$4(ExcelColumn col$2, BooleanRef finded$1, IntRef codeColIdx$1, ExcelColumn c) {
        Seq<String> seq = c.datas();
        Seq<String> seq2 = col$2.refs();
        if (!(seq != null ? !seq.equals(seq2) : seq2 != null)) {
            finded$1.elem = true;
        }
        ++codeColIdx$1.elem;
    }

    public static final /* synthetic */ void $anonfun$addRefValidation$2(BooleanRef finded$1, ExcelColumn col$2, XSSFDataValidationHelper helper$1, int startRowIdx$1, int columnIdx$1, Sheet sheet$3, ExcelScheet codeSheet) {
        block0: {
            IntRef codeColIdx = IntRef.create((int)65);
            codeSheet.columns().withFilter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)ExcelSchemaWriter$.$anonfun$addRefValidation$3(finded$1, c))).foreach((Function1 & Serializable)c -> {
                ExcelSchemaWriter$.$anonfun$addRefValidation$4(col$2, finded$1, codeColIdx, c);
                return BoxedUnit.UNIT;
            });
            if (!finded$1.elem) break block0;
            char refColumn = (char)(codeColIdx.elem - 1);
            String formular = new StringBuilder(7).append(codeSheet.name()).append("!$").append(refColumn).append("$2:$").append(refColumn).append("$").append(col$2.refs().size() + 1).toString();
            DataValidation validation = Constraints$.MODULE$.asFormular(helper$1, formular, col$2, startRowIdx$1, columnIdx$1, new StringBuilder(6).append("\u8bf7\u9009\u62e9\u5408\u9002\u7684").append(col$2.name()).toString());
            sheet$3.addValidationData(validation);
        }
    }

    private ExcelSchemaWriter$() {
    }
}

