/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.transfer.excel;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.beangle.data.transfer.excel.ExcelColumn;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Constraints$ {
    public static final Constraints$ MODULE$ = new Constraints$();

    public DataValidation asBoolean(XSSFDataValidationHelper helper, ExcelColumn col, int startRowIdx, int columnIdx) {
        DataValidationConstraint constraint = helper.createExplicitListConstraint((String[])((Object[])new String[]{"Y", "N"}));
        DataValidation v = this.createValidation(helper, col, startRowIdx, columnIdx, constraint, "\u8bf7\u9009\u62e9Y/N");
        v.setSuppressDropDownArrow(true);
        return v;
    }

    public DataValidation asFormular(XSSFDataValidationHelper helper, String formular, ExcelColumn col, int startRowIdx, int columnIdx, String prompt) {
        DataValidationConstraint constraint = helper.createFormulaListConstraint(formular);
        DataValidation validation = this.createValidation(helper, col, startRowIdx, columnIdx, constraint, new StringBuilder(6).append("\u8bf7\u9009\u62e9\u5408\u9002\u7684").append(col.name()).toString());
        validation.setSuppressDropDownArrow(true);
        return validation;
    }

    public DataValidation asDate(XSSFDataValidationHelper helper, ExcelColumn col, int startRowIdx, int columnIdx) {
        String prompt = null;
        DataValidationConstraint constraint = null;
        String format = (String)col.format().get();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String formual1Value = ((Object)BoxesRunTime.boxToDouble((double)DateUtil.getExcelDate((Date)sdf.parse(col.formular1())))).toString();
        String lf = format.toLowerCase();
        String cellContent = lf.contains("yyyy") ? (lf.contains("hh") ? "\u65e5\u671f\u65f6\u95f4" : "\u65e5\u671f") : "\u65f6\u95f4";
        Option<String> option = col.formular2();
        if (None$.MODULE$.equals(option)) {
            constraint = helper.createDateConstraint(6, formual1Value, null, format);
            prompt = this.composeError(cellContent, col.formular1(), (Option<String>)None$.MODULE$, this.composeError$default$4());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String f2 = (String)some.value();
            String formual2Value = ((Object)BoxesRunTime.boxToDouble((double)DateUtil.getExcelDate((Date)sdf.parse(f2)))).toString();
            constraint = helper.createDateConstraint(0, formual1Value, formual2Value, format);
            prompt = this.composeError(cellContent, col.formular1(), col.formular2(), this.composeError$default$4());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        return this.createValidation(helper, col, startRowIdx, columnIdx, constraint, prompt);
    }

    public DataValidation asNumeric(XSSFDataValidationHelper helper, ExcelColumn col, int validationType, int startRowIdx, int columnIdx) {
        String string;
        String prompt = null;
        DataValidationConstraint constraint = null;
        String unit = "\u503c";
        int n = validationType;
        switch (n) {
            case 1: {
                string = "\u6574\u6570";
                break;
            }
            case 2: {
                string = "\u5c0f\u6570";
                break;
            }
            case 6: {
                unit = "\u957f\u5ea6";
                string = "\u6587\u672c";
                break;
            }
            default: {
                string = "";
                break;
            }
        }
        String dataType = string;
        Option<String> option = col.formular2();
        if (None$.MODULE$.equals(option)) {
            constraint = helper.createNumericConstraint(validationType, 6, col.formular1(), null);
            prompt = this.composeError(dataType, col.formular1(), (Option<String>)None$.MODULE$, this.composeError$default$4());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String f2 = (String)some.value();
            constraint = helper.createNumericConstraint(validationType, 0, col.formular1(), f2);
            prompt = this.composeError(dataType, col.formular1(), col.formular2(), unit);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        return this.createValidation(helper, col, startRowIdx, columnIdx, constraint, prompt);
    }

    public DataValidation asUnique(XSSFDataValidationHelper helper, ExcelColumn col, int startRowIdx, int columnIdx) {
        char cn = (char)(65 + columnIdx);
        int rn = startRowIdx + 1;
        String formular = new StringBuilder(15).append("COUNTIF($").append(cn).append("$").append(rn).append(":").append(cn).append(rn).append(",").append(cn).append(rn).append(")=1").toString();
        String error = "\u8be5\u5217\u4e0d\u5141\u8bb8\u6709\u91cd\u590d";
        if (col.length().nonEmpty()) {
            String cname = new StringBuilder(0).append(((Object)BoxesRunTime.boxToCharacter((char)cn)).toString()).append(((Object)BoxesRunTime.boxToInteger((int)rn)).toString()).toString();
            formular = new StringBuilder(30).append("AND(AND(LEN(").append(cname).append(") >= ").append(col.formular1()).append(",LEN(").append(cname).append(") <= ").append(col.length().get()).append("),").append(formular).append(")").toString();
            error = new StringBuilder(3).append(error).append(",\u5e76\u4e14").append(this.composeError("\u6587\u672c", col.formular1(), col.formular2(), "\u957f\u5ea6")).toString();
        }
        DataValidationConstraint constraint = helper.createCustomConstraint(new StringBuilder(1).append("=").append(formular).toString());
        CellRangeAddressList addressList = new CellRangeAddressList(startRowIdx, 1048575, columnIdx, columnIdx);
        DataValidation validation = helper.createValidation(constraint, addressList);
        validation.createErrorBox(new StringBuilder(4).append(col.name()).append("\u8f93\u5165\u9519\u8bef").toString(), error);
        validation.setShowErrorBox(true);
        validation.setShowPromptBox(true);
        validation.setSuppressDropDownArrow(true);
        return validation;
    }

    private DataValidation createValidation(XSSFDataValidationHelper helper, ExcelColumn col, int startRowIdx, int columnIdx, DataValidationConstraint constraint, String prompt) {
        CellRangeAddressList addressList = new CellRangeAddressList(startRowIdx, 1048575, columnIdx, columnIdx);
        DataValidation validation = helper.createValidation(constraint, addressList);
        validation.createErrorBox(new StringBuilder(4).append(col.name()).append("\u8f93\u5165\u6709\u8bef").toString(), prompt);
        validation.setShowErrorBox(true);
        validation.setSuppressDropDownArrow(false);
        validation.setEmptyCellAllowed(!col.required());
        return validation;
    }

    public String composeError(String what, String min, Option<String> max, String quantifier) {
        String string;
        Option<String> option = max;
        if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(8).append("\u8bf7\u8f93\u5165").append(quantifier).append("\u5927\u4e8e\u7b49\u4e8e").append(min).append("\u7684").append(what).toString();
        } else if (option instanceof Some) {
            String m;
            Some some = (Some)option;
            String string2 = m = (String)some.value();
            String string3 = min;
            string = !(string2 != null ? !string2.equals(string3) : string3 != null) ? new StringBuilder(5).append("\u8bf7\u8f93\u5165").append(quantifier).append("\u4e3a").append(min).append("\u7684").append(what).toString() : new StringBuilder(8).append("\u8bf7\u8f93\u5165").append(quantifier).append("\u5728").append(min).append("~").append(m).append("\u4e4b\u95f4\u7684").append(what).toString();
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public String composeError$default$4() {
        return "";
    }

    private Constraints$() {
    }
}

