/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.transfer.excel;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Calendar;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.beangle.commons.conversion.converter.String2BooleanConverter$;
import org.beangle.commons.lang.Dates$;
import org.beangle.commons.lang.Numbers$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.transfer.excel.CellOps;
import org.beangle.data.transfer.excel.ExcelStyleRegistry;
import org.beangle.data.transfer.io.DataType$;
import scala.Enumeration;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CellOps$ {
    public static final CellOps$ MODULE$ = new CellOps$();

    public Cell toCell(Cell x) {
        return x;
    }

    public final void fillin$extension(Cell $this, Object value, ExcelStyleRegistry registry) {
        Object v;
        Object object;
        Object object2 = value;
        if (object2 instanceof Some) {
            Object s;
            Some some = (Some)object2;
            object = s = some.value();
        } else {
            object = None$.MODULE$.equals(object2) ? null : value;
        }
        Object object3 = v = object;
        if (object3 == null) {
            this.fillBlank$extension($this);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object3 instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)object3;
            java.util.Date date2 = date;
            if (date2 instanceof Date) {
                Date date3 = (Date)date2;
                this.fill$extension($this, date3, registry);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (date2 instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)date2;
                this.fill$extension($this, timestamp, registry);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (date2 instanceof Time) {
                Time time = (Time)date2;
                this.fill$extension($this, time, registry);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.fill$extension($this, date, registry);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object3 instanceof Calendar) {
            Calendar calendar = (Calendar)object3;
            this.fill$extension($this, calendar.getTime(), registry);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object3 instanceof Temporal) {
            Temporal temporal = (Temporal)object3;
            Temporal temporal2 = temporal;
            if (temporal2 instanceof LocalDate) {
                LocalDate localDate = (LocalDate)temporal2;
                this.fill$extension($this, Date.valueOf(localDate), registry);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (temporal2 instanceof Instant) {
                Instant instant = (Instant)temporal2;
                this.fill$extension($this, java.util.Date.from(instant), registry);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (temporal2 instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)temporal2;
                this.fill$extension($this, java.util.Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant()), registry);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (temporal2 instanceof ZonedDateTime) {
                ZonedDateTime zonedDateTime = (ZonedDateTime)temporal2;
                this.fill$extension($this, java.util.Date.from(zonedDateTime.toInstant()), registry);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (temporal2 instanceof LocalTime) {
                LocalTime localTime = (LocalTime)temporal2;
                this.fill$extension($this, Time.valueOf(localTime), registry);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (temporal2 instanceof Year) {
                Year year = (Year)temporal2;
                this.fill$extension($this, year, registry);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (temporal2 instanceof YearMonth) {
                YearMonth yearMonth = (YearMonth)temporal2;
                this.fill$extension($this, yearMonth, registry);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)temporal2);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object3 instanceof MonthDay) {
            MonthDay monthDay = (MonthDay)object3;
            this.fill$extension($this, monthDay, registry);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object3 instanceof Number) {
            Number number = (Number)object3;
            Number number2 = number;
            if (number2 instanceof Integer) {
                Integer n = (Integer)number2;
                this.fill$extension($this, n, registry);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (number2 instanceof Float) {
                Float f = (Float)number2;
                this.fill$extension($this, f.floatValue(), registry);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (number2 instanceof Double) {
                Double d = (Double)number2;
                this.fill$extension($this, d, registry);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.fill$extension($this, number.intValue(), registry);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object3 instanceof Boolean) {
            Boolean bl = (Boolean)object3;
            this.fill$extension($this, bl, registry);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.fill$extension($this, v.toString(), registry);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public final Object getValue$extension(Cell $this) {
        Object object;
        CellType cellType = $this.getCellType();
        if (CellType.BLANK.equals(cellType)) {
            object = null;
        } else if (CellType.STRING.equals(cellType)) {
            object = Strings$.MODULE$.trim($this.getRichStringCellValue().getString());
        } else if (CellType.NUMERIC.equals(cellType)) {
            object = DateUtil.isCellDateFormatted((Cell)$this) ? $this.getDateCellValue() : BoxesRunTime.boxToDouble((double)$this.getNumericCellValue());
        } else if (CellType.BOOLEAN.equals(cellType)) {
            object = $this.getBooleanCellValue() ? BoxesRunTime.boxToBoolean((boolean)true) : BoxesRunTime.boxToBoolean((boolean)false);
        } else if (CellType.FORMULA.equals(cellType)) {
            CellType cellType2 = $this.getCachedFormulaResultType();
            Object object2 = CellType.STRING.equals(cellType2) ? Strings$.MODULE$.trim($this.getRichStringCellValue().getString()) : (CellType.NUMERIC.equals(cellType2) ? BoxesRunTime.boxToDouble((double)$this.getNumericCellValue()) : null);
            object = object2;
        } else {
            object = null;
        }
        return object;
    }

    public final Object getValue$extension(Cell $this, Enumeration.Value dataType) {
        Object object;
        Object object2 = this.getValue$extension($this);
        if (object2 == null) {
            object = null;
        } else if (object2 instanceof String) {
            String string = (String)object2;
            object = this.convert$extension($this, string, dataType);
        } else if (object2 instanceof Double) {
            Double d = (Double)object2;
            object = this.convert$extension($this, Predef$.MODULE$.Double2double(d), dataType);
        } else if (object2 instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)object2;
            object = this.convert$extension($this, date, dataType);
        } else if (object2 instanceof Object) {
            Object object3;
            object = object3 = object2;
        } else {
            throw new MatchError(object2);
        }
        return object;
    }

    public final Object convert$extension(Cell $this, String str, Enumeration.Value dataType) {
        Object object;
        Enumeration.Value value = dataType;
        Enumeration.Value value2 = DataType$.MODULE$.String();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            object = str;
        } else {
            Enumeration.Value value4 = DataType$.MODULE$.Short();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                object = Numbers$.MODULE$.convert2Short(str, Numbers$.MODULE$.convert2Short$default$2());
            } else {
                Enumeration.Value value6 = DataType$.MODULE$.Integer();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    object = Numbers$.MODULE$.convert2Int(str, Numbers$.MODULE$.convert2Int$default$2());
                } else {
                    Enumeration.Value value8 = DataType$.MODULE$.Long();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        object = Numbers$.MODULE$.convert2Long(str, Numbers$.MODULE$.convert2Long$default$2());
                    } else {
                        Enumeration.Value value10 = DataType$.MODULE$.Float();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            object = Numbers$.MODULE$.convert2Float(str, Numbers$.MODULE$.convert2Float$default$2());
                        } else {
                            Enumeration.Value value12 = DataType$.MODULE$.Double();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                object = Numbers$.MODULE$.convert2Double(str, Numbers$.MODULE$.convert2Double$default$2());
                            } else {
                                Enumeration.Value value14 = DataType$.MODULE$.Date();
                                Enumeration.Value value15 = value;
                                if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                                    object = LocalDate.parse(Dates$.MODULE$.normalize(str));
                                } else {
                                    Enumeration.Value value16 = DataType$.MODULE$.DateTime();
                                    Enumeration.Value value17 = value;
                                    if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
                                        object = LocalDateTime.parse(Dates$.MODULE$.normalize(str));
                                    } else {
                                        Enumeration.Value value18 = DataType$.MODULE$.Boolean();
                                        Enumeration.Value value19 = value;
                                        if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
                                            object = String2BooleanConverter$.MODULE$.apply(str);
                                        } else {
                                            Enumeration.Value value20 = DataType$.MODULE$.Time();
                                            Enumeration.Value value21 = value;
                                            if (!(value20 != null ? !value20.equals(value21) : value21 != null)) {
                                                object = LocalTime.parse(str);
                                            } else {
                                                Enumeration.Value value22 = DataType$.MODULE$.YearMonth();
                                                Enumeration.Value value23 = value;
                                                if (!(value22 != null ? !value22.equals(value23) : value23 != null)) {
                                                    object = YearMonth.parse(str.contains("-") ? new StringBuilder(1).append(str.substring(0, 4)).append("-").append(str.substring(4)).toString() : str);
                                                } else {
                                                    Enumeration.Value value24 = DataType$.MODULE$.MonthDay();
                                                    Enumeration.Value value25 = value;
                                                    if (!(value24 != null ? !value24.equals(value25) : value25 != null)) {
                                                        object = MonthDay.parse(str.startsWith("--") ? new StringBuilder(2).append("--").append(str).toString() : str);
                                                    } else {
                                                        throw new RuntimeException(new StringBuilder(35).append("convert string to ").append(dataType).append(" is not supported").toString());
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return object;
    }

    public final Object convert$extension(Cell $this, double d, Enumeration.Value dataType) {
        Object object;
        Enumeration.Value value = dataType;
        Enumeration.Value value2 = DataType$.MODULE$.String();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            object = ((Object)BoxesRunTime.boxToDouble((double)d)).toString();
        } else {
            Enumeration.Value value4 = DataType$.MODULE$.Short();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                object = BoxesRunTime.boxToShort((short)Predef$.MODULE$.double2Double(d).shortValue());
            } else {
                Enumeration.Value value6 = DataType$.MODULE$.Integer();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    object = BoxesRunTime.boxToInteger((int)Predef$.MODULE$.double2Double(d).intValue());
                } else {
                    Enumeration.Value value8 = DataType$.MODULE$.Long();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        object = BoxesRunTime.boxToLong((long)Predef$.MODULE$.double2Double(d).longValue());
                    } else {
                        Enumeration.Value value10 = DataType$.MODULE$.Float();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            object = BoxesRunTime.boxToFloat((float)Predef$.MODULE$.double2Double(d).floatValue());
                        } else {
                            Enumeration.Value value12 = DataType$.MODULE$.Double();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                object = BoxesRunTime.boxToDouble((double)d);
                            } else {
                                throw new RuntimeException(new StringBuilder(26).append("Cannot convert double to  ").append(dataType).toString());
                            }
                        }
                    }
                }
            }
        }
        return object;
    }

    public final Object convert$extension(Cell $this, java.util.Date d, Enumeration.Value dataType) {
        Object object;
        Enumeration.Value value = dataType;
        Enumeration.Value value2 = DataType$.MODULE$.String();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            object = new Date(d.getTime()).toLocalDate().toString();
        } else {
            Enumeration.Value value4 = DataType$.MODULE$.Date();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                object = new Date(d.getTime()).toLocalDate();
            } else {
                Enumeration.Value value6 = DataType$.MODULE$.DateTime();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    object = d.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                } else {
                    Enumeration.Value value8 = DataType$.MODULE$.Time();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        object = d.toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
                    } else {
                        Enumeration.Value value10 = DataType$.MODULE$.YearMonth();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            object = YearMonth.from(new Date(d.getTime()).toLocalDate());
                        } else {
                            Enumeration.Value value12 = DataType$.MODULE$.MonthDay();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                object = MonthDay.from(new Date(d.getTime()).toLocalDate());
                            } else {
                                throw new RuntimeException(new StringBuilder(24).append("Cannot convert date to  ").append(dataType).toString());
                            }
                        }
                    }
                }
            }
        }
        return object;
    }

    public final void fill$extension(Cell $this, Date d, ExcelStyleRegistry registry) {
        $this.setCellValue((java.util.Date)d);
        $this.setCellStyle(registry.get(DataType$.MODULE$.Date()));
    }

    public final void fill$extension(Cell $this, java.util.Date d, ExcelStyleRegistry registry) {
        $this.setCellValue(d);
        $this.setCellStyle(registry.get(DataType$.MODULE$.DateTime()));
    }

    public final void fill$extension(Cell $this, YearMonth d, ExcelStyleRegistry registry) {
        $this.setCellValue((java.util.Date)Date.valueOf(d.atDay(1)));
        $this.setCellStyle(registry.get(DataType$.MODULE$.YearMonth()));
    }

    public final void fill$extension(Cell $this, Year d, ExcelStyleRegistry registry) {
        $this.setCellValue((double)d.getValue());
        $this.setCellStyle(registry.get(DataType$.MODULE$.YearMonth()));
    }

    public final void fill$extension(Cell $this, MonthDay d, ExcelStyleRegistry registry) {
        $this.setCellValue((java.util.Date)Date.valueOf(d.atYear(2000)));
        $this.setCellStyle(registry.get(DataType$.MODULE$.MonthDay()));
    }

    public final void fill$extension(Cell $this, Time d, ExcelStyleRegistry registry) {
        $this.setCellValue((java.util.Date)d);
        $this.setCellStyle(registry.get(DataType$.MODULE$.Time()));
    }

    public final void fill$extension(Cell $this, float d, ExcelStyleRegistry registry) {
        $this.setCellValue((double)d);
        $this.setCellStyle(registry.get(DataType$.MODULE$.Float()));
    }

    public final void fill$extension(Cell $this, double d, ExcelStyleRegistry registry) {
        $this.setCellValue(d);
        $this.setCellStyle(registry.get(DataType$.MODULE$.Double()));
    }

    public final void fill$extension(Cell $this, int d, ExcelStyleRegistry registry) {
        $this.setCellValue((double)d);
        $this.setCellStyle(registry.get(DataType$.MODULE$.Integer()));
    }

    public final void fill$extension(Cell $this, String s, ExcelStyleRegistry registry) {
        $this.setCellValue((RichTextString)new XSSFRichTextString(s));
    }

    public final void fill$extension(Cell $this, boolean b, ExcelStyleRegistry registry) {
        $this.setCellValue(b ? "Y" : "N");
    }

    public final void fillBlank$extension(Cell $this) {
        $this.setBlank();
    }

    public final int hashCode$extension(Cell $this) {
        return $this.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals$extension(Cell $this, Object x$1) {
        Object object = x$1;
        if (!(object instanceof CellOps)) return false;
        boolean bl = true;
        if (!bl) return false;
        Cell cell = x$1 == null ? null : ((CellOps)x$1).org$beangle$data$transfer$excel$CellOps$$cell();
        Cell cell2 = $this;
        Cell cell3 = cell;
        if (cell2 != null) {
            if (!cell2.equals(cell3)) return false;
            return true;
        }
        if (cell3 == null) return true;
        return false;
    }

    private CellOps$() {
    }
}

