/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.transfer.excel;

import java.io.OutputStream;
import java.io.Serializable;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.beangle.commons.lang.Chars$;
import org.beangle.commons.lang.Numbers$;
import org.beangle.data.excel.CellOps$;
import org.beangle.data.excel.ExcelStyleRegistry;
import org.beangle.data.transfer.Format;
import org.beangle.data.transfer.Format$;
import org.beangle.data.transfer.exporter.ExportContext;
import org.beangle.data.transfer.io.ItemWriter;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Short$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.reflect.ClassTag$;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class ExcelItemWriter
implements ItemWriter {
    private final ExportContext context;
    private final OutputStream outputStream;
    private SXSSFWorkbook workbook;
    private SXSSFSheet sheet;
    private ExcelStyleRegistry registry;
    private Object title;
    private int flushCount;
    private int countPerSheet;
    private int index;

    public ExcelItemWriter(ExportContext context, OutputStream outputStream) {
        this.context = context;
        this.outputStream = outputStream;
        this.flushCount = 1000;
        this.countPerSheet = 100000;
        this.index = 0;
        this.init();
    }

    public ExportContext context() {
        return this.context;
    }

    public OutputStream outputStream() {
        return this.outputStream;
    }

    public SXSSFWorkbook workbook() {
        return this.workbook;
    }

    public void workbook_$eq(SXSSFWorkbook x$1) {
        this.workbook = x$1;
    }

    public SXSSFSheet sheet() {
        return this.sheet;
    }

    public void sheet_$eq(SXSSFSheet x$1) {
        this.sheet = x$1;
    }

    public Object title() {
        return this.title;
    }

    public void title_$eq(Object x$1) {
        this.title = x$1;
    }

    public int flushCount() {
        return this.flushCount;
    }

    public void flushCount_$eq(int x$1) {
        this.flushCount = x$1;
    }

    public int countPerSheet() {
        return this.countPerSheet;
    }

    public void countPerSheet_$eq(int x$1) {
        this.countPerSheet = x$1;
    }

    public int index() {
        return this.index;
    }

    public void index_$eq(int x$1) {
        this.index = x$1;
    }

    public void init() {
        int countParam;
        Object count;
        if (this.context() != null && (count = this.context().datas().getOrElse((Object)"countPerSheet", ExcelItemWriter::$anonfun$1)) != null && Numbers$.MODULE$.isDigits(count.toString()) && (countParam = Numbers$.MODULE$.toInt(count.toString(), Numbers$.MODULE$.toInt$default$2())) > 0) {
            this.countPerSheet_$eq(countParam);
        }
        this.workbook_$eq(new SXSSFWorkbook(this.flushCount()));
        this.registry = new ExcelStyleRegistry((Workbook)this.workbook());
    }

    @Override
    public void close() {
        this.workbook().write(this.outputStream());
        this.workbook().dispose();
    }

    @Override
    public void write(Object obj) {
        if (this.index() + 1 >= this.countPerSheet()) {
            this.writeTitle(null, this.title());
        }
        this.writeItem(obj);
        this.index_$eq(this.index() + 1);
    }

    public SXSSFSheet createScheet(String name) {
        block3: {
            block2: {
                if (this.sheet() == null) break block2;
                if (name == null) break block3;
                String string = this.sheet().getSheetName();
                String string2 = name;
                if (!(string == null ? string2 != null : !string.equals(string2))) break block3;
            }
            this.sheet_$eq(name != null ? this.workbook().createSheet(name) : this.workbook().createSheet());
        }
        return this.sheet();
    }

    @Override
    public void writeTitle(String sheetName, Object data) {
        this.writeTitle(data);
    }

    @Override
    public void writeTitle(Object data) {
        Object[] objectArray;
        this.createScheet(null);
        this.title_$eq(data);
        this.index_$eq(0);
        this.writeItem(data);
        SXSSFRow titleRow = this.sheet().getRow(this.index());
        XSSFCellStyle titleStyle = this.buildTitleStyle();
        Object object = data;
        if (object instanceof String[]) {
            Object[] cs;
            objectArray = cs = (String[])object;
        } else if (object instanceof Iterable) {
            Iterable it = (Iterable)object;
            Object object2 = Predef$.MODULE$.genericArrayOps(it.toArray(ClassTag$.MODULE$.Any()));
            objectArray = (String[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)_$5 -> _$5.toString(), ClassTag$.MODULE$.apply(String.class));
        } else {
            throw new RuntimeException("cannot write title with " + String.valueOf(data));
        }
        Object[] titles = objectArray;
        int maxWith = 30;
        DoubleRef h = DoubleRef.create((double)0.0);
        Object object3 = Predef$.MODULE$.refArrayOps(titles);
        ArrayOps$.MODULE$.indices$extension(object3).foreach((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> this.writeTitle$$anonfun$1(titleRow, titleStyle, (String[])titles, maxWith, h, arg_0)));
        int height = (int)Math.ceil(h.elem);
        if (height > 8) {
            height = 8;
        }
        titleRow.setHeight((short)(height * 12 * 20));
        this.index_$eq(this.index() + 1);
        this.sheet().createFreezePane(0, this.index());
    }

    @Override
    public Format format() {
        return Format$.Xlsx;
    }

    public void writeItem(Object datas) {
        SXSSFRow row = this.sheet().createRow(this.index());
        Object object = datas;
        if (object == null) {
            return;
        }
        if (object instanceof Object[]) {
            Object[] a = (Object[])object;
            Object object2 = Predef$.MODULE$.genericArrayOps((Object)a);
            ArrayOps$.MODULE$.indices$extension(object2).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> CellOps$.MODULE$.fillin$extension(CellOps$.MODULE$.toCell((Cell)row.createCell(i)), a[i], this.registry));
            return;
        }
        if (object instanceof Iterable) {
            Iterable it = (Iterable)object;
            IntRef i2 = IntRef.create((int)0);
            it.foreach((Function1)(JProcedure1 & Serializable)obj -> {
                int n;
                CellOps$.MODULE$.fillin$extension(CellOps$.MODULE$.toCell((Cell)row.createCell(i$1.elem)), obj, this.registry);
                i$1.elem = n = i$1.elem + 1;
            });
            return;
        }
        if (object instanceof Number) {
            Number n = (Number)object;
            SXSSFCell cell = row.createCell(0);
            cell.setCellType(CellType.NUMERIC);
            cell.setCellValue((RichTextString)new XSSFRichTextString(n.toString()));
            return;
        }
        if (object instanceof Object) {
            Object a = object;
            SXSSFCell cell = row.createCell(0);
            cell.setCellValue((RichTextString)new XSSFRichTextString(a.toString()));
            return;
        }
        throw new MatchError(object);
    }

    public XSSFCellStyle buildTitleStyle() {
        XSSFCellStyle style = (XSSFCellStyle)this.workbook().createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setWrapText(true);
        byte[] rgb = new byte[]{(byte)221, (byte)217, (byte)196};
        style.setFillForegroundColor(new XSSFColor(rgb, (IndexedColorMap)new DefaultIndexedColorMap()));
        return style;
    }

    private static final Object $anonfun$1() {
        return "";
    }

    private final /* synthetic */ void writeTitle$$anonfun$1(SXSSFRow titleRow$1, XSSFCellStyle titleStyle$1, String[] titles$1, int maxWith$1, DoubleRef h$1, int i) {
        titleRow$1.getCell(i).setCellStyle((CellStyle)titleStyle$1);
        int n = Chars$.MODULE$.charLength(titles$1[i]);
        int w = Math.min(n, maxWith$1);
        double r = (double)n * 1.0 / (double)maxWith$1;
        if (r > h$1.elem) {
            double d;
            h$1.elem = d = r;
        }
        this.sheet().setColumnWidth(Short$.MODULE$.short2int((short)i), (w + 4) * 256);
    }
}

