/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.transfer.exporter;

import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Options$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.text.Formatter;
import org.beangle.commons.lang.text.Formatters$;
import org.beangle.data.transfer.Format;
import org.beangle.data.transfer.Format$;
import org.beangle.data.transfer.csv.CsvItemWriter;
import org.beangle.data.transfer.excel.ExcelItemWriter;
import org.beangle.data.transfer.excel.ExcelTemplateExporter;
import org.beangle.data.transfer.excel.ExcelTemplateWriter;
import org.beangle.data.transfer.exporter.DefaultPropertyExtractor;
import org.beangle.data.transfer.exporter.Exporter;
import org.beangle.data.transfer.exporter.PropertyExtractor;
import org.beangle.data.transfer.exporter.SimpleEntityExporter;
import org.beangle.data.transfer.io.ItemWriter;
import org.beangle.data.transfer.io.Writer;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public class ExportContext {
    private Exporter exporter;
    private Writer writer;
    private final Map datas = Collections$.MODULE$.newMap();
    private Format format;
    private PropertyExtractor extractor = new DefaultPropertyExtractor();
    private boolean convertToString = false;
    private scala.collection.immutable.Map typeFormatters = Predef$.MODULE$.Map().empty();
    private scala.collection.immutable.Map propertyFormatters = Predef$.MODULE$.Map().empty();
    private final Map sharedValues = Collections$.MODULE$.newMap();
    private String fileName;
    private String[] titles;
    private String[] attrs;

    public Exporter exporter() {
        return this.exporter;
    }

    public void exporter_$eq(Exporter x$1) {
        this.exporter = x$1;
    }

    public Writer writer() {
        return this.writer;
    }

    public void writer_$eq(Writer x$1) {
        this.writer = x$1;
    }

    public Map<String, Object> datas() {
        return this.datas;
    }

    public Format format() {
        return this.format;
    }

    public void format_$eq(Format x$1) {
        this.format = x$1;
    }

    public PropertyExtractor extractor() {
        return this.extractor;
    }

    public void extractor_$eq(PropertyExtractor x$1) {
        this.extractor = x$1;
    }

    public boolean convertToString() {
        return this.convertToString;
    }

    public void convertToString_$eq(boolean x$1) {
        this.convertToString = x$1;
    }

    public scala.collection.immutable.Map<Class<?>, Formatter> typeFormatters() {
        return this.typeFormatters;
    }

    public void typeFormatters_$eq(scala.collection.immutable.Map<Class<?>, Formatter> x$1) {
        this.typeFormatters = x$1;
    }

    public scala.collection.immutable.Map<String, Formatter> propertyFormatters() {
        return this.propertyFormatters;
    }

    public void propertyFormatters_$eq(scala.collection.immutable.Map<String, Formatter> x$1) {
        this.propertyFormatters = x$1;
    }

    public Map<String, String> sharedValues() {
        return this.sharedValues;
    }

    public String fileName() {
        return this.fileName;
    }

    public void fileName_$eq(String x$1) {
        this.fileName = x$1;
    }

    public String[] titles() {
        return this.titles;
    }

    public void titles_$eq(String[] x$1) {
        this.titles = x$1;
    }

    public String[] attrs() {
        return this.attrs;
    }

    public void attrs_$eq(String[] x$1) {
        this.attrs = x$1;
    }

    public ExportContext registerFormatter(Class<?> clazz, Formatter formatter) {
        Class clazz2 = (Class)Predef$.MODULE$.ArrowAssoc(clazz);
        this.typeFormatters_$eq((scala.collection.immutable.Map)this.typeFormatters().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz2, (Object)formatter)));
        return this;
    }

    public ExportContext registerFormatter(String propertyName, Formatter formatter) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)propertyName);
        this.propertyFormatters_$eq((scala.collection.immutable.Map<String, Formatter>)((scala.collection.immutable.Map)this.propertyFormatters().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)formatter))));
        return this;
    }

    public Option<Formatter> getFormatter(String propertyName, Object obj) {
        Option option = this.propertyFormatters().get((Object)propertyName);
        if (None$.MODULE$.equals(option)) {
            if (obj == null) {
                return None$.MODULE$;
            }
            return this.typeFormatters().get(obj.getClass());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Formatter f = (Formatter)some.value();
            Some p = some;
            return p;
        }
        throw new MatchError((Object)option);
    }

    public ExportContext writeTo(OutputStream os, Format format, Option<String> suggestFileName) {
        ItemWriter itemWriter;
        this.format_$eq(format);
        this.setFileName(suggestFileName);
        Format format2 = format;
        Format format3 = Format$.Xlsx;
        if (!(format2 != null ? !format2.equals(format3) : format3 != null)) {
            itemWriter = new ExcelItemWriter(this, os);
        } else {
            Format format4 = format;
            Format format5 = Format$.Csv;
            if (!(format4 != null ? !format4.equals(format5) : format5 != null)) {
                itemWriter = new CsvItemWriter(this, os);
            } else {
                throw new RuntimeException("Cannot export to other formats, csv/xlsx supported only!");
            }
        }
        this.writer_$eq(itemWriter);
        Format format6 = this.format();
        Format format7 = Format$.Csv;
        if (!(format6 != null ? !format6.equals(format7) : format7 != null)) {
            this.convertToString_$eq(true);
        }
        this.exporter_$eq(new SimpleEntityExporter());
        return this;
    }

    public ExportContext writeTo(OutputStream os, Format format, Option<String> suggestFileName, URL template) {
        Format format2 = format;
        Format format3 = Format$.Xlsx;
        if (format2 == null ? format3 != null : !format2.equals(format3)) {
            throw new RuntimeException("Xlsx supported only!");
        }
        this.format_$eq(Format$.Xlsx);
        this.setFileName(suggestFileName);
        this.writer_$eq(new ExcelTemplateWriter(template, this, os));
        this.exporter_$eq(new ExcelTemplateExporter());
        this.convertToString_$eq(false);
        return this;
    }

    private String setFileName(Option<String> suggest) {
        Object object;
        String ext = "." + Strings$.MODULE$.uncapitalize(this.format().toString());
        Option<String> option = suggest;
        if (option instanceof Some) {
            String f = (String)((Some)option).value();
            object = !f.endsWith(ext) ? f + ext : f;
        } else if (None$.MODULE$.equals(option)) {
            object = "exportFile" + ext;
        } else {
            throw new MatchError(option);
        }
        this.fileName_$eq((String)object);
        return this.fileName();
    }

    public void setTitles(String properties, Option<Object> convertToString) {
        Object[] props = Strings$.MODULE$.split(properties, ",");
        ArrayBuffer keys = new ArrayBuffer(props.length);
        ArrayBuffer titles = new ArrayBuffer(props.length);
        Object object = Predef$.MODULE$.refArrayOps(props);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)prop -> {
            if (prop.contains(":")) {
                String key = Strings$.MODULE$.substringBefore(prop, ":");
                String sharedValue = "";
                String title = Strings$.MODULE$.substringAfter(prop, ":");
                if (key.startsWith("blank.")) {
                    if (title.contains(":")) {
                        sharedValue = Strings$.MODULE$.substringAfter(title, ":");
                        title = Strings$.MODULE$.substringBefore(title, ":");
                    }
                    this.sharedValues().put((Object)key, (Object)sharedValue);
                }
                keys.$plus$eq((Object)key);
                return (ArrayBuffer)titles.$plus$eq((Object)title);
            }
            return (ArrayBuffer)titles.$plus$eq(prop);
        });
        if (keys.nonEmpty()) {
            this.attrs_$eq((String[])keys.toArray(ClassTag$.MODULE$.apply(String.class)));
        }
        this.titles_$eq((String[])titles.toArray(ClassTag$.MODULE$.apply(String.class)));
        convertToString.foreach((Function1 & Serializable)v1 -> {
            this.setTitles$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)v1));
            return BoxedUnit.UNIT;
        });
    }

    public <T> Option<T> get(String key, Class<T> clazz) {
        return this.datas().get((Object)key);
    }

    public void put(String key, Object v) {
        this.datas().put((Object)key, v);
    }

    public Object getPropertyValue(Object target, String property) {
        Option option = this.sharedValues().get((Object)property);
        if (option instanceof Some) {
            String v = (String)((Some)option).value();
            return v;
        }
        if (None$.MODULE$.equals(option)) {
            Object value = Options$.MODULE$.unwrap(this.extractor().getPropertyValue(target, property));
            if (value == null) {
                return "";
            }
            Option<Formatter> option2 = this.getFormatter(property, value);
            if (None$.MODULE$.equals(option2)) {
                if (this.convertToString()) {
                    return Formatters$.MODULE$.getDefault(value.getClass()).format(value);
                }
                return value;
            }
            if (option2 instanceof Some) {
                Formatter formatter = (Formatter)((Some)option2).value();
                return formatter.format(value);
            }
            throw new MatchError(option2);
        }
        throw new MatchError((Object)option);
    }

    private final /* synthetic */ void setTitles$$anonfun$2(boolean x) {
        this.convertToString_$eq(x);
    }
}

