/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.orm.hibernate;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.RollbackException;
import java.util.Map;
import javax.sql.DataSource;
import org.beangle.data.orm.hibernate.SessionHelper$;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.JdbcTransactionObjectSupport;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.NestedTransactionNotSupportedException;
import org.springframework.transaction.SavepointManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.DelegatingTransactionDefinition;
import org.springframework.transaction.support.ResourceHolderSupport;
import org.springframework.transaction.support.ResourceTransactionDefinition;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernateTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager {
    private final EntityManagerFactory sessionFactory;
    private DataSource dataSource;
    private Map jpaPropertyMap;

    public HibernateTransactionManager(EntityManagerFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.setNestedTransactionAllowed(true);
    }

    public EntityManagerFactory sessionFactory() {
        return this.sessionFactory;
    }

    public DataSource dataSource() {
        return this.dataSource;
    }

    public void dataSource_$eq(DataSource x$1) {
        this.dataSource = x$1;
    }

    public Map<String, Object> jpaPropertyMap() {
        return this.jpaPropertyMap;
    }

    public void jpaPropertyMap_$eq(Map<String, Object> x$1) {
        this.jpaPropertyMap = x$1;
    }

    public Object getResourceFactory() {
        return this.sessionFactory();
    }

    public Object doGetTransaction() {
        JpaTransactionObject txObject = new JpaTransactionObject();
        txObject.setSavepointAllowed(this.isNestedTransactionAllowed());
        SessionHolder emHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.sessionFactory()));
        if (emHolder != null) {
            txObject.update(emHolder, false);
        } else {
            txObject.sessionHolder_$eq(SessionHelper$.MODULE$.openSession((SessionFactory)this.sessionFactory(), SessionHelper$.MODULE$.openSession$default$2(), SessionHelper$.MODULE$.openSession$default$3()));
        }
        if (this.dataSource() != null) {
            ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)this.dataSource());
            txObject.setConnectionHolder(conHolder);
        }
        return txObject;
    }

    public boolean isExistingTransaction(Object transaction) {
        return ((JpaTransactionObject)((Object)transaction)).hasTransaction();
    }

    public void doBegin(Object transaction, TransactionDefinition definition) {
        JpaTransactionObject txObject = (JpaTransactionObject)((Object)transaction);
        if (txObject.hasConnectionHolder() && !txObject.getConnectionHolder().isSynchronizedWithTransaction()) {
            throw new IllegalTransactionStateException("Pre-bound JDBC Connection found! JpaTransactionManager does not support running within DataSourceTransactionManager if told to manage the DataSource itself. It is recommended to use a single JpaTransactionManager for all transactions on a single DataSource, no matter whether JPA or JDBC access.");
        }
        try {
            ConnectionHandle conHandle;
            if (!txObject.hasSessionHolder() || txObject.sessionHolder().isSynchronizedWithTransaction()) {
                Session newEm = this.createEntityManagerForTransaction();
                txObject.update(new SessionHolder(newEm), true);
            }
            EntityManager em = txObject.session();
            int timeoutToUse = this.determineTimeout(definition);
            Object transactionData = SessionHelper$.MODULE$.beginTransaction(em, (TransactionDefinition)new JpaTransactionDefinition(definition, timeoutToUse, txObject.isNewSession()));
            txObject.transactionData_$eq(transactionData);
            txObject.setReadOnly(definition.isReadOnly());
            if (timeoutToUse != -1) {
                txObject.sessionHolder().setTimeoutInSeconds(timeoutToUse);
            }
            if (this.dataSource() != null && (conHandle = SessionHelper$.MODULE$.getJdbcConnection(em, definition.isReadOnly())) != null) {
                ConnectionHolder conHolder = new ConnectionHolder(conHandle);
                if (timeoutToUse != -1) {
                    conHolder.setTimeoutInSeconds(timeoutToUse);
                }
                TransactionSynchronizationManager.bindResource((Object)this.dataSource(), (Object)conHolder);
                txObject.setConnectionHolder(conHolder);
            }
            if (txObject.isNewSession()) {
                TransactionSynchronizationManager.bindResource((Object)this.sessionFactory(), (Object)((Object)txObject.sessionHolder()));
            }
            txObject.sessionHolder().setSynchronizedWithTransaction(true);
        }
        catch (TransactionException ex) {
            this.closeEntityManagerAfterFailedBegin(txObject);
            throw ex;
        }
        catch (Throwable ex) {
            this.closeEntityManagerAfterFailedBegin(txObject);
            throw new CannotCreateTransactionException("Could not open JPA EntityManager for transaction", ex);
        }
    }

    public Session createEntityManagerForTransaction() {
        EntityManagerFactory emf = this.sessionFactory();
        Map<String, Object> properties = this.jpaPropertyMap();
        EntityManager em = properties == null || properties.isEmpty() ? emf.createEntityManager() : emf.createEntityManager(properties);
        return (Session)em;
    }

    public void closeEntityManagerAfterFailedBegin(JpaTransactionObject txObject) {
        if (txObject.isNewSession()) {
            EntityManager em = txObject.session();
            try {
                try {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                }
                catch (Throwable throwable) {}
            }
            finally {
                SessionHelper$.MODULE$.safeCloseSession(em);
            }
            txObject.update(null, false);
            return;
        }
    }

    public Object doSuspend(Object transaction) {
        JpaTransactionObject txObject = (JpaTransactionObject)((Object)transaction);
        txObject.update(null, false);
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory()));
        txObject.setConnectionHolder(null);
        ConnectionHolder connectionHolder = null;
        DataSource ds = this.dataSource();
        if (ds != null && TransactionSynchronizationManager.hasResource((Object)ds)) {
            connectionHolder = (ConnectionHolder)TransactionSynchronizationManager.unbindResource((Object)ds);
        }
        return new SuspendedResourcesHolder(sessionHolder, connectionHolder);
    }

    public void doResume(Object transaction, Object suspendedResources) {
        SuspendedResourcesHolder resourcesHolder = (SuspendedResourcesHolder)suspendedResources;
        TransactionSynchronizationManager.bindResource((Object)this.sessionFactory(), (Object)((Object)resourcesHolder.sessionHolder()));
        if (this.dataSource() != null && resourcesHolder.connectionHolder() != null) {
            TransactionSynchronizationManager.bindResource((Object)this.dataSource(), (Object)resourcesHolder.connectionHolder());
            return;
        }
    }

    public boolean shouldCommitOnGlobalRollbackOnly() {
        return true;
    }

    public void doCommit(DefaultTransactionStatus status) {
        JpaTransactionObject txObject = (JpaTransactionObject)((Object)status.getTransaction());
        try {
            txObject.session().getTransaction().commit();
        }
        catch (RollbackException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException e = (RuntimeException)throwable;
                throw e;
            }
            throw new RuntimeException(ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
    }

    public void doRollback(DefaultTransactionStatus status) {
        JpaTransactionObject txObject = (JpaTransactionObject)((Object)status.getTransaction());
        try {
            try {
                EntityTransaction tx = txObject.session().getTransaction();
                if (tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (PersistenceException pe) {
                throw new TransactionSystemException("Could not roll back JPA transaction", (Throwable)pe);
            }
        }
        finally {
            if (!txObject.isNewSession()) {
                txObject.session().clear();
            }
        }
    }

    public void doSetRollbackOnly(DefaultTransactionStatus status) {
        ((JpaTransactionObject)((Object)status.getTransaction())).setRollbackOnly();
    }

    public void doCleanupAfterCompletion(Object transaction) {
        JpaTransactionObject txObject = (JpaTransactionObject)((Object)transaction);
        if (txObject.isNewSession()) {
            TransactionSynchronizationManager.unbindResourceIfPossible((Object)this.sessionFactory());
        }
        txObject.sessionHolder().clear();
        if (this.dataSource() != null && txObject.hasConnectionHolder()) {
            TransactionSynchronizationManager.unbindResource((Object)this.dataSource());
            ConnectionHandle conHandle = txObject.getConnectionHolder().getConnectionHandle();
            if (conHandle != null) {
                try {
                    SessionHelper$.MODULE$.releaseJdbcConnection(conHandle, txObject.session());
                }
                catch (Throwable ex) {
                    this.logger.error((Object)"Failed to release JDBC connection after transaction", ex);
                }
            }
        }
        SessionHelper$.MODULE$.cleanupTransaction(txObject.transactionData());
        if (txObject.isNewSession()) {
            SessionHelper$.MODULE$.safeCloseSession((EntityManager)txObject.sessionHolder().session());
            return;
        }
        this.logger.debug((Object)"Not closing pre-bound JPA EntityManager after transaction");
    }

    public static class JpaTransactionDefinition
    extends DelegatingTransactionDefinition
    implements ResourceTransactionDefinition {
        private final int timeout;
        private final boolean localResource;

        public JpaTransactionDefinition(TransactionDefinition targetDefinition, int timeout, boolean localResource) {
            this.timeout = timeout;
            this.localResource = localResource;
            super(targetDefinition);
        }

        public int timeout() {
            return this.timeout;
        }

        public boolean localResource() {
            return this.localResource;
        }

        public boolean isLocalResource() {
            return this.localResource();
        }

        public int getTimeout() {
            return this.timeout();
        }
    }

    public class JpaTransactionObject
    extends JdbcTransactionObjectSupport {
        private SessionHolder sessionHolder;
        private boolean isNewSession;
        private Object data;

        public JpaTransactionObject() {
            if (HibernateTransactionManager.this == null) {
                throw new NullPointerException();
            }
            this.isNewSession = false;
        }

        public SessionHolder sessionHolder() {
            return this.sessionHolder;
        }

        public void sessionHolder_$eq(SessionHolder x$1) {
            this.sessionHolder = x$1;
        }

        public boolean isNewSession() {
            return this.isNewSession;
        }

        public void isNewSession_$eq(boolean x$1) {
            this.isNewSession = x$1;
        }

        public void update(SessionHolder sessionHolder, boolean isNewSession) {
            this.sessionHolder_$eq(sessionHolder);
            this.isNewSession_$eq(isNewSession);
        }

        public Object data() {
            return this.data;
        }

        public void data_$eq(Object x$1) {
            this.data = x$1;
        }

        public boolean hasSessionHolder() {
            return this.sessionHolder() != null;
        }

        public boolean hasTransaction() {
            return this.sessionHolder() != null && this.sessionHolder().transactionActive();
        }

        public EntityManager session() {
            return this.sessionHolder().session();
        }

        public void transactionData_$eq(Object d) {
            this.data_$eq(d);
            this.sessionHolder().transactionActive_$eq(true);
            Object object = d;
            if (object instanceof SavepointManager) {
                SavepointManager sm = (SavepointManager)object;
                this.sessionHolder().savepointManager_$eq(sm);
                return;
            }
        }

        public Object transactionData() {
            return this.data();
        }

        public void setRollbackOnly() {
            EntityTransaction tx = this.session().getTransaction();
            if (tx.isActive()) {
                tx.setRollbackOnly();
            }
            if (this.hasConnectionHolder()) {
                this.getConnectionHolder().setRollbackOnly();
                return;
            }
        }

        public boolean isRollbackOnly() {
            return this.session().getTransaction().getRollbackOnly();
        }

        public void flush() {
            this.session().flush();
        }

        public Object createSavepoint() throws TransactionException {
            if (this.sessionHolder().isRollbackOnly()) {
                throw new CannotCreateTransactionException("Cannot create savepoint for transaction which is already marked as rollback-only");
            }
            return this.savepointManager().createSavepoint();
        }

        public void rollbackToSavepoint(Object savepoint) throws TransactionException {
            this.savepointManager().rollbackToSavepoint(savepoint);
            this.sessionHolder().resetRollbackOnly();
        }

        public void releaseSavepoint(Object savepoint) throws TransactionException {
            this.savepointManager().releaseSavepoint(savepoint);
        }

        private SavepointManager savepointManager() {
            if (!this.isSavepointAllowed()) {
                throw new NestedTransactionNotSupportedException("Transaction manager does not allow nested transactions");
            }
            SavepointManager sm = this.sessionHolder().savepointManager();
            if (sm == null) {
                throw new NestedTransactionNotSupportedException("JpaDialect does not support savepoints - check your JPA provider's capabilities");
            }
            return sm;
        }

        public final /* synthetic */ HibernateTransactionManager org$beangle$data$orm$hibernate$HibernateTransactionManager$JpaTransactionObject$$$outer() {
            return HibernateTransactionManager.this;
        }
    }

    public static class SessionHolder
    extends ResourceHolderSupport {
        private final Session session;
        private SavepointManager savepointManager;
        private boolean transactionActive;

        public SessionHolder(Session session) {
            this.session = session;
        }

        public Session session() {
            return this.session;
        }

        public SavepointManager savepointManager() {
            return this.savepointManager;
        }

        public void savepointManager_$eq(SavepointManager x$1) {
            this.savepointManager = x$1;
        }

        public boolean transactionActive() {
            return this.transactionActive;
        }

        public void transactionActive_$eq(boolean x$1) {
            this.transactionActive = x$1;
        }

        public void clear() {
            super.clear();
            this.savepointManager_$eq(null);
            this.transactionActive_$eq(false);
        }
    }

    public static class SuspendedResourcesHolder {
        private final SessionHolder sessionHolder;
        private final ConnectionHolder connectionHolder;

        public SuspendedResourcesHolder(SessionHolder sessionHolder, ConnectionHolder connectionHolder) {
            this.sessionHolder = sessionHolder;
            this.connectionHolder = connectionHolder;
        }

        public SessionHolder sessionHolder() {
            return this.sessionHolder;
        }

        public ConnectionHolder connectionHolder() {
            return this.connectionHolder;
        }
    }
}

