/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.orm;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Locale;
import org.beangle.commons.bean.Properties$;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.config.Resources;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.annotation.value;
import org.beangle.commons.lang.reflect.BeanInfo;
import org.beangle.commons.lang.reflect.BeanInfos$;
import org.beangle.commons.lang.reflect.Reflections$;
import org.beangle.commons.lang.reflect.TypeInfo;
import org.beangle.commons.logging.Logging;
import org.beangle.commons.text.i18n.Messages;
import org.beangle.commons.text.i18n.Messages$;
import org.beangle.data.model.IntIdEntity;
import org.beangle.data.model.LongIdEntity;
import org.beangle.data.model.ShortIdEntity;
import org.beangle.data.model.StringIdEntity;
import org.beangle.data.model.annotation.archive;
import org.beangle.data.model.meta.EntityType;
import org.beangle.data.model.meta.Type;
import org.beangle.data.orm.Collection;
import org.beangle.data.orm.ColumnHolder;
import org.beangle.data.orm.Jpas$;
import org.beangle.data.orm.Name;
import org.beangle.data.orm.OrmBasicType;
import org.beangle.data.orm.OrmCollectionProperty;
import org.beangle.data.orm.OrmEmbeddableType;
import org.beangle.data.orm.OrmEntityType;
import org.beangle.data.orm.OrmMapProperty;
import org.beangle.data.orm.OrmPluralProperty;
import org.beangle.data.orm.OrmProperty;
import org.beangle.data.orm.OrmSingularProperty;
import org.beangle.data.orm.OrmStructType;
import org.beangle.data.orm.OrmType;
import org.beangle.data.orm.TypeDef;
import org.beangle.data.orm.cfg.Profiles;
import org.beangle.jdbc.DefaultSqlTypeMapping;
import org.beangle.jdbc.SqlTypeMapping;
import org.beangle.jdbc.meta.Column;
import org.beangle.jdbc.meta.Database;
import org.beangle.jdbc.meta.Identifier;
import org.beangle.jdbc.meta.Schema;
import org.beangle.jdbc.meta.SqlType;
import org.beangle.jdbc.meta.Table;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Enum;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public final class Mappings
implements Logging {
    private Logger logger;
    private final Database database;
    private final Profiles profiles;
    private Locale locale;
    private SqlTypeMapping sqlTypeMapping;
    private final HashMap classTypes;
    private final HashMap typeDefs;
    private final HashSet valueTypes;
    private final HashSet enumTypes;
    private final HashMap collectMap;
    private final scala.collection.mutable.Map entityTypes;
    private Messages messages;

    public Mappings(Database database, Profiles profiles) {
        this.database = database;
        this.profiles = profiles;
        Logging.$init$((Logging)this);
        this.locale = Locale.getDefault();
        this.sqlTypeMapping = new DefaultSqlTypeMapping(database.engine());
        this.classTypes = new HashMap();
        this.typeDefs = new HashMap();
        this.valueTypes = new HashSet();
        this.enumTypes = new HashSet();
        this.collectMap = new HashMap();
        this.entityTypes = Collections$.MODULE$.newMap();
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public Database database() {
        return this.database;
    }

    public Profiles profiles() {
        return this.profiles;
    }

    public Mappings(Database database, List<URL> ormLocations) {
        this(database, new Profiles(new Resources((Option)None$.MODULE$, ormLocations, (Option)None$.MODULE$)));
    }

    public Locale locale() {
        return this.locale;
    }

    public void locale_$eq(Locale x$1) {
        this.locale = x$1;
    }

    public SqlTypeMapping sqlTypeMapping() {
        return this.sqlTypeMapping;
    }

    public void sqlTypeMapping_$eq(SqlTypeMapping x$1) {
        this.sqlTypeMapping = x$1;
    }

    public HashMap<Class<?>, OrmEntityType> classTypes() {
        return this.classTypes;
    }

    public HashMap<String, TypeDef> typeDefs() {
        return this.typeDefs;
    }

    public HashSet<Class<?>> valueTypes() {
        return this.valueTypes;
    }

    public HashSet<String> enumTypes() {
        return this.enumTypes;
    }

    public HashMap<String, Collection> collectMap() {
        return this.collectMap;
    }

    public scala.collection.mutable.Map<String, OrmEntityType> entityTypes() {
        return this.entityTypes;
    }

    public Iterable<Collection> collections() {
        return this.collectMap().values();
    }

    public OrmEntityType getEntity(Class<?> clazz) {
        return (OrmEntityType)this.classTypes().apply(clazz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Mappings addEntity(OrmEntityType mapping) {
        Class<?> cls = mapping.clazz();
        this.classTypes().put(cls, (Object)mapping);
        if (!cls.isInterface() && !Modifier.isAbstract(cls.getModifiers())) {
            Option option = this.entityTypes().get((Object)mapping.entityName());
            if (option instanceof Some) {
                OrmEntityType o = (OrmEntityType)((Some)option).value();
                if (o.clazz().isAssignableFrom(mapping.clazz())) {
                    this.entityTypes().put((Object)mapping.entityName(), (Object)mapping);
                    v0 = BoxedUnit.UNIT;
                    return this;
                } else {
                    v0 = BoxedUnit.UNIT;
                }
                return this;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                v0 = this.entityTypes().put((Object)mapping.entityName(), (Object)mapping);
            }
            return this;
        } else {
            mapping.table().phantom_$eq(true);
            v0 = BoxedUnit.UNIT;
        }
        return this;
    }

    public Mappings addCollection(Collection definition) {
        this.collectMap().put((Object)(definition.clazz().getName() + definition.property()), (Object)definition);
        return this;
    }

    public Mappings cache(OrmEntityType em, String region, String usage) {
        em.cacheRegion_$eq(region);
        em.cacheUsage_$eq(usage);
        return this;
    }

    public Mappings cacheAll(OrmEntityType em, String region, String usage) {
        em.cacheAll_$eq(true);
        em.cacheRegion_$eq(region);
        em.cacheUsage_$eq(usage);
        return this;
    }

    public void addType(String name, String clazz, scala.collection.immutable.Map<String, String> params) {
        this.typeDefs().put((Object)name, (Object)new TypeDef(clazz, params));
    }

    public void autobind() {
        this.messages = Messages$.MODULE$.apply(this.locale());
        this.profiles().modules().foreach((Function1)(JProcedure1 & Serializable)m -> m.configure(this));
        this.classTypes().subtractAll((IterableOnce)((MapOps)this.classTypes().filter((Function1 & Serializable)x -> ((OrmStructType)x._2()).properties().isEmpty())).keys());
        List typeList = (List)this.classTypes().keys().toList().sortWith((Function2 & Serializable)(a, b) -> {
            Class clazz = a;
            Class clazz2 = b;
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                return false;
            }
            if (a.isAssignableFrom((Class<?>)b)) {
                return true;
            }
            return a.getName().compareTo(b.getName()) < 0;
        });
        typeList.foreach((Function1)(JProcedure1 & Serializable)cls -> this.merge((OrmEntityType)this.classTypes().apply(cls)));
        scala.collection.mutable.Map notEntities = (scala.collection.mutable.Map)this.entityTypes().filter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                OrmEntityType c = (OrmEntityType)tuple2._2();
                return c.clazz().isInterface() || Modifier.isAbstract(c.clazz().getModifiers());
            }
            throw new MatchError((Object)tuple2);
        });
        this.entityTypes().$minus$minus$eq((IterableOnce)notEntities.keys());
        this.database().schemas().values().foreach((Function1 & Serializable)s -> {
            HashMap phantomTables = (HashMap)s.tables().filter((Function1 & Serializable)_$2 -> ((Table)_$2._2()).phantom());
            return s.tables().subtractAll((IterableOnce)phantomTables.keys());
        });
        this.entityTypes().values().foreach((Function1)(JProcedure1 & Serializable)em -> this.firstPass((OrmEntityType)em));
        this.entityTypes().values().foreach((Function1)(JProcedure1 & Serializable)em -> this.secondPass((OrmEntityType)em));
    }

    public OrmEntityType autobind(Class<?> cls, String entityName, BeanInfo manifest) {
        if (cls.isAnnotationPresent(Jpas$.MODULE$.JpaEntityAnn())) {
            return null;
        }
        String fixedEntityName = entityName == null ? Jpas$.MODULE$.findEntityName(cls) : entityName;
        OrmEntityType entity = this.refEntity(cls, fixedEntityName);
        Object sample = Reflections$.MODULE$.newInstance(cls);
        manifest.readables().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                BeanInfo.PropertyInfo prop = (BeanInfo.PropertyInfo)tuple2._2();
                if (!prop.isTransient() && prop.readable() && prop.writable() && !entity.properties().contains((Object)name)) {
                    TypeInfo typeinfo = prop.typeinfo();
                    Class propType = typeinfo.isOptional() ? ((TypeInfo)typeinfo.args().apply(0)).clazz() : typeinfo.clazz();
                    String string = name;
                    String string2 = "id";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        this.bindId(entity, name, typeinfo);
                        return;
                    }
                    if (Jpas$.MODULE$.isEntity(propType)) {
                        this.bindManyToOne(entity, entity, name, typeinfo);
                        return;
                    }
                    if (Jpas$.MODULE$.isSeq(propType) || Jpas$.MODULE$.isSet(propType)) {
                        this.bindCollection(entity, entity, name, typeinfo);
                        return;
                    }
                    if (Jpas$.MODULE$.isMap(propType)) {
                        this.bindMap(entity, entity, name, typeinfo);
                        return;
                    }
                    if (Jpas$.MODULE$.isComponent(propType)) {
                        this.bindComponent(entity, entity, name, typeinfo);
                        return;
                    }
                    this.bindScalar(entity, entity, name, typeinfo, sample);
                    return;
                }
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        return entity;
    }

    public OrmEntityType refEntity(Class<?> clazz, String entityName) {
        Option option = this.entityTypes().get((Object)entityName);
        if (option instanceof Some) {
            OrmEntityType entity = (OrmEntityType)((Some)option).value();
            Class<?> clazz2 = entity.clazz();
            Class<?> clazz3 = clazz;
            if ((clazz2 == null ? clazz3 != null : !clazz2.equals(clazz3)) && entity.clazz().isAssignableFrom(clazz)) {
                entity.clazz_$eq(clazz);
            }
            return entity;
        }
        if (None$.MODULE$.equals(option)) {
            Name naming = this.profiles().getNamingPolicy(clazz).classToTableName(clazz, entityName);
            Schema schema = this.database().getOrCreateSchema((String)naming.schema().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            Table table = schema.createTable(naming.text());
            OrmEntityType e = new OrmEntityType(entityName, clazz, table);
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                e.isAbstract_$eq(true);
                table.phantom_$eq(true);
            }
            this.addEntity(e);
            return e;
        }
        throw new MatchError((Object)option);
    }

    public String columnName(Class<?> clazz, String propertyName, boolean key) {
        int lastDot = propertyName.lastIndexOf(".");
        Object colName = lastDot == -1 ? propertyName : propertyName.substring(lastDot + 1);
        colName = key ? (String)colName + "Id" : colName;
        colName = this.profiles().getNamingPolicy(clazz).propertyToColumnName(clazz, (String)colName);
        if (this.database().engine().keywords().contains(colName)) {
            return (String)colName + "_";
        }
        return colName;
    }

    public boolean columnName$default$3() {
        return false;
    }

    private void firstPass(OrmEntityType etm) {
        if (etm.idGenerator() == null) {
            throw new RuntimeException("Cannot find id generator for entity " + etm.entityName());
        }
        if (etm.id() == null) {
            throw new RuntimeException("Cannot find id for entity " + etm.entityName());
        }
        Class<?> clazz = etm.clazz();
        Column column = (Column)((OrmSingularProperty)etm.id()).columns().head();
        column.comment_$eq((Option)Some$.MODULE$.apply((Object)(this.getComment(clazz, etm.id().name()) + (":" + etm.idGenerator().strategy()))));
        etm.table().createPrimaryKey("", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{column.name().toLiteral(etm.table().engine())}));
        etm.partitionKey().foreach((Function1)(JProcedure1 & Serializable)partKey -> {
            Column partCol = (Column)((ColumnHolder)((Object)etm.property((String)partKey))).columns().head();
            Identifier partColName = partCol.name();
            Table table = etm.table();
            table.primaryKey().foreach((Function1)(JProcedure1 & Serializable)pk -> {
                Set existedNames = pk.columnNames().toSet();
                if (!existedNames.contains((Object)partColName.toLiteral(table.engine()))) {
                    pk.addColumn(partColName);
                    return;
                }
            });
            table.uniqueKeys().foreach((Function1)(JProcedure1 & Serializable)uk -> {
                Set existedNames = uk.columnNames().toSet();
                if (!existedNames.contains((Object)partColName.toLiteral(table.engine()))) {
                    uk.addColumn(partColName);
                    return;
                }
            });
        });
        etm.table().comment_$eq((Option)Some$.MODULE$.apply((Object)this.getComment(clazz, clazz.getSimpleName())));
        etm.table().module_$eq(etm.module());
    }

    private void secondPass(OrmEntityType etm) {
        this.processProperties(etm, etm, etm.table());
        this.processCache(etm, etm);
    }

    private void processCache(OrmStructType stm, OrmEntityType em) {
        if (em.cacheAll()) {
            stm.properties().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String p = (String)tuple2._1();
                    OrmProperty pm = (OrmProperty)tuple2._2();
                    OrmProperty ormProperty = pm;
                    if (ormProperty instanceof OrmSingularProperty) {
                        OrmSingularProperty spm = (OrmSingularProperty)ormProperty;
                        OrmType ormType = spm.propertyType();
                        if (ormType instanceof OrmEmbeddableType) {
                            OrmEmbeddableType etm = (OrmEmbeddableType)ormType;
                            this.processCache(etm, em);
                            return;
                        }
                        return;
                    }
                    if (ormProperty instanceof OrmPluralProperty) {
                        boolean canCache;
                        OrmPluralProperty ppm = (OrmPluralProperty)ormProperty;
                        OrmType ormType = ppm.element();
                        if (ormType instanceof EntityType) {
                            EntityType et = (EntityType)((Object)ormType);
                            v0 = ((OrmEntityType)this.entityTypes().apply((Object)et.entityName())).cacheable();
                        } else {
                            v0 = canCache = true;
                        }
                        if (canCache) {
                            this.addCollection(new Collection(em.clazz(), p, em.cacheRegion(), em.cacheUsage()));
                            return;
                        }
                        return;
                    }
                    throw new MatchError((Object)ormProperty);
                }
                throw new MatchError((Object)tuple2);
            });
            return;
        }
    }

    private void processProperties(OrmEntityType oet, OrmStructType ost, Table table) {
        ost.properties().foreach((Function1)(JProcedure1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                String p = (String)tuple2._1();
                OrmProperty property = (OrmProperty)tuple2._2();
                OrmProperty ormProperty = property;
                if (ormProperty instanceof OrmSingularProperty) {
                    OrmSingularProperty spm = (OrmSingularProperty)ormProperty;
                    OrmType ormType = spm.propertyType();
                    if (ormType instanceof OrmBasicType) {
                        OrmBasicType btm = (OrmBasicType)ormType;
                        this.addBasicTypeMapping(ost.clazz(), property.name(), btm, btm.column(), table);
                        return;
                    }
                    if (ormType instanceof OrmEntityType) {
                        OrmEntityType btm = (OrmEntityType)ormType;
                        this.addRefTypeMapping(ost.clazz(), property.name(), btm, (Column)spm.joinColumns().head(), table);
                        return;
                    }
                    if (ormType instanceof OrmEmbeddableType) {
                        OrmEmbeddableType etm = (OrmEmbeddableType)ormType;
                        this.processProperties(oet, etm, table);
                        return;
                    }
                    throw new MatchError((Object)ormType);
                }
                if (ormProperty instanceof OrmPluralProperty) {
                    OrmPluralProperty ppm = (OrmPluralProperty)ormProperty;
                    if (ppm.one2many()) {
                        OrmType ormType = ppm.element();
                        if (ormType instanceof EntityType) {
                            EntityType et = (EntityType)((Object)ormType);
                            OrmEntityType etm = this.refEntity(et.clazz(), et.entityName());
                            ppm.mappedBy().foreach((Function1)(JProcedure1 & Serializable)mappedBy -> {
                                if (!etm.properties().contains(mappedBy)) {
                                    throw new RuntimeException("Cannot find mappedBy property " + mappedBy + " in " + etm.entityName());
                                }
                            });
                            boolean defined = etm.table().indexes().exists((Function1 & Serializable)_$3 -> {
                                Object object = _$3.columns().head();
                                Identifier identifier = ppm.ownerColumn().name();
                                return !(object != null ? !object.equals(identifier) : identifier != null);
                            });
                            if (!defined) {
                                etm.table().createIndex("", false, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ppm.ownerColumn().name().value()}));
                                return;
                            }
                            return;
                        }
                        return;
                    }
                    if (ppm.many2many()) {
                        Option<String> option = ppm.mappedBy();
                        if (option instanceof Some) {
                            String mappedBy2 = (String)((Some)option).value();
                            OrmType ormType = ppm.element();
                            if (ormType instanceof OrmEntityType) {
                                OrmEntityType oet = (OrmEntityType)ormType;
                                Table refTable = this.refEntity(oet.clazz(), oet.entityName()).table();
                                String table = refTable.name().toString() + "_" + Strings$.MODULE$.unCamel(mappedBy2, '_');
                                ppm.table_$eq((Option<String>)Some$.MODULE$.apply((Object)table));
                                if (BeanInfos$.MODULE$.get(oet.clazz()).getPropertyType(mappedBy2).isEmpty()) {
                                    throw new RuntimeException("Cannot find " + mappedBy2 + " in " + oet.clazz().getName());
                                }
                                Table collectTable = refTable.schema().getOrCreateTable(table);
                                collectTable.module_$eq(oet.module());
                                collectTable.createIndex(null, false, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ppm.ownerColumn().name().value()}));
                                return;
                            }
                            return;
                        }
                        if (None$.MODULE$.equals(option)) {
                            if (ppm.table().isEmpty()) {
                                ppm.table_$eq((Option<String>)Some$.MODULE$.apply((Object)(table.name().toString() + "_" + Strings$.MODULE$.unCamel(p, '_'))));
                            }
                            Table collectTable = table.schema().getOrCreateTable((String)ppm.table().get());
                            collectTable.module_$eq(oet.module());
                            collectTable.comment_$eq((Option)Some$.MODULE$.apply((Object)this.getComment(ost.clazz(), property.name())));
                            ppm.ownerColumn().comment_$eq((Option)Some$.MODULE$.apply((Object)(this.getComment(oet.clazz(), oet.clazz().getSimpleName()) + "ID")));
                            collectTable.add(ppm.ownerColumn());
                            ppm.inverseColumn().foreach((Function1 & Serializable)c -> collectTable.add(c));
                            ppm.index().foreach((Function1 & Serializable)idxColumn -> collectTable.add(idxColumn));
                            collectTable.createIndex(null, false, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ppm.ownerColumn().name().value()}));
                            this.createForeignKey(collectTable, (Iterable<Column>)((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{ppm.ownerColumn()}))), table);
                            OrmType ormType = ppm.element();
                            if (ormType instanceof OrmBasicType) {
                                OrmBasicType btm = (OrmBasicType)ormType;
                                this.addBasicTypeMapping(ost.clazz(), property.name(), ppm.element(), btm.column(), collectTable);
                            } else if (ormType instanceof OrmEntityType) {
                                OrmEntityType oet = (OrmEntityType)ormType;
                                this.addRefTypeMapping(ost.clazz(), property.name(), oet, (Column)ppm.inverseColumn().get(), collectTable);
                            } else if (ormType instanceof OrmEmbeddableType) {
                                OrmEmbeddableType etm = (OrmEmbeddableType)ormType;
                                etm.properties().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                                    Tuple2 tuple2 = x$1;
                                    if (tuple2 != null) {
                                        String p = (String)tuple2._1();
                                        OrmProperty pm = (OrmProperty)tuple2._2();
                                        OrmProperty ormProperty = pm;
                                        if (ormProperty instanceof OrmSingularProperty) {
                                            OrmSingularProperty spm = (OrmSingularProperty)ormProperty;
                                            OrmType ormType = spm.propertyType();
                                            if (ormType instanceof OrmBasicType) {
                                                OrmBasicType btm = (OrmBasicType)ormType;
                                                this.addBasicTypeMapping(etm.clazz(), p, btm, btm.column(), collectTable);
                                                return;
                                            }
                                            if (ormType instanceof OrmEntityType) {
                                                OrmEntityType oet = (OrmEntityType)ormType;
                                                Class<?> idType = this.idTypeOf(oet.clazz());
                                                Column column = this.newColumn(this.columnName(spm.clazz(), spm.name(), true), idType, spm.optional());
                                                this.addRefTypeMapping(etm.clazz(), property.name(), oet, column, collectTable);
                                                return;
                                            }
                                            if (ormType instanceof OrmStructType) {
                                                OrmStructType ost = (OrmStructType)ormType;
                                                this.processProperties(oet, ost, collectTable);
                                                return;
                                            }
                                            throw new MatchError((Object)ormType);
                                        }
                                        throw new RuntimeException("Cannot support " + pm.getClass().getName() + " in collection");
                                    }
                                    throw new MatchError((Object)tuple2);
                                });
                            } else {
                                throw new MatchError((Object)ormType);
                            }
                            OrmPluralProperty ormPluralProperty = ppm;
                            if (ormPluralProperty instanceof OrmMapProperty) {
                                OrmMapProperty mm = (OrmMapProperty)ormPluralProperty;
                                OrmType ormType2 = mm.key();
                                if (ormType2 instanceof OrmBasicType) {
                                    OrmBasicType obt = (OrmBasicType)ormType2;
                                    v0 = collectTable.add(obt.column());
                                } else if (ormType2 instanceof OrmEntityType) {
                                    OrmEntityType oet = (OrmEntityType)ormType2;
                                    v0 = collectTable.add(mm.keyColumn());
                                } else {
                                    v0 = BoxedUnit.UNIT;
                                }
                            } else {
                                v0 = BoxedUnit.UNIT;
                            }
                            collectTable.createPrimaryKey(null, (Seq)((ListBuffer)collectTable.columns().map((Function1 & Serializable)_$4 -> _$4.name().toLiteral(table.engine()))).toList());
                            return;
                        }
                        throw new MatchError(option);
                    }
                    return;
                }
                throw new MatchError((Object)ormProperty);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private void addRefComment(Column column, Class<?> clazz, String entityName) {
        column.comment_$eq((Option)Some$.MODULE$.apply((Object)(this.getComment(clazz, clazz.getSimpleName()) + "ID")));
    }

    private void addBasicTypeMapping(Class<?> clazz, String propertyName, Type typ, Column column, Table table) {
        this.detectValueType(typ.clazz());
        if (column.comment().isEmpty()) {
            column.comment_$eq((Option)Some$.MODULE$.apply((Object)this.getComment(clazz, propertyName)));
        }
        if (!table.columnExits(column.name())) {
            table.add(column);
            return;
        }
    }

    private void addRefTypeMapping(Class<?> clazz, String propertyName, EntityType refType, Column column, Table table) {
        if (refType.partitionKey().isEmpty() && !clazz.isAnnotationPresent(archive.class)) {
            this.createForeignKey(table, (Iterable<Column>)((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{column}))), ((OrmEntityType)this.entityTypes().apply((Object)refType.entityName())).table());
        }
        if (column.comment().isEmpty() && column.name().value().toLowerCase().endsWith("id")) {
            String fkc;
            String string = fkc = this.getComment(clazz, propertyName);
            String string2 = propertyName + "?";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.addRefComment(column, refType.clazz(), refType.clazz().getSimpleName());
            } else {
                column.comment_$eq((Option)Some$.MODULE$.apply((Object)(fkc + "ID")));
            }
        }
        if (!table.columnExits(column.name())) {
            table.add(column);
            return;
        }
    }

    private void createForeignKey(Table table, Iterable<Column> columns, Table refTable) {
        table.createForeignKey(null, ((Column)columns.head()).name().toLiteral(table.engine()), refTable);
    }

    private String getComment(Class<?> clazz, String key) {
        String comment = this.messages.get(clazz, key);
        String string = key;
        String string2 = comment;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return key + "?";
        }
        return comment;
    }

    private void merge(OrmEntityType entity) {
        Class<?> cls = entity.clazz();
        ListBuffer supers = new ListBuffer();
        Object object = Predef$.MODULE$.refArrayOps((Object[])cls.getInterfaces());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)i -> {
            if (this.classTypes().contains(i)) {
                supers.$plus$eq(this.classTypes().apply(i));
                return;
            }
        });
        for (Class<?> supclz = cls.getSuperclass(); supclz != null; supclz = supclz.getSuperclass()) {
            Class<?> clazz = supclz;
            Class<Object> clazz2 = Object.class;
            if (!(clazz == null ? clazz2 != null : !clazz.equals(clazz2))) break;
            if (this.classTypes().contains(supclz)) {
                supers.$plus$eq(this.classTypes().apply(supclz));
            }
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])supclz.getInterfaces());
            ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)i -> {
                if (this.classTypes().contains(i)) {
                    supers.$plus$eq(this.classTypes().apply(i));
                    return;
                }
            });
        }
        scala.collection.mutable.Map inheris = Collections$.MODULE$.newMap();
        ObjectRef partitionKey = ObjectRef.create((Object)None$.MODULE$);
        ((IterableOnceOps)supers.reverse()).foreach((Function1)(JProcedure1 & Serializable)e -> {
            inheris.$plus$plus$eq((IterableOnce)e.properties().filter((Function1 & Serializable)_$5 -> !((OrmProperty)_$5._2()).mergeable()));
            if (entity.idGenerator() == null) {
                entity.idGenerator_$eq(e.idGenerator());
            }
            if (entity.cacheRegion() == null && entity.cacheUsage() == null) {
                entity.cache(e.cacheRegion(), e.cacheUsage());
            }
            if (e.partitionKey().nonEmpty()) {
                Option option;
                partitionKey$1.elem = option = e.partitionKey();
                option = null;
                return;
            }
        });
        scala.collection.mutable.Map inherited = Collections$.MODULE$.newMap();
        inheris.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                OrmProperty p = (OrmProperty)tuple2._2();
                if (((OrmProperty)entity.properties().apply((Object)name)).mergeable()) {
                    inherited.put((Object)name, (Object)p.copy());
                    return;
                }
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        if (entity.partitionKey().isEmpty() && ((Option)partitionKey.elem).nonEmpty()) {
            entity.partitionKey_$eq((Option<String>)((Option)partitionKey.elem));
        }
        entity.addProperties((Map<String, OrmProperty>)inherited);
    }

    private void bindComponent(OrmEntityType entity, OrmStructType c, String name, TypeInfo typeInfo) {
        Class propertyType = typeInfo.clazz();
        boolean optional = typeInfo.isOptional();
        OrmEmbeddableType oet = new OrmEmbeddableType(propertyType);
        OrmSingularProperty cpm = new OrmSingularProperty(name, propertyType, optional, oet);
        c.addProperty(cpm);
        BeanInfo manifest = BeanInfos$.MODULE$.get(propertyType);
        Object sample = Reflections$.MODULE$.newInstance(propertyType);
        manifest.readables().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                BeanInfo.PropertyInfo prop = (BeanInfo.PropertyInfo)tuple2._2();
                if (!prop.isTransient() && prop.readable() && prop.writable()) {
                    Class propType;
                    TypeInfo typeinfo = prop.typeinfo();
                    Class clazz = propType = typeinfo.isOptional() ? ((TypeInfo)typeinfo.args().apply(0)).clazz() : typeinfo.clazz();
                    if (Jpas$.MODULE$.isEntity(propType)) {
                        Class clazz2 = propType;
                        Class<?> clazz3 = entity.clazz();
                        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                            oet.parentName_$eq((Option<String>)Some$.MODULE$.apply((Object)name));
                            return;
                        }
                        this.bindManyToOne(entity, oet, name, typeinfo);
                        return;
                    }
                    if (Jpas$.MODULE$.isSeq(propType) || Jpas$.MODULE$.isSet(propType)) {
                        this.bindCollection(entity, oet, name, typeinfo);
                        return;
                    }
                    if (Jpas$.MODULE$.isMap(propType)) {
                        this.bindMap(entity, oet, name, typeinfo);
                        return;
                    }
                    if (Jpas$.MODULE$.isComponent(propType)) {
                        this.bindComponent(entity, oet, name, typeinfo);
                        return;
                    }
                    this.bindScalar(entity, oet, name, typeinfo, sample);
                    return;
                }
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private void detectValueType(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        Class<Object> clazz3 = Object.class;
        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
            throw new RuntimeException("Cannot find scalar type for object");
        }
        if (clazz.isAnnotationPresent(value.class)) {
            this.valueTypes().$plus$eq(clazz);
            return;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            this.enumTypes().$plus$eq((Object)clazz.getName());
            return;
        }
    }

    private Class<?> idTypeOf(Class<?> clazz) {
        if (LongIdEntity.class.isAssignableFrom(clazz)) {
            return Long.TYPE;
        }
        if (IntIdEntity.class.isAssignableFrom(clazz)) {
            return Integer.TYPE;
        }
        if (ShortIdEntity.class.isAssignableFrom(clazz)) {
            return Short.TYPE;
        }
        if (StringIdEntity.class.isAssignableFrom(clazz)) {
            return String.class;
        }
        return (Class)BeanInfos$.MODULE$.get(clazz).getPropertyType("id").get();
    }

    private void bindMap(OrmEntityType entity, OrmStructType c, String name, TypeInfo typeInfo) {
        TypeInfo.IterableType it = (TypeInfo.IterableType)typeInfo;
        ArraySeq kvtype = it.elementType().args();
        Class mapKeyClazz = ((TypeInfo)kvtype.apply(0)).clazz();
        Class mapEleClazz = ((TypeInfo)kvtype.apply(1)).clazz();
        OrmType keyMeta = null;
        Column keyColumn = null;
        if (Jpas$.MODULE$.isEntity(mapKeyClazz)) {
            keyMeta = this.refEntity(mapKeyClazz, mapKeyClazz.getName());
            keyColumn = this.newRefColumn(mapKeyClazz, mapKeyClazz.getName());
        } else {
            keyColumn = this.newColumn("name", mapKeyClazz, false);
            keyColumn.comment_$eq((Option)Some$.MODULE$.apply((Object)"name"));
            keyMeta = new OrmBasicType(mapKeyClazz, keyColumn);
        }
        OrmType eleMeta = this.buildElement(mapEleClazz, mapEleClazz.getName());
        OrmMapProperty property = new OrmMapProperty(name, typeInfo.clazz(), keyMeta, eleMeta);
        c.addProperty(property);
        property.keyColumn_$eq(keyColumn);
        property.ownerColumn_$eq(this.newRefColumn(entity.clazz(), entity.entityName()));
        OrmType ormType = eleMeta;
        if (ormType instanceof OrmEntityType) {
            OrmEntityType oet = (OrmEntityType)ormType;
            property.inverseColumn_$eq((Option<Column>)Some$.MODULE$.apply((Object)this.newRefColumn(oet.clazz(), oet.entityName())));
            return;
        }
    }

    private void bindCollection(OrmEntityType entity, OrmStructType c, String name, TypeInfo typeInfo) {
        Class entityClazz = ((TypeInfo.IterableType)typeInfo).elementType().clazz();
        String entityName = entityClazz.getName();
        OrmType typ = this.buildElement(entityClazz, entityName);
        OrmCollectionProperty property = new OrmCollectionProperty(name, typeInfo.clazz(), typ);
        c.addProperty(property);
        property.ownerColumn_$eq(this.newRefColumn(entity.clazz(), entity.entityName()));
        OrmType ormType = typ;
        if (ormType instanceof OrmEntityType) {
            property.inverseColumn_$eq((Option<Column>)Some$.MODULE$.apply((Object)this.newRefColumn(entityClazz, entityName)));
            return;
        }
    }

    private OrmType buildElement(Class<?> clazz, String entityName) {
        if (Jpas$.MODULE$.isEntity(clazz)) {
            return this.refEntity(clazz, entityName);
        }
        if (Jpas$.MODULE$.isComponent(clazz)) {
            OrmEmbeddableType e = new OrmEmbeddableType(clazz);
            BeanInfo manifest = BeanInfos$.MODULE$.get(clazz);
            Object sample = Reflections$.MODULE$.newInstance(clazz);
            manifest.readables().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    BeanInfo.PropertyInfo prop = (BeanInfo.PropertyInfo)tuple2._2();
                    if (!prop.isTransient() && prop.readable() && prop.writable()) {
                        boolean optional = prop.typeinfo().isOptional();
                        Class propType = prop.typeinfo().clazz();
                        OrmSingularProperty property = null;
                        if (Jpas$.MODULE$.isEntity(propType)) {
                            OrmEntityType ormType = this.refEntity(propType, propType.getName());
                            Class<?> idType = this.idTypeOf(propType);
                            Column column = this.newColumn(this.columnName(propType, name, true), idType, optional);
                            this.addRefComment(column, ormType.clazz(), ormType.entityName());
                            OrmSingularProperty sp2 = new OrmSingularProperty(name, propType, optional, ormType);
                            sp2.joinColumns_$eq((Seq<Column>)((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{column}))));
                            property = sp2;
                        } else if (Jpas$.MODULE$.isComponent(propType)) {
                            property = new OrmSingularProperty(name, propType, optional, this.buildElement(propType, null));
                        } else {
                            Column column = this.newScalarColumn(this.columnName(propType, name, this.columnName$default$3()), propType, optional, this.findDefaultValue(sample, name, propType, optional));
                            OrmBasicType ormType = new OrmBasicType(propType, column);
                            property = new OrmSingularProperty(name, propType, optional, ormType);
                        }
                        e.addProperty(property);
                        return;
                    }
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            return e;
        }
        return new OrmBasicType(clazz, this.newColumn("value_", clazz, false));
    }

    private void bindId(OrmEntityType entity, String name, TypeInfo typeinfo) {
        Class clazz = typeinfo.clazz();
        Column column = this.newColumn(this.columnName(entity.clazz(), name, this.columnName$default$3()), clazz, false);
        column.nullable_$eq(false);
        OrmSingularProperty property = new OrmSingularProperty(name, clazz, false, new OrmBasicType(clazz, column));
        entity.addProperty(property);
        entity.table().add(column);
    }

    private void bindScalar(OrmEntityType entity, OrmStructType c, String name, TypeInfo typeInfo, Object sample) {
        Class clazz = typeInfo.isOptional() ? ((TypeInfo)typeInfo.args().apply(0)).clazz() : typeInfo.clazz();
        this.detectValueType(clazz);
        Option<String> defaultValue = this.findDefaultValue(sample, name, clazz, typeInfo.isOptional());
        Column column = this.newScalarColumn(this.columnName(c.clazz(), name, this.columnName$default$3()), clazz, typeInfo.isOptional(), defaultValue);
        OrmSingularProperty property = new OrmSingularProperty(name, clazz, typeInfo.isOptional(), new OrmBasicType(clazz, column));
        entity.table().add(column);
        c.addProperty(property);
    }

    private void bindManyToOne(OrmEntityType entity, OrmStructType c, String name, TypeInfo typeInfo) {
        Class clazz = typeInfo.isOptional() ? ((TypeInfo)typeInfo.args().apply(0)).clazz() : typeInfo.clazz();
        OrmEntityType typ = this.refEntity(clazz, clazz.getName());
        Class<?> idType = this.idTypeOf(clazz);
        Column column = this.newColumn(this.columnName(c.clazz(), name, true), idType, typeInfo.isOptional());
        OrmSingularProperty property = new OrmSingularProperty(name, clazz, typeInfo.isOptional(), typ);
        property.joinColumns_$eq((Seq<Column>)((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{column}))));
        c.addProperty(property);
        entity.table().add(column);
    }

    private Option<String> findDefaultValue(Object sample, String propertyName, Class<?> propertyClazz, boolean optional) {
        if (propertyClazz.isPrimitive() && !optional && sample != null) {
            String value2;
            SqlType sqlType = this.sqlTypeMapping().sqlType(propertyClazz);
            String string = value2 = Properties$.MODULE$.get(sample, propertyName, ClassTag$.MODULE$.Any()).toString();
            String string2 = "0.0";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                value2 = "0";
            }
            return this.database().engine().convert(sqlType, value2);
        }
        return None$.MODULE$;
    }

    private Column newScalarColumn(String name, Class<?> clazz, boolean optional, Option<String> defaultValue) {
        Column col = new Column(this.database().engine().toIdentifier(name), this.sqlTypeMapping().sqlType(clazz), optional);
        col.defaultValue_$eq(defaultValue);
        return col;
    }

    private Column newColumn(String name, Class<?> clazz, boolean optional) {
        return new Column(this.database().engine().toIdentifier(name), this.sqlTypeMapping().sqlType(clazz), optional);
    }

    public Column newRefColumn(Class<?> clazz, String entityName) {
        Class<?> idType = this.idTypeOf(clazz);
        Column column = new Column(this.database().engine().toIdentifier(this.columnName(clazz, entityName, true)), this.sqlTypeMapping().sqlType(idType), false);
        this.addRefComment(column, clazz, entityName);
        return column;
    }
}

