/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.dao;

import java.io.Serializable;
import org.beangle.commons.collection.Order;
import org.beangle.commons.collection.Order$;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.collection.page.PageLimit$;
import org.beangle.commons.lang.Assert$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.AbstractQueryBuilder$;
import org.beangle.data.dao.Condition;
import org.beangle.data.dao.Conditions$;
import org.beangle.data.dao.Query;
import org.beangle.data.dao.QueryBean;
import org.beangle.data.dao.QueryBuilder;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public abstract class AbstractQueryBuilder<T>
implements QueryBuilder<T> {
    private String statement;
    private PageLimit limit;
    private final HashMap params = new HashMap();
    private String select;
    private String from;
    private String alias;
    private List conditions = package$.MODULE$.Nil();
    private List orders = package$.MODULE$.Nil();
    private List groups = package$.MODULE$.Nil();
    private String having;
    private Option tailOrder = None$.MODULE$;
    private boolean cacheable = false;

    public static String InnerJoin() {
        return AbstractQueryBuilder$.MODULE$.InnerJoin();
    }

    public static String OuterJoin() {
        return AbstractQueryBuilder$.MODULE$.OuterJoin();
    }

    public static String RightOuterJoin() {
        return AbstractQueryBuilder$.MODULE$.RightOuterJoin();
    }

    public String statement() {
        return this.statement;
    }

    public void statement_$eq(String x$1) {
        this.statement = x$1;
    }

    public PageLimit limit() {
        return this.limit;
    }

    public void limit_$eq(PageLimit x$1) {
        this.limit = x$1;
    }

    public HashMap<String, Object> params() {
        return this.params;
    }

    public String select() {
        return this.select;
    }

    public void select_$eq(String x$1) {
        this.select = x$1;
    }

    public String from() {
        return this.from;
    }

    public void from_$eq(String x$1) {
        this.from = x$1;
    }

    public String alias() {
        return this.alias;
    }

    public void alias_$eq(String x$1) {
        this.alias = x$1;
    }

    public List<Condition> conditions() {
        return this.conditions;
    }

    public void conditions_$eq(List<Condition> x$1) {
        this.conditions = x$1;
    }

    public List<Order> orders() {
        return this.orders;
    }

    public void orders_$eq(List<Order> x$1) {
        this.orders = x$1;
    }

    public List<String> groups() {
        return this.groups;
    }

    public void groups_$eq(List<String> x$1) {
        this.groups = x$1;
    }

    public String having() {
        return this.having;
    }

    public void having_$eq(String x$1) {
        this.having = x$1;
    }

    public Option<Order> tailOrder() {
        return this.tailOrder;
    }

    public void tailOrder_$eq(Option<Order> x$1) {
        this.tailOrder = x$1;
    }

    public boolean cacheable() {
        return this.cacheable;
    }

    public void cacheable_$eq(boolean x$1) {
        this.cacheable = x$1;
    }

    @Override
    public Query<T> build() {
        QueryBean queryBean = new QueryBean();
        queryBean.statement_$eq(this.genStatement());
        queryBean.params_$eq((scala.collection.immutable.Map<String, Object>)this.params().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        queryBean.limit_$eq(this.limit());
        queryBean.countStatement_$eq(this.genCountStatement());
        queryBean.cacheable_$eq(this.cacheable());
        queryBean.lang_$eq(this.lang());
        return queryBean;
    }

    public abstract Query.Lang lang();

    public AbstractQueryBuilder select(String what) {
        this.select_$eq((String)(what == null ? null : (what.toLowerCase().trim().startsWith("select") ? what : "select " + what)));
        return this;
    }

    public AbstractQueryBuilder newFrom(String from) {
        this.from_$eq((String)(from == null ? null : (Strings$.MODULE$.contains((CharSequence)from.toLowerCase(), (CharSequence)"from") ? from : "from " + from)));
        return this;
    }

    public AbstractQueryBuilder alias(String alias) {
        this.alias_$eq(alias);
        return this;
    }

    public AbstractQueryBuilder limit(PageLimit limit) {
        this.limit_$eq(limit);
        return this;
    }

    public AbstractQueryBuilder limit(int pageIndex, int pageSize) {
        this.limit_$eq(PageLimit$.MODULE$.apply(pageIndex, pageSize));
        return this;
    }

    public AbstractQueryBuilder cacheable(boolean cacheable) {
        this.cacheable_$eq(true);
        return this;
    }

    public boolean cacheable$default$1() {
        return true;
    }

    public AbstractQueryBuilder join(String path, String alias) {
        this.from_$eq(Strings$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.from(), " join ", path, " ", alias})));
        return this;
    }

    public AbstractQueryBuilder join(String joinMode, String path, String alias) {
        this.from_$eq(Strings$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.from(), " ", joinMode, " join ", path, " ", alias})));
        return this;
    }

    @Override
    public AbstractQueryBuilder params(Map<String, Object> newparams) {
        this.params().$plus$plus$eq(newparams);
        return this;
    }

    public AbstractQueryBuilder param(String name, Object value) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)name);
        this.params().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, value));
        return this;
    }

    public AbstractQueryBuilder where(Condition condition) {
        if (Strings$.MODULE$.isNotEmpty((CharSequence)this.statement())) {
            throw new RuntimeException("cannot add condition to a exists statement");
        }
        this.conditions_$eq((List<Condition>)((List)this.conditions().$colon$plus((Object)condition)));
        return this.params((Map)Conditions$.MODULE$.getParamMap(condition));
    }

    public AbstractQueryBuilder where(Seq<Condition> cons) {
        this.conditions_$eq((List<Condition>)((List)this.conditions().$plus$plus(cons)));
        return this.params((Map)Conditions$.MODULE$.getParamMap(cons));
    }

    public AbstractQueryBuilder where(String content, Seq<Object> params) {
        return this.where(new Condition(content, params));
    }

    public AbstractQueryBuilder tailOrder(String order) {
        this.tailOrder_$eq((Option<Order>)Order$.MODULE$.parse(order).headOption());
        return this;
    }

    public AbstractQueryBuilder orderBy(String order) {
        this.orderBy((List<Order>)Order$.MODULE$.parse(order));
        return this;
    }

    public AbstractQueryBuilder orderBy(int index, String order) {
        if (Strings$.MODULE$.isNotEmpty((CharSequence)this.statement())) {
            throw new RuntimeException("cannot add order by to a exists statement.");
        }
        List list = this.orders().slice(0, index);
        List list2 = Order$.MODULE$.parse(order);
        this.orders_$eq((List<Order>)this.orders().slice(index, this.orders().size()).$colon$colon$colon(list2).$colon$colon$colon(list));
        return this;
    }

    public AbstractQueryBuilder orderBy(Order order) {
        if (order != null) {
            this.orderBy((List<Order>)((List)new .colon.colon((Object)order, (List)Nil$.MODULE$)));
        }
        return this;
    }

    public AbstractQueryBuilder clearOrders() {
        this.orders_$eq((List<Order>)package$.MODULE$.Nil());
        return this;
    }

    public AbstractQueryBuilder clearGroups() {
        this.groups_$eq((List<String>)package$.MODULE$.Nil());
        return this;
    }

    public AbstractQueryBuilder orderBy(List<Order> orders) {
        if (orders != null) {
            if (Strings$.MODULE$.isNotEmpty((CharSequence)this.statement())) {
                throw new RuntimeException("cannot add order by to a exists statement.");
            }
            List<Order> list = this.orders();
            this.orders_$eq((List<Order>)orders.$colon$colon$colon(list));
        }
        return this;
    }

    public AbstractQueryBuilder groupBy(String what) {
        if (Strings$.MODULE$.isNotEmpty((CharSequence)what)) {
            this.groups_$eq((List<String>)((List)this.groups().$colon$plus((Object)what)));
        }
        return this;
    }

    public AbstractQueryBuilder having(String what) {
        Assert$.MODULE$.isTrue(this.groups().nonEmpty());
        if (Strings$.MODULE$.isNotEmpty((CharSequence)what)) {
            this.having_$eq(what);
        }
        return this;
    }

    public String genStatement() {
        if (Strings$.MODULE$.isNotEmpty((CharSequence)this.statement())) {
            return this.statement();
        }
        return this.genQueryStatement(true);
    }

    public abstract String genCountStatement();

    public String genQueryStatement(boolean hasOrder) {
        if (this.from() == null) {
            return this.statement();
        }
        StringBuilder buf = new StringBuilder(50);
        if (this.select() != null) {
            buf.append(this.select() + " ").append(this.from());
        }
        if (this.conditions().nonEmpty()) {
            buf.append(" where ").append(Conditions$.MODULE$.toQueryString(this.conditions()));
        }
        if (this.groups().nonEmpty()) {
            buf.append(" group by ");
            this.groups().foreach((Function1 & Serializable)groupBy -> buf.append(groupBy).append(','));
            buf.deleteCharAt(buf.length() - 1);
        }
        if (this.having() != null) {
            buf.append(" having ").append(this.having());
        }
        if (hasOrder && (this.orders().nonEmpty() || this.tailOrder().nonEmpty())) {
            if (this.hasGroupBy()) {
                if (this.orders().nonEmpty()) {
                    buf.append(' ').append(Order$.MODULE$.toSortString(this.orders()));
                }
            } else {
                Option<Order> option = this.tailOrder();
                if (None$.MODULE$.equals(option)) {
                    buf.append(' ').append(Order$.MODULE$.toSortString(this.orders()));
                } else if (option instanceof Some) {
                    Order o = (Order)((Some)option).value();
                    if (this.orders().isEmpty()) {
                        buf.append(' ').append(Order$.MODULE$.toSortString(this.tailOrder().toList()));
                    } else {
                        String originOrderBy = Order$.MODULE$.toSortString(this.orders());
                        buf.append(' ').append(originOrderBy);
                        if (!originOrderBy.contains(o.property())) {
                            buf.append(',').append(o.toString());
                        }
                    }
                } else {
                    throw new MatchError(option);
                }
            }
        }
        return buf.mkString();
    }

    public boolean hasGroupBy() {
        return this.groups().nonEmpty();
    }

    public boolean hasOrderBy() {
        return this.orders().nonEmpty();
    }
}

