/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.orm.hibernate;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import org.beangle.commons.bean.Initializing;
import org.beangle.commons.collection.page.Page;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.collection.page.PageLimit$;
import org.beangle.commons.collection.page.SinglePage;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.annotation.description;
import org.beangle.commons.logging.Logging;
import org.beangle.data.dao.AbstractQueryBuilder;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.LimitQuery;
import org.beangle.data.dao.Operation;
import org.beangle.data.dao.OperationType;
import org.beangle.data.dao.OperationType$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.Entity;
import org.beangle.data.model.meta.Domain;
import org.beangle.data.model.meta.EntityType;
import org.beangle.data.orm.Jpas$;
import org.beangle.data.orm.hibernate.DomainFactory$;
import org.beangle.data.orm.hibernate.HibernateProxyResolver$;
import org.beangle.data.orm.hibernate.QuerySupport$;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.jdk.javaapi.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

@description(value="\u57fa\u4e8eHibernate\u63d0\u4f9b\u7684\u901a\u7528\u5b9e\u4f53DAO")
public class HibernateEntityDao
implements EntityDao,
Logging,
Initializing {
    private Logger logger;
    private final SessionFactory sessionFactory;
    private Domain domain;

    public HibernateEntityDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        Logging.$init$((Logging)this);
        Jpas$.MODULE$.proxyResolver_$eq(HibernateProxyResolver$.MODULE$);
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public SessionFactory sessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public Domain domain() {
        return this.domain;
    }

    public void domain_$eq(Domain x$1) {
        this.domain = x$1;
    }

    public void init() {
        if (this.domain() == null) {
            this.domain_$eq(DomainFactory$.MODULE$.build(this.sessionFactory()));
            return;
        }
    }

    public Session currentSession() {
        return this.sessionFactory().getCurrentSession();
    }

    private Query<?> createQuery(String hql) {
        return this.currentSession().createQuery(hql, null);
    }

    public String entityNameOf(Class<?> clazz) {
        Option<EntityType> option = this.domain().getEntity(clazz);
        if (option instanceof Some) {
            EntityType e = (EntityType)((Some)option).value();
            return e.entityName();
        }
        if (None$.MODULE$.equals(option)) {
            return clazz.getName();
        }
        throw new MatchError(option);
    }

    @Override
    public <T extends Entity<ID>, ID> T get(Class<T> clazz, ID id) {
        return (T)((Entity)this.find(this.entityNameOf(clazz), id).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Override
    public <T> scala.collection.immutable.Seq<T> getAll(Class<T> clazz) {
        String hql = "from " + this.entityNameOf(clazz);
        Query<?> query = this.createQuery(hql);
        query.setCacheable(true);
        return CollectionConverters$.MODULE$.asScala(query.list()).toList();
    }

    public <T extends Entity<ID>, ID> Option<T> find(String entityName, ID id) {
        if (Strings$.MODULE$.contains((CharSequence)entityName, 46)) {
            Object obj = this.currentSession().get(entityName, (Object)((Serializable)id));
            if (obj == null) {
                return None$.MODULE$;
            }
            return Some$.MODULE$.apply((Object)((Entity)obj));
        }
        String hql = "from " + entityName + " where id =:id";
        Query<?> query = this.createQuery(hql);
        query.setParameter("id", id);
        java.util.List rs = query.list();
        if (rs.isEmpty()) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)((Entity)rs.get(0)));
    }

    @Override
    public <T extends Entity<ID>, ID> Option<T> find(Class<T> clazz, ID id) {
        return this.find(this.entityNameOf(clazz), id);
    }

    @Override
    public <T extends Entity<ID>, ID> scala.collection.immutable.Seq<T> find(Class<T> clazz, Iterable<ID> ids) {
        return this.findByMulti(this.entityNameOf(clazz), "id", ids);
    }

    @Override
    public <T extends Entity<?>> scala.collection.immutable.Seq<T> findBy(Class<T> clazz, String key, Object value2) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, value2);
        return this.findBy(clazz, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
    }

    @Override
    public <T extends Entity<?>> scala.collection.immutable.Seq<T> findBy(Class<T> clazz, scala.collection.immutable.Seq<Tuple2<String, Object>> kvs) {
        return this.findBy(clazz, (Map<String, ?>)kvs.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Override
    public <T extends Entity<?>> scala.collection.immutable.Seq<T> findBy(Class<T> clazz, Map<String, ?> params) {
        if (clazz == null || params == null || params.isEmpty()) {
            return package$.MODULE$.List().empty();
        }
        String entityName = this.entityNameOf(clazz);
        StringBuilder hql = new StringBuilder("from " + entityName + " where ");
        Tuple2<String, Map<String, Object>> where = this.buildWhere(params, this.buildWhere$default$2());
        hql.append((String)where._1());
        return this.search(hql.toString(), (Map)where._2());
    }

    private <T extends Entity<?>> scala.collection.immutable.Seq<T> findByMulti(String entityName, String keyName, Iterable<?> values) {
        if (values.isEmpty()) {
            return package$.MODULE$.List().empty();
        }
        String hql = "from " + entityName + " as entity where entity." + keyName + " in (:values)";
        HashMap parameterMap = new HashMap();
        if (values.size() < 500) {
            parameterMap.put((Object)"values", values);
            OqlBuilder query = OqlBuilder$.MODULE$.oql(hql);
            return this.search(((AbstractQueryBuilder)query.params((Map)parameterMap)).build());
        }
        OqlBuilder query = OqlBuilder$.MODULE$.oql(hql);
        ListBuffer rs = new ListBuffer();
        for (int i = 0; i < values.size(); i += 500) {
            int end = i + 500;
            if (end > values.size()) {
                end = values.size();
            }
            parameterMap.put((Object)"values", values.slice(i, end));
            rs.$plus$plus$eq(this.search(((AbstractQueryBuilder)query.params((Map)parameterMap)).build()));
        }
        return rs.toList();
    }

    private Tuple2<String, Map<String, Object>> buildWhere(Map<String, ?> params, String prefix) {
        HashMap parameterMap = new HashMap();
        ArrayBuffer conditions = new ArrayBuffer();
        IntRef i = IntRef.create((int)0);
        params.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            block4: {
                String name;
                Object v;
                String k;
                block6: {
                    block5: {
                        tuple2 = x$1;
                        if (tuple2 == null) break block4;
                        k = (String)tuple2._1();
                        v = tuple2._2();
                        ++i$1.elem;
                        String[] tempName = Strings$.MODULE$.split(k, "\\.");
                        name = tempName[tempName.length - 1] + i$1.elem;
                        if (QuerySupport$.MODULE$.isMultiValue(v)) {
                            parameterMap.put((Object)name, v);
                            return (ArrayBuffer)conditions.$plus$eq((Object)(prefix + k + " in (:" + name + ")"));
                        }
                        if (v == null) break block5;
                        Object object = v;
                        None$ none$ = None$.MODULE$;
                        if (object != null ? !object.equals(none$) : none$ != null) break block6;
                    }
                    return (ArrayBuffer)conditions.$plus$eq((Object)(prefix + k + " is null"));
                }
                parameterMap.put((Object)name, v);
                return (ArrayBuffer)conditions.$plus$eq((Object)(prefix + k + " = :" + name));
            }
            throw new MatchError((Object)tuple2);
        });
        return Tuple2$.MODULE$.apply((Object)conditions.mkString(" and "), (Object)parameterMap);
    }

    private String buildWhere$default$2() {
        return "";
    }

    @Override
    public int count(Class<?> clazz, scala.collection.immutable.Seq<Tuple2<String, Object>> kvs) {
        return this.count(clazz, (Map<String, ?>)kvs.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Override
    public int count(Class<?> clazz, Map<String, ?> params) {
        String entityName = this.entityNameOf(clazz);
        Tuple2<String, Map<String, Object>> where = this.buildWhere(params, this.buildWhere$default$2());
        String hql = Strings$.MODULE$.isEmpty((CharSequence)where._1()) ? "select count(*) from " + entityName : "select count(*) from " + entityName + " where " + where._1();
        scala.collection.immutable.Seq rs = this.search(hql, (Map)where._2());
        if (rs.isEmpty()) {
            return 0;
        }
        return ((Number)rs.head()).intValue();
    }

    @Override
    public boolean exists(Class<?> clazz, scala.collection.immutable.Seq<Tuple2<String, Object>> kvs) {
        return this.count(clazz, (Map<String, ?>)kvs.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())) > 0;
    }

    @Override
    public boolean exists(Class<?> clazz, Map<String, ?> params) {
        return this.count(clazz, params) > 0;
    }

    @Override
    public <T extends Entity<?>> boolean duplicate(Class<T> clazz, Object id, Map<String, ?> params) {
        Tuple2<String, Map<String, Object>> where;
        String entityName = this.entityNameOf(clazz);
        String hql = "from " + entityName + " where " + (where = this.buildWhere(params, this.buildWhere$default$2()))._1();
        scala.collection.immutable.Seq<T> list = this.search(hql, (Map)where._2());
        if (list.isEmpty()) {
            return false;
        }
        if (id == null) {
            return true;
        }
        return list.exists((Function1 & Serializable)e -> !BoxesRunTime.equals(e.id(), (Object)id));
    }

    @Override
    public <T> scala.collection.immutable.Seq<T> search(org.beangle.data.dao.Query<T> query) {
        org.beangle.data.dao.Query<T> query2 = query;
        if (query2 instanceof LimitQuery) {
            LimitQuery limitQuery = (LimitQuery)query2;
            if (limitQuery.limit() == null) {
                return QuerySupport$.MODULE$.doFind(limitQuery, this.currentSession());
            }
            return new SinglePage(limitQuery.limit().pageIndex(), limitQuery.limit().pageSize(), QuerySupport$.MODULE$.doCount(limitQuery, this.currentSession()), QuerySupport$.MODULE$.doFind(query, this.currentSession()));
        }
        return QuerySupport$.MODULE$.doFind(query, this.currentSession());
    }

    @Override
    public <T> scala.collection.immutable.Seq<T> search(QueryBuilder<T> builder) {
        return this.search(builder.build());
    }

    @Override
    public <T> scala.collection.immutable.Seq<T> search(String query, scala.collection.immutable.Seq<Object> params) {
        return QuerySupport$.MODULE$.list(QuerySupport$.MODULE$.setParameters(this.getNamedOrCreateQuery(query), (Iterable<?>)params));
    }

    @Override
    public <T> scala.collection.immutable.Seq<T> search(String queryString, Map<String, ?> params) {
        return QuerySupport$.MODULE$.list(QuerySupport$.MODULE$.setParameters(this.getNamedOrCreateQuery(queryString), params));
    }

    @Override
    public <T> scala.collection.immutable.Seq<T> search(String queryString, Map<String, ?> params, PageLimit limit, boolean cacheable) {
        Query<T> query = this.getNamedOrCreateQuery(queryString);
        query.setCacheable(cacheable);
        if (limit == null) {
            return QuerySupport$.MODULE$.list(QuerySupport$.MODULE$.setParameters(query, params));
        }
        return this.paginateQuery(query, params, limit);
    }

    @Override
    public <T> T unique(QueryBuilder<T> builder) {
        scala.collection.immutable.Seq<T> list = this.search(builder.build());
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return (T)list.head();
        }
        throw new RuntimeException("not unique query" + builder);
    }

    @Override
    public <T> Option<T> first(QueryBuilder<T> builder) {
        return this.topN(1, builder).headOption();
    }

    @Override
    public <T> scala.collection.immutable.Seq<T> topN(int limit, QueryBuilder<T> builder) {
        builder.limit(PageLimit$.MODULE$.apply(1, limit));
        return QuerySupport$.MODULE$.doFind(builder.build(), this.currentSession());
    }

    @Override
    public <T> scala.collection.immutable.Seq<T> topN(int limit, String queryString, scala.collection.immutable.Seq<Object> params) {
        Query<T> query = QuerySupport$.MODULE$.setParameters(this.getNamedOrCreateQuery(queryString), (Iterable<?>)params);
        return QuerySupport$.MODULE$.list(query.setMaxResults(limit));
    }

    private <T> Page<T> paginateQuery(Query<T> query, Map<String, ?> params, PageLimit limit) {
        QuerySupport$.MODULE$.setParameters(query, params);
        query.setFirstResult((limit.pageIndex() - 1) * limit.pageSize()).setMaxResults(limit.pageSize());
        java.util.List targetList = query.list();
        String queryStr = this.buildCountQueryStr(query);
        Query countQuery = null;
        countQuery = query instanceof NativeQuery ? (Query)this.currentSession().createNativeQuery(queryStr) : this.createQuery(queryStr);
        QuerySupport$.MODULE$.setParameters(countQuery, params);
        return new SinglePage(limit.pageIndex(), limit.pageSize(), ((Number)countQuery.uniqueResult()).intValue(), (Seq)CollectionConverters$.MODULE$.asScala(targetList));
    }

    @Override
    public void evict(Entity<?> entity) {
        Class clazz;
        Entity<?> entity2 = entity;
        if (entity2 instanceof HibernateProxy) {
            Entity hp = (Entity)((HibernateProxy)entity2);
            clazz = ((HibernateProxy)hp).getHibernateLazyInitializer().getPersistentClass();
        } else {
            clazz = entity.getClass();
        }
        Class clazz2 = clazz;
        this.sessionFactory().getCache().evict(clazz2, entity.id());
    }

    @Override
    public <A extends Entity<?>> void evict(Class<A> clazz) {
        SessionFactoryImplementor sf = (SessionFactoryImplementor)this.sessionFactory();
        sf.getCache().evict(clazz);
        String entityName = this.entityNameOf(clazz);
        EntityPersister entityDescriptor = sf.getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityName);
        sf.getCache().getTimestampsCache().invalidate(entityDescriptor.getPropertySpaces(), (SharedSessionContractImplementor)((SessionImplementor)this.currentSession()));
    }

    @Override
    public <T> T refresh(T entity) {
        this.currentSession().refresh(entity);
        return entity;
    }

    @Override
    public <T> T initialize(T proxy) {
        Object rs = proxy;
        T t = proxy;
        if (t instanceof HibernateProxy) {
            HibernateProxy hp = (HibernateProxy)t;
            LazyInitializer initer = hp.getHibernateLazyInitializer();
            if (initer.getSession() == null || initer.getSession().isClosed()) {
                rs = this.currentSession().get(initer.getEntityName(), initer.getIdentifier());
            } else {
                Hibernate.initialize(proxy);
            }
        } else if (t instanceof PersistentCollection) {
            PersistentCollection pc = (PersistentCollection)t;
            Hibernate.initialize((Object)pc);
        } else {
            throw new MatchError(t);
        }
        return rs;
    }

    @Override
    public <E> void remove(Iterable<E> entities) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        Session session = this.currentSession();
        entities.withFilter((Function1 & Serializable)entity -> entity != null).foreach((Function1)(JProcedure1 & Serializable)entity -> {
            Object object = entity;
            if (object instanceof Iterable) {
                Iterable seq = (Iterable)object;
                ((IterableOnceOps)seq).foreach((Function1)(JProcedure1 & Serializable)x$0 -> session.remove(x$0));
                return;
            }
            session.remove(entity);
        });
    }

    @Override
    public <E> void remove(E first, scala.collection.immutable.Seq<E> entities) {
        this.remove((Iterable<E>)entities.toList().$colon$colon(first));
    }

    @Override
    public <T extends Entity<ID>, ID> void remove(Class<T> clazz, ID id, scala.collection.immutable.Seq<ID> ids) {
        List idList = ids.toList().$colon$colon(id);
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"id");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)idList);
        this.removeBy(clazz, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
    }

    @Override
    public int removeBy(Class<?> clazz, Map<String, ?> params) {
        if (clazz == null || params == null || params.isEmpty()) {
            return 0;
        }
        Tuple2<String, Map<String, Object>> where = this.buildWhere(params, this.buildWhere$default$2());
        String hql = "delete from " + this.entityNameOf(clazz) + " where " + where._1();
        return this.executeUpdate(hql, (Map)where._2());
    }

    @Override
    public int executeUpdate(String queryString, Map<String, ?> parameterMap) {
        return QuerySupport$.MODULE$.setParameters(this.getNamedOrCreateQuery(queryString), parameterMap).executeUpdate();
    }

    @Override
    public int executeUpdate(String queryString, scala.collection.immutable.Seq<Object> arguments) {
        return QuerySupport$.MODULE$.setParameters(this.getNamedOrCreateQuery(queryString), (Iterable<?>)arguments).executeUpdate();
    }

    @Override
    public List<Object> executeUpdateRepeatly(String queryString, Iterable<Iterable<?>> arguments) {
        Query query = this.getNamedOrCreateQuery(queryString);
        ListBuffer updates = new ListBuffer();
        arguments.foreach((Function1 & Serializable)params -> (ListBuffer)updates.$plus$eq((Object)BoxesRunTime.boxToInteger((int)QuerySupport$.MODULE$.setParameters(query, (Iterable<?>)params).executeUpdate())));
        return updates.toList();
    }

    @Override
    public void execute(scala.collection.immutable.Seq<Operation> opts) {
        opts.foreach((Function1)(JProcedure1 & Serializable)operation -> {
            OperationType operationType = operation.typ();
            OperationType operationType2 = OperationType$.SaveUpdate;
            OperationType operationType3 = operationType;
            if (!(operationType2 != null ? !operationType2.equals(operationType3) : operationType3 != null)) {
                this.persistEntity(operation.data(), null);
                return;
            }
            OperationType operationType4 = OperationType$.Remove;
            OperationType operationType5 = operationType;
            if (!(operationType4 != null ? !operationType4.equals(operationType5) : operationType5 != null)) {
                this.remove((Object)operation.data(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                return;
            }
            throw new MatchError((Object)operationType);
        });
    }

    @Override
    public void execute(Operation.Builder builder) {
        builder.build().foreach((Function1)(JProcedure1 & Serializable)operation -> {
            OperationType operationType = operation.typ();
            OperationType operationType2 = OperationType$.SaveUpdate;
            OperationType operationType3 = operationType;
            if (!(operationType2 != null ? !operationType2.equals(operationType3) : operationType3 != null)) {
                this.persistEntity(operation.data(), null);
                return;
            }
            OperationType operationType4 = OperationType$.Remove;
            OperationType operationType5 = operationType;
            if (!(operationType4 != null ? !operationType4.equals(operationType5) : operationType5 != null)) {
                this.remove((Object)operation.data(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                return;
            }
            throw new MatchError((Object)operationType);
        });
    }

    @Override
    public <E> void saveOrUpdate(E first, scala.collection.immutable.Seq<E> entities) {
        this.saveOrUpdate((Iterable<E>)entities.toList().$colon$colon(first));
    }

    @Override
    public <E> void saveOrUpdate(Iterable<E> entities) {
        if (entities.nonEmpty()) {
            entities.foreach((Function1)(JProcedure1 & Serializable)entity -> {
                Object object = entity;
                if (object instanceof IterableOnce) {
                    Object col = (IterableOnce)object;
                    ((IterableOnce)col).iterator().foreach((Function1)(JProcedure1 & Serializable)e -> this.persistEntity(e, null));
                    return;
                }
                this.persistEntity(entity, null);
            });
            return;
        }
    }

    private void persistEntity(Object entity, String entityName) {
        if (entity == null) {
            return;
        }
        Session session = this.currentSession();
        Object object = entity;
        if (object instanceof HibernateProxy) {
            HibernateProxy hp = (HibernateProxy)object;
            session.update((Object)hp);
            return;
        }
        if (object instanceof Entity) {
            String en;
            Entity e = (Entity)object;
            String string = en = entityName == null ? this.entityNameOf(entity.getClass()) : entityName;
            if (e.id() == null) {
                session.persist(en, entity);
                return;
            }
            SessionImplementor si = (SessionImplementor)session;
            if (si.getContextEntityIdentifier(entity) == null) {
                session.persist(en, entity);
                return;
            }
            session.update(en, entity);
            return;
        }
        String en = entityName == null ? this.entityNameOf(entity.getClass()) : entityName;
        session.persist(en, entity);
    }

    public int batchUpdate(Class<?> entityClass, String attr, Iterable<?> values, Iterable<String> argumentNames, Iterable<Object> argumentValues) {
        if (values.isEmpty()) {
            return 0;
        }
        HashMap updateParams = new HashMap();
        Iterator valueIter = argumentValues.iterator();
        argumentNames.foreach((Function1 & Serializable)n -> updateParams.put(n, valueIter.next()));
        return this.batchUpdate(entityClass, attr, values, (Map<String, ?>)updateParams);
    }

    public int batchUpdate(Class<?> entityClass, String attr, Iterable<?> values, Map<String, ?> updateParams) {
        if (values.isEmpty() || updateParams.isEmpty()) {
            return 0;
        }
        StringBuilder hql = new StringBuilder();
        hql.append("update ").append(this.entityNameOf(entityClass)).append(" set ");
        HashMap newParams = new HashMap();
        updateParams.withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String parameterName = (String)tuple2._1();
                Object value2 = tuple2._2();
                return true;
            }
            return false;
        }).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String parameterName = (String)tuple2._1();
                Object value2 = tuple2._2();
                return parameterName != null;
            }
            throw new MatchError((Object)tuple2);
        }).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String parameterName = (String)tuple2._1();
                Object value2 = tuple2._2();
                String locateParamName = Strings$.MODULE$.replace(parameterName, ".", "_");
                hql.append(parameterName).append(" = ").append(":").append(locateParamName).append(",");
                return newParams.put((Object)locateParamName, value2);
            }
            throw new MatchError((Object)tuple2);
        });
        hql.deleteCharAt(hql.length() - 1);
        hql.append(" where ").append(attr).append(" in (:ids)");
        newParams.put((Object)"ids", values);
        return this.executeUpdate(hql.toString(), (Map<String, ?>)newParams);
    }

    @Override
    public Blob createBlob(InputStream inputStream, int length) {
        return this.currentSession().getLobHelper().createBlob(inputStream, Int$.MODULE$.int2long(length));
    }

    @Override
    public Blob createBlob(InputStream inputStream) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(inputStream.available());
        return this.currentSession().getLobHelper().createBlob(buffer.toByteArray());
    }

    @Override
    public Clob createClob(String str) {
        return this.currentSession().getLobHelper().createClob(str);
    }

    private <T> Query<T> getNamedOrCreateQuery(String queryString) {
        if (queryString.charAt(0) == '@') {
            return this.currentSession().createNamedQuery(queryString.substring(1), null);
        }
        return this.currentSession().createQuery(queryString, null);
    }

    private String buildCountQueryStr(Query<?> query) {
        Object queryStr = "select count(*) ";
        if (query instanceof NativeQuery) {
            queryStr = (String)queryStr + ("from (" + query.getQueryString() + ")");
        } else {
            String lowerCaseQueryStr = query.getQueryString().toLowerCase();
            String selectWhich = lowerCaseQueryStr.substring(0, query.getQueryString().indexOf("from"));
            int indexOfDistinct = selectWhich.indexOf("distinct");
            int indexOfFrom = lowerCaseQueryStr.indexOf("from");
            if (-1 != indexOfDistinct) {
                queryStr = Strings$.MODULE$.contains((CharSequence)selectWhich, (CharSequence)",") ? "select count(" + query.getQueryString().substring(indexOfDistinct, query.getQueryString().indexOf(",")) + ")" : "select count(" + query.getQueryString().substring(indexOfDistinct, indexOfFrom) + ")";
            }
            queryStr = (String)queryStr + query.getQueryString().substring(indexOfFrom);
        }
        return queryStr;
    }
}

