/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.orm.tool;

import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import org.beangle.commons.io.Files$;
import org.beangle.commons.io.ResourcePatternResolver$;
import org.beangle.commons.lang.Charsets$;
import org.beangle.commons.lang.Locales$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.SystemInfo$;
import org.beangle.data.orm.Mappings;
import org.beangle.data.orm.tool.SchemaExporter;
import org.beangle.jdbc.engine.Engine;
import org.beangle.jdbc.engine.Engines$;
import org.beangle.jdbc.meta.DBScripts;
import org.beangle.jdbc.meta.Database;
import org.beangle.jdbc.meta.Serializer$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public final class DdlGenerator$
implements Serializable {
    public static final DdlGenerator$ MODULE$ = new DdlGenerator$();

    private DdlGenerator$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DdlGenerator$.class);
    }

    public void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: DdlGenerator PostgreSQL /tmp zh_CN");
            return;
        }
        ObjectRef dir = ObjectRef.create((Object)SystemInfo$.MODULE$.tmpDir());
        if (args.length > 1) {
            dir.elem = args[1];
        }
        ObjectRef locale = ObjectRef.create((Object)Locale.getDefault());
        if (args.length > 2) {
            locale.elem = Locales$.MODULE$.of(args[2]);
        }
        String dialectName = args[0];
        ListBuffer warnings = new ListBuffer();
        Object object = Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(dialectName));
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)d -> (ListBuffer)warnings.$plus$plus$eq(MODULE$.gen((String)d, (String)dir$1.elem + Files$.MODULE$.$div() + d.toLowerCase(), (Locale)locale$1.elem)));
        Buffer w = (Buffer)warnings.toSet().toBuffer().sorted((Ordering)Ordering.String$.MODULE$);
        this.writeTo((String)dir.elem, "warnings.txt", (Seq<String>)w);
    }

    private List<String> gen(String dialect, String dir, Locale locale) {
        File target = new File(dir);
        target.mkdirs();
        if (!target.exists()) {
            Predef$.MODULE$.println((Object)("Cannot make dir " + target.getAbsolutePath()));
            return package$.MODULE$.List().empty();
        }
        Engine engine = Engines$.MODULE$.forName(dialect, Engines$.MODULE$.forName$default$2());
        List ormLocations = ResourcePatternResolver$.MODULE$.getResources("classpath*:META-INF/beangle/orm.xml");
        Database database = new Database(engine);
        String version = System.getProperty("database.version");
        if (Strings$.MODULE$.isNotBlank((CharSequence)version)) {
            database.version_$eq(version);
        }
        Mappings mappings = new Mappings(database, (List<URL>)ormLocations);
        mappings.locale_$eq(locale);
        mappings.autobind();
        DBScripts scripts = new SchemaExporter(mappings, engine).generate();
        this.writeTo(dir, "0-schemas.sql", (Seq<String>)scripts.schemas());
        this.writeTo(dir, "1-tables.sql", (Seq<String>)scripts.tables());
        this.writeTo(dir, "2-keys.sql", (Seq<String>)scripts.keys());
        this.writeTo(dir, "3-indices.sql", (Seq<String>)scripts.indices());
        this.writeTo(dir, "4-constraints.sql", (Seq<String>)scripts.constraints());
        this.writeTo(dir, "5-sequences.sql", (Seq<String>)scripts.sequences());
        this.writeTo(dir, "6-comments.sql", (Seq<String>)scripts.comments());
        this.writeLinesTo(dir, "7-auxiliaries.sql", (List<String>)scripts.auxiliaries());
        this.writeLinesTo(dir, "database.xml", (List<String>)((List)new .colon.colon((Object)Serializer$.MODULE$.toXml(database), (List)Nil$.MODULE$)));
        return scripts.warnings();
    }

    private void writeLinesTo(String dir, String file, List<String> contents) {
        if (contents.nonEmpty()) {
            FileWriter writer = new FileWriter(dir + "/" + file, Charsets$.MODULE$.UTF_8(), false);
            contents.foreach((Function1)(JProcedure1 & Serializable)c -> {
                if (c != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(c))) {
                    writer.write((String)c);
                    return;
                }
            });
            writer.flush();
            writer.close();
            return;
        }
    }

    private void writeTo(String dir, String file, Seq<String> contents) {
        if (contents != null && contents.nonEmpty()) {
            FileWriter writer = new FileWriter(dir + "/" + file, Charsets$.MODULE$.UTF_8(), false);
            contents.foreach((Function1)(JProcedure1 & Serializable)c -> {
                writer.write((String)c);
                writer.write(";\n");
            });
            writer.flush();
            writer.close();
            return;
        }
        new File(dir + "/" + file).delete();
    }
}

