/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.app.blob;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.time.Instant;
import org.beangle.commons.activation.MediaTypes$;
import org.beangle.commons.file.digest.Sha1$;
import org.beangle.commons.io.IOs$;
import org.beangle.ems.app.blob.BlobMeta;
import org.beangle.ems.app.blob.Repository;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t4AAC\u0006\u0001-!A\u0011\u0005\u0001BC\u0002\u0013\u0005!\u0005\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003$\u0011!y\u0003A!b\u0001\n\u0003\u0011\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\t\u000bE\u0002A\u0011\u0001\u001a\t\u000bY\u0002A\u0011I\u001c\t\u000bu\u0002A\u0011\t \t\u000b\r\u0003A\u0011\t#\t\u000b=\u0003A\u0011\t)\u0003\u001f1{7-\u00197SKB|7/\u001b;pefT!\u0001D\u0007\u0002\t\tdwN\u0019\u0006\u0003\u001d=\t1!\u00199q\u0015\t\u0001\u0012#A\u0002f[NT!AE\n\u0002\u000f\t,\u0017M\\4mK*\tA#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001/u\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0007C\u0001\u0010 \u001b\u0005Y\u0011B\u0001\u0011\f\u0005)\u0011V\r]8tSR|'/_\u0001\u0005E\u0006\u001cX-F\u0001$!\t!3F\u0004\u0002&SA\u0011a%G\u0007\u0002O)\u0011\u0001&F\u0001\u0007yI|w\u000e\u001e \n\u0005)J\u0012A\u0002)sK\u0012,g-\u0003\u0002-[\t11\u000b\u001e:j]\u001eT!AK\r\u0002\u000b\t\f7/\u001a\u0011\u0002\u0007\u0011L'/\u0001\u0003eSJ\u0004\u0013A\u0002\u001fj]&$h\bF\u00024iU\u0002\"A\b\u0001\t\u000b\u0005*\u0001\u0019A\u0012\t\u000b=*\u0001\u0019A\u0012\u0002\rI,Wn\u001c<f)\tA4\b\u0005\u0002\u0019s%\u0011!(\u0007\u0002\b\u0005>|G.Z1o\u0011\u0015ad\u00011\u0001$\u0003\u0005\u0001\u0018\u0001\u00029bi\"$\"a\u0010\"\u0011\u0007a\u00015%\u0003\u0002B3\t1q\n\u001d;j_:DQ\u0001P\u0004A\u0002\r\n1!\u001e:m)\t)e\nE\u0002\u0019\u0001\u001a\u0003\"a\u0012'\u000e\u0003!S!!\u0013&\u0002\u00079,GOC\u0001L\u0003\u0011Q\u0017M^1\n\u00055C%aA+S\u0019\")Q\b\u0003a\u0001G\u00051Q\u000f\u001d7pC\u0012$R!\u0015+W=\u0002\u0004\"A\b*\n\u0005M[!\u0001\u0003\"m_\nlU\r^1\t\u000bUK\u0001\u0019A\u0012\u0002\r\u0019|G\u000eZ3s\u0011\u00159\u0016\u00021\u0001Y\u0003\tI7\u000f\u0005\u0002Z96\t!L\u0003\u0002\\\u0015\u0006\u0011\u0011n\\\u0005\u0003;j\u00131\"\u00138qkR\u001cFO]3b[\")q,\u0003a\u0001G\u0005Aa-\u001b7f\u001d\u0006lW\rC\u0003b\u0013\u0001\u00071%A\u0003po:,'\u000f")
public class LocalRepository
implements Repository {
    private final String base;
    private final String dir;

    @Override
    public final boolean remove(String folder, String sha) {
        return Repository.remove$(this, folder, sha);
    }

    @Override
    public String getPath(String folder, String name) {
        return Repository.getPath$(this, folder, name);
    }

    @Override
    public String getExt(String fileName) {
        return Repository.getExt$(this, fileName);
    }

    public String base() {
        return this.base;
    }

    public String dir() {
        return this.dir;
    }

    @Override
    public boolean remove(String p) {
        Predef$.MODULE$.require(p.startsWith("/"));
        String path = new StringBuilder(0).append(this.base()).append(this.dir()).append(p).toString();
        File file = new File(path);
        return file.exists() ? file.delete() : false;
    }

    @Override
    public Option<String> path(String p) {
        Predef$.MODULE$.require(p.startsWith("/"));
        File file = new File(new StringBuilder(0).append(this.base()).append(this.dir()).append(p).toString());
        return file.exists() ? new Some((Object)file.getAbsolutePath()) : None$.MODULE$;
    }

    @Override
    public Option<URL> url(String path) {
        Predef$.MODULE$.require(path.startsWith("/"));
        File file = new File(new StringBuilder(0).append(this.base()).append(this.dir()).append(path).toString());
        return file.exists() ? new Some((Object)file.toURI().toURL()) : None$.MODULE$;
    }

    @Override
    public BlobMeta upload(String folder, InputStream is, String fileName, String owner) {
        Predef$.MODULE$.require(folder.startsWith("/"));
        long time = System.currentTimeMillis();
        File file = new File(new StringBuilder(1).append(this.base()).append(this.dir()).append(folder).append("/").append(time).toString());
        FileOutputStream os = new FileOutputStream(file);
        IOs$.MODULE$.copy(is, (OutputStream)os);
        IOs$.MODULE$.close((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{os}));
        String sha = Sha1$.MODULE$.digest(file);
        File target = new File(new StringBuilder(1).append(this.base()).append(this.dir()).append(folder).append("/").append(sha).toString());
        file.renameTo(target);
        String ext = this.getExt(fileName);
        BlobMeta meta = new BlobMeta();
        meta.sha_$eq(sha);
        meta.updatedAt_$eq(Instant.now());
        meta.size_$eq((int)target.length());
        meta.mediaType_$eq(MediaTypes$.MODULE$.get(ext, MediaTypes$.MODULE$.ApplicationOctetStream()).toString());
        meta.path_$eq(new StringBuilder(1).append(folder).append("/").append(sha).toString());
        return meta;
    }

    public LocalRepository(String base, String dir) {
        this.base = base;
        this.dir = dir;
        Repository.$init$(this);
    }
}

