/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.app.blob;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import org.beangle.commons.codec.digest.Digests$;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.net.http.HttpMethods$;
import org.beangle.commons.net.http.Https$;
import org.beangle.ems.app.blob.BlobMeta;
import org.beangle.ems.app.blob.RemoteRepository$InstantConverter$;
import org.beangle.ems.app.blob.Repository;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001df\u0001\u0002\r\u001a\u0001\u0011B\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001\r\u0005\ty\u0001\u0011\t\u0011)A\u0005c!AQ\b\u0001BC\u0002\u0013\u0005\u0001\u0007\u0003\u0005?\u0001\t\u0005\t\u0015!\u00032\u0011!y\u0004A!A!\u0002\u0013\t\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u000b\u0005\u0003A\u0011\u0001\"\t\u000f!\u0003\u0001\u0019!C\u0005\u0013\"9A\u000b\u0001a\u0001\n\u0013)\u0006BB.\u0001A\u0003&!\nC\u0003]\u0001\u0011\u0005S\fC\u0003c\u0001\u0011\u00053\rC\u0003j\u0001\u0011\u0005#\u000eC\u0003t\u0001\u0011\u0005C\u000fC\u0004\u0002\u000e\u0001!I!a\u0004\u0007\r\u0005\u0015\u0002\u0001AA\u0014\u0011\u0019\t\u0005\u0003\"\u0001\u0002R!9\u0011q\u000b\t\u0005\u0002\u0005esaBA@\u0001!\u0005\u0011\u0011\u0011\u0004\b\u0003\u0007\u0003\u0001\u0012AAC\u0011\u0019\tE\u0003\"\u0001\u0002\u0018\"9\u0011\u0011\u0014\u000b\u0005B\u0005m\u0005bBAQ\u0001\u0011\u0005\u00111\u0015\u0002\u0011%\u0016lw\u000e^3SKB|7/\u001b;pefT!AG\u000e\u0002\t\tdwN\u0019\u0006\u00039u\t1!\u00199q\u0015\tqr$A\u0002f[NT!\u0001I\u0011\u0002\u000f\t,\u0017M\\4mK*\t!%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001K-\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012a!\u00118z%\u00164\u0007C\u0001\u0017.\u001b\u0005I\u0012B\u0001\u0018\u001a\u0005)\u0011V\r]8tSR|'/_\u0001\u0005E\u0006\u001cX-F\u00012!\t\u0011\u0014H\u0004\u00024oA\u0011AgJ\u0007\u0002k)\u0011agI\u0001\u0007yI|w\u000e\u001e \n\u0005a:\u0013A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001O\u0014\u0002\u000b\t\f7/\u001a\u0011\u0002\u0007\u0011L'/\u0001\u0003eSJ\u0004\u0013\u0001B;tKJ\f1a[3z\u0003\u0019a\u0014N\\5u}Q)1\tR#G\u000fB\u0011A\u0006\u0001\u0005\u0006_\u001d\u0001\r!\r\u0005\u0006{\u001d\u0001\r!\r\u0005\u0006\u007f\u001d\u0001\r!\r\u0005\u0006\u0001\u001e\u0001\r!M\u0001\tM>\u0014X.\u0019;feV\t!\n\u0005\u0002L%6\tAJ\u0003\u0002N\u001d\u00061am\u001c:nCRT!a\u0014)\u0002\tQLW.\u001a\u0006\u0002#\u0006!!.\u0019<b\u0013\t\u0019FJA\tECR,G+[7f\r>\u0014X.\u0019;uKJ\fABZ8s[\u0006$XM]0%KF$\"AV-\u0011\u0005\u0019:\u0016B\u0001-(\u0005\u0011)f.\u001b;\t\u000fiK\u0011\u0011!a\u0001\u0015\u0006\u0019\u0001\u0010J\u0019\u0002\u0013\u0019|'/\\1uKJ\u0004\u0013A\u0002:f[>4X\r\u0006\u0002_CB\u0011aeX\u0005\u0003A\u001e\u0012qAQ8pY\u0016\fg\u000eC\u0003c\u0017\u0001\u0007\u0011'\u0001\u0003qCRDGC\u00013h!\r1S-M\u0005\u0003M\u001e\u0012aa\u00149uS>t\u0007\"\u00025\r\u0001\u0004\t\u0014!\u00019\u0002\u0007U\u0014H\u000e\u0006\u0002leB\u0019a%\u001a7\u0011\u00055\u0004X\"\u00018\u000b\u0005=\u0004\u0016a\u00018fi&\u0011\u0011O\u001c\u0002\u0004+Jc\u0005\"\u00022\u000e\u0001\u0004\t\u0014AB;qY>\fG\rF\u0004vqj\f)!!\u0003\u0011\u000512\u0018BA<\u001a\u0005!\u0011En\u001c2NKR\f\u0007\"B=\u000f\u0001\u0004\t\u0014A\u00024pY\u0012,'\u000fC\u0003|\u001d\u0001\u0007A0\u0001\u0002jgB\u0019Q0!\u0001\u000e\u0003yT!a )\u0002\u0005%|\u0017bAA\u0002}\nY\u0011J\u001c9viN#(/Z1n\u0011\u0019\t9A\u0004a\u0001c\u0005Aa-\u001b7f\u001d\u0006lW\r\u0003\u0004\u0002\f9\u0001\r!M\u0001\u0006_^tWM]\u0001\tI>,\u0006\u000f\\8bIRYQ/!\u0005\u0002\u0014\u0005U\u0011qCA\u0011\u0011\u0015Iw\u00021\u0001m\u0011\u0015Yx\u00021\u0001}\u0011\u0019\t9a\u0004a\u0001c!9\u0011\u0011D\bA\u0002\u0005m\u0011A\u00029be\u0006l7\u000fE\u00033\u0003;\t\u0014'C\u0002\u0002 m\u00121!T1q\u0011\u0019\t\u0019c\u0004a\u0001I\u0006I!-Y:jG\u0006+H\u000f\u001b\u0002\u000f\u0013:\u001cH/\u00198u\u0003\u0012\f\u0007\u000f^3s'\u0015\u0001\u0012\u0011FA\u001b!\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018!\u0006!A.\u00198h\u0013\u0011\t\u0019$!\f\u0003\r=\u0013'.Z2u!\u0019\t9$!\u0012\u0002J5\u0011\u0011\u0011\b\u0006\u0005\u0003w\ti$\u0001\u0003hg>t'\u0002BA \u0003\u0003\naaZ8pO2,'BAA\"\u0003\r\u0019w.\\\u0005\u0005\u0003\u000f\nID\u0001\tKg>tG)Z:fe&\fG.\u001b>feB!\u00111JA'\u001b\u0005q\u0015bAA(\u001d\n9\u0011J\\:uC:$HCAA*!\r\t)\u0006E\u0007\u0002\u0001\u0005YA-Z:fe&\fG.\u001b>f)!\tI%a\u0017\u0002f\u0005U\u0004bBA/%\u0001\u0007\u0011qL\u0001\u0005K2,W\u000e\u0005\u0003\u00028\u0005\u0005\u0014\u0002BA2\u0003s\u00111BS:p]\u0016cW-\\3oi\"9\u0011q\r\nA\u0002\u0005%\u0014\u0001\u0002;za\u0016\u0004B!a\u001b\u0002r5\u0011\u0011Q\u000e\u0006\u0005\u0003_\ni#A\u0004sK\u001adWm\u0019;\n\t\u0005M\u0014Q\u000e\u0002\u0005)f\u0004X\rC\u0004\u0002xI\u0001\r!!\u001f\u0002\u000f\r|g\u000e^3yiB!\u0011qGA>\u0013\u0011\ti(!\u000f\u00035)\u001bxN\u001c#fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002!%s7\u000f^1oi\u000e{gN^3si\u0016\u0014\bcAA+)\t\u0001\u0012J\\:uC:$8i\u001c8wKJ$XM]\n\u0005)\u0015\n9\tE\u0004\u0002\n\u0006M\u0015'!\u0013\u000e\u0005\u0005-%\u0002BAG\u0003\u001f\u000b!bY8om\u0016\u00148/[8o\u0015\r\t\tjH\u0001\bG>lWn\u001c8t\u0013\u0011\t)*a#\u0003\u0013\r{gN^3si\u0016\u0014HCAAA\u0003\u0015\t\u0007\u000f\u001d7z)\u0011\tI%!(\t\r\u0005}e\u00031\u00012\u0003\u00151\u0018\r\\;f\u0003%qwN]7bY&TX\rF\u00022\u0003KCa!a(\u0018\u0001\u0004\t\u0004")
public class RemoteRepository
implements Repository {
    private volatile RemoteRepository$InstantConverter$ InstantConverter$module;
    private final String base;
    private final String dir;
    private final String user;
    private final String key;
    private DateTimeFormatter formater;

    @Override
    public final boolean remove(String folder, String sha) {
        return Repository.remove$(this, folder, sha);
    }

    @Override
    public String getPath(String folder, String name) {
        return Repository.getPath$(this, folder, name);
    }

    @Override
    public String getExt(String fileName) {
        return Repository.getExt$(this, fileName);
    }

    public RemoteRepository$InstantConverter$ InstantConverter() {
        if (this.InstantConverter$module == null) {
            this.InstantConverter$lzycompute$1();
        }
        return this.InstantConverter$module;
    }

    public String base() {
        return this.base;
    }

    public String dir() {
        return this.dir;
    }

    private DateTimeFormatter formater() {
        return this.formater;
    }

    private void formater_$eq(DateTimeFormatter x$1) {
        this.formater = x$1;
    }

    @Override
    public boolean remove(String path) {
        Predef$.MODULE$.require(path.startsWith("/"));
        URL url = new URL(new StringBuilder(0).append(this.base()).append(this.dir()).append(path).toString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Https$.MODULE$.noverify(conn);
        conn.setDoOutput(true);
        conn.setRequestMethod(HttpMethods$.MODULE$.DELETE());
        String encoded = Base64.getEncoder().encodeToString(new StringBuilder(1).append(this.user).append(":").append(this.key).toString().getBytes(StandardCharsets.UTF_8));
        conn.setRequestProperty("Authorization", new StringBuilder(6).append("Basic ").append(encoded).toString());
        if (conn.getResponseCode() >= 300) {
            throw new Exception(new StringBuilder(31).append("Remove Failed,Response code is ").append(conn.getResponseCode()).toString());
        }
        return conn.getResponseCode() == 200;
    }

    @Override
    public Option<String> path(String p) {
        Predef$.MODULE$.require(p.startsWith("/"));
        return new Some((Object)new StringBuilder(0).append(this.base()).append(this.dir()).append(p).toString());
    }

    @Override
    public Option<URL> url(String path) {
        Predef$.MODULE$.require(path.startsWith("/"));
        String now = LocalDateTime.now().format(this.formater());
        String token = Digests$.MODULE$.sha1Hex(new StringBuilder(0).append(this.dir()).append(path).append(this.user).append(this.key).append(now).toString());
        return new Some((Object)new URL(new StringBuilder(13).append(this.base()).append(this.dir()).append(path).append("?token=").append(token).append("&u=").append(this.user).append("&t=").append(now).toString()));
    }

    @Override
    public BlobMeta upload(String folder, InputStream is, String fileName, String owner) {
        Predef$.MODULE$.require(folder.startsWith("/"));
        String folderUrl = folder.endsWith("/") ? folder : new StringBuilder(1).append(folder).append("/").toString();
        URL target = new URL(new StringBuilder(0).append(this.base()).append(this.dir()).append(folderUrl).toString());
        Map params = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"owner"), (Object)owner)}));
        return this.doUpload(target, is, fileName, (Map<String, String>)params, (Option<String>)new Some((Object)new StringBuilder(1).append(this.user).append(":").append(this.key).toString()));
    }

    private BlobMeta doUpload(URL url, InputStream is, String fileName, Map<String, String> params, Option<String> basicAuth) {
        String end = "\r\n";
        String twoHyphens = "--";
        String boundary = "*****";
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Https$.MODULE$.noverify(conn);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestMethod(HttpMethods$.MODULE$.POST());
        conn.setRequestProperty("Content-Type", new StringBuilder(29).append("multipart/form-data;boundary=").append(boundary).toString());
        conn.setRequestProperty("Connection", "Keep-Alive");
        basicAuth.foreach((Function1 & Serializable)auth -> {
            RemoteRepository.$anonfun$doUpload$1(conn, auth);
            return BoxedUnit.UNIT;
        });
        OutputStream os = conn.getOutputStream();
        DataOutputStream ds = new DataOutputStream(os);
        scala.collection.mutable.StringBuilder text = new scala.collection.mutable.StringBuilder();
        params.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            text.append(twoHyphens).append(boundary).append(end);
            text.append(new StringBuilder(39).append("Content-Disposition: form-data; name=\"").append(k).append("\"").toString());
            text.append(end).append(end);
            scala.collection.mutable.StringBuilder stringBuilder = text.append(v).append(end);
            return stringBuilder;
        });
        ds.write(text.toString().getBytes());
        scala.collection.mutable.StringBuilder strBuf = new scala.collection.mutable.StringBuilder();
        strBuf.append(twoHyphens).append(boundary).append(end);
        strBuf.append(new StringBuilder(56).append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(fileName).append("\"").toString());
        strBuf.append(end).append(end);
        ds.write(strBuf.toString().getBytes());
        IOs$.MODULE$.copy(is, (OutputStream)ds);
        ds.writeBytes(end);
        ds.writeBytes(new StringBuilder(0).append(twoHyphens).append(boundary).append(twoHyphens).append(end).toString());
        ds.flush();
        ds.close();
        os.close();
        if (conn.getResponseCode() != 200) {
            Predef$.MODULE$.println((Object)IOs$.MODULE$.readString(conn.getInputStream(), IOs$.MODULE$.readString$default$2()));
            throw new Exception(new StringBuilder(31).append("Upload Failed,Response code is ").append(conn.getResponseCode()).toString());
        }
        String response = IOs$.MODULE$.readString(conn.getInputStream(), IOs$.MODULE$.readString$default$2());
        Gson gson = new GsonBuilder().registerTypeAdapter(Instant.class, (Object)new InstantAdapter()).create();
        return (BlobMeta)gson.fromJson(response, BlobMeta.class);
    }

    public String normalize(String value) {
        String v = value.length() == 16 ? new StringBuilder(3).append(value).append(":00").toString() : value;
        return Strings$.MODULE$.replace(v, " ", "T");
    }

    private final void InstantConverter$lzycompute$1() {
        RemoteRepository remoteRepository = this;
        synchronized (remoteRepository) {
            if (this.InstantConverter$module == null) {
                this.InstantConverter$module = new RemoteRepository$InstantConverter$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$doUpload$1(HttpURLConnection conn$1, String auth) {
        String encoded = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
        conn$1.setRequestProperty("Authorization", new StringBuilder(6).append("Basic ").append(encoded).toString());
    }

    public RemoteRepository(String base, String dir, String user, String key) {
        this.base = base;
        this.dir = dir;
        this.user = user;
        this.key = key;
        Repository.$init$(this);
        this.formater = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss");
        Predef$.MODULE$.require(!dir.endsWith("/"));
    }

    public class InstantAdapter
    implements JsonDeserializer<Instant> {
        public Instant deserialize(JsonElement elem, Type type, JsonDeserializationContext context) {
            return this.org$beangle$ems$app$blob$RemoteRepository$InstantAdapter$$$outer().InstantConverter().apply(elem.getAsString());
        }

        public /* synthetic */ RemoteRepository org$beangle$ems$app$blob$RemoteRepository$InstantAdapter$$$outer() {
            return RemoteRepository.this;
        }

        public InstantAdapter() {
            if (RemoteRepository.this == null) {
                throw null;
            }
        }
    }
}

