/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.image;

import com.octo.captcha.Captcha;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.imageio.ImageIO;

public abstract class ImageCaptcha
implements Captcha {
    private Boolean hasChallengeBeenCalled = Boolean.FALSE;
    protected String question;
    protected transient BufferedImage challenge;

    protected ImageCaptcha(String string, BufferedImage bufferedImage) {
        this.challenge = bufferedImage;
        this.question = string;
    }

    public final String getQuestion() {
        return this.question;
    }

    public final Object getChallenge() {
        return this.getImageChallenge();
    }

    public final BufferedImage getImageChallenge() {
        this.hasChallengeBeenCalled = Boolean.TRUE;
        return this.challenge;
    }

    public final void disposeChallenge() {
        this.challenge = null;
    }

    public Boolean hasGetChalengeBeenCalled() {
        return this.hasChallengeBeenCalled;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.challenge != null) {
            ImageIO.write((RenderedImage)this.challenge, "jpg", objectOutputStream);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.challenge = ImageIO.read(objectInputStream);
    }
}

