/* Copyright c 2005-2012.
 * Licensed under GNU  LESSER General Public License, Version 3.
 * http://www.gnu.org/licenses
 */
package org.beangle.ems.avatar.model;

import java.util.Date;

import org.beangle.ems.avatar.Avatar;

public abstract class AbstractAvatar implements Avatar {

  private String name;

  private String type;

  private Date updatedAt;

  public double getKBSize() {
    return ((double) getSize() / 1024);
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public Date getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(Date updatedAt) {
    this.updatedAt = updatedAt;
  }

}
