/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.avatar.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;
import org.beangle.commons.lang.Strings;
import org.beangle.ems.avatar.AvatarException;
import org.beangle.ems.avatar.model.AbstractAvatar;

public class FileAvatar
extends AbstractAvatar {
    private File file;

    public FileAvatar(File file) {
        this.file = file;
        this.setUpdatedAt(new Date(file.lastModified()));
        this.setName(file.getName());
    }

    public FileAvatar() {
    }

    public long getSize() {
        return this.file.length();
    }

    public String getType() {
        if (null == super.getType()) {
            this.setType(Strings.substringAfterLast((String)this.file.getAbsolutePath(), (String)"."));
        }
        return super.getType();
    }

    public InputStream getInputStream() throws AvatarException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new AvatarException(e);
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

