/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.dictionary.service.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.ems.dictionary.model.BaseCode;
import org.beangle.ems.dictionary.model.CodeMeta;
import org.beangle.ems.dictionary.service.BaseCodeService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseCodeServiceImpl
extends BaseServiceImpl
implements BaseCodeService {
    @Override
    public <T extends BaseCode<?>> T getCode(Class<T> codeClass, String code) {
        OqlBuilder builder = OqlBuilder.from(codeClass, (String)"basecode").where("basecode.code=:code", (Object)code);
        List rs = this.entityDao.search((QueryBuilder)builder);
        if (!rs.isEmpty()) {
            return (T)((BaseCode)rs.get(0));
        }
        return null;
    }

    @Override
    public <T extends BaseCode<?>> List<T> getCodes(Class<T> codeClass) {
        OqlBuilder builder = OqlBuilder.from(codeClass, (String)"basecode").where("basecode.effectiveAt <= :now and (basecode.invalidAt is null or basecode.invalidAt >= :now)", (Object)new Date());
        builder.orderBy("basecode.code");
        return this.entityDao.search((QueryBuilder)builder);
    }

    @Override
    public <T extends BaseCode<?>> T getCode(Class<T> codeClass, Long codeId) {
        return (T)((BaseCode)this.entityDao.get(codeClass, (Serializable)codeId));
    }

    @Override
    public <T extends BaseCode<?>> List<T> getCodes(Class<T> type, Long ... ids) {
        OqlBuilder builder = OqlBuilder.from(type, (String)"basecode").where("basecode.id in(:ids)", (Object)ids);
        return this.entityDao.search((QueryBuilder)builder);
    }

    @Override
    public Class<? extends BaseCode<?>> getCodeType(String name) {
        OqlBuilder builder = OqlBuilder.from(CodeMeta.class, (String)"coder");
        builder.where("coder.name=:name or coder.engName=:name", (Object)name);
        List coders = this.entityDao.search((QueryBuilder)builder);
        try {
            if (1 != coders.size()) {
                return null;
            }
            return Class.forName(((CodeMeta)((Object)coders.get(0))).getClassName());
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Basecode " + name + "type not found", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeCodes(Class<? extends BaseCode<?>> codeClass, Long ... codeIds) {
        this.entityDao.remove((Collection)this.entityDao.get(codeClass, codeIds));
    }

    @Override
    public void saveOrUpdate(BaseCode<?> code) {
        if (code.isTransient()) {
            code.setCreatedAt(new java.sql.Date(System.currentTimeMillis()));
        }
        code.setUpdatedAt(new java.sql.Date(System.currentTimeMillis()));
        this.entityDao.saveOrUpdate(new Object[]{code});
    }
}

