/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.dictionary.service.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.EntityDao;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.entity.Entity;
import org.beangle.commons.entity.util.EntityUtils;
import org.beangle.commons.lang.Numbers;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.Throwables;
import org.beangle.ems.dictionary.model.CodeScript;
import org.beangle.ems.dictionary.service.CodeFixture;
import org.beangle.ems.dictionary.service.impl.ScriptCodeGenerator;

public class SeqCodeGenerator
extends ScriptCodeGenerator {
    public static final String SEQ = "seq";
    private EntityDao entityDao;

    public void setUp() throws Exception {
        this.interpreter.set(SEQ, (Object)SEQ);
        this.interpreter.set("dao", (Object)this.entityDao);
    }

    protected CodeScript getCodeScript(String entityName) {
        OqlBuilder builder = OqlBuilder.from(CodeScript.class, (String)"codeScript");
        builder.where("codeScript.codeClassName=:codeClassName", (Object)entityName);
        builder.cacheable();
        List scripts = this.entityDao.search((QueryBuilder)builder);
        if (scripts.size() != 1) {
            return null;
        }
        return (CodeScript)((Object)scripts.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String gen(CodeFixture fixture) {
        String script = fixture.getScript();
        CodeScript codeScript = null;
        if (null == script) {
            codeScript = this.getCodeScript(EntityUtils.getEntityClassName(fixture.getEntity().getClass()));
            if (null == codeScript) {
                return null;
            }
            script = codeScript.getScript();
            try {
                String code = (String)PropertyUtils.getProperty((Object)fixture.getEntity(), (String)codeScript.getAttr());
                if (this.isValidCode(code)) {
                    return code;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        int seqLength = -1;
        if (Strings.contains((CharSequence)script, (CharSequence)SEQ)) {
            seqLength = Numbers.toInt((String)Strings.substringBetween((String)script, (String)"seq[", (String)"]"));
            script = Strings.replace((String)script, (String)("seq[" + Strings.substringBetween((String)script, (String)"seq[", (String)"]") + "]"), (String)SEQ);
        }
        fixture.setScript(script);
        String code = super.gen(fixture);
        List seqs = CollectUtils.newArrayList();
        if (-1 != seqLength) {
            try {
                OqlBuilder builder = OqlBuilder.from(Class.forName(codeScript.getCodeClassName()), (String)"entity");
                builder.select("select substr(entity." + codeScript.getAttr() + "," + (code.indexOf(SEQ) + 1) + "," + seqLength + ")");
                builder.where(" entity." + codeScript.getAttr() + " like :codeExample", (Object)Strings.replace((String)code, (String)SEQ, (String)"%"));
                builder.where("length(entity." + codeScript.getAttr() + ")=" + (code.length() - SEQ.length() + seqLength));
                seqs = this.entityDao.search((QueryBuilder)builder);
                Collections.sort(seqs);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            SeqCodeGenerator seqCodeGenerator = this;
            synchronized (seqCodeGenerator) {
                String seqNo;
                int newSeqNo = 0;
                Iterator iter = seqs.iterator();
                while (iter.hasNext() && Numbers.toInt((String)(seqNo = (String)iter.next())) - newSeqNo < 2) {
                    newSeqNo = Numbers.toInt((String)seqNo);
                }
                String seqNo2 = String.valueOf(++newSeqNo);
                if (0 != seqLength) {
                    seqNo2 = Strings.repeat((String)"0", (int)(seqLength - seqNo2.length())) + newSeqNo;
                }
                code = Strings.replace((String)code, (String)SEQ, (String)seqNo2);
            }
        }
        return code;
    }

    public String test(CodeFixture fixture, CodeScript codeScript) {
        try {
            Class<?> codeClass = Class.forName(codeScript.getCodeClassName());
            Entity entity = (Entity)codeClass.newInstance();
            PropertyUtils.getProperty((Object)entity, (String)codeScript.getAttr());
            if (null != fixture) {
                for (String param : fixture.getParams().keySet()) {
                    this.interpreter.set(param, fixture.getParams().get(param));
                }
                if (Strings.isNotEmpty((CharSequence)fixture.getScript())) {
                    this.interpreter.eval(fixture.getScript());
                }
            }
            return this.gen(new CodeFixture(entity, codeScript.getScript()));
        }
        catch (Exception e) {
            return Throwables.getStackTrace((Throwable)e);
        }
    }

    public void setEntityDao(EntityDao entityDao) {
        this.entityDao = entityDao;
    }
}

